//bledy zwracane przez funkcje RSSekw i Status
#DEFINE TIMEOUT_NADAWANIA	20
#DEFINE TIMEOUT_ODBIERANIA	21
#DEFINE NIEPOPRAWNA_ODPOWIEDZ	23 
#DEFINE ODPOWIEDZ_NAK		24

//bledy zwracane tylko przez funkcje Status (0 - status odczytany poprawnie)
#DEFINE AWARIA_DRUKARKI		-1
#DEFINE BRAK_KOM_Z_KONTROLEREM	-2
#DEFINE ZATRZYMANY_WYDRUK	-3
#DEFINE BRAK_PAPIERU		-4
#DEFINE PODNIESIONA_GLOWICA     -5
#DEFINE ZALEGLY_WYDRUK		-6

//maksymalna ilosc retransmisji danych do drukarki
#DEFINE ILE_RETRANSMISJI	4

//mozliwe bledy przy drukowaniu etykiety
#DEFINE BRAK_BLEDU		0
#DEFINE BLAD_PRZED_WYDRUKIEM    1
#DEFINE BLAD_W_CZASIE_WYDRUKU   2

//mozliwe wydruki linii
#DEFINE _40ZNAK6MM	57
#DEFINE _20ZNAK6MM	55
#DEFINE _40ZNAK3MM	56
#DEFINE _20ZNAK3MM	54

//mozliwe kody kreskowe
#DEFINE EAN13W	64
#DEFINE EAN13SZ	65
#DEFINE EAN8W	66
#DEFINE EAN8SZ	68

//program glowny

   wejscie = array(256)
   wyjscie = array(256)

WHILE .T.	

   cls
   @ 1,15 SAY    "        *** PROGRAM TESTOWY ***     "
   @ 4,15 PROMPT "1. WYDRUK LINII 40 ZNAKOW O WYS.6 MM + EAN 13 WASKI"
   @ 5,15 PROMPT "2. WYDRUK LINII 20 ZNAKOW O WYS.6 MM + EAN 13 SZEROKI"
   @ 6,15 PROMPT "3. WYDRUK LINII 40 ZNAKOW O WYS.3 MM + EAN 8 WASKI"
   @ 7,15 PROMPT "4. WYDRUK LINII 20 ZNAKOW O WYS.3 MM + EAN 8 SZEROKI"
   @ 8,15 PROMPT "5. KONIEC PROGRAMU"

   MENU TO wybor

   IF wybor = 5 
      RETURN   //wyjscie z programu
   END

   //ustawienie parametrow dla portu szeregowego
   Port     =    1	// 1..4
   Szybkosc =    9600	// 9600 lub 19200
   Timeout  =    1	// 1..65535 sekund

   //inicjalizacja portu szeregowego
   Wynik = RSInit(Port, Szybkosc, Timeout)

 IF Wynik = 1 
    @ 20,1 SAY "BLAD INICJALIZACJI PORTU. USTAW WLASCIWY PORT"
    WAIT ""
 ELSEIF wynik = 2
    @ 20,1 SAY "BLAD INICJALIZACJI PORTU. USTAW WLASCIWA PREDKOSC TRANSMISJI"
    WAIT "" 
 ELSEIF wynik <> 0  
    @ 20,1 SAY "INNY BLAD INICJALIZACJI PORTU"
    WAIT "" 
 ELSE //port zainicjalizowany poprawnie	
   
   //ustaw raster etykiety
   //raster= 90
   //wynik=RSSekw(44, 1, 1, 1, wyjscie, raster)
   //obsluga bledow
   //ustaw wysokosc kodu
   //wysokosc = 14
   //wynik=RSSekw(46, 1, 1, 1,wyjscie, wysokosc)
   //obsluga bledow  

   Blad = BRAK_BLEDU	

   DO CASE 
        CASE wybor = 1
   	   Blad = DrukujEtykiete(_40ZNAK6MM, EAN13W)	   
        CASE wybor = 2
	   Blad = DrukujEtykiete(_20ZNAK6MM, EAN13SZ)
        CASE wybor = 3
	   Blad = DrukujEtykiete(_40ZNAK3MM, EAN8W)   	   
        CASE wybor = 4
	   Blad = DrukujEtykiete(_20ZNAK3MM, EAN8SZ)
   ENDCASE
   
   IF (Blad <> BRAK_BLEDU)
      IF (Blad = BLAD_W_CZASIE_WYDRUKU)
	 @ 21,15 SAY "BLAD W CZASIE WYDRUKU"
	 RSSekw(23, 2, 0, 0, wyjscie, wejscie)
      ENDIF
      @ 21,10 SAY "WYDRUK ETYKIETY ANULOWANY! NACISNIJ DOWOLNY KLAWISZ"	
      WAIT ""
   ENDIF	
 ENDIF
END //while (program glowny)


FUNCTION ObsluzStatus()
//funkcja sprawdzajaca czy spelnione sa warunki wydrukowania etykiety
//zwraca : -1 jesli bajt statusu nie zostal odczytany
//	   -2 jesli nie ma warunkow umozliwiajacych drukowanie etykiety
//	    0 jezeli mozna drukowac etykiete

LOCAL Wynik
LOCAL Powtorzen

Wynik = Status() //funkcja biblioteczna sprawdzajaca stan drukarki 

	Powtorzen = 0
	DO WHILE (((Wynik=TIMEOUT_ODBIERANIA) .OR. (Wynik=NIEPOPRAWNA_ODPOWIEDZ)) .AND. (Powtorzen<ILE_RETRANSMISJI))
 	   Wynik=Status()
	   Powtorzen = Powtorzen + 1
	ENDDO

IF (Wynik>0) //bajt statusu nie zostal odczytany
	DO CASE 
		CASE wynik = TIMEOUT_NADAWANIA
			@ 23, 15 SAY "Blad: timeout nadawania"
		CASE wynik = TIMEOUT_ODBIERANIA
			@ 23, 15 SAY "BLAD: timeout odbierania"
		CASE wynik = NIEPOPRAWNA_ODPOWIEDZ
			@ 23, 15 SAY "BLAD: niepoprawna odpowiedz"
		CASE wynik = ODPOWIEDZ_NAK
			@ 23, 15 SAY "BLAD: drukarka odpowiedziala NAK na sekwencje sterujaca"
		OTHERWISE
			@ 23, 15 SAY "BLAD o kodzie nieznanym"
	ENDCASE
	RETURN -1
ELSEIF (Wynik<0) // bajt statusu odczytany poprawnie ale sa bledy uniemozliwiajace drukowanie
	DO CASE 
		CASE wynik = AWARIA_DRUKARKI
			@ 23, 15 SAY "BLAD: awaria drukarki"
		CASE wynik = BRAK_KOM_Z_KONTROLEREM
			@ 23, 15 SAY "BLAD: brak komunikacji z kontrolerem drukarki"
		CASE wynik = ZALEGLY_WYDRUK
			@ 23, 15 SAY "BLAD: znaki do wydrukowania w buforze drukarki"
		CASE wynik = ZATRZYMANY_WYDRUK
			@ 23, 15 SAY "BLAD: wydruk zatrzymany z powodu braku papieru"
		CASE wynik = BRAK_PAPIERU
   			@ 23, 15 SAY "BLAD: brak papieru w drukarce"
                CASE wynik = PODNIESIONA_GLOWICA
   			@ 23, 15 SAY "BLAD: podniesiona glowica w drukarce"
	ENDCASE
	RETURN -2
ELSE //wynik=0 wiec mozna posylac odpowiednie sekwencje sterujace
RETURN 0
ENDIF


FUNCTION DrukujEtykiete(RodzajLinii, RodzajKoduEAN)

LOCAL DlugoscLinii
LOCAL DlugoskKoduEAN
LOCAL Bl
LOCAL Wynik

IF (RodzajLinii = _40ZNAK6MM) .OR. (RodzajLinii = _40ZNAK3MM)
   DlugoscLinii = 40
ELSEIF (RodzajLinii = _20ZNAK6MM) .OR. (RodzajLinii = _20ZNAK3MM)
   DlugoscLinii = 20
ENDIF

IF (RodzajKoduEAN = EAN13W) .OR. (RodzajKoduEAN = EAN13SZ) 
   DlugoscKoduEAN = 13
ELSEIF (RodzajKoduEAN = EAN8W) .OR. (RodzajKoduEAN = EAN8SZ) 
   DlugoscKoduEAN = 8
ENDIF

    Bl = 0

    IF (ObsluzStatus()=0) 
                 //przygotuj dane do wyslania
	         for k=1 to DlugoscLinii
	            wejscie[k] := 33
	         next
	         Powtorzen = 0        
                 //wyslij linie danych
                 Wynik = RSSekw(RodzajLinii, 1, DlugoscLinii, 1, wyjscie, wejscie)
  	         DO WHILE (((Wynik=TIMEOUT_ODBIERANIA) .OR. (Wynik=NIEPOPRAWNA_ODPOWIEDZ)) .AND. (Powtorzen<ILE_RETRANSMISJI))
	            Wynik=RSSekw(RodzajLinii, 1, DlugoscLinii, 1, wyjscie, wejscie)
	            Powtorzen = Powtorzen + 1
	         ENDDO
                 //sprawdz poprawnosc odebrania danych przez drukarke
	         IF (Wynik = 0)
		    //przygotuj kolejne dane do wyslania
	            for k=1 to DlugoscLinii
	               wejscie[k] := 32
	            next
	            Powtorzen=0	
                    Wynik = RSSekw(RodzajLinii, 1, DlugoscLinii, 1, wyjscie, wejscie)
	            DO WHILE (((Wynik=TIMEOUT_ODBIERANIA) .OR. (Wynik=NIEPOPRAWNA_ODPOWIEDZ)) .AND. (Powtorzen<ILE_RETRANSMISJI))
		       Wynik=RSSekw(RodzajLinii, 1, DlugoscLinii, 1, wyjscie, wejscie)
		       Powtorzen = Powtorzen + 1
	            ENDDO
	            IF (Wynik = 0)
		       //przygotuj cyfry kodu EAN	
	               for k=1 to DlugoscKoduEAN-1
	                  wejscie[k] := 51
	               next
                       IF ((RodzajKoduEAN = EAN8W) .OR. (RodzajKoduEAN = EAN8SZ)) 
                          wejscie[DlugoscKoduEAN] := EAN8(wejscie)
	               ELSE 
                          wejscie[DlugoscKoduEAN] := EAN13(wejscie) 
		       ENDIF
                       Powtorzen = 0         
	               //wyslanie cyfr kodu EAN
                       Wynik = RSSekw(RodzajKoduEAN, 1, DlugoscKoduEAN, 1, wyjscie, wejscie)
	               DO WHILE (((Wynik=TIMEOUT_ODBIERANIA) .OR. (Wynik=NIEPOPRAWNA_ODPOWIEDZ)) .AND. (Powtorzen<ILE_RETRANSMISJI))
		          Wynik=RSSekw(RodzajKoduEAN, 1, DlugoscKoduEAN, 1, wyjscie, wejscie)
		          Powtorzen = Powtorzen + 1
	               ENDDO
	               IF (Wynik=0) 
		          //wysuniecie etykiety
                          RSSekw(23, 2, 0, 0, wyjscie, wejscie)
	               ENDIF
	             ELSE
		       Bl = BLAD_W_CZASIE_WYDRUKU
                     ENDIF
	          ELSE
                     Bl = BLAD_PRZED_WYDRUKIEM 
                  ENDIF
             ELSE
	        Bl =  BLAD_PRZED_WYDRUKIEM
             ENDIF

RETURN Bl