//---------------------------------------------------------------------------

#pragma hdrstop

#define LINUX
#include "elzabdr.h"
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#ifdef WINDOWS
  #include <windows.h>
  #include <conio.h>
#endif

#ifdef LINUX
#define _atoi64  atoll
#define __int64 long long
#endif
typedef char MyPChar[255];
FILE* PlikWyjsciowy;
FILE* PlikWejsciowy;

//---------------------------------------------------------------------------

#pragma argsused

void WyciagnijZLiniiArgument(unsigned nrarg, MyPChar linia, MyPChar *wzwr)
{
  unsigned Licznik, LDod, Licznik3;
  MyPChar tmps;

  for (Licznik=0; Licznik<255; Licznik++)
     tmps[Licznik]=0;

  Licznik = 1;
  LDod    = 0;
  while ((LDod<=strlen(linia)) && (Licznik<nrarg))
  {
     while ((LDod<=strlen(linia)) && (linia[LDod]!=0x09))
       LDod++;
     LDod++;
     Licznik++;
  }
  Licznik3 = 0;
  while (((LDod<=strlen(linia)) && (linia[LDod]!=0x09)))
  {
      tmps[Licznik3]=linia[LDod];
      LDod++;
      Licznik3++;
  }

  strcpy((char*) wzwr, (const char*) tmps);
  return;
}

void ObsluzBlad(long Blad, unsigned char ZakonczProgram, char* Funkcja, char* Komunikat)
{
  MyPChar TmpString;
  char Dana[255];

  if (strcmp(Komunikat,"")==0)
  {
     pErrMessage(Blad,TmpString);
     itoa(Blad, Dana, 10);
     strcat(Dana, "\t");
     strcat(Dana, TmpString);
     strcat(Dana, "\t");
     strcat(Dana, Funkcja);
     fprintf(PlikWyjsciowy, "%s\n", Dana);
  }
  else
  {
     itoa(Blad, Dana, 10);
     strcat(Dana, "\t");
     strcat(Dana, Komunikat);
     fprintf(PlikWyjsciowy, "%s\n", Dana);
  }

  if (ZakonczProgram)
  {
    CommunicationEnd();
    fclose(PlikWyjsciowy);
    fclose(PlikWejsciowy);
    exit(Blad);
  }

}

int main(int argc, char* argv[])
{
  unsigned char TylkoOtwarcieSzuflady = 1;
  unsigned char PierwszyRaz = 1;
  char NazwaPlikuWyj[255];
  char NazwaPlikuWej[255];
  char TmpString[255];
  char LiniaZPliku[255];
  char Dana[255];
  char Tmp[255];
  char Time[255];
  long t;
  unsigned int NrPortu, Predkosc, Timeout, DebugMode;
  long Blad;
  long Wartosc;
  long Numer;

  char Rabat[255];
  char Sprzed[255];
  char Nazwa[255];
  char Stawka[255];
  char Ilosc[255];
  char Cena[255];
  char Jedn[255];
  char MP[255];
  char Komunikat[255];

  long Hour, Minute;
  long IleStawek;
  long Stawki[8];
  int Licznik;
  long Fiscal, rr1, mm1, dd1, rr2, mm2, dd2;
  __int64  IloscI, CenaI;
  long KomunikatI, StawkaI;
  long FreeLines;

  int MPI;

  if ((argc>2) && (strcmp(argv[2], "")!=0))
    strcpy(NazwaPlikuWyj, argv[2]);
  else
    strcpy(NazwaPlikuWyj, "raport.txt");

  if (
       (PlikWyjsciowy=fopen(NazwaPlikuWyj, "wt"))==NULL
     )
    return 1;

  strcpy(Dana, "#");
  strcat(Dana, argv[0]);
  strcat(Dana, "\t");
  t = time(&t);
  strcat(Dana, asctime(localtime(&t)));

  fprintf(PlikWyjsciowy, "%s", Dana);

  pDllVersion(TmpString);
  strcpy(Dana, "#");
  strcat(Dana, "Biblioteka ElzabDr wersja (ElzabDr library version)");
  strcat(Dana, "\t");
  strcat(Dana, TmpString);
  fprintf(PlikWyjsciowy, "%s\n", Dana);
  fprintf(PlikWyjsciowy, "#\n");
  if (argc<2)
  {
     strcpy(Dana, "501");
     strcat(Dana, "\t");
     strcat(Dana, "Brak nazwy pliku wejsciowego (No name of input file)");
     fprintf(PlikWyjsciowy, "%s\n", Dana);
     fclose(PlikWyjsciowy);
     return 1;
  }

  strcpy(NazwaPlikuWej, argv[1]);
  if (
       (PlikWejsciowy=fopen(NazwaPlikuWej, "rt"))==NULL
     )
  {

    fprintf(PlikWyjsciowy, "%s\n", "%Nie otwarto pliku wejsciowego (input file cannot be opened)");
    fclose(PlikWyjsciowy);
    return 1;
  }

//tu wpisywac kod
  do
  {
    fgets(LiniaZPliku, 255, PlikWejsciowy);
    if (LiniaZPliku[strlen(LiniaZPliku)-1]=='\n')
      LiniaZPliku[strlen(LiniaZPliku)-1]=0x00;
  }
  while ((strlen(LiniaZPliku)>1) && (LiniaZPliku[0]==';'));

//koniec tu wpisywac kod
  WyciagnijZLiniiArgument(1, LiniaZPliku, &Dana);
  NrPortu = atoi(Dana);
  if (!(NrPortu>0))
  {
    ObsluzBlad(500,1,"","Bledny format pliku wejsciowego (bad format of input file)");
  }

  WyciagnijZLiniiArgument(2, LiniaZPliku, &Dana);
  Predkosc = atoi(Dana);
  if (Predkosc<9600)
    Predkosc = 9600;

  WyciagnijZLiniiArgument(3, LiniaZPliku, &Dana);
  Timeout = atoi(Dana);
  if (Timeout<=0)
    Timeout = 5;

  WyciagnijZLiniiArgument(4, LiniaZPliku, &Dana);
  DebugMode = atoi(Dana);
  if (DebugMode)
    SetDebugMode();
  else
    ClearDebugMode();

  Blad = CommunicationInit(NrPortu, Predkosc, Timeout);
  if (Blad)
  {
    strcpy(Dana,"CommunicationInit(");
    itoa(NrPortu, TmpString, 10);
    strcat(Dana, TmpString);
    strcat(Dana, ")");
    ObsluzBlad(Blad, 1,Dana, "");
  }

  while (!feof(PlikWejsciowy))
  {
     fgets(LiniaZPliku, 255, PlikWejsciowy);
     if (LiniaZPliku[strlen(LiniaZPliku)-1]=='\n')
       LiniaZPliku[strlen(LiniaZPliku)-1]=0x00;
     Wartosc = 0;
     if (strlen(LiniaZPliku)==0)
       break;

     WyciagnijZLiniiArgument(2,LiniaZPliku, &Rabat);
     WyciagnijZLiniiArgument(1,LiniaZPliku, &Sprzed);
     WyciagnijZLiniiArgument(2,LiniaZPliku, &Nazwa);
     WyciagnijZLiniiArgument(3,LiniaZPliku, &Stawka);
     WyciagnijZLiniiArgument(4,LiniaZPliku, &Ilosc);
     WyciagnijZLiniiArgument(5,LiniaZPliku, &Cena);
     WyciagnijZLiniiArgument(6,LiniaZPliku, &Jedn);
     WyciagnijZLiniiArgument(7,LiniaZPliku, &MP);
     WyciagnijZLiniiArgument(8,LiniaZPliku, &Komunikat);

     if (strcmp(Komunikat, "")==0)
       strcpy(Komunikat, "0");
     if (strcmp(Jedn, "")==0)
       strcpy(Jedn, "szt.");

     if (strcmp(MP, "")==0)
       MPI = 0;
     else
     {
       MPI = atoi(MP);
       if (MPI<0)
       {
         ObsluzBlad(500,1,"","Bledny format pliku wejsciowego (bad format of input file)");
       }
     }

     switch (Sprzed[0])
     {
       case 'K'  :
                  strcpy(Dana, Rabat);
                  strcat(Dana, "\n\n");
                  #ifdef WINDOWS
                    strcat(Dana, "Nacinij  ENTER");
                    MessageBox(0,Dana,"", MB_ICONINFORMATION + MB_OK);
                  #elif defined LINUX
                    strcat(Dana, "Nacinij dowolny klawisz");
                    printf("%s", Dana);
                  #endif
                  #ifdef WINDOWS
                    while (!kbhit());
                  #endif
                  break;
       case 'O'  :
                  Blad = DailyReport(atoi(Rabat));
                  if (Blad)
                    ObsluzBlad(Blad, 1, "DailyReport","");

                  strcpy(Dana, "0");
                  strcat(Dana, "\t");
                  strcat(Dana, "Program zakonczony bezblednie");
                  fprintf(PlikWyjsciowy,"%s\n",Dana);
                  Blad=CommunicationEnd();
                  if (Blad)
                    ObsluzBlad(Blad,1,"CommunicationEnd","");
                  fclose(PlikWejsciowy);
                  fclose(PlikWyjsciowy);
                  return 1; //program
                  //break;

        case 'X':
                  WyciagnijZLiniiArgument(2, LiniaZPliku, &Dana);
                  Hour = atoi(Dana);
                  WyciagnijZLiniiArgument(3, LiniaZPliku, &Dana);
                  Minute = atoi(Dana);
                  Blad = ChangeTime(Hour, Minute);
                  if (Blad)
                    ObsluzBlad(Blad,1,"ChangeTime","");

                  strcpy(Dana, "0");
                  strcat(Dana, "\t");
                  strcat(Dana, "Program zakonczony bezblednie");
                  fprintf(PlikWyjsciowy,"%s\n",Dana);
                  Blad=CommunicationEnd();
                  if (Blad)
                    ObsluzBlad(Blad,1,"CommunicationEnd","");
                  fclose(PlikWejsciowy);
                  fclose(PlikWyjsciowy);
                  return 1;
                  //break;
        case 'E' :
                  Blad = PrintResume();
                  if (Blad)
                   ObsluzBlad(Blad, 1, "PrintResume","");

                  strcpy(Dana, "0");
                  strcat(Dana, "\t");
                  strcat(Dana, "Program zakonczony bezblednie");

                  Blad = CommunicationEnd();
                  if (Blad)
                    ObsluzBlad(Blad,1,"CommunicationEnd","");
                  fclose(PlikWejsciowy);
                  fclose(PlikWyjsciowy);
                  return 1;
                  //break;

        case 'V' :

                  Blad = ReadVAT(&IleStawek, &Stawki[1],&Stawki[2],&Stawki[3],
                                   &Stawki[4],&Stawki[5],&Stawki[6],&Stawki[7]);
                  if (Blad)
                    ObsluzBlad(Blad, 1, "ReadVAT","");

                   Blad = pReadUniqueNumber(Tmp);
                   if (Blad)
                     ObsluzBlad(Blad, 1, "ReadUniqueNumber","");
                   Blad = pReadClock(Time);
                   if (Blad)
                     ObsluzBlad(Blad, 1, "ReadClock","");

                   if (strlen(Time)>8)
                     Time[8] = 0x09;

                   strcpy(Dana, "0");
                   strcat(Dana, "\t");
                   strcat(Dana, "Program zakonczony bezblednie");
                  fprintf(PlikWyjsciowy,"%s\n",Dana);

                   for (Licznik=1; Licznik<=IleStawek; Licznik++)
                   {
                      if (Stawki[Licznik]==10000)
                        fprintf(PlikWyjsciowy,"ZWOLNIONA");
                      else
                        if (Stawki[Licznik]==25500)
                        fprintf(PlikWyjsciowy,"REZERWA");
                      else
                        {
                          itoa(Stawki[Licznik], Dana, 10);
                          fprintf(PlikWyjsciowy,Dana);
                        }
                        if (Licznik<IleStawek)
                           fprintf(PlikWyjsciowy, "\t");
                        else
                           fprintf(PlikWyjsciowy, "\n");
                   }
                   fprintf(PlikWyjsciowy, "%s\n", Tmp);
                   fprintf(PlikWyjsciowy, "%s\n", Time);
                   Blad=CommunicationEnd();
                   if (Blad)
                     ObsluzBlad(Blad,1,"CommunicationEnd","");
                   fclose(PlikWejsciowy);
                   fclose(PlikWyjsciowy);
                   return 1; //program
                   //break;


       case 'P'  :
                     WyciagnijZLiniiArgument(2, LiniaZPliku, &Dana);
                     Fiscal = atoi(Dana);
                     WyciagnijZLiniiArgument(3, LiniaZPliku, &Dana);
                     rr1 = atoi(Dana);
                     WyciagnijZLiniiArgument(4, LiniaZPliku, &Dana);
                     mm1 = atoi(Dana);
                     WyciagnijZLiniiArgument(5, LiniaZPliku, &Dana);
                     dd1 = atoi(Dana);
                     WyciagnijZLiniiArgument(6, LiniaZPliku, &Dana);
                     rr2 = atoi(Dana);
                     WyciagnijZLiniiArgument(7, LiniaZPliku, &Dana);
                     mm2 = atoi(Dana);
                     WyciagnijZLiniiArgument(8, LiniaZPliku, &Dana);
                     dd2 = atoi(Dana);

                     if ((mm1<1) || (mm1>12) || (mm2<1) || (mm2>12) || (dd1<1) || (dd1>31)
                        || (dd2<1) || (dd2>31))
                        ObsluzBlad(500,1,"","Bledny format pliku wejsciowego (bad input file format)");

                   Blad = PeriodReport(Fiscal, rr1, mm1, dd1, rr2, mm2, dd2);
                   if (Blad)
                     ObsluzBlad(Blad, 1, "PeriodReport","");

                   strcpy(Dana, "0");
                   strcat(Dana, "\t");
                   strcat(Dana, "Program zakonczony bezblednie");
                   fprintf(PlikWyjsciowy,"%s\n", Dana);
                   Blad = CommunicationEnd();
                   if (Blad)
                    ObsluzBlad(Blad,1,"CommunicationEnd","");
                   fclose(PlikWejsciowy);
                   fclose(PlikWyjsciowy);
                   return 1; //program
                   //break;

           case 'R':
                   break;
           case '+':
           case '-':
                    TylkoOtwarcieSzuflady = 0;
                    StawkaI = _atoi64 (Stawka);
                    CenaI   = _atoi64 (Cena);
                    IloscI  = _atoi64 (Ilosc);

                    if (Sprzed[0]=='+')
                    {
                       for (Licznik = 0; Licznik<=27; Licznik++)
                         if ((Nazwa[Licznik]<0x20) & (Nazwa[Licznik]>0x00))
                           Nazwa[Licznik]=' ';
                       if (PierwszyRaz)
                       {
                         ErasePayments();
                         EraseLines();
                         PierwszyRaz = 0;
                         Blad = ReceiptBegin();
                         if (Blad)
                           ObsluzBlad(Blad,1,"ReceiptBegin","");

                       }
                       KomunikatI = atoi(Komunikat);
                       Blad =pReceiptItem(1,Nazwa,StawkaI,KomunikatI,IloscI,MPI,Jedn,CenaI,&Wartosc);
                       if (Blad)
                       {
                        pErrMessage(Blad,TmpString);
                        ObsluzBlad(Blad,1,"ReceiptItem (sprzedaz)",TmpString);
                       }
                    }
                    else
                    {
                       KomunikatI = atoi(Komunikat);
                       for (Licznik = 0; Licznik<=27; Licznik++)
                         if ((Nazwa[Licznik]<0x20) & (Nazwa[Licznik]>0x00))
                           Nazwa[Licznik]=' ';
                       Blad = pReceiptItem(0,Nazwa,StawkaI,KomunikatI,IloscI,MPI,Jedn,CenaI,&Wartosc);
                       if (Blad)
                         ObsluzBlad(Blad,1,"ReceiptItem (korekta)","");
                    }
                    break;
       case 'S' :
                  TylkoOtwarcieSzuflady = 0;
                  if (PierwszyRaz)
                  {
                     ErasePayments();
                     EraseLines();
                     PierwszyRaz = 0;
                     Blad = ReceiptBegin();
                     if (Blad)
                       ObsluzBlad(Blad,1,"ReceiptBegin","");
                  }
                  Blad=PackageItem(0,(long)(atoi(Nazwa)),(long)(atoi(Stawka)),(long)_atoi64(Ilosc));
                  if (Blad)
                  {
                    pErrMessage(Blad,TmpString);
                    ObsluzBlad(Blad,0,"PackageItem (sprzedaz): ",TmpString);
                  }
                  break;
       case 's' :
                  TylkoOtwarcieSzuflady = 0;
                  if (PierwszyRaz)
                  {
                     ErasePayments();
                     EraseLines();
                     PierwszyRaz = 0;
                     Blad = ReceiptBegin();
                     if (Blad)
                       ObsluzBlad(Blad,1,"ReceiptBegin","");
                  }
                  Blad=PackageItem(2,(long)(atoi(Nazwa)),(long)(atoi(Stawka)),(long)_atoi64(Ilosc));
                  if (Blad)
                   ObsluzBlad(Blad,0,"PackageItem (anulowanie sprzedazy)","");
                  break;
       case 'Z' :
                  TylkoOtwarcieSzuflady = 0;
                  if (PierwszyRaz)
                  {
                     ErasePayments();
                     EraseLines();
                     PierwszyRaz = 0;
                     Blad = ReceiptBegin();
                     if (Blad)
                       ObsluzBlad(Blad,1,"ReceiptBegin","");
                  }
                  Blad=PackageItem(1,(long)(atoi(Nazwa)),(long)(atoi(Stawka)),(long)_atoi64(Ilosc));
                  if (Blad)
                  {
                   pErrMessage(Blad,TmpString);
                   ObsluzBlad(Blad,0,"%PackageItem (przyjecie): ",TmpString);
                  }
                  break;
       case 'z' :
                  TylkoOtwarcieSzuflady = 0;
                  if (PierwszyRaz)
                  {
                     ErasePayments();
                     EraseLines();
                     PierwszyRaz = 0;
                     Blad = ReceiptBegin();
                     if (Blad)
                       ObsluzBlad(Blad,1,"ReceiptBegin","");
                  }
                  Blad=PackageItem(3,(long)(atoi(Nazwa)),(long)(atoi(Stawka)),(long)_atoi64(Ilosc));
                  if (Blad)
                   ObsluzBlad(Blad,0,"PackageItem (anulowanie zwrotu)","");
                  break;
      case 'T'  :
                  TylkoOtwarcieSzuflady = 0;
                  if (PierwszyRaz)
                  {
                     ErasePayments();
                     EraseLines();
                     PierwszyRaz = 0;
                     Blad = ReceiptBegin();
                     if (Blad)
                       ObsluzBlad(Blad,1,"ReceiptBegin","");
                  }
                  Blad = PrintSubtotal();
                  if (Blad)
                  {
                   pErrMessage(Blad,TmpString);
                   ObsluzBlad(Blad,0,"%PrintSubtotal: ",TmpString);
                  }
                  break;
      case 'D'  :
                  WyciagnijZLiniiArgument(2,LiniaZPliku, &TmpString);
                  Blad = OpenDrawer(atoi(TmpString));
                  if (Blad)
                  {
                   pErrMessage(Blad,TmpString);
                   ObsluzBlad(Blad,0,"%OpenDrawer: ",TmpString);
                  }
                  break;
      case 'L' :  Blad = pFillLines(atoi(Nazwa),Stawka,&FreeLines);
                  if (Blad)
                    ObsluzBlad(Blad,0,"FillLines","");
                  break;
      case 'W' :  if (strcmp(MP,"")==0)
                    strcpy(MP, "1");
                  if (Nazwa[0] == '1')
                    Blad=pCurrencyPayment1(Stawka, Ilosc, _atoi64(Cena), _atoi64(Jedn), _atoi64(MP));
                   else
                     if (Nazwa[0] == '2')
                     Blad= pCurrencyPayment2(_atoi64(Stawka), _atoi64(Ilosc), _atoi64(Cena), _atoi64(Jedn), atoi(MP));
                   if (Blad)
                     ObsluzBlad(Blad,0,"pCurrencyPayment","");
                   break;
      case 'C' :
                  Blad=pFillPayment(atoi(Nazwa), Stawka, _atoi64(Ilosc), _atoi64(Cena));
                  if (Blad)
                     ObsluzBlad(Blad,0,"pFillPayment","");
                  break;
      case 'I'  : Blad=DiscountOrSurcharge(1, _atoi64(Nazwa));
                  if (Blad)
                    ObsluzBlad(Blad,0,"DiscountOrSurcharge","");
                  break;
      case 'H'  : Blad=DiscountOrSurcharge(0, _atoi64(Nazwa));
                  if (Blad)
                    ObsluzBlad(Blad,0,"DiscountOrSurcharge","");
                  break;
      case ';'  : continue;
                  //break;
      default   : ObsluzBlad(500,1,"","Bledny format pliku wejsciowego");

     }

  }
     if (Sprzed[0]=='R')
     {
       StawkaI = _atoi64(Stawka);
       Blad = ReceiptEndEx(_atoi64(Rabat), StawkaI);
     }
     else
       if (TylkoOtwarcieSzuflady)
       {
          fprintf(PlikWyjsciowy,"0\n");
          strcpy(Dana, "0");
          strcat(Dana, "\t");
          strcat(Dana, "Program zakonczony bezblednie");
          fprintf(PlikWyjsciowy,"%s\n", Dana);
       }
       else
         Blad = ReceiptEnd(0);


  if (Blad==0)
  {
    Blad = ReceiptNumber(&Numer);
    if (Blad==0)
    {
          strcpy(Dana, "0");
          strcat(Dana, "\t");
          strcat(Dana, "NrParagonu");
          strcat(Dana, "\t");
          itoa(Numer, TmpString, 10);
          strcat(Dana, TmpString);
          strcat(Dana, "\n");
          fprintf(PlikWyjsciowy,Dana);
          strcpy(Dana, "0");
          strcat(Dana, "\t");
          strcat(Dana, "Program zakonczony bezblednie");
          fprintf(PlikWyjsciowy,"%s\n", Dana);
    }
    else
      ObsluzBlad(Blad,0,"ReceiptNumber","");
  }
  else
    ObsluzBlad(Blad,1,"ReceiptEnd","");


  Blad = CommunicationEnd();
  if (Blad)
   ObsluzBlad(Blad,1,"CommunicationEnd","");

  fclose(PlikWejsciowy);
  fclose(PlikWyjsciowy);
  return 0;

}
//---------------------------------------------------------------------------
