#ifndef _posnet_hlapiH_
#define _posnet_hlapiH_

/*

	Nagwek w wersji: 1.1

*/

extern "C"
{

/*!
\defgroup hlapi_global API Wysokiego Poziomu
\brief Zestaw funkcji wysokiego poziomu obsugujcych rozkazy kasy.

Zestaw funkcji wysokiego poziomu skada si z dwch rodzajw funkcji. 
Pierwsza grupa o nazwach POSS_XXX suy do tworzenia i wysyania do kasy
rozkazw. Druga grupa funkcji o nazwach POSG_XXX suy do odbioru i analizy danych 
zwracanych w wyniku wysania odpowiedniego rozkazu do kasy.

Dokumentacje poszczeglnych parametrw funcji znajduj si w dokumentacji
programisty kasy COMBO. Wikszo parametrw literalnie odpowiada zarwno typami danych 
jak i przyjmowanymi wartociami. Jednake dla zmiejszenia iloci parametrw wywoa
w sytuacja, gdy w parametrach funkcji wystpuj wartoci i bloki powtarzajce si,
zostay one zastpione listami wartoci (znakowymi) oddzielanymi separatorami -
znakiem \\n (nowej linii). Oprcz tego, we wszystkich miejscach, gdzie wystpuj
pojcia daty i czasu s one przekazywane i zwracane w formacie zgodnym z ISO-8601 
w postaci cigu znakw o formacie: "RRRR-MM-DDTHH:MM:SS".

Kada funkcja POSS_XXX przyjmuje 3 standardowe parametry
 - hDevice - uchwyt urzdzenia,
 - phRequest - wskanik do \ref POSNET_HANDLE w ktrym umieszczony zostanie 
   uchwyt stworzonego i wysanego zapytania. Jei informacja ta nie jest pottrzebna
   mona przekaza warto NULL,
 - tryb - tryb wysyania rozkazu por. \ref req_modes
 .
Pozostae parametry s zalene od rozkazu.
\warning Funkcje POSS_ w przypadku bdu NIE USUWAJ stworzonego obiektu rozkazowego. Naley go
usun poprzez przekazanie do funkcji \ref POSG_Default lub uycie \ref POS_DestroyRequest.

Kada funcja POSG_XXX przyjmuje jeden standardowy parametr: 
 - hRequest - uchwyt odebranej odpowiedzi do rozkodowania.
 .

W przypadku, gdy wynik operacji nas nie interesuje moemy uy funcji \ref POSG_Default, 
ktra automatycznie zniszczy wynik, zwracajc jedynie status operacji (bez danych). W ten
sposb wszystkie operacje POSS_XXX maj sw odpowiednik w postaci POSG_XXX lub POSG_Default.

@{
*/

/*!
@}
*/


POSNET_API unsigned long __stdcall POS_GetHLLibraryVersion();

/*!
\defgroup hlapi_misc Obsuga domylna
\ingroup hlapi_global
@{
*/

POSNET_API POSNET_STATUS __stdcall POSG_Default(const POSNET_HANDLE hRequest);

/*!
@}
*/


/*!
\defgroup hlapi_trans Obsuga transakcji
\ingroup hlapi_global
@{
*/



/*! 
	\brief Realizacja rozkazu TRANSSTATUSGET - Odczyt statusu transakcji

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_TransStatusGet
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_TransStatusGet(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu TRANSSTATUSGET - Odczyt statusu transakcji

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_TransStatusGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_TransStatusGet(const POSNET_HANDLE phRequest,
														unsigned char *transakcja,
														unsigned char *paragon,
														unsigned char *anulowanie,
														unsigned short *numer_paragonu,
														char *data_czas,
														char *obrotA,
														char *obrotB,
														char *obrotC,
														char *obrotD,
														char *obrotE,
														char *obrotF,
														char *obrotG,
														char *obrot_suma,
														char *suma
														);

/*!
@}
*/




/*!
\defgroup hlapi_discount Obsuga rabatw
\ingroup hlapi_global
@{
*/

/*! 
	\brief Realizacja rozkazu AUTODISCNTINSEX - Programowanie rabatu czasowego
	
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty.

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_AutoDiscntInsEx(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_rekordu,
														   const unsigned short numer_rabatu,
														   const unsigned char rodzaj,
														   const char *data_pocz,
														   const char *godz_pocz,
														   const char *data_konc,
														   const char *godz_konc,
														   const unsigned char czy_nadpisac,
														   const unsigned char tryb
														   );

/*! 
	\brief Realizacja rozkazu AUTODISCNTREADEX - Odczyt rabatu czasowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_AutoDiscntReadEx
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_AutoDiscntReadEx(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short numer_rekordu,
													   const unsigned char tryb
													   );

/*! 
	\brief Realizacja rozkazu AUTODISCNTREADEX - Odczyt rabatu czasowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_AutoDiscntReadEx
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_AutoDiscntReadEx(const POSNET_HANDLE phRequest,
															unsigned short *numer_rekordu,
															unsigned short *numer_rabatu,
															unsigned char *rodzaj,
															char *data_pocz,
															char *godz_od,
															char *data_konc,
															char *godz_do
															);

/*! 
	\brief Realizacja rozkazu DISCNTSTATCLEARALL - Kasowanie wszystkich statystyk bazy rabatw/narzutw
	
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty.

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_DiscntStatClearAll(const POSNET_HANDLE hDevice,
																POSNET_HANDLE *phRequest,
																const unsigned char tryb=POSNET_REQMODE_SPOOL
																);


/*!
	\brief Realizacja rozkazu DBDISCNTPCSET - Ustawienie rabatu z bazy dla karty rabatowej
	
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DBDiscntPCSet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short kod_bledu,
														   const unsigned short numer_rabatu,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu MANUALDISCNTPCSET - Ustawienie rabatu z rki dla karty rabatowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_ManualDiscntPCSet(const POSNET_HANDLE hDevice,
															   POSNET_HANDLE *phRequest,
															   const unsigned short kod_bledu,
															   const char *nazwa_rabatu,
															   const unsigned char typ_rabatu,
															   const char *wartosc_rabatu,
															   const unsigned char czy_z_narzutami,
															   const unsigned char czy_z_rabatami,
															   const unsigned char tryb=POSNET_REQMODE_SPOOL
															   );
/*! 
	\brief Realizacja rozkazu AUTODISCNTDEL -  Usuwanie rabatu czasowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_AutoDiscntDel(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_rekordu,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu AUTODISCNTINS - Programowanie rabatu czasowego

	Parametry godz_pocz i godz_konc stanowi godzin i minuty w zapisie "GG:MM" w postaci cigu znakw.

	Pozostae parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_AutoDiscntIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_rekordu,
														   const unsigned short numer_rabatu,
														   const char *godz_pocz,
														   const char *godz_konc,
														   const unsigned char czy_nadpisac,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu DISCNTDELALL - Usuwanie bazy rabatw/narzutw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DiscntDelAll(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char flagi,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu DISCNTDEL - Usunicie rabatu/narzutu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DiscntDel(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short numer_rabatu,
													   const unsigned char czy_powiazane,
													   const unsigned char czy_niezerowe,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu PROMODISCNTINS - Programowanie rabatu promocji

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PromoDiscntIns(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned short numer_rekordu,
															const char *nazwa,
															const unsigned char wartosc_sprzedawana,
															const unsigned char wartosc_naliczana,
															const unsigned char czy_z_narzutami,
															const unsigned char czy_z_rabatami,
															const unsigned char czy_nadpisac,
															const unsigned char czy_nadpisac_niezerowe,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu PROGDISCNTINS - Programowanie rabatu progresywnego

	Pole wartosci - Lista wartosci poszczeglnych progw - liczby rozdzielone znakami nowej linii
	Pole kwoty - Lista kwot rabatowych dla poszczeglnych progw - liczby rozdzielone znakami nowej linii - ich ilo
	             musi si zgadza z iloci wartoci progw.

	Pozostae parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_ProgDiscntIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_rekordu,
														   const char *nazwa,
														   const unsigned char czy_rabat,
														   const unsigned char czy_procentowy,
														   const unsigned char ilosc_progow,
														   const char *wartosci,  // LICZBY ROZDZIELONE \n
														   const char *kwoty,
														   const unsigned char czy_z_narzutami,
														   const unsigned char czy_z_rabatami,
														   const unsigned char czy_nadpisac,
														   const unsigned char czy_nadpisac_niezerowe,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu STDDICNTINS - Programowanie rabatu standardowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_StdDiscntIns(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_rekordu,
														  const char *nazwa,
														  const unsigned char czy_rabat,
														  const unsigned char czy_procentowy,
														  const char *wartosc,
														  const unsigned char czy_z_narzutami,
														  const unsigned char czy_z_rabatami,
														  const unsigned char czy_nadpisac,
														  const unsigned char czy_nadpisac_niezerowe,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu CARDINFO - Odsyanie przez kas do PC informacji o karcie rabatowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

	Nie posiada czci nadawczej.
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_CardInfo(const POSNET_HANDLE phRequest,
													  char *numer_karty
													  );
/*! 
	\brief Realizacja rozkazu AUTODISCNTNEXTFREEGET - Znajdowanie wolnego rekordu w bazie rabatw czasowych poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_AutoDiscntNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_AutoDiscntNextFreeGet(const POSNET_HANDLE hDevice,
																   POSNET_HANDLE *phRequest,
																   const unsigned char numer_pocz,
																   const unsigned char tryb=POSNET_REQMODE_SPOOL
																   );
/*! 
	\brief Realizacja rozkazu  AUTODISCNTNEXTFREEGET - Znajdowanie wolnego rekordu w bazie rabatw czasowych poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

	Posiada cz nadawcz - POSG_AutoDiscntNextFreeGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_AutoDiscntNextFreeGet(const POSNET_HANDLE phRequest,
																   unsigned short *wolny_numer
																   );
/*! 
	\brief Realizacja rozkazu AUTODISCNTREAD - Odczyt rabatu czasowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_AutoDiscntRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_AutoDiscntRead(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned short numer_rekordu,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu AUTODISCNTREAD - Odczyt rabatu czasowego

	Godzina pocztkowa i kocowa obowizywania rabatu kodowane s w postaci cigu znakw
	w formacie "GG:MM" (5 znakw). Minimalny rozmiar bufora - 6 znakw.

	Pozostae parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_AutoDiscntRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_AutoDiscntRead(const POSNET_HANDLE phRequest,
															unsigned short *numer_rekordu,
															unsigned short *numer_rabatu,
															char *godz_od,
															char *godz_do
															);
/*! 
	\brief Realizacja rozkazu DISCNTGETBYNAME - Wyszukiwanie rekordu rabatu/narzutu po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DiscntGetByName
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DiscntGetByName(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const char *nazwa,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );
/*! 
	\brief Realizacja rozkazu DISCNTGETBYNAME - Wyszukiwanie rekordu rabatu/narzutu po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DiscntGetByName
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DiscntGetByName(const POSNET_HANDLE phRequest,
															 unsigned short *numer_rekordu
															 );
/*! 
	\brief Realizacja rozkazu  DISCNTSTATREAD - Odczyt statystyki rabatu/narzutu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DiscntStatRead
*/


POSNET_API	POSNET_STATUS	__stdcall	POSS_DiscntStatRead(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned short numer_rekordu,
															const unsigned char czy_zerowac,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu DISCNTSTATREAD - Odczyt statystyki rabatu/narzutu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DiscntStatRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DiscntStatRead(const POSNET_HANDLE phRequest,
															unsigned short *numer_rekordu,
															char *statystyka
															);
/*! 
	\brief Realizacja rozkazu DISCNTNEXTFREEGET - Znajdowanie wolnego rekordu bazy rabatw/narzutw poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DiscntNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DiscntNextFreeGet(const POSNET_HANDLE hDevice,
															   POSNET_HANDLE *phRequest,
															   const unsigned short numer_rekordu,
															   const unsigned char tryb=POSNET_REQMODE_SPOOL
															   );
/*! 
	\brief Realizacja rozkazu DISCNTNEXTFREEGET - Znajdowanie wolnego rekordu bazy rabatw/narzutw poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DiscntNextFreeGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DiscntNextFreeGet(const POSNET_HANDLE phRequest,
															   unsigned short *wolny_numer
															   );
/*! 
	\brief Realizacja rozkazu DISCNTREAD - Odczyt rekordu rabatu/narzutu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DiscntRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DiscntRead(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_rekordu,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu DISCNTREAD - Odczyt rekordu rabatu/narzutu

	Pola wartosci, progi, wart_M i wart_N s ustawiane w zalenoci od typu rabatu:
	-  dla rabatu standardowego - pole wartosci zawiera warto rabatu (pojedyncza liczba)
	-  dla rabatu progresywnego - pola wartosci i kwoty zawieraj odpowiednio listy wartoci i kwot rozdzielane znakiem nowej linii
	-  dla rabatu promocja - ustawione s pola wart_M i wart_N
	.

	Pozostae parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DiscntRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DiscntRead(const POSNET_HANDLE phRequest,
														unsigned short *numer_rekordu,
														char *nazwa,
														unsigned char *czy_z_narzutami,
														unsigned char *czy_z_rabatami,
														unsigned char *rodzaj,

														unsigned char *typ,
														char *wartosci,
														char *progi,
														unsigned char *wart_M,
														unsigned char *wart_N
														);


/*!
@}
*/




/*!
\defgroup hlapi_hotkey Obsuga klawiszy
\ingroup hlapi_global
@{
*/

/*! 
	\brief Realizacja rozkazu HOTKEYPLUINSEX - Zaprogramowanie klawisza przypisanego do sprzeday PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyPLUInsEx(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_klawisza,
														  const unsigned short numer_PLU,
														  const char *ilosc,
														  const unsigned short numer_platnosci,
														  const unsigned char czy_nadpisac,
														  const unsigned char czy_wazony,
														  const unsigned char tryb
														  );
/*! 
	\brief Realizacja rozkazu HOTKEYREPCASHOUTDESCINS - Przypisanie do klawisza skrtu raportu bazy opisw wypaty

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepCashoutDescIns(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short klawisz,
													  const unsigned short numer_rekordu,
													  const unsigned char czy_nadpisac,
													  const unsigned char tryb
													  );

/*! 
	\brief Realizacja rozkazu HOTKEYREPCURRUSERINS - Przypisanie do klawisza skrtu raportu zalogowanego kasjera

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepCurrUserIns(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short klawisz,
													  const unsigned char typ_raportu,
													  const unsigned char czy_nadpisac,
													  const unsigned char tryb
													  );
/*! 
	\brief Realizacja rozkazu HOTKEYREPPOGDAILYINS - Przypisanie do klawisza skrtu raportu pogldowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepPogDailyIns(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short klawisz,
													  const unsigned char czy_nadpisac,
													  const unsigned char tryb
													  );
/*! 
	\brief Realizacja rozkazu HOTKEYREPPLUDESCINS - Przypisanie do klawisza skrtu raportu opisw towarw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepPLUDescIns(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short klawisz,
													  const unsigned char czy_nadpisac,
													  const unsigned char tryb
													  );
/*! 
	\brief Realizacja rozkazu HOTKEYREPHOURSINS - Przypisanie do klawisza skrtu raportu godzinowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepHoursIns(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short klawisz,
													  const unsigned char typ_rekordu,
													  const unsigned char zakres,
													  const unsigned char czy_nadpisac,
													  const unsigned char tryb
													  );



/*! 
	\brief Realizacja rozkazu HOTKEYREPCOMMINS - Dodanie klawisza raportu komunikacji
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_HotkeyRepCommIns(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short klawisz,
													 const unsigned char czy_nadpisac,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );

/*! 
	\brief Realizacja rozkazu HOTKEYDELALL - Usunicie bazy klawiszy szybkich

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> wszystkie
	\par
	<b>Kasy:</b> NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyDelAll(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu HOTKEYDEL - Usunicie klawisza szybkiego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyDel(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short numer_rekordu,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu HOTKEYREPSETINS - Zaprogramowanie klawisza szybkiego przypisanego do zestaww raportw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepSetIns(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned short numer_klawisza,
															 const unsigned short numer_zestawu,
															 const unsigned char czy_nadpisac,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu HOTKEYFUNCINS - Zaprogramowanie klawisza szybkiego realizujcego okrelone funkcje

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyFuncIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_klawisza,
														   const unsigned short ident_funkcji,
														   const unsigned long parametry,
														   const unsigned char czy_nadpisac,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu HOTKEYPACKINS - Zaprogramowanie klawisza szybkiego przypisanego do opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyPackIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_rekordu,
														   const unsigned short numer_opakowania,
														   const char *ilosc,
														   const unsigned char czy_wydanie,
														   const unsigned char czy_nadpisac,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );



/*! 
	\brief Realizacja rozkazu HOTKEYCURRENCYINS - Zaprogramowanie klawisza szybkiego realizujcego przeliczanie walut

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyCurrencyIns(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short klawisz,
														  const unsigned short numer_platnosci,
														  const unsigned char czy_nadpisac,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );


/*! 
	\brief Realizacja rozkazu HOTKEYFORMINS - Zaprogramowanie klawisza przypisanego do form patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyFormIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_klawisza,
														   const unsigned short numer_platnosci,
														   const unsigned char czy_nadpisac,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu HOTKEYDISCNTINS - Zaprogramowanie klawisza przypisanego do rabatw/narzutw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyDiscntIns(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned short numer_klawisza,
															 const unsigned short numer_rabatu,
															 const unsigned char czy_nadpisac,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );
/*! 
	\brief Realizacja rozkazu HOTKEYPLUINS - Zaprogramowanie klawisza przypisanego do sprzeday PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyPLUIns(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_klawisza,
														  const unsigned short numer_PLU,
														  const char *ilosc,
														  const unsigned short numer_platnosci,
														  const unsigned char czy_nadpisac,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu HOTKEYNEXTFREEGET - Znajdowanie wolnego rekordu w bazie klawiszy szybkich  poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_HotkeyNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyNextFreeGet(const POSNET_HANDLE hDevice,
															   POSNET_HANDLE *phRequest,
															   const unsigned short numer_poczatkowy,
															   const unsigned char tryb=POSNET_REQMODE_SPOOL
															   );
/*! 
	\brief Realizacja rozkazu HOTKEYNEXTFREEGET - Znajdowanie wolnego rekordu w bazie klawiszy szybkich  poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_HotkeyNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSG_HotkeyNextFreeGet(const POSNET_HANDLE phRequest,
															   unsigned short *numer
															   );


/*! 
	\brief Realizacja rozkazu HOTKEYREPPLUBYRECRANGEINS - Przypisanie do klawisza szybkiego raportu bazy PLU wg zakresu rekordw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepPLUByRecRangeIns(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned short klawisz,
															const unsigned char identyfikator,
															const unsigned char typ_raportu,
															const unsigned char zakres_raportu,
															const unsigned short numer_pocz,
															const unsigned short numer_konc,
															const unsigned char czy_nadpisac,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu HOTKEYREPPLUBYGROUPINS - Przypisanie do klawisza szybkiego raportu bazy PLU wg grupy towarowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepPLUByGroupIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short klawisz,
														   const unsigned char identyfikator,
														   const unsigned char typ_raportu,
														   const unsigned char zakres_raportu,
														   const unsigned char numer_grupy,
														   const unsigned char czy_nadpisac,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu HOTKEYREPPLUBYVATINS - Przypisanie do klawisza szybkiego raportu bazy PLU wg stawki VAT

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepPLUByVATIns(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned short klawisz,
														 const unsigned char identyfikator,
														 const unsigned char typ_raportu,
														 const unsigned char zakres_raportu,
														 const unsigned char stawka_vat,
														 const unsigned char czy_nadpisac,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu HOTKEYREPAUTODISCNTINS - Przypisanie do klawisza szybkiego raportu bazy rabatw czasowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepAutoDisntIns(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short klawisz,
														  const unsigned char typ_raportu,
														  const unsigned char zakres_raportu,
														  const unsigned short numer_rekordu,
														  const unsigned char czy_nadpisac,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu HOTKEYREPGROUPSTATINS - Przypisanie do klawisza szybkiego raportu statystyk bazy grup towarowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepGroupStatIns(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short klawisz,
														  const unsigned char rodzaj_raportu,
														  const unsigned char typ_raportu,
														  const unsigned char zakres,
														  const unsigned short numer_rekordu,
														  const unsigned char czy_nadpisac,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu HOTKEYREPGROUPINS - Przypisanie do klawisza szybkiego bazy grup towarowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepGroupIns(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short klawisz,
													  const unsigned char typ_raportu,
													  const unsigned char zakres_raportu,
													  const unsigned short numer_rekordu,
													  const unsigned char czy_nadpisac,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );
/*! 
	\brief Realizacja rozkazu HOTKEYREPPAYFORMINS - Przypisanie do klawisza szybkiego raportu bazy form patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepPayFormIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short klawisz,
														const unsigned char typ_raportu,
														const unsigned char zakres_raportu,
														const unsigned short numer_rekordu,
														const unsigned char czy_nadpisac,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);

/*! 
	\brief Realizacja rozkazu HOTKEYREPSHORTAGEPACKINS - Przypisanie do klawisza szybkiego raportu brakw magazynowych opakowan

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepShortagePackIns(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short klawisz,
													 const unsigned char czy_nadpisac,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
														);


/*! 
	\brief Realizacja rozkazu HOTKEYREPNOTEPADINS - Przypisanie do klawisza szybkiego raportu notatnika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepNotepadIns(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short klawisz,
													 const unsigned char czy_nadpisac,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
														);

/*! 
	\brief Realizacja rozkazu HOTKEYREPDISCNTINS - Przypisanie do klawisza szybkiego raportu bazy rabatw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepDiscntIns(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short klawisz,
													   const unsigned char typ_raportu,
													   const unsigned char zakres_raportu,
													   const unsigned short numer_rekordu,
													   const unsigned char czy_nadpisac,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu HOTKEYREPPACKINS - Przypisanie do klawisza szybkiego raportu opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepPackIns(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short klawisz,
													 const unsigned char typ_raportu,
													 const unsigned char zakres_raportu,
													 const unsigned short numer_rekordu,
													 const unsigned char czy_nadpisac,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu HOTKEYREPREPSETINS - Przypisanie do klawisza szybkiego raportu zestaww raportw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepRepSetIns(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short klawisz,
													   const unsigned short numer_zestawu,
													   const unsigned char czy_nadpisac,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu HOTKEYREPHOTKEYINS - Przypisanie do klawisza szybkiego raportu bazy klawiszy szybkich

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepHotkeyIns(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short klawisz,
													   const unsigned short numer_rekordu,
													   const unsigned char czy_nadpisac,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu HOTKEYREPCODEFMTINS - Przypisanie do klawisza szybkiego raportu bazy formatw kodw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepCodeFmtIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short klawisz,
														const unsigned short numer_rekordu,
														const unsigned char czy_nadpisac,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu HOTKEYREPMUINS - Przypisanie do klawisza szybkiego raportu bazy jednostek miary

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepMUIns(const POSNET_HANDLE hDevice,
												   POSNET_HANDLE *phRequest,
												   const unsigned short klawisz,
												   const unsigned short numer_rekordu,
												   const unsigned char czy_nadpisac,
												   const unsigned char tryb=POSNET_REQMODE_SPOOL
												   );
/*! 
	\brief Realizacja rozkazu HOTKEYREPCFGSALEINS - Przypisanie do klawisza szybkiego raportu konfiguracji sprzeday

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepCfgSaleIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short klawisz,
														const unsigned char czy_nadpisac,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu HOTKEYREPCFGCOMMINS - Przypisanie do klawisza szybkiego raportu konfiguracji we/wy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepCfgCommIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short klawisz,
														const unsigned char czy_nadpisac,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu HOTKEYREPSERVICEINS - Przypisanie do klawisza szybkiego raportu serwisowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepServiceIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short klawisz,
														const unsigned char czy_nadpisac,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu HOTKEYREPCASHREGINS - Przypisanie do klawisza szybkiego raportu kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepCashRegIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short klawisz,
														const unsigned char czy_nadpisac,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu HOTKEYREPINACTIVEPLUINS - Przypisanie do klawisza szybkiego raportu nieaktywnych PLU

	Pole daty - cig znakw w formacie "RRRR-MM-DD"

	Pozostae parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepInactivePLUIns(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned short klawisz,
															const char *date,
															const unsigned char czy_nadpisac,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu HOTKEYREPFSKPERIODINS - Przypisanie do klawisza szybkiego raportu okresowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepFskPeriodIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short klawisz,
														   const unsigned char czy_nadpisac,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu HOTKEYREPFSKDAILYINS - Przypisanie do klawisza szybkiego raportu dobowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepFskDailyIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short klawisz,
														   const unsigned char czy_nadpisac,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu HOTKEYREPFSKMONTHLYINS - Przypisanie do klawisza szybkiego raportu miesicznego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepFskMonthlyIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short klawisz,
														   const unsigned char czy_nadpisac,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu HOTKEYREPPTUINS - Przypisanie do klawisza szybkiego raportu stawek VAT

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepPTUIns(const POSNET_HANDLE hDevice,
													POSNET_HANDLE *phRequest,
													const unsigned short klawisz,
													const unsigned char czy_nadpisac,
													const unsigned char tryb=POSNET_REQMODE_SPOOL
													);
/*! 
	\brief Realizacja rozkazu HOTKEYREPUSERINS - Przypisanie do klawisza szybkiego raportu bazy kasjerw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepUserIns(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short klawisz,
													 const unsigned char typ_raportu,
													 const unsigned char zakres_raportu,
													 const unsigned short numer_rekordu,
													 const unsigned char czy_nadpisac,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu HOTKEYREPSTOREPACKINS - Przypisanie do klawisza szybkiego raportu stanw magazynowych opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepStorePackIns(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short klawisz,
														  const unsigned char czy_nadpisac,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );

/*! 
	\brief Realizacja rozkazu HOTKEYREPCFGHARDWAREINS - Przypisanie do klawisza szybkiego raportu konfiguracji sprztu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepCfgHardwareIns(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned short klawisz,
															const unsigned char czy_nadpisac,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu HOTKEYREPPLUBYRECNOINS - Przypisanie do klawisza szybkiego raportu bazy PLU wg numerw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRepPLUByRecNoIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short klawisz,
														   const unsigned char identyfikator,
														   const unsigned char typ_raportu,
														   const unsigned char zakres_raportu,
														   const unsigned short numer_rekordu,
														   const unsigned char czy_nadpisac,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );


/*!
@}
*/

/*!
\defgroup hlapi_hotkeyreadcodes Kody klawiszy skrtu
\ingroup hlapi_hotkeyread
@{
*/


#define POSNET_HOTKEY_TYPE_QUICKSALE	1	//!< Klawisz szybkiej sprzeday
#define POSNET_HOTKEY_TYPE_DISCOUNT		2	//!< Klawisz rabatu/narzutu
#define POSNET_HOTKEY_TYPE_PAYFORM		3	//!< Klawisz formy patnoci
#define POSNET_HOTKEY_TYPE_PACK			4	//!< Klawisz opakowania
#define POSNET_HOTKEY_TYPE_FUNCTION		5	//!< Klawisz funkcyjny
#define POSNET_HOTKEY_TYPE_REPSET		6	//!< Klawisz zestawu raportw
#define POSNET_HOTKEY_TYPE_REPORT		7	//!< Klawisz raportu
#define POSNET_HOTKEY_TYPE_CURRENCY		8	//!< Klawisz przeliczania walut

/*!
@}
*/

/*!
\defgroup hlapi_hotkeyread Obsuga odczytu klawiszy skrtu
\ingroup hlapi_hotkey
@{
*/

/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada zoon cz odbiorcz - \ref POSG_HotkeyReadGetType, \ref POSG_HotkeyReadGetQuickSale,
	\ref POSG_HotkeyReadGetDiscount, \ref POSG_HotkeyReadGetPayform, \ref POSG_HotkeyReadGetPack,
	\ref POSG_HotkeyReadGetFunction, \ref POSG_HotkeyReadGetRepSet, \ref POSG_HotkeyReadGetReport
*/


POSNET_API	POSNET_STATUS	__stdcall	POSS_HotkeyRead(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);

/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Ze wzgldu na wariantowo danych, ich odbir odbywa si przy pomocy dwch funkcji -
	najpierw uywa si \ref POSG_HotkeyReadGetType aby uzyska rodzaj klawisza
	skrtu okrelony staymi \ref hlapi_hotkeyreadcodes a nastpnie przy pomocy
	pozostaych funkcji POSG_HotkeyReadGetXXXXX (\ref POSG_HotkeyReadGetQuickSale,
	\ref POSG_HotkeyReadGetDiscount, \ref POSG_HotkeyReadGetPayform, \ref POSG_HotkeyReadGetPack,
	\ref POSG_HotkeyReadGetFunction, \ref POSG_HotkeyReadGetRepSet, \ref POSG_HotkeyReadGetReport)
	odpowiednio do odebranego typu klawisza.

	Funkcja POSG_HotkeyReadGetType NIE USUWA odpowiedzi, pozostae funkcje usuwaj wynik.

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_HotkeyRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSG_HotkeyReadGetType(const POSNET_HANDLE phRequest,
															   unsigned short *numer,
															   unsigned short *typ
															   );


/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Cz odbierajca wyniki polecenia dla klawisza sprzeday szybkiej \ref POSNET_HOTKEY_TYPE_QUICKSALE

	Parametry zgodne z Instrukcj Programisty
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> COMBO,NEO
	\par
    Posiada cz nadawcz - \ref POSS_HotkeyRead, oraz odbiorcz \ref POSG_HotkeyReadGetType.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSG_HotkeyReadGetQuickSale(const POSNET_HANDLE phRequest,
																	unsigned short *PLU,
																	char *ilosc,
																	unsigned char *platnosc
																	);

/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Cz odbierajca wyniki polecenia dla klawisza sprzeday szybkiej \ref POSNET_HOTKEY_TYPE_QUICKSALE

	Parametry zgodne z Instrukcj Programisty
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
    Posiada cz nadawcz - \ref POSS_HotkeyRead, oraz odbiorcz \ref POSG_HotkeyReadGetType.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSG_v2_HotkeyReadGetQuickSale(const POSNET_HANDLE phRequest,
																unsigned short *PLU,
																char *ilosc,
																unsigned char *platnosc,
																unsigned char *czy_wazony
															   );


/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Cz odbierajca wyniki polecenia dla klawisza rabatu \ref POSNET_HOTKEY_TYPE_DISCOUNT

	Parametry zgodne z Instrukcj Programisty

    Posiada cz nadawcz - \ref POSS_HotkeyRead, oraz odbiorcz \ref POSG_HotkeyReadGetType.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSG_HotkeyReadGetDiscount(const POSNET_HANDLE phRequest,
																   unsigned char *numer
																   );
/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Cz odbierajca wyniki polecenia dla klawisza przeliczania form patnoci \ref POSNET_HOTKEY_TYPE_CURRENCY

	Parametry zgodne z Instrukcj Programisty

    Posiada cz nadawcz - \ref POSS_HotkeyRead, oraz odbiorcz \ref POSG_HotkeyReadGetType.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSG_HotkeyReadGetCurrency(const POSNET_HANDLE phRequest,
																   unsigned char *numer
																   );

/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Cz odbierajca wyniki polecenia dla klawisza formy patnoci \ref POSNET_HOTKEY_TYPE_PAYFORM

	Parametry zgodne z Instrukcj Programisty

    Posiada cz nadawcz - \ref POSS_HotkeyRead, oraz odbiorcz \ref POSG_HotkeyReadGetType.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSG_HotkeyReadGetPayform(const POSNET_HANDLE phRequest,
																  unsigned char *numer
															   );
/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Cz odbierajca wyniki polecenia dla klawisza opakowania \ref POSNET_HOTKEY_TYPE_PACK

	Parametry zgodne z Instrukcj Programisty

    Posiada cz nadawcz - \ref POSS_HotkeyRead, oraz odbiorcz \ref POSG_HotkeyReadGetType.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSG_HotkeyReadGetPack(const POSNET_HANDLE phRequest,
															   unsigned char *numer,
															   char *ilosc,
															   unsigned char *tryb
															   );
/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Cz odbierajca wyniki polecenia dla klawisza funkcyjnego \ref POSNET_HOTKEY_TYPE_FUNCTION

	Parametry zgodne z Instrukcj Programisty

    Posiada cz nadawcz - \ref POSS_HotkeyRead, oraz odbiorcz \ref POSG_HotkeyReadGetType.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSG_HotkeyReadGetFunction(const POSNET_HANDLE phRequest,
																   unsigned char *numer,
																   unsigned long *port
																   );
/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Cz odbierajca wyniki polecenia dla klawisza zestawu raportw \ref POSNET_HOTKEY_TYPE_REPSET

	Parametry zgodne z Instrukcj Programisty

    Posiada cz nadawcz - \ref POSS_HotkeyRead, oraz odbiorcz \ref POSG_HotkeyReadGetType.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSG_HotkeyReadGetRepSet(const POSNET_HANDLE phRequest,
																 unsigned short *numer
																 );

/*! 
	\brief Realizacja rozkazu HOTKEYREAD - Odczyt klawisza skrtu

	Cz odbierajca wyniki polecenia dla klawisza raportu \ref POSNET_HOTKEY_TYPE_REPORT

	Parametry zgodne z Instrukcj Programisty

    Posiada cz nadawcz - \ref POSS_HotkeyRead, oraz odbiorcz \ref POSG_HotkeyReadGetType.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSG_HotkeyReadGetReport(const POSNET_HANDLE phRequest,
																 unsigned short *raport,
																 unsigned char *zakres,
																 unsigned char *rekordy,
																 unsigned short *rekord_od,
																 unsigned short *rekord_do
																 );

/*!
@}
*/




/*!
\defgroup hlapi_report Obsuga raportw
\ingroup hlapi_global
@{
*/
/*! 
	\brief Realizacja rozkazu REPPLUDESC - Raport opisw towarw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPLUDesc(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_rekordu,
														  const unsigned char tryb
														  );
/*! 
	\brief Realizacja rozkazu REPHOURS - Raport godzinowy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_RepHours(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char rodzaj,
														  const unsigned char zakres,
														  const unsigned char tryb
														  );
/*! 
	\brief Realizacja rozkazu REPNOFSKDAILY - Raport dobowy pogldowy (niefiskalny)

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_RepNoFskDaily(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char tryb
														  );
															

/*! 
	\brief Realizacja rozkazu REPCOMM - Raport komunikacji
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> wszystkie
	\par
	<b>Kasy:</b> NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_RepComm(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );

/*! 
	\brief Realizacja rozkazu REPSHORTAGEPACK - Raport brakw magazynowych opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepShortagePack(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu REPNOTEPAD - Raport notatnika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepNotepad(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );

/*! 
	\brief Realizacja rozkazu REPFSKMONTHLY - Raport fiskalny miesiczny

	Data w formacie "RRRR-MM-DD".

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepFskMonthly(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const char *data,
														   const unsigned char czy_podsumowania,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu REPFSKPERIODBYDATE - Raport fiskalny okresowy wg dat

	Daty w formacie "RRRR-MM-DD"

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepFskPeriodByDate(const POSNET_HANDLE hDevice,
																POSNET_HANDLE *phRequest,
																const char *data_od,
																const char *data_do,
																const unsigned char czy_podsumowania,
																const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu REPFSKPERIODBYNUM - Raport fiskalny okresowy wg numerw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepFskPeriodByNum(const POSNET_HANDLE hDevice,
															   POSNET_HANDLE *phRequest,
															   const unsigned short num_od,
															   const unsigned short num_do,
															   const unsigned char czy_podsumowania,
															   const unsigned char tryb=POSNET_REQMODE_SPOOL
															   );
/*! 
	\brief Realizacja rozkazu REPFSKDAILY - Raport fiskalny dobowy

	Data i czas w formacie: "RRRR-MM-DD HH:MM"

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepFskDaily(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char czy_z_data,
														 const char *date_time,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu REPINACTIVEPLU - Raport nieaktywnych PLU

	Data w formacie "RRRR-MM-DD"

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepInactivePLU(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const char *date,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu REPAUTODISCNT - Raport rabatw czasowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepAutoDiscnt(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_rekordu,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu REPGROUPSTAT - Raport statystyk grup towarowych w rozbiciu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepGroupStat(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char rodzaj_raportu,
														  const unsigned char typ_raportu,
														  const unsigned char zakres,
														  const unsigned short numer_rekordu,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu REPGROUP - Raport grup towarowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepGroup(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned char typ_raportu,
													  const unsigned char zakres_raportu,
													  const unsigned short numer_rekordu,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );
/*! 
	\brief Realizacja rozkazu REPCODEFMT - Raport formatw kodw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepCodeFmt(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_rekordu,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu REPREPSET - Raport zestaww raportw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepRepSet(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short numer_zestawu,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu REPHOTKEY - Raport klawiszy szybkich

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepHotkey(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short numer_rekordu,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu REPMU - Raport jednostek miary

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepMU(const POSNET_HANDLE hDevice,
												   POSNET_HANDLE *phRequest,
												   const unsigned short numer_rekordu,
												   const unsigned char tryb=POSNET_REQMODE_SPOOL
												   );
/*! 
	\brief Realizacja rozkazu REPPAYFORM - Raport form patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPayForm(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char typ_raportu,
														const unsigned char zakres_raportu,
														const unsigned short numer_rekordu,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu REPDISCNT - Raport rabatw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepDiscnt(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned char typ_raportu,
													   const unsigned char zakres_raportu,
													   const unsigned short numer_rekordu,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu REPUSER - Raport kasjerw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepUser(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned char typ_raportu,
													 const unsigned char zakres_raportu,
													 const unsigned short numer_rekordu,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu REPPACK - Raport opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPack(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned char typ_raportu,
													 const unsigned char zakres_raportu,
													 const unsigned short numer_rekordu,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu REPPLUBYGROUP - Raport PLU wg grupy towarowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPLUByGroup(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char identyfikator,
														   const unsigned char typ_raportu,
														   const unsigned char zakres_raportu,
														   const unsigned char numer_grupy,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu REPPLUBYVAT - Raport PLU wg stawki VAT

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPLUByVAT(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char identyfikator,
														 const unsigned char typ_raportu,
														 const unsigned char zakres_raportu,
														 const unsigned char stawka_vat,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu REPPLUBYNAMERANGE - Raport PLU wg zakresu nazw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPLUByNameRange(const POSNET_HANDLE hDevice,
															   POSNET_HANDLE *phRequest,
															   const unsigned char identyfikator,
															   const unsigned char typ_raportu,
															   const unsigned char zakres_raportu,
															   const char *nazwa_pocz,
															   const char *nazwa_koncowa,
															   const unsigned char tryb=POSNET_REQMODE_SPOOL
															   );
/*! 
	\brief Realizacja rozkazu REPPLUBYRECRANGE - Raport PLU wg zakresw rekordw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPLUByRecRange(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned char identyfikator,
															const unsigned char typ_raportu,
															const unsigned char zakres_raportu,
															const unsigned short numer_pocz,
															const unsigned short numer_konc,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu REPPLUBYRECNO - Raport PLU wg numeru rekordu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPLUByRecNo(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char identyfikator,
														   const unsigned char typ_raportu,
														   const unsigned char zakres_raportu,
														   const unsigned short numer_rekordu,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu REPCASHREG - Raport kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepCashReg(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu REPSERVICE - Raport serwisowy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepService(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu REPCFGCOMM - Raport konfiguracji we/wy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepCfgComm(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu REPCFGHARDWARE - Raport konfiguracji sprztu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepCfgHardware(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu REPCFGSALE - Raport konfiguracji sprzeday

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepCfgSale(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu REPPTU - Raport stawek VAT

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPTU(const POSNET_HANDLE hDevice,
													POSNET_HANDLE *phRequest,
													const unsigned char tryb=POSNET_REQMODE_SPOOL
													);
/*! 
	\brief Realizacja rozkazu REPSTOREPACK - Raport brakw magazynowych opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepStorePack(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );


/*! 
	\brief Realizacja rozkazu REPPLUBYCODE- Raport pojedynczego PLU wg kodu kreskowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPluByCode(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char identyfikator_raportu,
														  const unsigned char typ_raportu,
														  const unsigned char zakres_raportu,
														  const char *kod_kreskowy,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu REPPLUBYCODERANGE - Raport PLU wg kodw kreskowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_RepPluByCodeRange(const POSNET_HANDLE hDevice,
															   POSNET_HANDLE *phRequest,
															   const unsigned char identyfikator_raportu,
															   const unsigned char typ_raportu,
															   const unsigned char zakres_raportu,
															   const char *kod_kreskowy_od,
															   const char *kod_kreskowy_do,
															   const unsigned char tryb=POSNET_REQMODE_SPOOL
															   );

/*!
@}
*/




/*!
\defgroup hlapi_barcode Obsuga kodw kreskowych
\ingroup hlapi_global
@{
*/
/*! 
	\brief Realizacja rozkazu CODEFMTDELALL - Usunicie bazy formatw kodw kreskowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CodeFmtDelAll(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu BARCODEDEL - Usuwanie wybranego kodu kreskowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_BarcodeDel(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const char *kod_kreskowy,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu BARCODEDELALLFORPLU - Usuwanie wszystkich kodw kreskowych dla wybranego PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_BarcodeDelAllForPLU(const POSNET_HANDLE hDevice,
																 POSNET_HANDLE *phRequest,
																 const unsigned short numer_PLU,
																 const unsigned char tryb=POSNET_REQMODE_SPOOL
																 );
/*! 
	\brief Realizacja rozkazu BARCODEINS - Programowanie kodw kreskowych

	Pole barcodes zawiera poszczeglne kody kreskowe rozdzielone znakiem nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_BarcodeIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_plu,
														const char *barcodes, // \n separated
														const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu CODEFMTDEL - Usuwanie rekordu formatu kodu kreskowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CodeFmtDel(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_rekordu,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu CODEFMTINS - Programowanie formatu kodu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CodeFmtIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_rekordu,
														const char *format,
														const unsigned char czy_nadpisac,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu BARCODEREAD - Odczyt dodatkowych kodw kreskowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_BarcodeRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_BarcodeRead(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned short numer_PLU,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu BARCODEREAD - Odczyt dodatkowych kodw kreskowych

	Pole barcodes - umieszczane s w nim kody kreskowe rozdzielone znakami nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_BarcodeRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_BarcodeRead(const POSNET_HANDLE phRequest,
														unsigned short *czytany,
														 char *barcodes // rozdzielone \n
														 );
/*! 
	\brief Realizacja rozkazu CODEFMTNEXTFREEGET - Znajdowanie wolnego rekordu formatw kodw kreskowych poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_CodeFmtNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CodeFmtNextFreeGet(const POSNET_HANDLE hDevice,
																POSNET_HANDLE *phRequest,
																const unsigned short numer_poczatkowy,
																const unsigned char tryb=POSNET_REQMODE_SPOOL
																);
/*! 
	\brief Realizacja rozkazu CODEFMTNEXTFREEGET - Znajdowanie wolnego rekordu formatw kodw kreskowych poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_CodeFmtNextFreeGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_CodeFmtNextFreeGet(const POSNET_HANDLE phRequest,
																unsigned short *wolny_numer
																);
/*! 
	\brief Realizacja rozkazu CODEFMTREAD - Odczyt rekordu formatu kodu kreskowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_CodeFmtRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CodeFmtRead(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned short numer_rekordu,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu CODEFMTREAD - Odczyt rekordu formatu kodu kreskowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_CodeFmtRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_CodeFmtRead(const POSNET_HANDLE phRequest,
														 unsigned short *numer_rekordu,
														 char *format
														 );



/*!
@}
*/




/*!
\defgroup hlapi_payform Obsuga form patnoci
\ingroup hlapi_global
@{
*/

/*! 
	\brief Realizacja rozkazu PAYFORMSTATCLEARALL - Kasowanie wszystkich statystyk bazy form patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PayformStatClearAll(const POSNET_HANDLE hDevice,
																 POSNET_HANDLE *phRequest,
																 const unsigned char tryb=POSNET_REQMODE_SPOOL
																 );
/*! 
	\brief Realizacja rozkazu PAYFORMDELALL - Kasowanie bazy form patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PayformDelAll(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char flagi,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu PAYFORMDEL - Kasowanie rekordu formy patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PayformDel(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_rekordu,
														const unsigned char czy_niezerowe,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu PAYFORMINS - Programowanie rekordu formy patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PayformIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_rekordu,
														const char *nazwa,
														const unsigned char typ_platnosci,
														const unsigned short flagi_platnosci,
														const char *skrot_waluty,	
														const char *kurs_lub_cashback,
														const unsigned char czy_nadpisac,
														const unsigned char czy_nadpisac_niezerowe,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu PAYFORMGETBYNAME - Wyszukiwanie rekordu formy patnoci po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PayformGetByName
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PayformGetByName(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const char *nazwa,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu PAYFORMGETBYNAME - Wyszukiwanie rekordu formy patnoci po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PayformGetByName
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PayformGetByName(const POSNET_HANDLE phRequest,
															  unsigned short *numer_rekordu
															  );
/*! 
	\brief Realizacja rozkazu PAYFORMSTATREAD - Odczyt statystyk rekordu formy patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PayformStatRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PayformStatRead(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned short numer_rekordu,
															 const unsigned char czy_zerowac,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );
/*! 
	\brief Realizacja rozkazu PAYFORMSTATREAD - Odczyt statystyk rekordu formy patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PayformStatRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PayformStatRead(const POSNET_HANDLE phRequest,
															 unsigned short *numer_rekordu,
															 char *obrot
															 );
/*! 
	\brief Realizacja rozkazu PAYFORMNEXTFREEGET - Znajdowanie wolnego rekordu bazy formy patnoci poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PayformNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PayformNextFreeGet(const POSNET_HANDLE hDevice,
																POSNET_HANDLE *phRequest,
																const unsigned short numer_rekordu,
																const unsigned char tryb=POSNET_REQMODE_SPOOL
																);
/*! 
	\brief Realizacja rozkazu PAYFORMNEXTFREEGET - Znajdowanie wolnego rekordu bazy formy patnoci poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PayformNextFreeGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PayformNextFreeGet(const POSNET_HANDLE phRequest,
																unsigned short *wolny_numer
																);
/*! 
	\brief Realizacja rozkazu PAYFORMREAD - Odczyt rekordu bazy formy patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PayformRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PayformRead(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned short numer_rekordu,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu PAYFORMREAD - Odczyt rekordu bazy formy patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PayformRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PayformRead(const POSNET_HANDLE phRequest,
														 unsigned short *numer,
														 char *nazwa,
														 unsigned char *typ,
														 unsigned short *flagi,
														 char *waluta,
														 char *kurs
														 );




/*!
@}
*/




/*!
\defgroup hlapi_group Obsuga grup towarowych
\ingroup hlapi_global
@{
*/

/*! 
	\brief Realizacja rozkazu GROUPREADEXEX - Odczyt rekordu bazy grupy towarowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_GroupReadExEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupReadExEx(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short numer_rekordu,
													   const unsigned char tryb
													   );
/*! 
	\brief Realizacja rozkazu GROUPREADEXEX - Odczyt rekordu bazy grupy towarowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
    Posiada cz nadawcz - \ref POSS_GroupReadExEx
*/													   
POSNET_API	POSNET_STATUS __stdcall		POSG_GroupReadExEx(const POSNET_HANDLE phRequest,
													   unsigned short *numer_rekordu,
													   char *nazwa,
													   unsigned char *rabat,
													   char *cena,
													   unsigned char *towary_waz,
													   unsigned char *id_drukarki
													   );
/*! 
	\brief Realizacja rozkazu GROUPINSEXEX - Programowanie rekordu grupy towarowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupInsExEx(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short numer_rekordu,
													  const char *nazwa,
													  const unsigned char rabat,
													  const char *cena,
													  const unsigned char tow_wazone,
													  const unsigned char id_drukarki,
													  const unsigned char czy_nadpisac,
													  const unsigned char czy_nadpisac_niezerowe,
													  const unsigned char tryb
													  );


/*! 
	\brief Realizacja rozkazu GROUPSTATCLEARALL - Kasowanie wszystkich statystyk grup towarowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupStatClearAll(const POSNET_HANDLE hDevice,
															   POSNET_HANDLE *phRequest,
															   const unsigned char tryb=POSNET_REQMODE_SPOOL
															   );
/*! 
	\brief Realizacja rozkazu GROUPDELALL - Kasowanie bazy grup towarowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupDelAll(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char flagi,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu GROUPDEL - Kasowanie rekordu grup towarowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupDel(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short numer_rekordu,
													  const unsigned char czy_powiazane,
													  const unsigned char czy_niezerowe,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );
/*! 
	\brief Realizacja rozkazu GROUPINS - Programowanie rekordu grupy towarowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupIns(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short numer_rekordu,
													  const char *nazwa,
													  const unsigned char czy_nadpisac,
													  const unsigned char czy_nadpisac_niezerowe,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );

/*! 
	\brief Realizacja rozkazu GROUPINSEX - Programowanie rekordu grupy towarowej
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_GroupInsEx(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short numer_rekordu,
													  const char *nazwa,
													  const unsigned char rabat,
													  const unsigned char czy_nadpisac,
													  const unsigned char czy_nadpisac_niezerowe,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );
/*! 
	\brief Realizacja rozkazu GROUPINSEX - Programowanie rekordu grupy towarowej
	\ingroup hlapi_group
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupInsEx(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short numer_rekordu,
													  const char *nazwa,
													  const unsigned char rabat,
													  const unsigned char czy_nadpisac,
													  const unsigned char czy_nadpisac_niezerowe,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );
/*! 
	\brief Realizacja rozkazu GROUPGETBYNAME - Wyszukiwanie rekordu grupy towarowej po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_GroupGetByName
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupGetByName(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const char *nazwa,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu GROUPGETBYNAME - Wyszukiwanie rekordu grupy towarowej po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_GroupGetByName
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_GroupGetByName(const POSNET_HANDLE phRequest,
															unsigned short *numer_rekordu
															);
/*! 
	\brief Realizacja rozkazu GROUPSTATREAD - Odczyt statystyk rekordu grupy towarowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_GroupStatRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupStatRead(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_rekordu,
														   const unsigned char czy_zerowanie,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu GROUPSTATREAD - Odczyt statystyk rekordu grupy towarowej

	Pole dni_tygodnia zawiera 7 liczb - statystyki na kady dzie rozdzielone znakami nowej linii.
	Pole miesiace zawiera 12 liczb - statystyki miesiczne rozdzielone znakami nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_GroupStatRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_GroupStatRead(const POSNET_HANDLE phRequest,
														   unsigned short *numer_rekordu,
														   char *ogolnie,
														   char *dni_tygodnia, // liczby rozdzielone \n
														   char *miesiace
														   );
/*! 
	\brief Realizacja rozkazu GROUPNEXTFREEGET - Znajdowanie wolnego rekordu bazy grup towarowych poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_GroupNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupNextFreeGet(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned short numer_rekordu,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu GROUPNEXTFREEGET - Znajdowanie wolnego rekordu bazy grup towarowych poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_GroupNextFreeGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_GroupNextFreeGet(const POSNET_HANDLE phRequest,
															  unsigned short *wolny_numer
															  );
/*! 
	\brief Realizacja rozkazu GROUPREAD - Odczyt rekordu bazy grupy towarowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_GroupRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupRead(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short numer_rekordu,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );

/*! 
	\brief Realizacja rozkazu GROUPREADEX - Odczyt rekordu bazy grupy towarowej - wersja dla kasy NEO
	\ingroup Kasa_Neo

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Posiada cz odbiorcz - \ref POSG_NEO_GroupReadEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_GroupReadEx(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short numer_rekordu,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu GROUPREADEX - Odczyt rekordu bazy grupy towarowej - wersja dla kasy NEO
	\ingroup hlapi_group

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Posiada cz odbiorcz - \ref POSG_GroupReadEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_GroupReadEx(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned short numer_rekordu,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu GROUPREAD - Odczyt rekordu bazy grupy towarowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_GroupRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_GroupRead(const POSNET_HANDLE phRequest,
													   unsigned short *numer_rekordu,
													   char *nazwa
													   );

/*! 
	\brief Realizacja rozkazu GROUPREADEX - Odczyt rekordu bazy grupy towarowej
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
    Posiada cz nadawcz - \ref POSS_NEO_GroupReadEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_NEO_GroupReadEx(const POSNET_HANDLE phRequest,
													   unsigned short *numer_rekordu,
													   char *nazwa,
													   unsigned char *rabat
													   );
/*! 
	\brief Realizacja rozkazu GROUPREADEX - Odczyt rekordu bazy grupy towarowej
	\ingroup hlapi_group
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
    Posiada cz nadawcz - \ref POSS_GroupReadEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_GroupReadEx(const POSNET_HANDLE phRequest,
													   unsigned short *numer_rekordu,
													   char *nazwa,
													   unsigned char *rabat
													   );
/*!
@}
*/




/*!
\defgroup hlapi_pack Obsuga bazy opakowa
\ingroup hlapi_global
@{
*/
/*! 
	\brief Realizacja rozkazu PACKSTORECLR - Zerowanie stanw magazynowych opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackStoreClr(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );

/*! 
	\brief Realizacja rozkazu PACKSTOCKQNTMODIFY - Zmiana stanu magazynowego opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackStockQntModify(const POSNET_HANDLE hDevice,
																POSNET_HANDLE *phRequest,
																const unsigned short numer_rekordu,
																const char *ilosc,
																const unsigned char czy_zwiekszyc,
																const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu PACKSTATCLEARALL - Kasowanie statystyk wszystkich opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackStatClearAll(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char czy_stany,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu PACKDELALL - Kasowanie bazy opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackDelAll(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char flagi,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu PACKDEL - Kasowanie rekordu opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackDel(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const unsigned char czy_powiazane,
													 const unsigned char czy_niezerowe,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu PACKDELBYBARCODE - Kasowanie rekordu opakowa wg kodw kreskowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PackDelByBarcode(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const char *kod_kreskowy,
															  const unsigned char czy_powiazane,
															  const unsigned char czy_niezerowe,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );


/*! 
	\brief Realizacja rozkazu PACKINS - Programowanie rekordu opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackIns(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const char *nazwa,
													 const char *kod_kreskowy,
													 const char *cena,
													 const char *min_stan,
													 const unsigned char czy_cena_sztywna,
													 const unsigned char czy_nadpisac,
													 const unsigned char czy_niezerowy,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu PACKGETBYNAME - Wyszukiwanie rekordu opakowania po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

	Posiada cz odbiorcz - \ref POSG_PackGetByName
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackGetByName(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const char *nazwa,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu PACKGETBYBARCODE - Wyszukiwanie rekordu opakowania po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

	Posiada cz odbiorcz - \ref POSG_PackGetByBarcode
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackGetByBarcode(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const char *kod_kreskowy,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );

/*! 
	\brief Realizacja rozkazu PACKGETBYBARCODE - Wyszukiwanie rekordu opakowania po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PackGetByBarcode
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PackGetByBarcode(const POSNET_HANDLE phRequest,
														   unsigned short *numer_rekordu
														   );

/*! 
	\brief Realizacja rozkazu PACKGETBYNAME - Wyszukiwanie rekordu opakowania po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PackGetByName
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PackGetByName(const POSNET_HANDLE phRequest,
														   unsigned short *numer_rekordu
														   );
/*! 
	\brief Realizacja rozkazu PACKSTATREAD - Odczyt statystyk rekordu opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PackStatRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackStatRead(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_rekordu,
														  const unsigned char czy_zerowanie,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu PACKSTATREAD -  Odczyt statystyk rekordu opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PackStatRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PackStatRead(const POSNET_HANDLE phRequest,
														  unsigned short *numer_rekordu,
														  char *sprzedane,
														  char *zwrocone,
														  char *wartosc_sprzedane,
														  char *wartosc_zwrocone,
														  char *stan
														  );
/*! 
	\brief Realizacja rozkazu PACKSTATREADBYBARCODE - Odczyt statystyk rekordu opakowa po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PackStatReadByBarcode
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PackStatReadByBarcode(const POSNET_HANDLE hDevice,
																   POSNET_HANDLE *phRequest,
																   const char *kod_kreskowy,
																   const unsigned char czy_zerowanie,
																   const unsigned char tryb=POSNET_REQMODE_SPOOL
																   );
/*! 
	\brief Realizacja rozkazu PACKSTATREADBYBARCODE -  Odczyt statystyk rekordu opakowa po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PackStatReadByBarcode
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_PackStatReadByBarcode(const POSNET_HANDLE phRequest,
																   char *kod_kreskowy,
																   char *sprzedane,
																   char *zwrocone,
																   char *wartosc_sprzedane,
																   char *wartosc_zwrocone,
																   char *stan
																   );
/*! 
	\brief Realizacja rozkazu PACKNEXTFREEGET - Znajdowanie wolnego rekordu opakowa poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PackNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackNextFreeGet(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned short numer_rekordu,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );
/*! 
	\brief Realizacja rozkazu PACKNEXTFREEGET - Znajdowanie wolnego rekordu opakowa poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PackNextFreeGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PackNextFreeGet(const POSNET_HANDLE phRequest,
															 unsigned short *wolny_numer
															 );

/*! 
	\brief Realizacja rozkazu PACKREADBYBARCODE - Odczyt rekordu opakowa po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PackReadByBarcode
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PackReadByBarcode(const POSNET_HANDLE hDevice,
															   POSNET_HANDLE *phRequest,
															   const char *kod_kreskowy,
															   const unsigned char tryb=POSNET_REQMODE_SPOOL
															   );
/*! 
	\brief Realizacja rozkazu PACKREADBYBARCODE -  Odczyt rekordu opakowa po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PackReadByBarcode
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_PackReadByBarcode(const POSNET_HANDLE phRequest,
															   char *kod_kreskowy,
															   char *nazwa,
															   char *cena,
															   char *stan_min,
															   unsigned char *czy_sztywna
															   );
/*! 
	\brief Realizacja rozkazu PACKREAD - Odczyt rekordu opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PackRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackRead(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short numer_rekordu,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );
/*! 
	\brief Realizacja rozkazu PACKREAD -  Odczyt rekordu opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PackRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PackRead(const POSNET_HANDLE phRequest,
													  unsigned short *numer,
													  char *nazwa,
													  char *kod_kreskowy,
													  char *cena,
													  char *stan_min,
													  unsigned char *czy_sztywna
													  );

/*! 
	\brief Realizacja rozkazu PACKPRICEUPDATE - Aktualizacja ceny opakowania.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackPriceUpdate(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned short numer_rekordu,
															 const char *cena,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );
/*! 
	\brief Realizacja rozkazu PACKPRICEUPDATEBYBARCODE - Aktualizacja ceny opakowania wg kodu kreskowego.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PackPriceUpdateByBarcode(const POSNET_HANDLE hDevice,
																	  POSNET_HANDLE *phRequest,
																	  const char *kod_kreskowy,
																	  const char *cena,
																	  const unsigned char tryb=POSNET_REQMODE_SPOOL
																	  );

/*! 
\brief Realizacja rozkazu PACSTOCKKMINQNTSET - Ustawienie minimalnego stanu magazynowego opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackStockMinQntSet(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned short numer_rekordu,
															 const char *stan,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );
/*!
@}
*/




/*!
\defgroup hlapi_mu Obsuga bazy jednostek miary
\ingroup hlapi_global
@{
*/

/*! 
	\brief Realizacja rozkazu MUDELALL - Kasowanie caej bazy jednostek miary

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/


POSNET_API	POSNET_STATUS	__stdcall	POSS_MUDelAll(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned char flagi,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );
/*! 
	\brief Realizacja rozkazu MUDEL - Kasowanie rekordu jednostki miary

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_MUDel(const POSNET_HANDLE hDevice,
												   POSNET_HANDLE *phRequest,
												   const unsigned short numer_rekordu,
												   const unsigned char czy_powiazane,
												   const unsigned char tryb=POSNET_REQMODE_SPOOL
												   );
/*! 
	\brief Realizacja rozkazu MUINS - Programowanie rekordu jednostki miary

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_MUIns(const POSNET_HANDLE hDevice,
												   POSNET_HANDLE *phRequest,
												   const unsigned short numer_rekordu,
												   const char *nazwa,
												   const char *skrot,
												   const unsigned char czy_nadpisac,
												   const unsigned char tryb=POSNET_REQMODE_SPOOL
												   );
/*! 
	\brief Realizacja rozkazu MUGETBYNAME - Znajdowanie numeru rekordu jednostek miary po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_MUGetByName
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_MUGetByName(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const char *nazwa,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu MUGETBYNAME - Znajdowanie numeru rekordu jednostek miary po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_MUGetByName
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_MUGetByName(const POSNET_HANDLE phRequest,
														 unsigned short *numer_rekordu
														 );
/*! 
	\brief Realizacja rozkazu MUNEXTFREEGET - Znajdowanie wolnego rekordu jednostek miary poczwszy od zadanego numeru.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_MUNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_MUNextFreeGet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_rekordu,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu MUNEXTFREEGET - Znajdowanie wolnego rekordu jednostek miary poczwszy od zadanego numeru.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_MUNextFreeGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_MUNextFreeGet(const POSNET_HANDLE phRequest,
														   unsigned short *wolny_numer
														   );
/*! 
	\brief Realizacja rozkazu MUREAD - Odczyt rekordu jednostki miary

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_MURead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_MURead(const POSNET_HANDLE hDevice,
													POSNET_HANDLE *phRequest,
													const unsigned short numer_rekordu,
													const unsigned char tryb=POSNET_REQMODE_SPOOL
											  );
/*! 
	\brief Realizacja rozkazu MUREAD - Odczyt rekordu jednostki miary

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_MURead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_MURead(const POSNET_HANDLE phRequest,
													unsigned short *numer_rekordu,
													char *nazwa,
													char *skrot
											  );




/*!
@}
*/




/*!
\defgroup hlapi_users Obsuga bazy kasjerw
\ingroup hlapi_global
@{
*/

/*! 
	\brief Realizacja rozkazu USERREADEXEX - Odczyt rekordu uytkownika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_UserReadExEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_UserReadExEx(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu USERREADEXEX - Odczyt rekordu uytkownika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_UserReadExEx
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_UserReadExEx(const POSNET_HANDLE phRequest,
													  unsigned short *numer_rekordu,
													  char *nazwa,
													  char *haslo,
													  char *karta,
													  char *pin,
													  unsigned long *prawa,
													  unsigned char *prawa_raporty,
													  unsigned char *prawa_klawisze,
													  char *limit_paragonu
													  );
/*! 
	\brief Realizacja rozkazu USERINSEXEX - Dodanie nowego uytkownika
	
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty.

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_UserInsExEx(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const char *nazwa,
													 const char *haslo,
													 const char *karta,
													 const char *pin,
													 const unsigned long uprawnienia,
													 const unsigned char uprawnienia_raportow,
													 const unsigned char uprawnienia_klawisze,
													 const char *limit_paragonu,
													 const unsigned char czy_nadpisac,
													 const unsigned char czy_nadpisac_niezerowe,
													 const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu USERSTATREADEXEX - Odczyt statystyki kasjera

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_UserStatReadExEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_UserStatReadExEx(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_rekordu,
														  const unsigned char czy_zerowanie,
														  const unsigned char tryb
														  );
/*! 
	\brief Realizacja rozkazu USERSTATREADEXEX - Odczyt statystyki kasjera

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_UserStatReadExEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_UserStatReadExEx(const POSNET_HANDLE phRequest,
														  unsigned short *numer_rekordu,
														  char *rabaty_z_reki,
														  char *narzuty_z_reki,
														  char *pierwsze_logowanie,
														  char *ostatnie_wylogowanie,
														  char *czas_pracy,
														  unsigned long *ilosc_otwarc,
														  char *wart_opakowan_sprzedanych,
														  char *wart_opakowan_zwroconych,
														  char *wplaty,
														  char *wyplaty,
														  char *sprzedaz,
														  unsigned long *paragony,
														  unsigned long *paragony_anul,
														  char *wart_parag_anul,
														  unsigned long *storna, 
														  char *wart_storn,
														  unsigned long *autoryzacje, 
														  char *wart_autoryzacji,
														  char *numery_form_platnosci,
														  char *kwoty_form_platnosci,
														  char *numery_rabatow,
														  char *kwoty_rabatow,
														  char *numery_platn,
														  char *kwoty_platn
														  );
														  

/*! 
	\brief Realizacja rozkazu USERDELALL - Kasowanie caej bazy kasjerw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserDelAll(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char flagi,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu USERSTATCLEARALL - Kasowanie statystyk kasjerw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserStatClearAll(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char czy_nadpisac,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu USERDEL - Kasowanie uytkownika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserDel(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const unsigned char czy_niezerowe,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu USERINS - Dodanie nowego uytkownika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserIns(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const char *nazwa,
													 const char *haslo,
													 const char *karta,
													 const char *pin,
													 const unsigned short uprawnienia,
													 const unsigned char uprawnienia_raportow,
													 const unsigned char uprawnienia_klawisze,
													 const unsigned char czy_nadpisac,
													 const unsigned char czy_nadpisac_niezerowe,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu USERINSEX - Dodanie nowego uytkownika
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_UserInsEx(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const char *nazwa,
													 const char *haslo,
													 const char *karta,
													 const char *pin,
													 const unsigned short uprawnienia,
													 const unsigned char uprawnienia_raportow,
													 const unsigned char uprawnienia_klawisze,
													 const char *limit_paragonu,
													 const unsigned char czy_nadpisac,
													 const unsigned char czy_nadpisac_niezerowe,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu USERINSEX - Dodanie nowego uytkownika
	\ingroup hlapi_users
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserInsEx(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const char *nazwa,
													 const char *haslo,
													 const char *karta,
													 const char *pin,
													 const unsigned short uprawnienia,
													 const unsigned char uprawnienia_raportow,
													 const unsigned char uprawnienia_klawisze,
													 const char *limit_paragonu,
													 const unsigned char czy_nadpisac,
													 const unsigned char czy_nadpisac_niezerowe,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu USERGETBYNAME - Znajdowanie numeru rekordu kasjera po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_UserGetByName
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserGetByName(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const char *nazwa,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu USERGETBYNAME - Znajdowanie numeru rekordu kasjera po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_UserGetByName
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_UserGetByName(const POSNET_HANDLE phRequest,
														   unsigned short *numer_rekordu
														   );
/*! 
	\brief Realizacja rozkazu USERSTATREAD - Odczyt statystyki kasjera

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_UserStatRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserStatRead(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_rekordu,
														  const unsigned char czy_zerowanie,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu USERSTATREAD -  Odczyt statystyki kasjera

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 
	Czas pracy podawany jest w formacie: dni:godziny:minuty:sekundy
	Listy numerw form patnoci, kwot w poszczeglnych patnociach, numerw rabatw i kwot wykonanych rabatw 
	s w postaci oddzielanej znakami nowej linii.

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_UserStatRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_UserStatRead(const POSNET_HANDLE phRequest,
														  unsigned short *numer_rekordu,
														  char *rabaty_z_reki,
														  char *narzuty_z_reki,
														  char *pierwsze_logowanie,
														  char *ostatnie_wylogowanie,
														  char *czas_pracy,
														  char *wart_opakowan_sprzedanych,
														  char *wart_opakowan_zwroconych,
														  char *wplaty,
														  char *wyplaty,
														  char *sprzedaz,
														  unsigned long *paragony,
														  unsigned long *paragony_anul,
														  char *wart_parag_anul,
														  unsigned long *storna, 
														  char *wart_storn,
														  char *numery_form_platnosci,
														  char *kwoty_form_platnosci,
														  char *numery_rabatow,
														  char *kwoty_rabatow
														  );

/*! 
	\brief Realizacja rozkazu USERSTATREADEX - Odczyt statystyki kasjera
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Posiada cz odbiorcz - \ref POSG_NEO_UserStatReadEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_UserStatReadEx(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_rekordu,
														  const unsigned char czy_zerowanie,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu USERSTATREADEX - Odczyt statystyki kasjera
	\ingroup hlapi_user
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Posiada cz odbiorcz - \ref POSG_UserStatReadEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_UserStatReadEx(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_rekordu,
														  const unsigned char czy_zerowanie,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu USERSTATREADEX -  Odczyt statystyki kasjera
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 
	Czas pracy podawany jest w formacie: dni:godziny:minuty:sekundy
	Listy numerw form patnoci, kwot w poszczeglnych patnociach, numerw rabatw i kwot wykonanych rabatw 
	s w postaci oddzielanej znakami nowej linii.

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
    Posiada cz nadawcz - \ref POSS_NEO_UserStatReadEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_NEO_UserStatReadEx(const POSNET_HANDLE phRequest,
														  unsigned short *numer_rekordu,
														  char *rabaty_z_reki,
														  char *narzuty_z_reki,
														  char *pierwsze_logowanie,
														  char *ostatnie_wylogowanie,
														  char *czas_pracy,
														  unsigned long *ilosc_otwarc,
														  char *wart_opakowan_sprzedanych,
														  char *wart_opakowan_zwroconych,
														  char *wplaty,
														  char *wyplaty,
														  char *sprzedaz,
														  unsigned long *paragony,
														  unsigned long *paragony_anul,
														  char *wart_parag_anul,
														  unsigned long *storna, 
														  char *wart_storn,
														  unsigned long *autoryzacje, 
														  char *wart_autoryzacji,
														  char *numery_form_platnosci,
														  char *kwoty_form_platnosci,
														  char *numery_rabatow,
														  char *kwoty_rabatow
														  );
/*! 
	\brief Realizacja rozkazu USERSTATREADEX -  Odczyt statystyki kasjera
	\ingroup hlapi_user
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 
	Czas pracy podawany jest w formacie: dni:godziny:minuty:sekundy
	Listy numerw form patnoci, kwot w poszczeglnych patnociach, numerw rabatw i kwot wykonanych rabatw 
	s w postaci oddzielanej znakami nowej linii.

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
    Posiada cz nadawcz - \ref POSS_UserStatReadEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_UserStatReadEx(const POSNET_HANDLE phRequest,
														  unsigned short *numer_rekordu,
														  char *rabaty_z_reki,
														  char *narzuty_z_reki,
														  char *pierwsze_logowanie,
														  char *ostatnie_wylogowanie,
														  char *czas_pracy,
														  unsigned long *ilosc_otwarc,
														  char *wart_opakowan_sprzedanych,
														  char *wart_opakowan_zwroconych,
														  char *wplaty,
														  char *wyplaty,
														  char *sprzedaz,
														  unsigned long *paragony,
														  unsigned long *paragony_anul,
														  char *wart_parag_anul,
														  unsigned long *storna, 
														  char *wart_storn,
														  unsigned long *autoryzacje, 
														  char *wart_autoryzacji,
														  char *numery_form_platnosci,
														  char *kwoty_form_platnosci,
														  char *numery_rabatow,
														  char *kwoty_rabatow
														  );
/*! 
	\brief Realizacja rozkazu USERNEXTFREEGET - Znajdowanie wolnego rekordu kasjera poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_UserNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserNextFreeGet(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned short numer_rekordu,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );
/*! 
	\brief Realizacja rozkazu USERNEXTFREEGET - Znajdowanie wolnego rekordu kasjera poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_UserNextFreeGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_UserNextFreeGet(const POSNET_HANDLE phRequest,
															 unsigned short *nastepny
															 );
/*! 
	\brief Realizacja rozkazu USERREAD - Odczyt rekordu uytkownika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_UserRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserRead(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short numer_rekordu,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );
/*! 
	\brief Realizacja rozkazu USERREAD - Odczyt rekordu uytkownika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_UserRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_UserRead(const POSNET_HANDLE phRequest,
													  unsigned short *numer_rekordu,
													  char *nazwa,
													  char *haslo,
													  char *karta,
													  char *pin,
													  unsigned short *prawa,
													  unsigned char *prawa_raporty,
													  unsigned char *prawa_klawisze
													  );
/*! 
	\brief Realizacja rozkazu USERREADEX - Odczyt rekordu uytkownika
	\ingroup Kasa_Neo

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Posiada cz odbiorcz - \ref POSG_NEO_UserReadEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_UserReadEx(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short numer_rekordu,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );
/*! 
	\brief Realizacja rozkazu USERREADEX - Odczyt rekordu uytkownika
	\ingroup hlapi_user

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Posiada cz odbiorcz - \ref POSG_UserReadEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_UserReadEx(const POSNET_HANDLE hDevice,
													  POSNET_HANDLE *phRequest,
													  const unsigned short numer_rekordu,
													  const unsigned char tryb=POSNET_REQMODE_SPOOL
													  );
/*! 
	\brief Realizacja rozkazu USERREADEX - Odczyt rekordu uytkownika
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
    Posiada cz nadawcz - \ref POSS_NEO_UserReadEx
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_NEO_UserReadEx(const POSNET_HANDLE phRequest,
													  unsigned short *numer_rekordu,
													  char *nazwa,
													  char *haslo,
													  char *karta,
													  char *pin,
													  unsigned short *prawa,
													  unsigned char *prawa_raporty,
													  unsigned char *prawa_klawisze,
													  char *limit_paragonu
													  );

/*! 
	\brief Realizacja rozkazu USERREADEX - Odczyt rekordu uytkownika
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
    Posiada cz nadawcz - \ref POSS_UserReadEx
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_UserReadEx(const POSNET_HANDLE phRequest,
													  unsigned short *numer_rekordu,
													  char *nazwa,
													  char *haslo,
													  char *karta,
													  char *pin,
													  unsigned short *prawa,
													  unsigned char *prawa_raporty,
													  unsigned char *prawa_klawisze,
													  char *limit_paragonu
													  );

/*!
@}
*/




/*!
\defgroup hlapi_PLU Obsuga bazy towarowej
\ingroup hlapi_global
@{
*/
/*! 
	\brief Realizacja rozkazu PLUSTOREREAD -  Odczyt danych magazynowo - statystycznych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PLUStoreRead
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUStoreRead(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short numer_rekordu,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );

/*! 
	\brief Realizacja rozkazu PLUSTOREREAD - Odczyt danych magazynowo - statystycznych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PLUStoreRead
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_PLUStoreRead(const POSNET_HANDLE phRequest,
														  unsigned short *numer,
														  char *nazwa,
														  char *stan_min,
														  char *stan,
														  char *data
														  );


/*! 
	\brief Realizacja rozkazu PLUSTOREREADBYBARCODE -  Odczyt danych magazynowo - statystycznych po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PLUStoreReadByBarcode
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUStoreReadByBarcode(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const char *kod_kreskowy,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );

/*! 
	\brief Realizacja rozkazu PLUSTOREREADBYBARCODE - Odczyt danych magazynowo - statystycznych po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PLUStoreReadByBarcode
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_PLUStoreReadByBarcode(const POSNET_HANDLE phRequest,
														  char *kod_kreskowy,
														  char *nazwa,
														  char *stan_min,
														  char *stan,
														  char *data
														  );

/*! 
	\brief Realizacja rozkazu PLUSTORECLR -  Zerowanie stanw magazynowych PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUStoreClr(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );


/*! 
	\brief Realizacja rozkazu PLUSETITEMUPDATE -  Aktualizacja elementu zestawu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PluSetItemUpdate(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned short numer_zestawu,
															  const unsigned short numer_PLU,
															  const char *ilosc,
															  const char *cena,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );

/*! 
	\brief Realizacja rozkazu PLUNOTEPADDEL -  Usuwanie towaru z notatnika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUNotepadDel(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_PLU,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu PLUNOTEPADINS - Dodanie towaru do notatnika 

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUNotepadIns(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned short numer_PLU,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu SETINS - Programowanie zestawu

	Pola numery, ilosci i ceny zawieraj rozdzielone znakami nowej linii wartoci odpowiednich
	parametrw dla kolejnych towarw zestawu. Kade z tych pl musi posiada tak sam
	ilo elementw.

	Pozostae parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_SetIns(const POSNET_HANDLE hDevice,
													POSNET_HANDLE *phRequest,
													const unsigned short numer_rekordu,
													const char *nazwa,
													const char *barcode,
													const char *ilosc_min,
													const unsigned char numer_rabatu,
													const unsigned char numer_grupy,
													const unsigned char czy_zabronione,
													const unsigned char czy_dodac,
													const unsigned char czy_nadpisac,
													const unsigned char czy_nadpisac_niezerowe,
													const char *numery, // rozdzielone \n
													const char *ilosci, // j.w. 
													const char *ceny,
													const unsigned char tryb=POSNET_REQMODE_SPOOL
													);

/*! 
	\brief Realizacja rozkazu PLUSETINS - Programowanie zestawu

	Pola numery, ilosci i ceny zawieraj rozdzielone znakami nowej linii wartoci odpowiednich
	parametrw dla kolejnych towarw zestawu. Kade z tych pl musi posiada tak sam
	ilo elementw.

	Pozostae parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUSetIns(const POSNET_HANDLE hDevice,
													POSNET_HANDLE *phRequest,
													const unsigned short numer_rekordu,
													const char *nazwa,
													const char *barcode,
													const char *ilosc_min,
													const unsigned char numer_rabatu,
													const unsigned char numer_grupy,
													const unsigned char czy_zabronione,
													const unsigned char czy_dodac,
													const unsigned char czy_nadpisac,
													const unsigned char czy_nadpisac_niezerowe,
													const char *numery, // rozdzielone \n
													const char *ilosci, // j.w. 
													const char *ceny,
													const unsigned char tryb=POSNET_REQMODE_SPOOL
													);

/*! 
	\brief Realizacja rozkazu PLUSTOCKQNTMODIFY - Zmiana stanu magazynowego PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUStockQntModify(const POSNET_HANDLE hDevice,
															   POSNET_HANDLE *phRequest,
															   const unsigned short numer_rekordu,
															   const char *ilosc,
															   const unsigned char czy_zwiekszyc,
															   const unsigned char tryb=POSNET_REQMODE_SPOOL
															   );
/*! 
	\brief Realizacja rozkazu PLUDEL - Usuwanie PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUDel(const POSNET_HANDLE hDevice,
													POSNET_HANDLE *phRequest,
													const unsigned short numer_rekordu,
													const unsigned char czy_niezerowe,
													const unsigned char czy_z_zestawu,
													const unsigned char tryb=POSNET_REQMODE_SPOOL
													);
/*! 
	\brief Realizacja rozkazu PLUDELBYBARCODE - Usuwanie PLU po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUDelByBarcode(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const char *kod_kreskowy,
															 const unsigned char czy_niezerowe,
															 const unsigned char czy_z_zestawu,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );

/*! 
	\brief Realizacja rozkazu EPLUINS - Programowanie eUsugi

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.

*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_EPLUIns(const POSNET_HANDLE hDevice,
													POSNET_HANDLE *phRequest,
													const unsigned short numer_rekordu,
													const char *nazwa,
													const char *barcode,
													const unsigned char numer_MU,
													const unsigned char numer_rabatu,
													const unsigned char numer_grupy,
													const unsigned char numer_VAT,
													const unsigned short numer_euslugi,
													const unsigned char czy_rabat,
													const unsigned char czy_notatnik,
													const unsigned char czy_nadpisac,
													const unsigned char czy_nadpisac_niezerowy,
													const unsigned char tryb
													);

/*! 
	\brief Realizacja rozkazu PLUINS - Programowanie PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUIns(const POSNET_HANDLE hDevice,
													POSNET_HANDLE *phRequest,
													const unsigned short numer_rekordu,
													const char *nazwa,
													const char *barcode,
													const char *cena,
													const char *ilosc_min,
													const unsigned char numer_opakowania,
													const unsigned char numer_MU,
													const unsigned char numer_rabatu,
													const unsigned char numer_grupy,
													const unsigned char numer_VAT,
													const unsigned char format_ilosci,
													const unsigned char cena_sztywna,
													const unsigned char czy_rabat,
													const unsigned char czy_notatnik,
													const unsigned char czy_nadpisac,
													const unsigned char czy_nadpisac_niezerowy,
													const unsigned char tryb=POSNET_REQMODE_SPOOL
													);
/*! 
	\brief Realizacja rozkazu PLUSTATCLEARALL - Kasowanie wszystkich statystyk PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUStatClearAll(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned char czy_stany,
															 const unsigned char czy_date,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu PLUNOTEPADDELALL - Usuwanie wszystkich towarw z notatnika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUNotepadDelAll(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu PLUDELALL - Kasowanie caej bazy PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUDelAll(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned char flagi,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu SETREAD -  Odczyt elementw zestaww

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_SetRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_SetRead(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu SETREAD - Odczyt elementw zestaww

	W polach numery, nazwy, ilosci, ceny zwracane s listy oddzielone znakami nowej linii zawierajce
	odpowiednie parametry dla kolejnych skadnikw zestawu.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SetRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_SetRead(const POSNET_HANDLE phRequest,
													unsigned short *czytany,
													 char *numery, // liczby rozdzielane \n
													 char *ilosci,
													 char *ceny
													 );
/*! 
	\brief Realizacja rozkazu PLUNEXTFREEGET - Znajdowanie wolnego rekordu w bazie PLU poczwszy od zadanego numeru.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PLUNextFreeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUNextFreeGet(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned short numer_rekordu,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu PLUNEXTFREEGET - Znajdowanie wolnego rekordu w bazie PLU poczwszy od zadanego numeru.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PLUNextFreeGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PLUNextFreeGet(const POSNET_HANDLE phRequest,
															unsigned short *wolny_numer
															);

/*! 
	\brief Realizacja rozkazu PLUREADBYBARCODE - Odczytywanie informacji o PLU i zestawach towarw po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PLUReadByBarcode
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUReadByBarcode(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const char *kod_kreskowy,
															  const unsigned char z_kodem,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu PLUREADBYBARCODE - Odczytywanie informacji o PLU i zestawach towarw po kodzie kreskowym

	W polu barcodes zwracane s wszystkie kody kreskowe przypisane do towaru w postaci
	listy rozdzielanej znakami nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PLUReadByBarcode
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_PLUReadByBarcode(const POSNET_HANDLE phRequest,
															  char *kod_kreskowy,
															  char *nazwa,
															  char *kod_kreskowy_podstawowy,
															  char *cena,
															  char *min_stan,
															  unsigned char *typ_rekordu,
															  unsigned char *numer_opak,
															  unsigned char *numerMU,
															  unsigned char *stawka_PTU,
															  unsigned char *format_ilosci,
															  unsigned char *flaga_ceny,
															  unsigned char *flaga_rabatow,
															  unsigned char *numer_rabatu,
															  unsigned char *numer_grupy,
															  char *barcodes
															  );
/*! 
	\brief Realizacja rozkazu PLUREAD - Odczytywanie informacji o PLU i zestawach towarw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PLURead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLURead(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const unsigned char z_kodem,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu PLUREAD - Odczytywanie informacji o PLU i zestawach towarw

	W polu barcodes zwracane s wszystkie kody kreskowe przypisane do towaru w postaci
	listy rozdzielanej znakami nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> COMBO,NEO
	\par
    Posiada cz nadawcz - \ref POSS_PLURead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PLURead(const POSNET_HANDLE phRequest,
													 unsigned short *numer_rekordu,
													 char *nazwa,
													 char *kod_kreskowy_podstawowy,
													 char *cena,
													 char *min_stan,
													 unsigned char *typ_rekordu,
													 unsigned char *numer_opak,
													 unsigned char *numerMU,
													 unsigned char *stawka_PTU,
													 unsigned char *format_ilosci,
													 unsigned char *flaga_ceny,
													 unsigned char *flaga_rabatow,
													 unsigned char *numer_rabatu,
													 unsigned char *numer_grupy,
													 char *barcodes
													 );
/*! 
	\brief Realizacja rozkazu PLUREAD - Odczytywanie informacji o PLU i zestawach towarw

	W polu barcodes zwracane s wszystkie kody kreskowe przypisane do towaru w postaci
	listy rozdzielanej znakami nowej linii.

	W polu numer_opak_lub_euslugi zostaje umieszczony numer opakowania lub numer eUslugi w zalenoci od
	rodzaju rekordu wskazanego w polu typ_rekordu.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
    Posiada cz nadawcz - \ref POSS_PLURead
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_v2_PLURead(const POSNET_HANDLE phRequest,
													 unsigned short *numer_rekordu,
													 char *nazwa,
													 char *kod_kreskowy_podstawowy,
													 char *cena,
													 char *min_stan,
													 unsigned char *typ_rekordu,
													 unsigned short *numer_opak_lub_euslugi,
													 unsigned char *numerMU,
													 unsigned char *stawka_PTU,
													 unsigned char *format_ilosci,
													 unsigned char *flaga_ceny,
													 unsigned char *flaga_rabatow,
													 unsigned char *numer_rabatu,
													 unsigned char *numer_grupy,
													 char *barcodes
													 );

/*! 
	\brief Realizacja rozkazu PLUREADEX - Odczytywanie rozszerzone informacji o PLU i zestawach towarw
	
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. Pole barcode moe by NULL - traktowane jest
	wtedy jako puste.

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01, Instrukcja programisty COMBO v. >= 2.04
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_PLUReadEx

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUReadEx(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const char* barcode,
													 const unsigned char z_kodem,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu PLUREADEx - Odczytywanie rozszerzone informacji o PLU i zestawach towarw

	W polu barcodes zwracane s wszystkie kody kreskowe przypisane do towaru w postaci
	listy rozdzielanej znakami nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 
	\par
	<b>Wersja  protokou:</b> 1.01, Instrukcja programisty COMBO v. >= 2.04
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PLUReadEx
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PLUReadEx(const POSNET_HANDLE phRequest,
													 unsigned short *numer_rekordu,
													 char *nazwa,
													 char *kod_kreskowy_podstawowy,
													 char *cena,
													 char *min_stan,
													 unsigned char *typ_rekordu,
													 unsigned char *numer_opak,
													 unsigned char *numerMU,
													 unsigned char *stawka_PTU,
													 unsigned char *format_ilosci,
													 unsigned char *flaga_ceny,
													 unsigned char *flaga_rabatow,
													 unsigned char *numer_rabatu,
													 unsigned char *numer_grupy,
													 char *barcodes,
													 unsigned char *w_notatniku
													 );

/*! 
	\brief Realizacja rozkazu PLUREADEX - Odczytywanie rozszerzone informacji o PLU i zestawach towarw
	
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. Pole barcode moe by NULL - traktowane jest
	wtedy jako puste.

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_v2_PLUReadEx

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_v2_PLUReadEx(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const char *barcode,
													 const unsigned char z_kodem,
													 const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu PLUREADEx - Odczytywanie rozszerzone informacji o PLU i zestawach towarw

	W polu barcodes zwracane s wszystkie kody kreskowe przypisane do towaru w postaci
	listy rozdzielanej znakami nowej linii.

	W polu numer_opak_lub_euslugi zostaje umieszczony numer opakowania lub numer eUslugi w zalenoci od
	rodzaju rekordu wskazanego w polu typ_rekordu.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_v2_PLUReadEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_v2_PLUReadEx(const POSNET_HANDLE phRequest,
													 unsigned short *numer_rekordu,
													 char *nazwa,
													 char *kod_kreskowy_podstawowy,
													 char *cena,
													 char *min_stan,
													 unsigned char *typ_rekordu,
													 unsigned short *numer_opak_lub_euslugi,
													 unsigned char *numerMU,
													 unsigned char *stawka_PTU,
													 unsigned char *format_ilosci,
													 unsigned char *flaga_ceny,
													 unsigned char *flaga_rabatow,
													 unsigned char *numer_rabatu,
													 unsigned char *numer_grupy,
													 char *barcodes,
													 unsigned char *w_notatniku
													 );


/*! 
	\brief Realizacja rozkazu PLUSTATREAD - Odczyt statystyki towaru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PLUStatRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUStatRead(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned short numer_rekordu,
														 const unsigned char czy_zerowanie,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu PLUSTATREAD - Odczyt statystyki towaru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PLUStatRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PLUStatRead(const POSNET_HANDLE phRequest,
														 unsigned short *numer_rekordu,
														 char *wartosc,
														 char *ilosc,
														 char *stan,
														 char *data
														 );

/*! 
	\brief Realizacja rozkazu PLUSTATREADBYBARCODE - Odczyt statystyki towaru po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PLUStatReadByBarcode
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUStatReadByBarcode(const POSNET_HANDLE hDevice,
																  POSNET_HANDLE *phRequest,
																  const char *kod_kreskowy,
																  const unsigned char czy_zerowanie,
																  const unsigned char tryb=POSNET_REQMODE_SPOOL
																  );
/*! 
	\brief Realizacja rozkazu PLUSTATREADBYBARCODE - Odczyt statystyki towaru po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PLUStatReadByBarcode
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_PLUStatReadByBarcode(const POSNET_HANDLE phRequest,
																  char *kod_kreskowy,
																  char *wartosc,
																  char *ilosc,
																  char *stan,
																  char *data
																  );
/*! 
	\brief Realizacja rozkazu DFPLUVATCHECK - Sprawdzanie czy towar jest zablokowany

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> wszystkie
	\par
	<b>Kasy:</b> COMBO
	\par
	Posiada cz odbiorcz - \ref POSG_DFPluVatCheck
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_DFPluVatCheck(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const char *nazwa,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu DFPLUVATCHECK - Sprawdzanie czy towar jest zablokowany

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> wszystkie
	\par
	<b>Kasy:</b> COMBO
	\par
    Posiada cz nadawcz - \ref POSS_DFPluVatCheck
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_DFPluVatCheck(const POSNET_HANDLE phRequest,
														   unsigned char *stan,
														   unsigned short *stawka
														   );
/*! 
	\brief Realizacja rozkazu PLUGETBYBARCODE - Wyszukiwanie towaru po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PLUGetByBarcode
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUGetByBarcode(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const char *barcode,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );
/*! 
	\brief Realizacja rozkazu PLUGETBYBARCODE - Wyszukiwanie towaru po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PLUGetByBarcode
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PLUGetByBarcode(const POSNET_HANDLE phRequest,
															 unsigned short *numer_rekordu
															 );
/*! 
	\brief Realizacja rozkazu PLUGETBYNAME - Wyszukiwanie towaru po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PLUGetByName

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUGetByName(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const char *name,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu PLUGETBYNAME -  Wyszukiwanie towaru po nazwie

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PLUGetByName
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PLUGetByName(const POSNET_HANDLE phRequest,
														  unsigned short *numer_rekordu
														  );
/*! 
	\brief Realizacja rozkazu PLUSETITEMSTATREAD - Odczyt statystyki elementu zestawu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PLUSetItemStatRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUSetItemStatRead(const POSNET_HANDLE hDevice,
																POSNET_HANDLE *phRequest,
																const unsigned short numer_zestawu,
																const unsigned char czy_zerowanie,
																const unsigned char tryb=POSNET_REQMODE_SPOOL
																);
/*! 
	\brief Realizacja rozkazu PLUSETITEMSTATREAD - Odczyt statystyki elementu zestawu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 
	Numery, Iloci i Wartoci zawieraj listy oddzielone znakami nowej linii, po jednej wartoci dla kadego elementu
	zestawu.

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PLUSetItemStatRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PLUSetItemStatRead(const POSNET_HANDLE phRequest,
																unsigned short *numer_zestawu,
																char *numery,
																char *ilosci,
																char *wartosci
																);


/*! 
	\brief Realizacja rozkazu PLUPRICEUPDATE - Aktualizacja ceny towaru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PluPriceUpdate(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const char *cena,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );

/*! 
	\brief Realizacja rozkazu PLUPRICEUPDATEBYBARCODE - Aktualizacja ceny towaru po kodzie kreskowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PluPriceUpdateByBarcode(const POSNET_HANDLE hDevice,
																	 POSNET_HANDLE *phRequest,
																	 const char *kod_kreskowy,
																	 const char *cena,
																	 const unsigned char tryb=POSNET_REQMODE_SPOOL
																	 );
/*! 
\brief Realizacja rozkazu PLUSTOCKMINQNTSET - Ustawienie minimalnego stanu magazynowego PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PluStockMinQntSet(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned short numer_rekordu,
													 const char *stan,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );


/*!
	@}
*/




/*!
	\defgroup hlapi_fiscal	Obsuga pamici fiskalnej
	\ingroup hlapi_global
	@{
*/

/*! 
	\brief Realizacja rozkazu FISCMEMFIRST - Odsyanie pierwszego rekordu okrelonego typu z pamici fiskalnej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_FiscMemFirst
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_FiscMemFirst(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned short typ,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu FISCMEMFIRST - Odsyanie pierwszego rekordu okrelonego typu z pamici fiskalnej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemFirst
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemFirst(const POSNET_HANDLE phRequest,
														  unsigned short *typ,
														  unsigned short *numer
														  );
/*! 
	\brief Realizacja rozkazu FISCMEMLAST - Odsyanie ostatniego rekordu okrelonego typu z pamici fiskalnej 

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_FiscMemLast
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_FiscMemLast(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned short typ,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu FISCMEMLAST - Odsyanie ostatniego rekordu okrelonego typu z pamici fiskalnej 

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemLast
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemLast(const POSNET_HANDLE phRequest,
														 unsigned short *typ,
														 unsigned short *numer
														 );
/*! 
	\brief Realizacja rozkazu FISCMEMNEXT - Odsyanie nastpnego rekordu okrelonego typu z pamici fiskalnej 

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_FiscMemNext
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_FiscMemNext(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned short typ,
														 const unsigned short numer,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu FISCMEMNEXT - Odsyanie nastpnego rekordu okrelonego typu z pamici fiskalnej 

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemNext
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemNext(const POSNET_HANDLE phRequest,
														 unsigned short *typ,
														 unsigned short *nastepny
														 );
/*! 
	\brief Realizacja rozkazu FISCMEMPREV - Odsyanie poprzedniego rekordu okrelonego typu z pamici fiskalnej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_FiscMemPrev
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_FiscMemPrev(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned short typ,
														 const unsigned short numer,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu FISCMEMPREV - Odsyanie poprzedniego rekordu okrelonego typu z pamici fiskalnej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemPrev
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemPrev(const POSNET_HANDLE phRequest,
														 unsigned short *typ,
														 unsigned short *nastepny
														 );
/*! 
	\brief Realizacja rozkazu FISCMEMSTATUS - Odczyt statusu pamici fiskalnej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_FiscMemStatus
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_FiscMemStatus(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu FISCMEMSTATUS - Odczyt statusu pamici fiskalnej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemStatus
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemStatus(const POSNET_HANDLE phRequest,
														   char *numer_unikatowy,
														   char *NIP,
														   unsigned short *rap_dobowe,
														   unsigned short *limit_rap_dobowych,
														   unsigned short *liczba_zmian_PTU,
														   unsigned short *limit_zmian_PTU,
														   unsigned short *liczba_zerowan_RAM,
														   unsigned short *limit_zerowan_RAM
														   );
/*! 
	\brief Realizacja rozkazu FISCMEMREAD - Odczyt rekordu pamici fiskalnej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.


	Odbir wynikw dziaania tej funkcji odbywa si dwuetapowo - najpierw naley sprawdzi 
	typ wyniku za pomoc \ref POSG_FiscMemReadType a nastpnie przy pomocy
	odpowiednich funkcji POSG_FiscMemReadXXXXX odczyta zawarto rekordu.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_FiscMemRead(const POSNET_HANDLE hDevice,
											  POSNET_HANDLE *phRequest,
											  const unsigned short numer_rekordu,
											  const unsigned char tryb=POSNET_REQMODE_SPOOL
											  );
/*! 
	\brief Realizacja rozkazu FISCMEMREAD -  Odczyt rekordu pamici fiskalnej

	Pobranie typu rekordu pamici fiskalnej.

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemReadType(const POSNET_HANDLE phRequest,
											  unsigned short *typ
											  );
/*! 
	\brief Realizacja rozkazu FISCMEMREAD -  Odczyt rekordu pamici fiskalnej

	Pobranie rekordu raportu dobowego pamici fiskalnej.
	Pole totalizeryAG - cig liczb rozdzielonych znakami nowej linii zawierajcych wartoci
	totalizerw stawek A...G;

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemRead
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemReadDaily(const POSNET_HANDLE phRequest,
											  char *data,
											  unsigned short *numer,
											  unsigned short *paragonow,
											  unsigned short *anulowanych,
											  char *totalizeryAG, // liczby rozdzielone \n
											  char *wart_anulowanych,
											  unsigned long *zmianPLU
											  );
/*! 
	\brief Realizacja rozkazu FISCMEMREAD -  Odczyt rekordu pamici fiskalnej

	Pobranie rekordu zmian stawek VAT.

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemReadPTUChange(const POSNET_HANDLE phRequest,
											  char *data,
											  unsigned short *numer,
											  unsigned short *stawkaA,
											  unsigned short *stawkaB,
											  unsigned short *stawkaC,
											  unsigned short *stawkaD,
											  unsigned short *stawkaE,
											  unsigned short *stawkaF,
											  unsigned short *stawkaG
											  );
/*! 
	\brief Realizacja rozkazu FISCMEMREAD -  Odczyt rekordu pamici fiskalnej

	Pobranie rekordu fiskalizacji.

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemReadFiscal(const POSNET_HANDLE phRequest,
    										  char *data,
										      char *nip
											  );
/*! 
	\brief Realizacja rozkazu FISCMEMREAD -  Odczyt rekordu pamici fiskalnej

	Pobranie rekordu rozpoczcia sprzeday po zerowaniu RAM.

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemReadSaleStart(const POSNET_HANDLE phRequest,
															   char *data
															   );


/*! 
	\brief Realizacja rozkazu FISCMEMREAD -  Odczyt rekordu pamici fiskalnej

	Pobranie rekordu zerowania RAM.

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FiscMemRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FiscMemReadClearRAM(const POSNET_HANDLE phRequest,
											  char *data,
											  unsigned short *numer_zerowania,
											  unsigned short *przyczyna_fiscal,
											  unsigned short *przyczyna_apli
											  );
/*!
	@}
*/

/*!
\defgroup hlapi_config Obsuga konfiguracji kasy
\ingroup hlapi_global
@{
*/

/*! 
	\brief Realizacja rozkazu REMOTELOGIN - Logowanie zdalne

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_RemoteLogin(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const char *haslo,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu REMOTELOGOUT - Wyogowanie zdalne

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_RemoteLogout(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu REMOTELOGINPARAMSET - Zapis parametrw logowania zdalnego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_RemoteLoginParamSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char flagi,
														const char *haslo,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu REMOTELOGINPARAMGET - Odczyt parametrw logowania zdalnego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_RemoteLoginParamGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_RemoteLoginParamGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu REMOTELOGINPARAMGET - Odczyt parametrw logowania zdalnego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_RemoteLoginParamGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_RemoteLoginParamGet(const POSNET_HANDLE phRequest,
															unsigned char *flagi,
															char *haslo
															);


/*! 
	\brief Realizacja rozkazu SALEFLDPLUNAMEASPRICECFG - Konfiguracja pola nazwa towaru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_SaleFldPLUNameAsPriceCfg(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char flaga,
														const unsigned char tryb
													 );

/*! 
	\brief Realizacja rozkazu CHANGELOGOUTSET - Zapis konfiguracji wylogowania po raporcie zmianowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ChangeLogoutSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char flaga,
														const unsigned char tryb
													 );


/*! 
	\brief Realizacja rozkazu TAKINGSVERIFYSET - Zapis ustawienia weryfikacji utargu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_TakingsVerifySet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char flaga,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu ADDONCFGSET - Zapis konfiguracji obsugi suplementw kodu kreskowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_AddonCfgSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char suplement2,
														const unsigned char suplement5,
														const unsigned short odstep,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu CHANGEREPCNTCLR - Zerowanie licznika wykonanych raportw zmianowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ChangeRepCntClr(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_kasjera,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu PROTTRANSMONCFGINS - Zapis konfiguracji ramki monitora transakcji

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ProtTransMonCfgIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_ciagu,
														const char *ciag,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu EXTPRNCFGSET - Ustawienie konfiguracji drukarki paragonowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/													 
POSNET_API	POSNET_STATUS	__stdcall	POSS_ExtPrnCfgSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char numer_drukarki,
														const unsigned char czcionki,
														const unsigned char szerokosc,
														const unsigned char obcinacz,
														const char *linie_naglowka,
														const unsigned char tryb
													 );
													 



/*! 
	\brief Realizacja rozkazu BILLBUFCFGGETEX - Odczyt konfiguracji rozszerzonej bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_BillBufCfgGetEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_BillBufCfgGetEx(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );

/*! 
	\brief Realizacja rozkazu BILLBUFCFGGETEX - Odczyt konfiguracji rozszerzonej bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_BillBufCfgGetEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_BillBufCfgGetEx(const POSNET_HANDLE phRequest,
															unsigned char *aktywny,
															unsigned char *przepelnienie,
															unsigned short *prog,
															unsigned char *blokada,
															unsigned char *sygnalizacja
															);

/*! 
	\brief Realizacja rozkazu SALESIZEGETEX - Odsyanie informacji o stanie zapenienia bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_SaleSizeGetEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_SaleSizeGetEx(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu SALESIZEGETEX - Odsyanie informacji o stanie zapenienia bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_SaleSizeGetEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleSizeGetEx(const POSNET_HANDLE phRequest,
														 unsigned char *prog,
														 unsigned long *wartosc_biezaca,
														 unsigned long *wartosc_maksymalna
														 );

/*! 
	\brief Realizacja rozkazu EXTPRNCFGGET - Pobranie konfiguracji drukarki paragonowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_ExtPrnCfgGet
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ExtPrnCfgGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char numer_drukarki,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu EXTPRNCFGGET - Pobranie konfiguracji drukarki paragonowej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_ExtPrnCfgGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_ExtPrnCfgGet(const POSNET_HANDLE phRequest,
														 unsigned char *numer_drukarki,
														 unsigned char *czcionki,
														 unsigned char *szerokosc,
														 unsigned char *obcinacz,
														 char *linie_naglowka
														 );
/*! 
	\brief Realizacja rozkazu PROTTRANSMONCFGREAD - Odczyt konfiguracji ramki monitora transakcji

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_ProtTransMonCfgRead
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ProtTransMonCfgRead(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_ciagu,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu PROTTRANSMONCFGREAD - Odczyt konfiguracji ramki monitora transakcji

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_ProtTransMonCfgRead
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_ProtTransMonCfgRead(const POSNET_HANDLE phRequest,
														 unsigned short *numer_ciagu,
														 char *ciag
														 );

/*! 
	\brief Realizacja rozkazu ADDONCFGGET - Odczyt konfiguracji obsugi suplementw kodu kreskowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_AddonCfgGet
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_AddonCfgGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu ADDONCFGGET - Odczyt konfiguracji obsugi suplementw kodu kreskowego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_AddonCfgGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_AddonCfgGet(const POSNET_HANDLE phRequest,
														 unsigned char *suplement2,
														 unsigned char *suplement5,
														 unsigned short *odstep
														 );

/*! 
	\brief Realizacja rozkazu TERMINALCFGSET - Ustawienie konfiguracji wsppracy z terminalem patnicztym

	\param wariant posiada 3 moliwe wartoci 0 - nie wysyaj blokw danych portw (parametry portcfgA i portcfgB s
	nieistotne) - wycza wspprac z terminalem, 1 - wylij blok danych pinpada (parametr portcfgA istotny, portcfgB nieistotny)
	2 - wylij oba bloki danych (pinpada i modemu)

	Format parametrw portu:  9600,8,N,1,H [ bitrate,bits,parity,stop,flow (N,S,H,D - DTR/DSR)]

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_TerminalCfgSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char wariant,
														const unsigned char portA_numer,
														const char *portcfgA, 
														const unsigned char portB_numer,
														const char *portcfgB,
														const unsigned char tryb
														);

/*! 
	\brief Realizacja rozkazu TAKINGSVERIFYGET - Odczyt ustawienia weryfikacji utargu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_TakingsVerifyGet
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_TakingsVerifyGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu TAKINGSVERIFYGET - Odczyt ustawienia weryfikacji utargu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_TakingsVerifyGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_TakingsVerifyGet(const POSNET_HANDLE phRequest,
														 unsigned char *tryb
														 );


/*! 
	\brief Realizacja rozkazu STORECFGGETEX - Odczyt rozszerzonych ustawie magazynw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_StoreCfgGetEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_StoreCfgGetEx(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu STORECFGGETEX - Odczyt rozszerzonych ustawie magazynw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_StoreCfgGetEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_StoreCfgGetEx(const POSNET_HANDLE phRequest,
														 unsigned char *magazyn_PLU_wlaczony,
														 unsigned char *kontrola_stanu,
														 unsigned char *kontrola_stanu_sprzedaz,
														 unsigned char *magazyn_opak_wlaczony,
														 unsigned char *kontrola_stanu_opak,
														 unsigned char *kontrola_opak_sprzedaz,
														 unsigned char *receptury
														 );

/*! 
	\brief Realizacja rozkazu COMMCFGGETEX - Odczyt rozszerzonej konfiguracji komunikacji z PC

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_CommCfgGetEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CommCfgGetEx(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu COMMCFGGETEX - Odczyt rozszerzonej konfiguracji komunikacji z PC

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_CommCfgGetEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_CommCfgGetEx(const POSNET_HANDLE phRequest,
														unsigned char *typ,
														unsigned char *id_kanalu,
														unsigned char *szyfr,
														unsigned char *charset,
														unsigned char *tcpip,
														char *ipv4_address,
														char *ipv4_netmask,
														char *ipv4_gateway,
														unsigned short *port,
														unsigned char *dhcp
														);

/*! 
	\brief Realizacja rozkazu CHANGELOGOUTGET - Odczyt konfiguracji wylogowania po raporcie zmianowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_ChangeLogoutGet
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ChangeLogoutGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu CHANGELOGOUTGET - Odczyt konfiguracji wylogowania po raporcie zmianowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_ChangeLogoutGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_ChangeLogoutGet(const POSNET_HANDLE phRequest,
														 unsigned char *flaga
														 );


/*! 
	\brief Realizacja rozkazu HEADERSET - Programowanie nagwka

	Pola parametry_linii i linie zawieraj wartoci oddzielone znakami nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS __stdcall POSS_HeaderSet(const POSNET_HANDLE hDevice,
												   POSNET_HANDLE *phRequest,
												   const char *parametry_linii, // liczby rozdzielone \n
												   const char *linie, // wiersze rozdzielone \n (sam liczy ile)
												   const unsigned char tryb=POSNET_REQMODE_SPOOL
												   );
/*! 
	\brief Realizacja rozkazu HEADERGET - Odczyt nagwka

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_HeaderGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HeaderGet(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu HEADERGET - Odczyt nagwka

	Pola flagi_linii i linie zawieraj wartoci oddzielone znakami nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_HeaderGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_HeaderGet(const POSNET_HANDLE phRequest,
													   char *flagi_linii, // liczby rozdzielone \n
													   char *linie // liniee rozdzielone \n
													   );
/*! 
	\brief Realizacja rozkazu DATEGET - Pobranie daty

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DateGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DateGet(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu DATEGET - Pobranie daty

	Data jest w formacie "RRRR-MM-DD"

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DateGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DateGet(const POSNET_HANDLE phRequest,
													 char *data
													 );

/*! 
	\brief Realizacja rozkazu TIMEGET - Pobranie czasu

	Czas w formacie: "GG:MM"

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_TimeGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_TimeGet(const POSNET_HANDLE phRequest,
													 char *time
													 );
/*! 
\brief Realizacja rozkazu TIMEGET - Pobranie czasu

Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

Cz wysyajca polecenie.

Posiada cz odbiorcz - \ref POSS_TimeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_TimeGet(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );
/*! 
	\brief Realizacja rozkazu DATETIMESET - Ustawianie daty i czasu 

	Data i czas w formacie: "RRRR-MM-DD GG:MM:SS"

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DateTimeSet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const char *data_czas,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu VATSET - Zapis stawek

	Data i czas w formacie: "RRRR-MM-DD GG:MM:SS"

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_VATSet(const POSNET_HANDLE hDevice,
													POSNET_HANDLE *phRequest,
													const char *data_czas,
													const unsigned short stawkaA,
													const unsigned short stawkaB,
													const unsigned short stawkaC,
													const unsigned short stawkaD,
													const unsigned short stawkaE,
													const unsigned short stawkaF,
													const unsigned short stawkaG,
													const unsigned char tryb=POSNET_REQMODE_SPOOL
													);
/*! 
	\brief Realizacja rozkazu VATGET - Odczyt stawek

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_VATGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_VATGet(const POSNET_HANDLE hDevice,
													POSNET_HANDLE *phRequest,
													const unsigned char tryb=POSNET_REQMODE_SPOOL
											  );
/*! 
	\brief Realizacja rozkazu VATGET - Odczyt stawek

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_VATGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_VATGet(const POSNET_HANDLE phRequest,
													unsigned short *stawkaA,
													unsigned short *stawkaB,
													unsigned short *stawkaC,
													unsigned short *stawkaD,
													unsigned short *stawkaE,
													unsigned short *stawkaF,
													unsigned short *stawkaG
											  );
/*! 
	\brief Realizacja rozkazu FOOTERSET - Programowanie linii stopki

	Pola flagi i linie zawieraj wartoci oddzielone znakami nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_FooterSet(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const char *flagi, // liczby rozdzielone \n
													   const char *linie, // linie rozdzielone \n
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu FOOTERGET - Odczyt linii stopki

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_FooterGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_FooterGet(const POSNET_HANDLE hDevice,
													   POSNET_HANDLE *phRequest,
													   const unsigned char tryb=POSNET_REQMODE_SPOOL
													   );
/*! 
	\brief Realizacja rozkazu FOOTERGET - Odczyt linii stopki

	Pola flagi_linii i linie zawieraj wartoci oddzielone znakami nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_FooterGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_FooterGet(const POSNET_HANDLE phRequest,
													   char *flagi_linii,
													   char *linie
													   );
/*! 
	\brief Realizacja rozkazu DSPPARAMGET - Odczyt konfiguracji wywietlacza

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DspParamGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DspParamGet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char wyswietlacz,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu DSPPARAMGET - Odczyt konfiguracji wywietlacza

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DspParamGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DspParamGet(const POSNET_HANDLE phRequest,
														 unsigned char *kontrast,
														 unsigned char *podswietlenie,
														 unsigned char *tryb_podsw,
														 unsigned short *opoznienie
														 );
/*! 
	\brief Realizacja rozkazu SALECFGSET - Zapis konfiguracji sprzeday

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_SaleCfgSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char czy_zak_gotowkowe,
														const unsigned char czy_sprawdzanie_cen,
														const unsigned char wart_kwotowe,
														const unsigned char czy_sprawdz_przy_sprzedazy,
														const unsigned char stat_tyg,
														const unsigned char stat_roczne,
														const char *limit_rab_proc_z_reki,
														const char *limit_narz_proc_z_reki,
														const char *limit_rab_kwot_z_reki,
														const char *limit_narz_kwot_z_reki,
														const unsigned char czy_rabaty,
														const unsigned char czy_narzuty,
														const unsigned char klawisz_kod,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu SALECFGSETEX - Zapis konfiguracji sprzeday - wersja dla kasy NEO
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_SaleCfgSetEx(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char czy_zak_gotowkowe,
														const unsigned char czy_sprawdzanie_cen,
														const unsigned char wart_kwotowe,
														const unsigned char czy_sprawdz_przy_sprzedazy,
														const unsigned char stat_tyg,
														const unsigned char stat_roczne,
														const char *limit_rab_proc_z_reki,
														const char *limit_narz_proc_z_reki,
														const char *limit_rab_kwot_z_reki,
														const char *limit_narz_kwot_z_reki,
														const unsigned char czy_rabaty,
														const unsigned char czy_narzuty,
														const unsigned char klawisz_kod,
														const unsigned char automat,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu SALECFGSETEX - Zapis konfiguracji sprzeday 
	\ingroup hlapi_config
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_SaleCfgSetEx(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char czy_zak_gotowkowe,
														const unsigned char czy_sprawdzanie_cen,
														const unsigned char wart_kwotowe,
														const unsigned char czy_sprawdz_przy_sprzedazy,
														const unsigned char stat_tyg,
														const unsigned char stat_roczne,
														const char *limit_rab_proc_z_reki,
														const char *limit_narz_proc_z_reki,
														const char *limit_rab_kwot_z_reki,
														const char *limit_narz_kwot_z_reki,
														const unsigned char czy_rabaty,
														const unsigned char czy_narzuty,
														const unsigned char klawisz_kod,
														const unsigned char automat,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);

/*! 
	\brief Realizacja rozkazu PRICEVERIFCFGGET - Odczyt konfiguracji weryfikatora cen
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Posiada cz odbiorcz - \ref POSG_NEO_PriceVerifCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_PriceVerifCfgGet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char typ,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu PRICEVERIFCFGGET - Odczyt konfiguracji weryfikatora cen
	\ingroup hlapi_config
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Posiada cz odbiorcz - \ref POSG_PriceVerifCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PriceVerifCfgGet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char typ,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu PRICEVERIFCFGGET -  Odczyt konfiguracji weryfikatora cen
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
    Posiada cz nadawcz - \ref POSS_NEO_PriceVerifCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_NEO_PriceVerifCfgGet(const POSNET_HANDLE phRequest,
														 unsigned char *ilosc,
														 unsigned char *miganie,
														 unsigned char *opoznienie,
														 unsigned char *czas,
														 char *tekst
														 );
/*! 
	\brief Realizacja rozkazu PRICEVERIFCFGGET -  Odczyt konfiguracji weryfikatora cen
	\ingroup hlapi_config
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
    Posiada cz nadawcz - \ref POSS_PriceVerifCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PriceVerifCfgGet(const POSNET_HANDLE phRequest,
														 unsigned char *ilosc,
														 unsigned char *miganie,
														 unsigned char *opoznienie,
														 unsigned char *czas,
														 char *tekst
														 );

/*! 
	\brief Realizacja rozkazu PRICEVERIFCFGSET - Zapis konfiguracji weryfikatora cen
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS __stdcall POSG_NEO_PriceVerifCfgSet(const POSNET_HANDLE hDevice,
												   POSNET_HANDLE *phRequest,
												   const unsigned char typ,
												   const unsigned char ilosc,
												   const unsigned char miganie,
												   const unsigned char opoznienie,
												   const unsigned char czas,
												   const char *tekst,
												   const unsigned char tryb=POSNET_REQMODE_SPOOL
												   );
/*! 
	\brief Realizacja rozkazu PRICEVERIFCFGSET - Zapis konfiguracji weryfikatora cen
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS __stdcall POSS_PriceVerifCfgSet(const POSNET_HANDLE hDevice,
												   POSNET_HANDLE *phRequest,
												   const unsigned char typ,
												   const unsigned char ilosc,
												   const unsigned char miganie,
												   const unsigned char opoznienie,
												   const unsigned char czas,
												   const char *tekst,
												   const unsigned char tryb=POSNET_REQMODE_SPOOL
												   );

/*! 
	\brief Realizacja rozkazu SALECFGGETEX - Odczyt konfiguracji sprzeday
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Posiada cz odbiorcz - \ref POSG_NEO_SaleCfgGetEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_SaleCfgGetEx(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu SALECFGGETEX - Odczyt konfiguracji sprzeday
	\ingroup hlapi_config
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Posiada cz odbiorcz - \ref POSG_SaleCfgGetEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_SaleCfgGetEx(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu SALECFGGETEX -  Odczyt konfiguracji sprzeday
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
    Posiada cz nadawcz - \ref POSS_NEO_SaleCfgGetEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_NEO_SaleCfgGetEx(const POSNET_HANDLE phRequest,
														unsigned char *czy_zakonczenie,
														unsigned char *czy_sprawdzenie,
														unsigned char *format_warosci,
														unsigned char *czy_sprawdz_sprzedaz,
														unsigned char *stat_tyg,
														unsigned char *stat_roczne,
														char *limit_rab_proc,
														char *limit_rab_kwot,
														char *limit_narz_proc,
														char *limit_narz_kwot,
														unsigned char *czy_z_rabatami,
														unsigned char *czy_z_narzutami,
														unsigned char *klawisz_kod,
														unsigned char *automat
														);
/*! 
	\brief Realizacja rozkazu SALECFGGETEX -  Odczyt konfiguracji sprzeday
	\ingroup hlapi_config
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
    Posiada cz nadawcz - \ref POSS_SaleCfgGetEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleCfgGetEx(const POSNET_HANDLE phRequest,
														unsigned char *czy_zakonczenie,
														unsigned char *czy_sprawdzenie,
														unsigned char *format_warosci,
														unsigned char *czy_sprawdz_sprzedaz,
														unsigned char *stat_tyg,
														unsigned char *stat_roczne,
														char *limit_rab_proc,
														char *limit_rab_kwot,
														char *limit_narz_proc,
														char *limit_narz_kwot,
														unsigned char *czy_z_rabatami,
														unsigned char *czy_z_narzutami,
														unsigned char *klawisz_kod,
														unsigned char *automat
														);

/*! 
	\brief Realizacja rozkazu DSPPARAMSET - Konfiguracja wywietlacza

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DspParamSet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char wyswietlacz,
														 const unsigned char kontrast,
														 const unsigned char podswietlenie,
														 const unsigned char tryb_podsw,
														 const unsigned short opoznienie,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu DSPINFOSET - Programowanie tekstw reklamowych na wywietlacz

	Pola typy_zawartosci, linie, inwersje, predkosci, kierunki, formaty_czasu zawieraj wartoci
	rozdzielone znakami nowej linii po jednej dla kadej linii tektu reklamowego.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DspInfoSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char numer,
														const char *typy_zawartosci, // liczby rozdzielone \n
														const char *linie, // ciagi rozdzielone \n
														const char *inwersje,
														const char *predkosci,
														const char *kierunki,
														const char *formaty_czasu,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu SALECFGGET - Odczyt konfiguracji sprzeday

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_SaleCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_SaleCfgGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu SALECFGGET -  Odczyt konfiguracji sprzeday

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SaleCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_SaleCfgGet(const POSNET_HANDLE phRequest,
														unsigned char *czy_zakonczenie,
														unsigned char *czy_sprawdzenie,
														unsigned char *format_warosci,
														unsigned char *czy_sprawdz_sprzedaz,
														unsigned char *stat_tyg,
														unsigned char *stat_roczne,
														char *limit_rab_proc,
														char *limit_rab_kwot,
														char *limit_narz_proc,
														char *limit_narz_kwot,
														unsigned char *czy_z_rabatami,
														unsigned char *czy_z_narzutami,
														unsigned char *klawisz_kod
														);




/*! 
	\brief Realizacja rozkazu STORECFGGET - Odczyt ustawie magazynw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_StoreCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_StoreCfgGet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu STORECFGGET - Odczyt ustawie magazynw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_StoreCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_StoreCfgGet(const POSNET_HANDLE phRequest,
														 unsigned char *magazyn_PLU_wlaczony,
														 unsigned char *kontrola_stanu,
														 unsigned char *kontrola_stanu_sprzedaz,
														 unsigned char *magazyn_opak_wlaczony,
														 unsigned char *kontrola_stanu_opak,
														 unsigned char *kontrola_opak_sprzedaz
														 );
/*! 
	\brief Realizacja rozkazu DRAWERIMPULSEGET - Pobranie dugoci impulsu szuflady

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DrawerImpulseGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DrawerImpulseGet(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu DRAWERIMPULSEGET - Pobranie dugoci impulsu szuflady

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DrawerImpulseGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DrawerImpulseGet(const POSNET_HANDLE phRequest,
															  unsigned short *impuls
															  );
/*! 
	\brief Realizacja rozkazu SOUNDCFGGET - Odczyt konfiguracji dwikw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_SoundCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_SoundCfgGet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu SOUNDCFGGET - Odczyt konfiguracji dwikw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SoundCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_SoundCfgGet(const POSNET_HANDLE phRequest,
														 unsigned char* flaga,
														 unsigned char *zrodlo
														 );
/*! 
	\brief Realizacja rozkazu TIMEOUTSGET - Odczyt czasu wylogowania i wyczenia

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_TimeoutsGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_TimeoutsGet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu TIMEOUTSGET - Odczyt czasu wylogowania i wyczenia

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_TimeoutsGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_TimeoutsGet(const POSNET_HANDLE phRequest,
														 unsigned char *wylogowanie,
														 unsigned char *wylaczenie
														 );


/*! 
	\brief Realizacja rozkazu TIMEOUTSGETEX - Odczyt czasu wylogowania i wyczenia

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_TimeoutsGetEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_TimeoutsGetEx(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char tryb
														 );
/*! 
	\brief Realizacja rozkazu TIMEOUTSGETEX - Odczyt czasu wylogowania i wyczenia

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
    Posiada cz nadawcz - \ref POSS_TimeoutsGetEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_TimeoutsGetEx(const POSNET_HANDLE phRequest,
														 unsigned char *wylogowanie,
														 unsigned char *wylaczenie,
														 unsigned char *blokada,
														 unsigned short *godzina_odblokowania
														 );

/*! 
	\brief Realizacja rozkazu MODEMCFGGET - Odczyt sekwencji inicjalizujcej modem

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_ModemCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_ModemCfgGet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu MODEMCFGGET - Odczyt sekwencji inicjalizujcej modem

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_ModemCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_ModemCfgGet(const POSNET_HANDLE phRequest,
														 unsigned char *modem,
														 char *init,
														 char *telefon
														 );
/*! 
	\brief Realizacja rozkazu PRINTCFGGET - Odczyt konfiguracji wydruku

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PrintCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PrintCfgGet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu PRINTCFGGET - Odczyt konfiguracji wydruku

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PrintCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PrintCfgGet(const POSNET_HANDLE phRequest,
														 unsigned char *niefiskalne,
														 unsigned char *zmiany_PLU,
														 unsigned char *czulosc,
														 unsigned char *obcinacz
														 );
/*! 
	\brief Realizacja rozkazu DSPINFOCFGSET - Zapis ustawie wywietlania linii informacyjnych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.

*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DspInfoCfgSet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char linia_zalogowany,
														   const unsigned char linia_niezalogowany,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu PRINTCFGSET - Zapis konfiguracji wydruku

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PrintCfgSet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char niefiskalne,
														 const unsigned char zmiany_PLU,
														 const unsigned char czulosc_papieru,
														 const unsigned char obcinacz,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu MODEMCFGSET - Zmiana sekwencji inicjalizujcej modem

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_ModemCfgSet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char czy_modem,
														 const char *init,
														 const char *telefon,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu TIMEOUTSSET - Ustawienie czasu wylogowania i wyczenia

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_TimeoutsSet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char wylogowanie,
														 const unsigned char wylaczenia,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );

/*! 
	\brief Realizacja rozkazu TIMEOUTSSET - Ustawienie czasu wylogowania i wyczenia

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
		\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_v2_TimeoutsSet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char wylogowanie,
														 const unsigned char wylaczenia,
														 const unsigned char blokada,
														 const unsigned short godzina_odblokowania,
														 const unsigned char tryb
														 );


/*! 
	\brief Realizacja rozkazu SOUNDCFGSET - Zmiana konfiguracji dwiku

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_SoundCfgSet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char flaga,
														 const unsigned char zrodlo,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu DRAWERIMPULSESET - Ustawienie dugoci impulsu szuflady

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DrawerImpulseSet(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned short dlugosc,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu PACKSTORECFGSET - Zmiana ustawie magazynu opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PackStoreCfgSet(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned char magazyn_wlaczony,
															 const unsigned char kontrola_stanow,
															 const unsigned char blokowac,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu PLUSTORECFGSET - Zmiana ustawie magazynu PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> COMBO,NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUStoreCfgSet(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned char czy_wlaczony,
															const unsigned char kontrola_stanow,
															const unsigned char blokowac,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu PLUSTORECFGSET - Zmiana ustawie magazynu PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_v2_PLUStoreCfgSet(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned char czy_wlaczony,
															const unsigned char kontrola_stanow,
															const unsigned char blokowac,
															const unsigned char receptury,
															const unsigned char tryb
															);

/*! 
	\brief Realizacja rozkazu BILLBUFCFGGET - Odczyt konfiguracji bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_BillBufCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_BillBufCfgGet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu BILLBUFCFGGET - Odczyt konfiguracji bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_BillBufCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_BillBufCfgGet(const POSNET_HANDLE phRequest,
														   unsigned char *aktywny,
														   unsigned char *syg_przepelnienia,
														   unsigned short *prog
														   );
/*! 
	\brief Realizacja rozkazu AUTHSTATUSGET - Odczyt stanu autoryzacji kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_AuthStatusGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_AuthStatusGet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu AUTHSTATUSGET - Odczyt stanu autoryzacji kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_AuthStatusGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_AuthStatusGet(const POSNET_HANDLE phRequest,
														   unsigned short *pozostalo
														   );
/*! 
	\brief Realizacja rozkazu CASHREGPARGET - Odczyt parametrw kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_CashregParGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CashregParGet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu CASHREGPARGET - Odczyt parametrw kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_CashregParGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_CashregParGet(const POSNET_HANDLE phRequest,
														   char *numer
														   );
/*! 
	\brief Realizacja rozkazu USERAUTHCFGGET - Odczyt konfiguracji logowania uytkownika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_UserAuthCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserAuthCfgGet(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu USERAUTHCFGGET - Odczyt konfiguracji logowania uytkownika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_UserAuthCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_UserAuthCfgGet(const POSNET_HANDLE phRequest,
															unsigned char *sposob,
															unsigned char *kontrola
															);
/*! 
	\brief Realizacja rozkazu PORTCFGGET - Odczyt konfiguracji portu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_PortCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PortCfgGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char port,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);



/*! 
	\brief Realizacja rozkazu PORTCFGGET - Odczyt konfiguracji portu - wersja dla kasy NEO
    \ingroup Kasa_Neo

	\param phRequest Uchwyt wyniku	
	\param typ_urzadzenia Typ urzdzenia 0-brak, 1-waga, 2-skaner, 3-komputer
	\param nazwa Nazwa portu
	\param konfiguracja Opis konfiguracji portu w postaci cigu znakw w formacie:  [predkosc],[bity danych],[parzysto],[bity stop],[kontrola transmisji]
			przy czym dopuszczalne wartoci poszczeglnych pl to: 
			-  prdko: 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200
			-  bity danych: 7, 8
			-  parzysto: N - brak, O - nieparzysto, E - parzysto
			-  bity stop-u: 1, 2
			-  kontrola transmisji: X - XOn/XOFF, R -RTS/CTS, D - DTR,DSR, N - brak
	\param podtyp Podtyp urzdzenia.

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
    Posiada cz nadawcz - \ref POSS_PortCfgGet
*/


POSNET_API	POSNET_STATUS __stdcall		POSG_NEO_PortCfgGet(const POSNET_HANDLE phRequest,
														unsigned char *typ_urzadzenia,
														char *nazwa,
														char *konfiguracja,
														unsigned char *podtyp
														);
/*! 
	\brief Realizacja rozkazu PORTCFGGET - Odczyt konfiguracji portu 
    \ingroup hlapi_config

	\param phRequest Uchwyt wyniku	
	\param typ_urzadzenia Typ urzdzenia 0-brak, 1-waga, 2-skaner, 3-komputer
	\param nazwa Nazwa portu
	\param konfiguracja Opis konfiguracji portu w postaci cigu znakw w formacie:  [predkosc],[bity danych],[parzysto],[bity stop],[kontrola transmisji]
			przy czym dopuszczalne wartoci poszczeglnych pl to: 
			-  prdko: 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200
			-  bity danych: 7, 8
			-  parzysto: N - brak, O - nieparzysto, E - parzysto
			-  bity stop-u: 1, 2
			-  kontrola transmisji: X - XOn/XOFF, R -RTS/CTS, D - DTR,DSR, N - brak
	\param podtyp Podtyp urzdzenia.

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
    Posiada cz nadawcz - \ref POSS_PortCfgGet
*/


POSNET_API	POSNET_STATUS __stdcall		POSG_v2_PortCfgGet(const POSNET_HANDLE phRequest,
														unsigned char *typ_urzadzenia,
														char *nazwa,
														char *konfiguracja,
														unsigned char *podtyp
														);
/*! 
	\brief Realizacja rozkazu PORTCFGGET - Odczyt konfiguracji portu

	\param phRequest Uchwyt wyniku	
	\param typ_urzadzenia Typ urzadzenia 0-brak, 1-waga, 2-skaner, 3-monitor transakcji, 4-komputer, 5-weryfikator cen
	\param nazwa Nazwa portu
	\param konfiguracja Opis konfiguracji portu w postaci cigu znakw w formacie:  [predkosc],[bity danych],[parzysto],[bity stop],[kontrola transmisji]
			przy czym dopuszczalne wartoci poszczeglnych pl to: 
			-  prdko: 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200
			-  bity danych: 7, 8
			-  parzysto: N - brak, O - nieparzysto, E - parzysto
			-  bity stop-u: 1, 2
			-  kontrola transmisji: X - XOn/XOFF, R -RTS/CTS, D - DTR,DSR, N - brak
	.

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_PortCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_PortCfgGet(const POSNET_HANDLE phRequest,
														unsigned char *typ_urzadzenia,
														char *nazwa,
														char *konfiguracja
														);



/*! 
	\brief Realizacja rozkazu COMMCFGGET - Odczyt konfiguracji komunikacji z PC

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_CommCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CommCfgGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu COMMCFGGET - Odczyt konfiguracji komunikacji z PC

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_CommCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_CommCfgGet(const POSNET_HANDLE phRequest,
														unsigned char *typ,
														unsigned char *id_kanalu,
														unsigned char *szyfr,
														unsigned char *charset,
														unsigned char *tcpip,
														char *ipv4_address,
														char *ipv4_netmask,
														char *ipv4_gateway
														);
/*! 
	\brief Realizacja rozkazu DSPINFOCFGGET - Odczyt ustawie wywietlania linii informacyjnych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DspInfoCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DspInfoCfgGet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu DSPINFOCFGGET -  Odczyt ustawie wywietlania linii informacyjnych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DspInfoCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DspInfoCfgGet(const POSNET_HANDLE phRequest,
														   unsigned char *gdy_zalogowany,
														   unsigned char *gdy_wylogowany
														   );
/*! 
	\brief Realizacja rozkazu DSPINFOGET -  Pobranie informacji o tekstach reklamowych z wywietlacza


	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DspInfoGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DspInfoGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char numer,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu DSPINFOGET - Pobranie informacji o tekstach reklamowych z wywietlacza

	Pola typy_zawartosci, linie, inwersje, predkosci, kierunki, formaty_czasu zawieraj wartoci rozdzielone
	znakami nowej linii, po jednej dla kadej linii tekstu reklamowego.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DspInfoGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DspInfoGet(const POSNET_HANDLE phRequest,
														char *typy_zawartosci, // liczby rozdzielone \n
														char *linie, // ciagi rozdzielone \n
														char *inwersje,
														char *predkosci,
														char *kierunki,
														char *formaty_czasu
														);
/*! 
	\brief Realizacja rozkazu DISCNTCARDCFGGET - Odczyt konfiguracji kart rabatowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DiscntCardCfgGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DiscntCardCfgGet(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu DISCNTCARDCFGGET - Odczyt konfiguracji kart rabatowych

	Odmienne znaczenie pola "wazne" w kasach NEO i COMBO

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DiscntCardCfgGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DiscntCardCfgGet(const POSNET_HANDLE phRequest,
															  unsigned char *wazne,
															  unsigned short *czas,
															  unsigned short *metoda
															  );
/*! 
	\brief Realizacja rozkazu DISCNTCARDCFGSET w kasie NEO - Zapis konfiguracji kart rabatowych
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_DiscntCardCfgSet(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char czy_wazne,
															  const unsigned short czas_odpowiedzi,
															  const unsigned short sposob_wprowadzania,
															  const char *parametry,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu DISCNTCARDCFGSET  - Zapis konfiguracji kart rabatowych
	\ingroup hlapi_config
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_v2_DiscntCardCfgSet(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char czy_wazne,
															  const unsigned short czas_odpowiedzi,
															  const unsigned short sposob_wprowadzania,
															  const char *parametry,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu DISCNTCARDCFGSET - Zapis konfiguracji kart rabatowych
	
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DiscntCardCfgSet(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char czy_wazne,
															  const unsigned short czas_odpowiedzi,
															  const unsigned short sposob_wprowadzania,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu DISCNTCARDCFGGETEX - Odczyt konfiguracji kart rabatowych - rozszerzony
	\ingroup Kasa_Neo
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par

	Posiada cz odbiorcz - \ref POSG_NEO_DiscntCardCfgGetEx
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_DiscntCardCfgGetEx(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );

/*! 
	\brief Realizacja rozkazu DISCNTCARDCFGGETEX - Odczyt konfiguracji kart rabatowych - rozszerzony
	\ingroup hlapi_discount
	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par

	Posiada cz odbiorcz - \ref POSG_DiscntCardCfgGetEx
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DiscntCardCfgGetEx(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );

/*! 
	\brief Realizacja rozkazu DISCNTCARDCFGGETEX - Odczyt konfiguracji kart rabatowych - rozszerzony 
	\ingroup Kasa_Neo

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par 
	<b>Kasy:</b> NEO
	\par
    Posiada cz nadawcz - \ref POSS_NEO_DiscntCardCfgGetEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_NEO_DiscntCardCfgGetEx(const POSNET_HANDLE phRequest,
															  unsigned char *wazne,
															  unsigned short *czas,
															  unsigned short *metoda,
															  char *parametry
															  );

/*! 
	\brief Realizacja rozkazu DISCNTCARDCFGGETEX - Odczyt konfiguracji kart rabatowych - rozszerzony 
	\ingroup hlapi_discount

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
    Posiada cz nadawcz - \ref POSS_DiscntCardCfgGetEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_DiscntCardCfgGetEx(const POSNET_HANDLE phRequest,
															  unsigned char *wazne,
															  unsigned short *czas,
															  unsigned short *metoda,
															  char *parametry
															  );


/*! 
	\brief Realizacja rozkazu MAINTENANCESET - Programowanie przypomnienia o przegldzie serwisowym

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_MaintenanceSet(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const char *data,
															const char *serwis,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu COMMCFGSET - Zapis konfiguracji komunikacji z PC

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02 i wczeniejsze
	\par
	<b>Kasy:</b> COMBO,NEO
	\par

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CommCfgSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char typ_interfejsu,
														const unsigned char id_kanalu,
														const unsigned char typ_szyfru,
														const unsigned char charset,
														const unsigned char tcpip,
														const char *ipv4_address,
														const char *ipv4_netmask,
														const char *ipv4_gateway,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu COMMCFGSET - Zapis konfiguracji komunikacji z PC

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_v2_CommCfgSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char typ_interfejsu,
														const unsigned char id_kanalu,
														const unsigned char typ_szyfru,
														const unsigned char charset,
														const unsigned char tcpip,
														const char *ipv4_address,
														const char *ipv4_netmask,
														const char *ipv4_gateway,
														const unsigned short port,
														const unsigned char dhcp,
														const unsigned char tryb
														);

/*! 
	\brief Realizacja rozkazu PORTCFGSET - Zapis konfiguracji portu

	Format parametrw portu:  9600,8,N,1,H [ bitrate,bits,parity,stop,flow (N,S,H,D - DTR/DSR)]

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_PortCfgSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char typ_urzadzenia,
														const unsigned char numer_portu,
														const char *portcfg, 
														const char *nazwa,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);

/*! 
	\brief Realizacja rozkazu PORTCFGSET - Zapis konfiguracji portu - wersja dla kasy NEO
	\ingroup Kasa_Neo
	Format parametrw portu:  9600,8,N,1,H [ bitrate,bits,parity,stop,flow (N,S,H,D - DTR/DSR)]

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_NEO_PortCfgSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char typ_urzadzenia,
														const unsigned char numer_portu,
														const char *portcfg, 
														const char *nazwa,
														const char podtyp,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu PORTCFGSET - Zapis konfiguracji portu 
	\ingroup hlapi_config
	Format parametrw portu:  9600,8,N,1,H [ bitrate,bits,parity,stop,flow (N,S,H,D - DTR/DSR)]

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_v2_PortCfgSet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char typ_urzadzenia,
														const unsigned char numer_portu,
														const char *portcfg, 
														const char *nazwa,
														const char podtyp,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu USERAUTHCFGSET - Zapis konfiguracji logowania uytkownika

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_UserAuthCfgSet(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned char sposob_log,
															const unsigned char typ_kontroli,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu CASHREGPARSET - Zapis parametrw kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CashregParSet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const char *numer_kasy,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu AUTHCODERESET - Reset kodw autoryzacyjnych

	Terminy - liczby rozdzielone znakami nowej linii.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_AuthCodeReset(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const char *kod,
														   const unsigned short okres_wstepny,
														   const char *terminy, // liczby rozdzielone \n
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );

/*!
	\brief Realizacja rozkazu USERLOGOUT - Wylogowanie kasjera

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_UserLogout(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);


/*!
	\brief Realizacja rozkazu TURNOFF - Wyczenie kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_TurnOff(const POSNET_HANDLE hDevice,
													 POSNET_HANDLE *phRequest,
													 const unsigned char tryb=POSNET_REQMODE_SPOOL
													 );

/*! 
	\brief Realizacja rozkazu AUTHCODEINS - Wprowadzanie kodu autoryzacyjnego

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_AuthCodeIns(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const char *kod,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu BILLBUFCFGSET - Ustawienie konfiguracji bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> COMBO,NEO
	\par
	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_BillBufCfgSet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char czy_aktywny,
														   const unsigned char czy_sygnalizowac,
														   const unsigned short poziom_progowy,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu BILLBUFCFGSET - Ustawienie konfiguracji bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_v2_BillBufCfgSet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char czy_aktywny,
														   const unsigned char czy_sygnalizowac,
														   const unsigned short poziom_progowy,
														   const unsigned char czy_blokada,
														   const unsigned char czy_informacja,
														   const unsigned char tryb
														   );

/*! 
	\brief Realizacja rozkazu DBSTATUSGET - Odczyt statusu baz kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DBStatusGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_DBStatusGet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu DBSTATUSGET -  Odczyt statusu baz kasy

	Pole rozmiary i zaprogramowane zawieraj licniki rozdzielone znakami nowej linii, kolejno: 
	opakowania, klawisze, kasjerzy, platnosci, rabaty, PLU, grupy, MU, barcodes, formaty_barcode

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DBStatusGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_DBStatusGet(const POSNET_HANDLE phRequest,
														 unsigned char *typ_kasy,
														 unsigned char *totalizery,
														 char *rozmiary, // liczby rozdzielone \n
														 char *zaprogramowane
														 );

/*! 
	\brief Realizacja rozkazu DBSTATUSGETEX - Odczyt statusu baz kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_DBStatusGetEx
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_DBStatusGetEx(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char tryb
														 );

/*! 
	\brief Realizacja rozkazu DBSTATUSGETEX -  Odczyt statusu baz kasy

	Pole rozmiary i zaprogramowane zawieraj licniki rozdzielone znakami nowej linii, kolejno: 
	opakowania, klawisze, kasjerzy, platnosci, rabaty, PLU, grupy, MU, barcodes, formaty_barcode,
	opisy_wyplat, bdy, opisy towarw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_DBStatusGetEx
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_DBStatusGetEx(const POSNET_HANDLE phRequest,
														 unsigned char *typ_kasy,
														 unsigned char *totalizery,
														 char *rozmiary, // liczby rozdzielone \n
														 char *zaprogramowane
														 );

/*! 
	\brief Realizacja rozkazu CASHREGSTATUSGET - Odczyt statusu kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_CashRegStatusGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CashregStatusGet(const POSNET_HANDLE hDevice,
															  POSNET_HANDLE *phRequest,
															  const unsigned char tryb=POSNET_REQMODE_SPOOL
															  );
/*! 
	\brief Realizacja rozkazu CASHREGSTATUSGET - Odczyt statusu kasy

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_CashregStatusGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_CashRegStatusGet(const POSNET_HANDLE phRequest,
															  unsigned char *typ_kasy,
															  char *numer,
															  unsigned short *zalogowany_kasjer,
															  unsigned char *tryb_pracy,
															  unsigned char *totalizery,
															  unsigned char *naglowek,
															  unsigned char *transakcja,
															  char *data_fiskalizacji,
															  char *zegar_kasy,
															  char *nip,
															  char *numer_unikatowy,
															  char *wersja
															  );
/*! 
	\brief Realizacja rozkazu SALESIZEGET - Odsyanie informacji o stanie zapenienia bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_SaleSizeGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_SaleSizeGet(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu SALESIZEGET - Odsyanie informacji o stanie zapenienia bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SaleSizeGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_SaleSizeGet(const POSNET_HANDLE phRequest,
														 unsigned char *limit
														 );
/*! 
	\brief Realizacja rozkazu CMPLXSEQSTOP -  Zatrzymanie wykonywania sekwencji zoonej

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_CmplxSeqStop(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu WAITSTATUSGET - Zwraca informacj czy jest oczekiwanie na wykonanie sekwencji zoonej i z jakiego powodu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_WaitStatusGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_WaitStatusGet(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu WAITSTATUSGET - Zwraca informacj czy jest oczekiwanie na wykonanie sekwencji zoonej i z jakiego powodu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_WaitStatusGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_WaitStatusGet(const POSNET_HANDLE phRequest,
														   unsigned char *trwa,
														   unsigned short *cmd_status
														   );
/*! 
	\brief Realizacja rozkazu SEQSTATUSGET - Odsyanie statusu ostatnio wysanego rozkazu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Posiada cz odbiorcz - \ref POSG_SeqStatusGet
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_SeqStatusGet(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  unsigned char typ,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu SEQSTATUSGET - Odsyanie statusu ostatnio wysanego rozkazu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SeqStatusGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_SeqStatusGet(const POSNET_HANDLE phRequest,
														  unsigned short *cmd,
														  unsigned short *cmd_status,
														  unsigned long *token
														  );

/*!
@}
*/


/*!
\defgroup hlapi_salebuf Obsuga bufora pozycji paragonowych
\ingroup hlapi_global

@{
*/

/*! 
	\brief Realizacja rozkazu SALERECDELALL - Kasowanie bufora pozycji paragonowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/


POSNET_API	POSNET_STATUS	__stdcall	POSS_SaleRecDelAll(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );

/*! 
	\brief Realizacja rozkazu SALERECGET - Odsyanie danych z bufora pozycji paragonowych

	Odbir danych paragonowych skada si z dwch etapw - pobranie typu rekordu 
	paragonowego za pomoc \ref POSG_SaleRecGetType a nastpnie odczytanie wartoci 
	odpowiedni funkcj POSG_SaleRecGetXXXXX

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_SaleRecGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char sposob,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie typu rekordu.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetType(const POSNET_HANDLE phRequest,
															unsigned char *pelny,
															unsigned short *nastepny,
															unsigned short *typ
															);


/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych
	\ingroup hlapi_salebuf

	Pobranie rekordu - cashback - typ rekordu 31.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetCashback(const POSNET_HANDLE phRequest,
															  unsigned short *numer_platnosci,
															  char *nazwa_platnosci,
															  unsigned char *typ_platnosci,
															  char *kwota_cashback
															  );

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych
	\ingroup Kasa_Neo

	Pobranie rekordu - autoryzacja paragonu - typ rekordu 25.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_NEO_SaleRecGetAuthorize(const POSNET_HANDLE phRequest,
															  unsigned long *numer_kasjera,
															  char *nazwa,
															  char *kwota
															  );
/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych
	\ingroup hlapi_salebuf

	Pobranie rekordu - autoryzacja paragonu - typ rekordu 25.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetAuthorize(const POSNET_HANDLE phRequest,
															  unsigned long *numer_kasjera,
															  char *nazwa,
															  char *kwota
															  );
/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych
	\ingroup Kasa_Neo

	Pobranie rekordu - inwentaryzacja PLU i opakowa  - typ rekordu 26,27,28,29.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> COMBO,NEO
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_NEO_SaleRecGetInventoryPluPack(const POSNET_HANDLE phRequest,
															  unsigned short *plu_pack,
															  char *kwota
															  );

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych
	

	Pobranie rekordu - inwentaryzacja PLU i opakowa - typ rekordu 26,27,28,29.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_v2_SaleRecGetInventoryPluPack(const POSNET_HANDLE phRequest,
															  unsigned short *plu_pack,
															  char *kryterium,
															  char *ilosc,
															  char *opis
															  );
/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych
	

	Pobranie rekordu - zamwienia PLU i opakowa - typ rekordu 32,33,34,35.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetOrderPluPack(const POSNET_HANDLE phRequest,
															  unsigned short *plu_pack,
															  char *kryterium,
															  char *ilosc,
															  char *opis
															  );

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu opakowa  - typ rekordu  - typ rekordu 0,1.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetPack(const POSNET_HANDLE phRequest,
															unsigned short *numer,
															char *kod_kreskowy,
															char *ilosc,
															char *wartosc
															);
/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu patnoci.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
\par
	<b>Wersja  protokou:</b> wszystkie
	\par
	<b>Kasy:</b> COMBO,NEO
	\par
	<b>W wersji 1.01</b> - typy rekordw: 2,3,4,5
	\par
	<b>W wersji 1.02</b> - typy rekordw: 2,3
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetPayform(const POSNET_HANDLE phRequest,
															   unsigned short *numer,
															   char *nazwa,
															   unsigned char *typ,
															   char *kwota
															   );

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu patnoci.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	<b>W wersji 1.02</b> - typy rekordw: 4,5
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetPayformEx(const POSNET_HANDLE phRequest,
															   unsigned short *numer,
															   char *nazwa,
															   unsigned char *typ,
															   char *kwota,
															   char *opis,
															   char *kasa,
															   char *kasjer,
															   unsigned short *numer_kasjera
															   );

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu walut.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> wszystkie
	\par
	<b>Kasy:</b> COMBO,NEO
	\par
	<b>W wersji 1.01</b> - typy rekordw: 6,7,8,9
	\par
	<b>W wersji 1.02</b> - typy rekordw: 6,7
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetCurrency(const POSNET_HANDLE phRequest,
																unsigned short *numer,
																char *nazwa,
																char *wartoscPLN,
																char *wartosc,
																char *kurs
																);
/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu walut.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	<b>W wersji 1.02</b> - typy rekordw: 8,9
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetCurrencyEx(const POSNET_HANDLE phRequest,
																unsigned short *numer,
																char *nazwa,
																char *wartoscPLN,
																char *wartosc,
																char *kurs,
																char *opis,
															    char *kasa,
															    char *kasjer,
															    unsigned short *numer_kasjera
																);

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu zestaww - typ rekordu 10-15.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> COMBO,NEO
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetPLUSet(const POSNET_HANDLE phRequest,
															  unsigned char *vat,
															  unsigned short *PLU,
															  char *kod_kreskowy,
															  char *nazwa,
															  char *ilosc,
															  char *wartosc
															  );

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu zestaww - typ rekordu 10-15.

	W zalenoci od konfiguracji ustawionej rozkazem SALEFLDPLUNAMEASPRICECFG w rekordzie
	w polu nazwa_lub_cena pojawi si nazwa (w powyszym flaga 0) lub cena w groszach bez przecinka (w powyszym flaga 1)

	Pozostae parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_v2_SaleRecGetPLUSet(const POSNET_HANDLE phRequest,
															  unsigned char *vat,
															  unsigned short *PLU,
															  char *kod_kreskowy,
															  char *nazwa_lub_cena,
															  char *ilosc,
															  char *wartosc,
															  char *addon
															  );

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu raportu dobowego - typ rekordu 16.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetFiscal(const POSNET_HANDLE phRequest,
															  char *data,
															  unsigned short *numer,
															  unsigned short *paragonow,
															  unsigned short *anulowanych,
															  char *totalizeryAG, // liczby rozdzielone \n
															  char *wart_anulowanych,
															  unsigned long *zmianPLU
															  );
/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu zakoczonego paragonu - typ rekordu 17,19.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetFinished(const POSNET_HANDLE phRequest,
																unsigned long *numer,
																char *data,
																char *kasa,
																char *kasjer,
																unsigned short *numer_kasjera,
																char *wartosc,
																char *do_zaplaty
																);

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych
	\ingroup Kasa_Neo
	Pobranie rekordu zakoczonego paragonu wersja dla kasy NEO - typ rekordu 17,19.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> NEO
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_NEO_SaleRecGetFinished(const POSNET_HANDLE phRequest,
																unsigned long *numer,
																char *data,
																char *kasa,
																char *kasjer,
																unsigned short *numer_kasjera,
																char *wartosc,
																char *do_zaplaty,
																unsigned long *numer_niefiskalny
																);
/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych
	
	Pobranie rekordu zakoczonego paragonu  - typ rekordu 17,19.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO(take 1.01)
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_v2_SaleRecGetFinished(const POSNET_HANDLE phRequest,
																unsigned long *numer,
																char *data,
																char *kasa,
																char *kasjer,
																unsigned short *numer_kasjera,
																char *wartosc,
																char *do_zaplaty,
																unsigned long *numer_niefiskalny
																);

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu anulowanego paragonu - typ rekordu 18,20.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.01 i wczeniejsze
	\par
	<b>Kasy:</b> COMBO,NEO
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetCancelled(const POSNET_HANDLE phRequest,
																 char *data,
																 char *kasa,
																 char *kasjer,
																 unsigned short *numer_kasjera,
																 unsigned short *autoryzujacy,
																 char *wartosc,
																 char *do_zaplaty
																 );
/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu anulowanego paragonu - typ rekordu 18,20.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia
	\par
	<b>Wersja  protokou:</b> 1.02
	\par  
	<b>Kasy:</b> COMBO, NEO
	\par
    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_v2_SaleRecGetCancelled(const POSNET_HANDLE phRequest,
																 char *data,
																 char *kasa,
																 char *kasjer,
																 unsigned short *numer_kasjera,
																 unsigned short *autoryzujacy,
																 char *wartosc,
																 char *do_zaplaty,
																 unsigned long *storna,
																 char *wart_storn
																 );

/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu rabatw bez rabatw MxN (PROMOCJA) - typ rekordu 21,22,23.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetRebate(const POSNET_HANDLE phRequest,
															  char *nazwa,
															  unsigned char *typ,
															  unsigned short *numer,
															  char *kwota,
															  char *karta
															  );
/*! 
	\brief Realizacja rozkazu SALERECGET -  Odsyanie danych z bufora pozycji paragonowych

	Pobranie rekordu rabatw typu MxN (PROMOCJA) - typ rekordu 24.

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia

    Posiada cz nadawcz - \ref POSS_SaleRecGet
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_SaleRecGetRebateMN(const POSNET_HANDLE phRequest,
															  char *nazwa,
															  unsigned short *numer,
															  unsigned short *PLU,
															  unsigned char *stawkaVAT,
															  char *kwota
															  );

/*!
@}
*/



/*!
\defgroup hlapi_context Obsuga kontekstu baz
\ingroup hlapi_global


Rekordy w bazach mona odczytywa albo bezporednio (podajc numer czytanego rekordu) albo
kontekstowo (podajc CNTX_RECORD (warto zero) jako numer rekordu. Kontekst zawiera
numer biecego rekordu (rodzaj wskanika) oraz kryteria okrelajce, ktry rekord bdzie uwaany
za nastpny. Aby odczytywa baz w trybie kontekstowym, naley najpierw zainicjalizowa
kontekst, co powoduje ustawienie wskanika na pocztek bazy. Pniejsze polecenia odczytu
powoduj ustawienie wskanika na kolejny rekord speniajcy zadane kryteria i odczyt rekordu.
Elementy kontekstu:

FLAGA1 \par
Maska bitowa  okrela jaka informacja o rekordzie jest istotna.
  -  bit 0  czy brane pod uwag jest istnienie rekordu. Poniewa wystpuje moliwo wyszukiwania
kontekstowego tylko istniejcych rekordw, warto tego bitu jest ignorowana.
  -  bit 1  czy brane pod uwag s statystyki (0  nie jest wane jakie statystyki posiada rekord, 1  jest
wane jakie statystyki posiada rekord)
  -  bit 2  czy brane pod uwag jest to e rekord jest zestawem  bit dotyczy bazy PLU. (0  nie jest
wane czy rekord jest zestawem, 1  jest wane czy rekord jest zestawem).
  .

FLAGA2 \par
Warto bitowa  okrela jakiej informacji o rekordzie poszukujemy
  -  bit 0  poniewa wystpuje moliwo wyszukiwania kontekstowego tylko istniejcych rekordw,
warto tego bitu jest ignorowana.
  -  bit 1  1  szukane s rekordy z niezerowymi statystykami, 0  szukane s rekordy z zerowymi
statystykami.
  -  bit 2  1  szukane s zestawy, 0  szukane s pojedyncze elementy.
  .

Warto bitowa i suma bitowa mog stanowi sumy logiczne nastpujcych bitw:\n
PF_STAT1 0x02 - czy statystyki niezerowe\n
PF_PLUSET 0x04 - czy jest to zestaw\n

Czyli np. Aby odczytac wszystkie statystyki niezerowe w bazie form patnoci,
wywoujemy CNTXPAYFORMINIT z wartoci bitow 2 i mask bitow 2,
Aby odczyta wszystkie zestawy o zerowych statystykach wywoujemy CNTXPLUINIT z wartoci
bitow 4 i mask bitow 6,
Warto = PF_PLUSET
Maska = PF_PLUSET | PF_STAT1.
Przy odczycie elementw z dowolnymi statystykami w masce bitowej bit 1 powinien mie warto
0, bit 1 w wartoci bitowej przyjmuje warto dowoln.
Aby nastpnie odczytywa kolejne takie zestawy, wywoujemy
PluRead z numerem rekordu rwnym 0, a do zwrcenia bdu DB_ERR_CNTX_END
przez to polecenie.

@{
*/

/*! 
	\brief Realizacja rozkazu CNTXPLUINIT - Inicjalizacja kontekstu bazy PLU

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/



POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxPLUInit(const POSNET_HANDLE hDevice,
														 POSNET_HANDLE *phRequest,
														 const unsigned char flaga1,
														 const unsigned char flaga2,
														 const unsigned char tryb=POSNET_REQMODE_SPOOL
														 );
/*! 
	\brief Realizacja rozkazu CNTXMUINIT - Ustawianie kontekstu dla bazy jednostek miary

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxMUInit(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char flaga1,
														const unsigned char flaga2,
														const unsigned char tryb=POSNET_REQMODE_SPOOL
														);
/*! 
	\brief Realizacja rozkazu CNTXUSERINIT - Ustawianie kontekstu dla bazy kasjerw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxUserInit(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char flaga1,
														  const unsigned char flaga2,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu CNTXPACKINIT - Ustawianie kontekstu dla bazy opakowa

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxPackInit(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char flaga1,
														  const unsigned char flaga2,
														  const unsigned char tryb=POSNET_REQMODE_SPOOL
														  );
/*! 
	\brief Realizacja rozkazu CNTXGROUPINIT - Ustawianie kontekstu dla bazy grup towarowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxGroupInit(const POSNET_HANDLE hDevice,
														   POSNET_HANDLE *phRequest,
														   const unsigned char flaga1,
														   const unsigned char flaga2,
														   const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu CNTXPAYFORMINIT - Ustawianie kontekstu dla bazy form patnoci

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxPayformInit(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned char flaga1,
															 const unsigned char flaga2,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );
/*! 
	\brief Realizacja rozkazu CNTXDISCNTINIT - Ustawianie kontekstu dla bazy rabatw/narzutw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxDiscntInit(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned char flaga1,
															const unsigned char flaga2,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu CNTXCODEFMTINIT - Ustawianie kontekstu dla bazy formatw kodw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxCodeFmtInit(const POSNET_HANDLE hDevice,
															 POSNET_HANDLE *phRequest,
															 const unsigned char flaga1,
															 const unsigned char flaga2,
															 const unsigned char tryb=POSNET_REQMODE_SPOOL
															 );
/*! 
	\brief Realizacja rozkazu CNTXHOTKEYINIT - Ustawianie kontekstu dla bazy klawiszy skrtu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxHotkeyInit(const POSNET_HANDLE hDevice,
															POSNET_HANDLE *phRequest,
															const unsigned char flaga1,
															const unsigned char flaga2,
															const unsigned char tryb=POSNET_REQMODE_SPOOL
															);
/*! 
	\brief Realizacja rozkazu CNTXAUTODISCNTINIT - Ustawianie kontekstu dla bazy rabatw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxAutoDiscntInit(const POSNET_HANDLE hDevice,
																POSNET_HANDLE *phRequest,
																const unsigned char flaga1,
																const unsigned char flaga2,
																const unsigned char tryb=POSNET_REQMODE_SPOOL
																);
/*! 
	\brief Realizacja rozkazu CNTXPACKSHORTAGEINIT - Ustawianie kontekstu do przeszukiwania bazy opakowa po brakach magazynowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxPackShortageInit(const POSNET_HANDLE hDevice,
																  POSNET_HANDLE *phRequest,
																  const unsigned char flaga1,
																  const unsigned char flaga2,
																  const unsigned char tryb=POSNET_REQMODE_SPOOL
																  );
/*! 
	\brief Realizacja rozkazu CNTXPLUSHORTAGEINIT - Ustawianie kontekstu do przeszukiwania bazy PLU po brakach magazynowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxPLUShortageInit(const POSNET_HANDLE hDevice,
																 POSNET_HANDLE *phRequest,
																 const unsigned char flaga1,
																 const unsigned char flaga2,
																 const unsigned char tryb=POSNET_REQMODE_SPOOL
														   );
/*! 
	\brief Realizacja rozkazu CNTXPLUINACTIVEINIT - Ustawianie kontekstu do przeszukiwania bazy PLU po nieaktywnych rekordach

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.

	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxPLUInactiveInit(const POSNET_HANDLE hDevice,
																 POSNET_HANDLE *phRequest,
																 const unsigned char flaga1,
																 const unsigned char flaga2,
																 const char *data,
																 const unsigned char tryb=POSNET_REQMODE_SPOOL
															);

/*! 
	\brief Realizacja rozkazu CNTXCASHOUTDESCINIT - Ustawianie kontekstu dla bazy opisw wypat

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxCashoutDescInit(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char flaga1,
														  const unsigned char flaga2,
														  const unsigned char tryb
														  );
/*! 
	\brief Realizacja rozkazu CNTXERRMSGINIT - Ustawianie kontekstu dla bazy obsugi bdw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxErrMsgInit(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char flaga1,
														  const unsigned char flaga2,
														  const unsigned char tryb
														  );
/*! 
	\brief Realizacja rozkazu CNTXPLUDESCINIT - Ustawianie kontekstu dla bazy opisw towarw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CntxPLUDescInit(const POSNET_HANDLE hDevice,
														  POSNET_HANDLE *phRequest,
														  const unsigned char flaga1,
														  const unsigned char flaga2,
														  const unsigned char tryb
														  );

/*!
@}
*/
/*!
	\defgroup hlapi_cashout Opisy wypat
	\ingroup hlapi_global
	Funkcje zwizane z obsug opisw wypat
*/
/*@{*/

/*! 
	\brief Realizacja rozkazu CASHOUTDESCDEL - Kasowanie rekordu opisu wypaty

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CashoutDescDel(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu CASHOUTDESCDELALL - Kasowanie wsyztkich opisw wypat

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CashoutDescDelAll(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );

/*! 
	\brief Realizacja rozkazu CASHOUTDESCINS - Programowanie rekordu opisu wypaty

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CashoutDescIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const char *nazwa,
														const unsigned char flagi,
														const unsigned char tryb
													 );

/*! 
	\brief Realizacja rozkazu CASHOUTDESCREAD - Odczyt rekordu opisu wypaty

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada czc odbiorcz \ref POSG_CashoutDescRead.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CashoutDescRead(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu CASHOUTDESCNEXTFREEGET - Znajdowanie wolnego rekordu opisw wypaty  poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada czc odbiorcz \ref POSG_CashoutDescNextFreeGet.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_CashoutDescNextFreeGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu CASHOUTDESCNEXTFREEGET - Znajdowanie wolnego rekordu opisw wypaty  poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada czc nadawcz \ref POSS_CashoutDescNextFreeGet.
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_CashoutDescNextFreeGet(const POSNET_HANDLE phRequest,
															unsigned short *wolny_numer
															);
/*! 
	\brief Realizacja rozkazu CASHOUTDESCREAD - Odczyt rekordu opisu wypaty

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada czc nadawcz \ref POSS_CashoutDescRead.
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_CashoutDescRead(const POSNET_HANDLE phRequest,
															unsigned short *numer,
															char *nazwa
															);
															


/*@}*/

/*!
	\defgroup hlapi_errmsg Obsuga bdw
	\ingroup hlapi_global
	Funkcje obsugi bdw
*/
/*@{*/

/*! 
	\brief Realizacja rozkazu ERRMSGDELALL - Kasowanie wszystkich rekordw obsugi bdw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ErrMsgDelAll(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu ERRMSGDEL - Kasowanie rekordu obsugi bdu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ErrMsgDel(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu ERRMSGINS - Programowanie rekordu obsugi bdu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ErrMsgIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_rekordu,
														const unsigned short numer_bledu,
														const unsigned short rodzaj_obslugi,
														const char *komunikat,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu ERRMSGREAD - Odczyt rekordu bazy obsugi bdu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada czc odbiorcz \ref POSG_ErrMsgRead.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ErrMsgRead(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu ERRMSGNEXTFREEGET - Znajdowanie wolnego rekordu obsugi bdu poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada czc odbiorcz \ref POSG_ErrMsgNextFreeGet.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_ErrMsgNextFreeGet(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu ERRMSGNEXTFREEGET - Znajdowanie wolnego rekordu obsugi bdu poczwszy od zadanego numeru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada czc nadawcz \ref POSS_ErrMsgNextFreeGet.
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_ErrMsgNextFreeGet(const POSNET_HANDLE phRequest,
															unsigned short *wolny_numer
															);
/*! 
	\brief Realizacja rozkazu ERRMSGREAD - Odczyt rekordu bazy obsugi bdu

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada czc nadawcz \ref POSS_ErrMsgRead.
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_ErrMsgRead(const POSNET_HANDLE phRequest,
															unsigned short *numer_rekordu,
															unsigned short *numer_bledu,
															unsigned short *rodzaj_obslugi,
															char *komunikat
															);



/*@}*/

/*!
	\defgroup hlapi_pludesc Opisy do towarw
	\ingroup hlapi_global
	Funkcje opisw do towarw
*/
/*@{*/


/*! 
	\brief Realizacja rozkazu PLUDESCDELALL - Kasowanie wszystkich rekordw opisw towarw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUDescDelAll(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu PLUDESCDEL - Kasowanie rekordu bazy opisw towarw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUDescDel(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu PLUDESCINS - Programowanie rekordu opisu towaru

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Nie posiada czci odbiorczej.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUDescIns(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer_rekordu,
														const char *komunikat,
														const unsigned char tryb
													 );
/*! 
	\brief Realizacja rozkazu PLUDESCREAD - Odczyt rekordu bazy opisw towarw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada czc odbiorcz \ref POSG_PLUDescRead.
*/
POSNET_API	POSNET_STATUS	__stdcall	POSS_PLUDescRead(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned short numer,
														const unsigned char tryb
													 );

/*! 
	\brief Realizacja rozkazu PLUDESCREAD - Odczyt rekordu bazy opisw towarw

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbierajca wyniki polecenia.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada czc nadawcz \ref POSS_PLUDescRead.
*/
POSNET_API	POSNET_STATUS __stdcall		POSG_PLUDescRead(const POSNET_HANDLE phRequest,
															unsigned short *numer_rekordu,
															char *komunikat
															);


/*@}*/

/*!
	\defgroup hlapi_stat Odczyt statystyk
	\ingroup hlapi_global
	
*/
/*@{*/

/*! 
	\brief Realizacja rozkazu HOURSSTATREAD - Odczyt statystyk godzinowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz wysyajca polecenie.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz odbiorcz - \ref POSG_HoursStatRead
*/

POSNET_API	POSNET_STATUS	__stdcall	POSS_HoursStatRead(const POSNET_HANDLE hDevice,
														POSNET_HANDLE *phRequest,
														const unsigned char typ,
														const unsigned char tryb
													 );

/*! 
	\brief Realizacja rozkazu HOURSSTATREAD - Odczyt statystyk godzinowych

	Parametry i rezultat standardowe, zgodne z Instrukcj Programisty. 

	Cz odbiorcza.
	\par
	<b>Wersja  protokou:</b> 1.02
	\par
	<b>Kasy:</b> COMBO, NEO
	\par
	Posiada cz nadawcz - \ref POSS_HoursStatRead
*/

POSNET_API	POSNET_STATUS __stdcall		POSG_HoursStatRead(const POSNET_HANDLE phRequest,
															char *wartosci,
															char *pozycje,
															char *ilosci_paragonow
															);


/*@}*/



/*!
	\defgroup Kasa_Neo Kasa NEO
	\ingroup hlapi_global
	Funkcje specyficzne dla kasy NEO
*/
/*@{*/




/*@}*/


}

#endif
