#ifndef _posnetH_
#define _posnetH_

/*

	Nagwek w wersji: 1.0

*/


/*!
	\mainpage Biblioteka interfejsu kasy POSNET COMBO oraz POSNET NEO
	
	Spis Treci

	- \ref sec_intro 
	- \ref sec_flow 
	- \ref sec_async
	  - \ref sec_async_events
	  - \ref sec_async_sale_buffer
	  - \ref sec_modem
	  .
	- \ref sec_example
	- \ref sec_extern
	- \ref linux_port
	.

	<b> Zgodnie z INSTRUKCJ PROGRAMISTY COMBO 1.01, v. 1.6.61.1
	oraz SPECYFIKACJ PROTOKOU KASY POSNET NEO 1.01 v. 006
	oraz SPECYFIKACJ PROTOKOU KAS POSNET NEO 1.02 ORAZ POSNET COMBO 1.02 v.004 </b>

	<hr>

	\section sec_intro	Wprowadzenie

	Podstawowe zaoenia, ktre zostay przyjte przy projektowaniu biblioteki dla
	kasy POSNET COMBO s nastpujce:
	  - komunikacja za porednictwem RS-232, USB (VCP lub DXX), Ethernet
	  - wielowtkowo i wielo-urzdzeniowo biblioteki (brak zmiennych globalnych)
	  - obsuga zdarze asynchronicznych (karta rabatowa)
	  - kolejkowanie rozkazw w celu przyspieszenia wymiany danych
	  - wykorzystanie z rnych jzykw programowania (konwencja wywoa __stdcall zgodna 
		z WINAPI)
	  - minimalna zaleno od systemu operacyjnego w zakresie interfejsu biblioteki -
	    praktycznie tylko 2 funkcja s typowo dedykowane dla Windows - \ref POS_GetEvent
		i \ref POS_SetMessageParams.
	  - interfejs ledzenia (\ref debugging)
	  - natywny port dla systemu Linux
	  .
    
	Ze wzgldu na to, e ilo rozkazw wykorzystywanych w komunikacji z kas jest ogromna
	przy projektowaniu biblioteki zrezygnowano z literalnej realizacji kadego rozkazu
	jako osobnej funkcji. Grupowanie rozkazw w/g rodzaju parametrw take nie jest dobrym
	rozwizaniem. W tej sytuacji zosta zastosowany model "obiektu rozkazowego (Request)",
	wraz z zestawem funkcji umoliwiajcych ustawianie parametrw (\ref req_param). 

	Zastosowanie takiego rozwizania ma dodatkow zalet. Drobne korekty w rozkazach obsugi
	kasy w tym dodanie nowych czy zmiana iloci i rodzaju parametrw nie wymagaj wtedy
	zmian w bibliotece komunikacyjnej, a jedynie dostosowania aplikacji do tych zmian.

	Po wykonaniu takiego obiektu rozkazowego przez kas (por. \ref sec_flow) wyniki 
	dostpne s w analogiczny sposb - przez zestaw funkcji pobierajcych je kolejno
	z obiektu rozkazowego.

	Cztery niezalene kolejki rozkazowe (rozkazy oczekujce, rozkazy wykonane, zdarzenia
	asynchroniczne i pozycje paragonowe) umoliwiaj jednoczenie du swobod przy 
	tworzeniu aplikacji klienckiej zostawiajc znaczn swobod wybory sposobu obsugi kasy
	jej twrcy.

	\section sec_flow	Przepyw informacji

	W aplikacji istniej 4 kolejki rozkazowe, pomidzy ktrymi nastpuje przepyw danych 
	jak w grafie poniej.
	\dot
	digraph flow {
		node [shape=record, fontname=Helvetica, fontsize=8];
		K0 [label="Kolejka rozkazowa"  shape="ellipse" ]
		K1 [label="Kolejka wynikow"  shape="ellipse" ]
		K2 [label="Kolejka asynchroniczna"  shape="ellipse" ]
		K3 [label="Bufor paragonowy" shape="ellipse" ]
		NOWY -> OCZEKUJACY [label="POS_PostRequest" fontname=Helvetica fontsize=8];
		OCZEKUJACY -> K0;
		K0 -> WYSLANY [label="transmisja do kasy" fontname=Helvetica fontsize=8];
		WYSLANY -> POTWIERDZONY [label="sekwencja zlozona" fontname=Helvetica fontsize=8];
		WYSLANY -> ZAKONCZONY [label="sekwencja prosta\n lub blad" fontname=Helvetica fontsize=8];
		POTWIERDZONY -> ZAKONCZONY [label="sekwencja zlozona" fontname=Helvetica fontsize=8];
		ZAKONCZONY -> K1 [label="Rozkaz" fontname=Helvetica fontsize=8]
		ZAKONCZONY -> K2 [label="Asychroniczny" fontname=Helvetica fontsize=8]
		ZAKONCZONY -> K3 [label="Paragonowy" fontname=Helvetica fontsize=8]
	}
	\enddot

	Cao transmisji obsugiwana jest przez dwa niezalene wtki, jeden transmisyjny,
	drugi odbiorczy operujce na odpowiednich kolejkach rozkazw.

	\section sec_async	Zdarzenia asynchroniczne i bufor paragonowy

	\subsection sec_async_events Zdarzenia asynchroniczne

	Kasa POSNET COMBO posiada moliwo generacji pewnych
	zdarze w sposb asynchroniczny w stosunku do wykonywanych polece
	wydawanych przez nadzorujc j aplikacj sterujco-magazynow.
	
	Do obsugi zdarze w tym trybie zosta przygotowany zestaw funkcji
	opisany w module \ref event_handling. Przychodzce zdarzenia asynchroniczne 
	gromadzone s w osobnej kolejce zdarze, w ktrej oczekuj na obsug.
	Aplikacja gwna moe zostac powiadomiona o przyjciu nowego zdarzenia
	za pomoc:
	  - zdarzenia IPC typu "Event" systemu Windows,
	  - komunikatu Windows wysanego do wskazanego okna aplikacji
	
	Aplikacja moe te cyklicznie sprawdza, czy w kolejce znajduj si nowe
	zdarzenia asynchroniczne (polling).

	\subsection sec_async_sale_buffer	Bufor pozycji paragonowych

	Aby uproci obsug pozycji paragonowych tak, aby nie kolidowaa z gwn kolejk
	zdarze i w efekcie moga by obsugiwana za porednictwem osobnego watku aplikacji
	zostaa stworzona osobna kolejka zdarze zbierajca wyniki polece czytajcych
	pozycje paragonowe patrz \ref sale_buffer.

	W ten sposb wtek odbioru danych paragonowych moe wysya zapytania o pozycje
	paragonowe w standadowy sposb (do gwnej kolejki rozkazw). Gwna kolejka
	rozkazw do wysania moe rwnolegle otrzymywa rozkazy przygotowywane przez rne 
	wtki (jest w peni wielowtkowa), serializowa je i wysyac w kolejnoci otrzymania
	do kasy.

	Odpowiedzi s natomiast rozdzielane od siebie i trafiaj do dwch osobnych
	kolejek odbiorczych. W kolejce pozycji paragonowych umieszczane s wycznie
	wyniki wysyanych rozkazw dotyczcych pozycji paragonowych.

	Mog to by wasciwe pozycje paragonowe lub informacje o bdach wykonania
	tych rozkazw.

	\section sec_modem Obsuga modemu
	Obsuga modemu w bibliotece COMBO/NEO jest realizowana poprzez trzy 
	dodatkowe funkcje biblioteczne oraz trzy dodatkowe parametry 
	dla urzdzenia typu RS232. Umoliwia realizacj zarwno pocze 
	wychodzcych (wybieranie numeru telefonu) jak i przyjmowanie 
	pocze przychodzcych (odbieranie telefonu). Stanowi ona integraln 
	cz urzdzenia typu RS232.

	Aby wczy tryb modemowy naley ustawi parametr urzdzenia 
	RS232  POSNET_DEV_PARAM_MODEMMODE na warto 1. Po wykonaniu tej 
	czynnoci urzdzenie nie bdzie wykonywao zleconych polece do 
	momentu nawizania poczenia modemowego. Urzdzenie jest take 
	gotowe do przyjmowania pocze przychodzcych. W przypadku 
	pojawienia si sygnau RING na modemie zostanie automatycznie odebrana rozmowa.

	UWAGA: W trybie odbioru rozmowy nie ma moliwoci ustawienia modemu cigiem 
	inicjujcym bezporednio (tryb zaczyna si pasywnie)  mona to jednak 
	zrobi za porednictwem polecenia dzwonienia bez ustawiania numeru 
	telefonu (polecenie to zakoczy si bdem POSNET_STATUS_MODEM_BADDIAL) ale 
	wyle do modemu cig inicjujcy.

	Dla urzdzenia modemowego mona ustawi dwa cigi:
	  - cig inicjujcy modem wraz z pocztkowym cigiem AT np. AT&S0=0  parametr POSNET_DEV_PARAM_MODEMINIT
	  - cig dzwonienia wraz z pocztkowym ATD np. ATDT022123456789  parametr POSNET_DEV_PARAM_MODEMDIAL

	Urzdzenie modemowe NIGDY samo nie wybiera numeru i nie ponawia 
	przerwanych pocze  ta operacja pozostawiona jest w gestii aplikacji 
	zarzdzajcej kasami.

	Do obsugi trybu modemowego su nastpujce funkcje
	  - Do wykonania poczenia suy funkcja: \ref POS_ModemDial , ktra wymaga dwch parametrw  uchwytu globalnego urzdzenia (nie uchwytu widoku lokalnego) oraz flagi wait oczekiwania na wykonanie poczenia (0  nie czekaj, 1  czekaj na zakoczenie operacji). W przypadku wyboru trybu bez oczekiwania postp procesu mona monitorowa z wykorzystaniem funkcji POS_ModemStatus  poprawne poczenie jest sygnalizowane statusem POSNET_STATUS_MODEM_CONNECTED.
	  - Do rozczenia trwajcego poczenia suy funkcja: \ref POS_ModemDisconnect , ktra przyjmuje takie same parametry jak polecenie dzwonienia i wykonuje procedur rozczania poczenia,
	  - Do sprawdzania biecego statusu modemu suy funkcja: \ref POS_ModemStatus , ktra zwraca zestaw flag zalenych od aktualnego stanu poczenia modemowego:

	Przykad uycia  patrz demo demo_modem.exe.


	\section sec_example	Przykadowa sekwencja polece

	Obsuga kasy wymaga wykonania pewnego zestawu standardowych
	operacji. Poniszy opis przedstawia jedn z moliwoci na
	przykadzie polecenia DSPPARAMGET. Przykad jest w jzyku C++,
	pominito obsug sytuacji wyjtkowych.

	\code
	// Deklaracje zmiennych
	POSNET_HANDLE hDevice;
	POSNET_HANDLE hGlobalDevice;
	POSNET_HANDLE hRequest;

	// Wyniki
	unsigned char kontrast;
	unsigned char podswietlenie;
	unsigned char tryb;

	// Utworzenie obiektu urzdzenia
	hGlobalDevice = POS_CreateDeviceHandle(POSNET_INTERFACE_RS232);

	// Ustawienie parametrw urzdzenia
	POS_SetDeviceParam(hGlobalDevice, POSNET_DEV_PARAM_COMSETTINGS,"COM1,19200,8,N,1,H");

	// Otwarcie urzdzenia
	hDevice = POS_OpenDevice(hGlobalDevice);

	// Przygotowanie polecenia
	// Numer polecenia DSPPARAMGET = 101
	hRequest = POS_CreateRequest(hDevice,POSNET_CMDID_DSPPARAMGET);

	// Przygotowanie parametrw polecenia
	// Pobierz dane dla wywietlacza operatora
	// Wymagany 1 paramter typu 'B' o wartoci 0
	POS_PushRequestParamByte(hRequest,0);

	// Wylij rozkaz do kasy w trybie interaktywnym
	POS_PostRequest(hRequest,POSNET_REQMODE_IMMEDIATE);

	// Oczekuj na wykonanie
	POS_WaitForRequestCompleted(hRequest,INFINITE);

	// Sprawd czy zakoczyo si sukcesem
	if (POS_GetRequestStatus(hRequest) == POSNET_STATUS_OK)
	{
		// Pobranie wynikw, polecenie zwraca 3 wartoci typu byte
		unsigned char kontrast,podswietlenie,tryb;
		POS_PopResponseValueByte(hRequest,&kontrast);
		POS_PopResponseValueByte(hRequest,&podswietlenie);
		POS_PopResponseValueByte(hRequest,&tryb);
	}

	// Usu stworzone zapytanie
	POS_DestroyRequest(hRequest);

	// Zamknij urzdzenie
	POS_CloseDevice(hDevice);

	\endcode

	\section sec_extern	Wykorzystanie w jzykach programowania

	W wersji prototypowej biblioteka zostaa przetestowana w:
	  - VisualC++ .NET 2003
	  - Borland C++ Builder 4
	  - Delphi 7
	  - Visual Basic for Applications (MS Excel)
	  - Ch  (<a href='http://www.softintegration.com'>http://www.softintegration.com</a>)
	
	Poniej przedstawiono przykadowy kod dla VBA.
	\verbatim
	Private Declare Function POS_PopSalesQueue Lib "posnet.dll" (ByVal H As Long, ByVal P As Long) As Long
	\endverbatim

	Podobny kod dla Delphi 7

	\verbatim
	function POS_PopSalesQueue (hDevice : THandle; k: longint) : THandle; stdcall; external 'posnet.dll'
	\endverbatim

	\section linux_port Wersja dla systemu Linux

	Natywny port dla systemu Linux skada si z bibliotek:

	libposnet.so.1.0

	libhlapi.so.1.0

	oraz 

	libptypes.so.2.0.2 (http://www.melikyan.com/ptypes/)

	Biblioteki te s zalene take od dostpnych na licencji LGPL bibliotek obsugujcych
	podsystem USB:

	libusb - w wersji 0.1.11+ dostpnej standardowo w wikszoci dystrybucji
	(http://libusb.sourceforge.net/)

	oraz 

	libftdi w wersji 0.7+ (http://www.intra2net.com/de/produkte/opensource/ftdi/index.php)
	do obsugi konwertera FTDI zastosowanego w urzdzeniu.

	UWAGA!!!  W przypadku korzystania z trybu natywnego USB (POSNET_INTERFACE_USB)
	do poprawnego dziaania kasy niezbdne jest zablokowanie automatycznego adowania
	i usunicie jesli jest zaadowany moduu jdra ftdi_sio. W przeciwnym razie poczenie z kas nie bdzie
	moliwe (w pliku logu zgaszany bdzie bd o kodzie -5), gdy modu ten przejmuje kontrol nad konwerterem
	FTDI tworzc wirtualny port szeregowy (/dev/ttyUSBx).

	W przypadku korzystania w trybie wirtualnego portu szeregowego, sterownik ftdi_sio jest potrzebny.
*/


/*!
	\ingroup global_defs
	\brief	Standardowy sposb obsugi bibliotek DLL
*/
/* Patch dla Borland C++ Builder'a */
#ifdef __WIN32__
#define WIN32 
#endif

#ifdef WIN32
#ifdef POSNET_EXPORTS
#define POSNET_API  __declspec(dllexport)	
#else
#define POSNET_API  __declspec(dllimport)	
#endif
#else
#define POSNET_API
#define __stdcall
#define __cdecl
#endif

extern "C"
{

	/*!
		\defgroup	global_defs Definicje globalne
		@{
		
	*/
	/*!
	\brief Definicja typu uchwytu urzdzenia.
	*/
	typedef  void*					POSNET_HANDLE;
	/*!
	\brief Definicja typu wartoci zwracanej jako status.
	*/
	typedef	 unsigned long			POSNET_STATUS;
	/*!
	\brief Definicja typu wartoci zwracanej jako stan rozkazu.
	*/
	typedef	 unsigned long			POSNET_STATE;
	/*!
	\brief Definicja typu wartoci reprezentujcej kod polecenia.
	*/
	typedef	 unsigned short			POSNET_CMD;
	/*!
	\brief Definicja typu wartoci reprezentujcej typ danych w polach DATA.
	*/
	typedef	 unsigned long			POSNET_DATA_TYPE;

	/*!
	\brief	Pobierz wersj biblioteki

	\return	Wersja jako liczba 32 bitowa. Liczba ta skada si z trzech czci. Najstarsze 8 bitw to gwny
	 numer wersji, nastpne 8 to podrzdny numer wersji, oststanie 16 bitw to numer kompilacji.
	*/

	POSNET_API unsigned long __stdcall POS_GetLibraryVersion();


	/*!
		@}
	*/


	/*!
		\defgroup	data_types	Typy danych pl DATA
		\ingroup	sync_api
		
		\sa POS_GetResponseValueType
		@{
	*/
	
	#define	POSNET_DATATYPE_STRING		'S' //!< Cig znakw
	#define POSNET_DATATYPE_BYTE		'B'	//!< Liczba cakowita 1 bajtowa
	#define POSNET_DATATYPE_WORD		'V'	//!< Liczba cakowita 2 bajtowa
	#define POSNET_DATATYPE_LONG		'L'	//!< Liczba cakowita 4 bajtowa
	#define POSNET_DATATYPE_QUANTITY	'Q'	//!< Typ ilociowy (nie wykorzystywany w obecnej wersji kasy)
	#define POSNET_DATATYPE_CURRENCY	'K'	//!< Typ walutowy (nie wykorzystywany w obecnej wersji kasy)
	#define POSNET_DATATYPE_NUMERIC		'N'	//!< Typ numeryczny
	#define POSNET_DATATYPE_INVALID		'*'	//!< Typ niewaciwy/bd


	/*!
		@}
	*/

	/*! \defgroup debug_level	Poziomy informacyjnoci
		\ingroup debugging
	@{
	*/
	#define	POSNET_DEBUG_NONE				0x00000000  //!< Brak rejestrowania informacji.
	#define POSNET_DEBUG_ALL				0xFFFFFFFF	//!< Rejestracja wszystkich informacji we wszystkich podsystemach
	#define POSNET_SUBSYSTEM_DEVICE			0x00001000	//!< Podsystem urzdzenia
	#define POSNET_SUBSYSTEM_DEVICERS232	0x00002000  //!< Podsystem RS232
	#define POSNET_SUBSYSTEM_DEVICEETHER	0x00004000  //!< Podstsystem Ethernet
	#define	POSNET_SUBSYSTEM_DEVICEUSB		0x00008000  //!< Podsystem USB (uywa sterownika D2XX, w przypadku korzystania ze
														//!< sterownika VCP naley korzysta z trybu RS232
	#define	POSNET_SUBSYSTEM_FRAME			0x00010000  //!< Podsystem ramki - wywietla zawarto wysyanych i odbieranych ramek
														//!< w formacie hexadecymalnym - moliwo konwersji na posta binarn doczonym konwerterem
	#define POSNET_DEBUG_EXTRA				0x00800000  //!< Rejestracja szczegowych informacji o stanach rozkazw
	/*!
	@}
	*/

	/*!
		\defgroup	debugging	Ustawienie poziomu ledzenia (informacyjnoci) biblioteki
		@{
	*/

	/*!
		\brief Ustaw poziom informacyjnoci biblioteki.

		System debuggingu opiera si na tzw. "podsystemach".\n
		Definicje POSNET_DEBUG_SUBSYSTEM_* definiuj te podsystemy.\n
		S one maskami bitowymi, ktre zsumowane (OR) daja moliwo 
		jednoczesnego rejestrowania przepywu danych w rznych podsystemach.\n
		4 najmodsze bity definiuj poziom iloci wysyanych danych (stae
		POSNET_DEBUG_LEVEL_*).
		
		Ustawienie poziomu debuggingu na warto rn od 0 powoduje otwarcie
		aktualnie wybranego pliku (domylnie "POS_DBG.txt", mona ustawi przy
		wykorzystaniu \ref POS_SetDebugFileName . W pliku tym zostan zapisane
		odpowiednie informacje umoliwiajce ledzenie wykonania kodu biblioteki.
		Ponowne ustawienie poziomu debuggingu zamyka plik ledzcy.
		
		Maksymalna ilo podsystemw okrelona zostaa na 28.
		\param hGlobalDevice	Uchwyt stworzonego poczenia z urzdzeniem
		\param debugLevel	Okrelenie poziomu ledzenia
	*/
	POSNET_API	void	__stdcall POS_SetDebugLevel(POSNET_HANDLE hGlobalDevice, unsigned long debugLevel);
	/*!
		\brief	Ustawienie nazwy pliku ledzcego.

		Funkcja umoliwia zmian domylnego pliku ledzcego.
		\param hGlobalDevice	Uchwyt stworzonego poczenia z urzdzeniem
		\param fileName nowa nazwa pliku
	*/
	POSNET_API  void	__stdcall POS_SetDebugFileName(POSNET_HANDLE hGlobalDevice, const char *fileName);

	/*!
		@}
	*/



	/*! 
	*	\addtogroup dev_types Rodzaje interfejsu urzdzenia
		\ingroup basic_api

		@{
	*/

	/*!
		\brief	Podczenie przez RS232
	*/
	#define POSNET_INTERFACE_RS232	0x0001	
	/*!
		\brief	Podczenie przez USB

		Podczenie przez  USB moe by wykonane na dwa sposoby:
		-  korzystajc ze sterownika FTDI VCP (Virtual ComPort), gdzie tworzony jest dodatkowy, virtualny port szeregowy (odpowiednik RS232),
		w tym przypadku naley korzysta z trybu RS232.
		-  przy wykorzystaniu sterownika D2XX, korzysta si z trybu USB. Naley w tym przypadku poda zaprogramowany w interfejsie numer seryjny
		kasy.
		.

	*/
	#define POSNET_INTERFACE_USB	0x0002
	/*!
		\brief	Podczenie przez Ethernet

		Biblioteka, dla urzdze sieciowych w systemie Windows nie wywouje WSA_Startup. Obowizek inicjalizacji podsystemu
		Winsock spoczywa na aplikacji wykorzystujcej bibliotek. Brak inicjalizacji podsystemu Winsock objawia si bdem w logach
		biblioteki: DEVICE_Ether: Socket Error (1)- 10093. 
	*/
	#define POSNET_INTERFACE_ETH	0x0003
	/*! @}

	*/


	/*!
		\defgroup dev_params	Identyfikatory parametrw urzdzenia
		\ingroup basic_api
		@{
	*/
	
	/*!
		\brief	Parametry portu szeregowego

		TYLKO ZAPIS
		
		Parametry portu przekazuje si jako cig znakw w formacie
		port,baud rate,bits,parity,stopbits,flowcontrol np. "COM1,9600,8,N,1,H"
		Flowcontrol: (N)one, (S)oftware XON/XOFF, (H)ardware RTS/CTS
	*/
	#define	POSNET_DEV_PARAM_COMSETTINGS	0x00020001

	/*!
		\brief Tryb obsugi cigw znakw

		TYLKO ZAPIS

		Sposb traktowania cigw znakw jako wartoci zwracanych przez funkcje - 
		dopuszczalne s dwie moliwoci:

		  - \ref POSNET_STRINGMODE_PREDEF - aplikacja zna maksymalne dugoci 
			buforw na podstawie dokumentacji kasy
		  - \ref POSNET_STRINGMODE_INTELLIGENT aplikacja kliencka definiuje swj bufor 
			o dugoci N i w jego pierwszym znaku przekazuje liczb okrelajc 
			dugo cigu. Funkcje zwracajce cigi znakw sprawdzaj w tym trybie 
			dugo przekazanego cigu i w przypadku braku miejsca dziaaj nastpujco: 
			jako status zwracaj \ref POSNET_STATUS_BUFFERTOOSHORT i we wszystkich 
			otrzymanych buforach ustawiaj wymagane dugoci. Mona te w ten 
			sposb uzyska informacj o wymaganych dugociach buforw  wystarczy 
			przekaza bufory z ustawion dugoci 0.
		  


	*/
	#define POSNET_DEV_PARAM_STRINGHANDLING		0x00020002

	/*!
		\brief Separator czsci dziesitnej

		TYLKO ZAPIS

		W obecnej wersji kasy, w zwizku z nieobsugiwaniem typw danych QUANTITY i CURRENCY
		parametr jest ignorowany.

		Parametr - wskanik na 1 znak
	
	*/
	#define POSNET_DEV_PARAM_DECIMALSEPARATOR	0x00020003
	/*!
		\brief Czas w [s] po jakim ma by zaniechane wysyanie ramki

		TYLKO ZAPIS

		Parametr - wskanik na wartoc long
	*/
	#define POSNET_DEV_PARAM_SENDTIMEOUT		0x00020004

	/*!
		\brief Adres IP kasy dla urzdzenia typu \ref POSNET_INTERFACE_ETH

		TYLKO ZAPIS

		Parametr - wskanik na cig znakw jzyka C (zakoczony 0) zawierajcy adres IP.
	*/
	#define POSNET_DEV_PARAM_IP					0x00020005
	/*!
		\brief Port dla protokou TCP/IP dla urzdzenia typu \ref POSNET_INTERFACE_ETH

		TYLKO ZAPIS

		Parametr - wskanik na cig znakw jzyka C (zakoczony 0) zawierajcy numer portu.
	*/
	#define POSNET_DEV_PARAM_IPPORT				0x00020006

	/*!
		\brief Numer seryjny kasy do otwarcia przez typ urzdzenia \ref POSNET_INTERFACE_USB
		
		TYLKO ZAPIS

		Parametr - wskanik na cig znakw jzyka C (zakoczony 0) zawierajcy numer seryjny.

	*/
	#define POSNET_DEV_PARAM_USBSERIAL			0x00020007

	/*!

		\brief Odczyt wszystkich numerw seryjnych kas podczonych do komputera poprzez interfejs USB i sterownik
				FTDI - D2XX

		TYLKO ODCZYT

		Parametr - bufor na numery seryjne rozdzielone znakiem koca linii - 
					(kady numer ma max. 8znakw+2 bajty - koniec linii = 10 bajtw * max. 127 urzdze na USB = 1270)
					w zwizku z tym zalecany jest rozmiar bufora wikszy lub rwny 1271 znakw.

	*/

	#define POSNET_DEV_PARAM_LISTUSBSERIALS		0x00020008

	/*!

	\brief Dugo kolejki wysykowej, po przekroczeniu, ktrej rozkazy traktowane s jak wysyane w trybie natychmiastowym.

	TYLKO ZAPIS

	Parametr - wskanik na liczb typu unsigned long (32 bit) zawierajc dan dugo kolejki wysykowej.

	*/

	#define POSNET_DEV_PARAM_OUTQUEUELENGTH		0x00020009

	/*

	\brief Sterowanie auto synchronizacj polece zoonych. Kontroluje automatyczne oczekiwanie na zakoczenie
			polece zoonych. Domylnie biblioteka samodzielnie odczytuje status polece zoonych i oczekuje na ich zakoczenie.
			Jeli program samodzielnie chce weryfikowa ich przebieg, naley ten mechanizm wyczy.

	TYLKO ZAPIS

	Parametr - wskanik na warto typu unsigned char. 0 - synchronizuj, inna warto nie synchronizuj
	*/

	#define POSNET_DEV_PARAM_NOSYNC				0x0002000A

	/*

	\brief	Wczenie/Wyczenie trybu modemowego urzadzenia typu RS232. Wsppraca z modemem ma nastpujce
		wymagania: 1. modem musi byc podczony penym kablem RS232 i musi poprawnie obsugiwa sygnay DCD (Data Carrier Detect)
		dla detekcji aktywnego poczenia, oraz DTR (Data Termina Ready)- w celu poprawnego rozczania pocze telefonicznych.
		UWAGA 1: Poczenia modemowe NIE s automatycznie nawizywane i ponawiane w przypadku zerwania - to zadanie naley
		do aplikacji korzystajcej z biblioteki (ponowne dzwonienie nie wymaga zamknicia i otwarcia urzdzenia) - to podejcie
		ma na celu przekazanie kontroli nad generujcymi koszty poczeniami telefonicznymi na wyszy poziom (do aplikacji
		zarzdzajcej kasami).
		UWAGA 2: Tryb modemowy wymusza sprztowy handshake bez wzgldu na ustawienia cigu inicjujcego parametry portu RS232

	ZAPIS I ODCZYT

	Parametr: wskanik na warto typu unsigned char. 0 - tryb wyczony, 1 - tryb wczony
	*/
	#define POSNET_DEV_PARAM_MODEMMODE				0x0002000B

	/*!
		\brief Cig inicjujcy modem (wraz z pocztkowym AT)
		
		TYLKO ZAPIS

		Parametr - wskanik na cig znakw jzyka C (zakoczony 0).

	*/
	#define POSNET_DEV_PARAM_MODEMINIT				0x0002000C

	/*!
		\brief Cig dzwonienia z numerem telefonicznym (wraz z pocztkowym ATD)- numer podany bez przedrostka trybu wybierania P (impulsowe) lub T (tonowe) zostanie wybrany 
		w trybie zalenym od aktualnie zaprogramowanego w modemie, lub ustawionego cigiem inicjujcym. (por. komendy AT modemowe
		polecenie ATD ).
		
		TYLKO ZAPIS

		Parametr - wskanik na cig znakw jzyka C (zakoczony 0).

	*/
	#define POSNET_DEV_PARAM_MODEMDIAL				0x0002000D


	/*!
		@}
	*/

	/*!
		\defgroup	string_handling Tryby obsugi buforw znakowych w API wysokiego poziomu
		\ingroup dev_params

		\sa POSNET_DEV_PARAM_STRINGHANDLING
		@{
	*/
	#define POSNET_STRINGMODE_PREDEF 0x00
	#define POSNET_STRINGMODE_INTELLIGENT 0x01


	/*!
		@}
	*/


	/*!
		\defgroup	basic_api	Obsuga podstawowa urzdzenia
		@{
	*/

	/*!
		\brief	Utworzenie uchwytu do nowego urzdzenia kasowego. 
		
		Tworzy odpowiedni obiekt i ustawia
		niebdne jego waciwoci, ale fizycznie go nie otwiera. Przed otwarciem urzdzenia 
		naley ustawi niebdne parametry, ktre s rzne w zalenoci od typu urzdzenia.
		\param	deviceType	Typ podczonego urzdzenia \ref dev_types "Typy podczenia"
		\return Uchwyt globalny utworzonego urzdzenia. Wartoc NULL zostanie zwrcona wycznie
				w przypadku braku pamici lub podania bdnego typu urzdzenia.
	*/
	POSNET_API POSNET_HANDLE	__stdcall POS_CreateDeviceHandle(unsigned long deviceType);

	/*!
		\brief	Otwrz urzdzenie.
		
		\param hGlobalDevice	Uchwyt globalny urzadzenia do otwarcia.
		\return Zwraca uchwyt lokalny do urzdzenia w kontekcie biecego wtku. NULL w przypadku bdu,
				kod bdu mona odczyta funkcj POS_GetError
	*/
	POSNET_API POSNET_HANDLE	__stdcall POS_OpenDevice(POSNET_HANDLE hGlobalDevice);		  
	/*!
		\brief	Zamknij urzdzenie. 
		
		Zamyka urzadzenie wskazywane przez uchwyt. Usuwa zawartoci kolejek
		komunikacyjnych. Wszytskie dane naley odczyta przed zamkniciem urzdzenia.

		\param hLocalDevice	Uchwyt urzadzenia do zamknicia.
	*/
	POSNET_API POSNET_STATUS	__stdcall POS_CloseDevice(POSNET_HANDLE hLocalDevice);
	/*!
		\brief	Usu istniejcy uchwyt urzdzenia i zwolnij zajmowan pami.

		Ostatecznie usuwa obiekt komunikacyjny i zwalnia pami.

		\param hGlobalDevice	Uchwyt globalny urzdzenia do usunicia. Wszystkie wtki musz najpierw zamkn urzadzenie,
								w przeciwnym wypadku funkcja zwrci bd POSNET_STATUS_BUSY.
	*/
	POSNET_API POSNET_STATUS	__stdcall POS_DestroyDeviceHandle(POSNET_HANDLE hGlobalDevice); 
	/*!
		\brief	Funkcja do ustawiania parametrw urzdzenia

		\param hDevice Uchwyt urzdzenia - zarwno lokalny jak i globalny
		\param paramCode Kod parametru por. \ref dev_params kody parametrw
		\param paramValue Wskanik lub warto parametru. Opis przy parametrach urzdzenia.

	*/
	POSNET_API POSNET_STATUS	__stdcall POS_SetDeviceParam(POSNET_HANDLE hDevice, unsigned long paramCode,void *paramValue);	
	/*!
		\brief	Funkcja do pobierania parametrw urzdzenia

		\param hDevice Uchwyt urzdzenia - zarwno lokalny jak i globalny
		\param paramCode Kod parametru por. \ref dev_params kody parametrw
		\param paramValue Wskanik lub warto parametru. Opis przy parametrach urzdzenia.

	*/
	POSNET_API POSNET_STATUS	__stdcall POS_GetDeviceParam(POSNET_HANDLE hDevice, unsigned long paramCode,void *paramValue);	


	/*!
		\brief	Funkcja suy do nawizania poczenia modemowego. Procedura rozpoczyna proces nawizywania poczenia
		modemowego.

		\param hGlobalDevice Uchwyt globalny urzadzenia typu RS232
		\param wait	Flaga oczekiwania na wykonanie polecenia - 0 - nie oczekuj, 1 - oczekuj, poniewa czas wykonania poczenia modemowego
		moe osiga nawet ponad minut dla aplikacji wsppracujcej z bibliotek wskazane moe by samodzielne sprawdzenie statusu
		dzwonienia funkcj POS_ModemStatus

		\return Status wykonania polecenia
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_ModemDial(POSNET_HANDLE hGlobalDevice,int wait);

	/*!
		\brief	Funkcja suzy do rozczenia poczenia modemowego. Procedura rozpoczyna proces zamykania poczenia
		modemowego.

		\param hGlobalDevice Uchwyt globalny urzadzenia typu RS232
		\param wait	Flaga oczekiwania na wykonanie polecenia - 0 - nie oczekuj, 1 - oczekuj, chocia czas rozczenia poczenia modemowego
		jest do krtki to dla spnoci ze sposobem obsugi poczenia dostepne s oba tryby pracy

		\return Status wykonania polecenia
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_ModemDisconnect(POSNET_HANDLE hGlobalDevice,int wait);

	/*!
		\brief	Funkcja suzy do sprawdzenia stanu poczenia modemowego. 

		\param hGlobalDevice Uchwyt globalny urzadzenia typu RS232

		\return Status poczenia modemowego POSNET_STATUS_MODEM_xxx
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_ModemStatus(POSNET_HANDLE hGlobalDevice);

	/*!
		\brief Funkcja umoliwia zapis cigu znakw bezporednio do portu szeregowego (modemu), do wykorzystania
		wycznie w trybie wczonego modemu

		\param hGlobalDevice Uchwyt globalny urzadzenia typu RS232
		\param buffer Cig znakw do wysania do modemu

		\return Status wykonania rozkazu
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_ModemWrite(POSNET_HANDLE hGlobalDevice,const char *buffer);

	/*!
		@}
	*/

	/*! \defgroup error_codes	Kody bdw biblioteki
		\ingroup	error_handling

		\brief	Kody bdw biblioteki. Biblioteka moe zwraca kody
				bdw zarwno wasne jak i kody bezporednio uzyskane
				z kasy.
		@{
	*/
	
	#define POSNET_STATUS_OK						0x00000000 //!< Brak bdu
	#define POSNET_STATUS_OUTOFMEMORY				0x00000001 //!< Brak pamici
	#define POSNET_STATUS_FRAMETOOSHORT				0x00000002 //!< Za krtka ramka
	#define POSNET_STATUS_FRAMINGERROR				0x00000003 //!< Bd ramki odebranej z kasy
	#define POSNET_STATUS_COULDNOTOPEN				0x00000005 //!< Nie mona otworzyc wskazanego urzdzenia
	#define POSNET_STATUS_CRCERROR					0x00000006 //!< Bd CRC w odebranej ramce
	#define POSNET_STATUS_IPCERROR					0x00000007 //!< Bd utworzenia obiektu IPC (Event)
	#define POSNET_STATUS_COMMERROR					0x00000008 //!< Bd komunikacji
	#define POSNET_STATUS_USBERROR					0x00000009 //!< Bd krytyczny USB - urzdzenie nie bdzie funkcjonowa poprawnie
	#define POSNET_STATUS_FTLIBIMPORTFAIL			0x0000000A //!< Nieudany import sterownika FTDI
	#define POSNET_STATUS_COULDNOTSETUPPORT			0x0000000B //!< Bd ustawienia parametrw otwieranego portu
	#define POSNET_STATUS_COULDNOTOPEN_ACCESSDENIED 0x0000000C //!< Bd otwarcia urzdzenia - dostp zabroniony
	#define POSNET_STATUS_COULDNOTOPEN_FILENOTFOUND 0x0000000D //!< Bd otwarcia urzdzenia - brak takiego pliku (urzdzenia)
	#define POSNET_STATUS_SETUP_INVALIDBAUD			0x0000000E //!< Bdne parametry portu - baudrate
	#define POSNET_STATUS_SETUP_INVALIDDATA			0x0000000F //!< Bdne parametry portu - databits
	#define POSNET_STATUS_SETUP_INVALIDPARITY		0x00000010 //!< Bdne parametry portu - parity
	#define POSNET_STATUS_SETUP_INVALIDSTOP			0x00000011 //!< Bdne parametry portu - stop bits
	#define POSNET_STATUS_SETUP_INVALIDHANDSHAKE	0x00000012 //!< Bdne parametry portu - handshake
	#define POSNET_STATUS_INVALIDSTATE				0x00000013 //!< Wydano polecenie REPEAT dla ramki znajdujcej si w niewaciwym stanie (innym ni SENT lub ACK)
	#define POSNET_STATUS_DEVICE_BUSY				0x00000014 //!< Urzdzenie zajte

	#define	POSNET_STATUS_BUSY					0x00000020 //!< Urzdzenie zajte
	#define	POSNET_STATUS_BUSY_LEVER			0x00000021 //!< Urzdzenie zajte - podniesiona dwignia
	#define	POSNET_STATUS_BUSY_MECHANISM		0x00000022 //!< Urzdzenie zajte - bd mechanizmu
	#define	POSNET_STATUS_BUSY_COVER			0x00000023 //!< Urzdzenie zajte - podniesiona pokrywa
	#define	POSNET_STATUS_BUSY_PAPER			0x00000024 //!< Urzdzenie zajte - brak papieru
	#define	POSNET_STATUS_BUSY_TEMP				0x00000025 //!< Urzdzenie zajte - zbyt wysoka temperatura
	#define	POSNET_STATUS_BUSY_POWER			0x00000026 //!< Urzdzenie zajte - chwilowy zanik zasilania
	#define	POSNET_STATUS_BUSY_CUTTER			0x00000027 //!< Urzdzenie zajte - bd obcinacza

	#define POSNET_STATUS_ALREADY_COMPLETED		0x00010000 //!< Rozkaz ju wykonany \sa POS_CancelRequest
	#define POSNET_STATUS_EMPTY					0x00010001 //!< Brak danych w kolejce
	#define	POSNET_STATUS_INVALIDVALUE			0x00010002 //!< Bdna warto
	#define	POSNET_STATUS_TIMEOUT				0x00010003 //!< Oczekiwanie zakoczone upyniciem czasu (timeout)
	#define	POSNET_STATUS_PENDING				0x00010004 //!< Polecenie w trakcie wykonywania
	#define POSNET_STATUS_INVALIDCOMMAND		0x00010005 //!< Bdny numer polecenia
	#define POSNET_STATUS_INVALIDHANDLE			0x00010006 //!< Bdny uchwyt
	#define POSNET_STATUS_BUFFERTOOSHORT		0x00010007 //!< Przekazany bufor znakowy jest za may
	#define POSNET_STATUS_OUTOFRANGE			0x00010008 //!< Poza zakresem licznika
	#define POSNET_STATUS_INVALIDSPOOLMODE		0x00010009 //!< Bdny tryb kolejkowania
	#define POSNET_STATUS_CANCELLED				0x0001000A //!< Rozkaz anulowany

	#define POSNET_STATUS_COULDNOTOPEN_WSAEINTR  		0x00000030 //!< Bd sieciowy - przerwane wywoanie systemowe
	#define POSNET_STATUS_COULDNOTOPEN_WSAEACCES 		0x00000031 //!< Bd sieciowy - brak dostpu
	#define POSNET_STATUS_COULDNOTOPEN_WSAEINPROGRESS 	0x00000032 //!< Bd sieciowy - operacja w toku
	#define POSNET_STATUS_COULDNOTOPEN_WSAEDESTADDRREQ  0x00000033 //!< Bd sieciowy - wymagany adres docelowy
	#define POSNET_STATUS_COULDNOTOPEN_WSAEADDRINUSE 	0x00000034 //!< Bd sieciowy - adres w uyciu
	#define POSNET_STATUS_COULDNOTOPEN_WSAEADDRNOTAVAIL	0x00000035 //!< Bd sieciowy - adres nieprawidowy
	#define POSNET_STATUS_COULDNOTOPEN_WSAENETDOWN 		0x00000036 //!< Bd sieciowy - sie jest wyczona
	#define POSNET_STATUS_COULDNOTOPEN_WSAENETUNREACH 	0x00000037 //!< Bd sieciowy - sie jest nieosigalna
	#define POSNET_STATUS_COULDNOTOPEN_WSAENETRESET 	0x00000038 //!< Bd sieciowy - sie rozczya poczenie
	#define POSNET_STATUS_COULDNOTOPEN_WSAECONNABORTED  0x00000039 //!< Bd sieciowy - poczenie zerwane przez aplikacj
	#define POSNET_STATUS_COULDNOTOPEN_WSAECONNRESET 	0x0000003A //!< Bd sieciowy - strona zdalna zerwaa poczenie
	#define POSNET_STATUS_COULDNOTOPEN_WSAETIMEDOUT 	0x0000003B //!< Bd sieciowy - upyn czas oczekiwania na odpowied
	#define POSNET_STATUS_COULDNOTOPEN_WSAECONNREFUSED 	0x0000003c //!< Bd sieciowy - poczenie odrzucone
	#define POSNET_STATUS_COULDNOTOPEN_WSAEHOSTDOWN  	0x0000003d //!< Bd sieciowy - serwer zdalny jest wyczony
	#define POSNET_STATUS_COULDNOTOPEN_WSAEHOSTUNREACH 	0x0000003e //!< Bd sieciowy - serwer zdalny jest nieosigalny
	#define POSNET_STATUS_COULDNOTOPEN_WSAHOSTNOTFOUND 	0x0000003f //!< Bd sieciowy - serwer nieznaleziony
	#define POSNET_STATUS_COULDNOTOPEN_WSATRYAGAIN  	0x00000040 //!< Bd sieciowy - serwer nieznaleziony, sprbuj ponownie

	#define POSNET_STATUS_MODEM_NOTSUPPORTED		0x00000060	//!< Modem nie obsugiwany - urzdzenie nie jest RS232 lub ma nie aktywny tryb modemowy
	#define POSNET_STATUS_MODEM_ONHOOK				0x00000061	//!< Status modemu - na widekach (rozczony)
	#define POSNET_STATUS_MODEM_DIALING				0x00000062  //!< Status modemu - w trakcie nawizywania poczenia
	#define POSNET_STATUS_MODEM_DISCONNECTING		0x00000063  //!< Status modemu - w trakcie rozczania
	#define POSNET_STATUS_MODEM_CONNECTED			0x00000064  //!< Status modemu - poczony
	#define POSNET_STATUS_MODEM_ANSWERING			0x00000065	//!< Status modemu - trwa odbieranie poczenia
	#define	POSNET_STATUS_MODEM_BUSY				0x00000066  //!< Prba wykonania poczenia przy zajetym modemie
	#define POSNET_STATUS_MODEM_NOTCONNECTED		0x00000067  //!< Prba rozczenia nie poczonego modemu
	#define	POSNET_STATUS_MODEM_NODIALTONE			0x00000068	//!< Status poczenia - brak tonu centrali
	#define POSNET_STATUS_MODEM_NOCARRIER			0x00000069  //!< Status poczenia - nie powiodo si
	#define POSNET_STATUS_MODEM_OTHERERROR			0x0000006A	//!< Status poczenia - inny bd
	#define POSNET_STATUS_MODEM_BADINIT				0x0000006B	//!< Status poczenia - modem nie zaakceptowa ciagu inicjujcego
	#define POSNET_STATUS_MODEM_BADDIAL				0x0000006C	//!< Status poczenia - modem nie zaakceptowa komendy poczenia
	#define POSNET_STATUS_MODEM_NOMODEM				0x0000006D  //!< Status poczenia - brak odpowiedzi modemu na polecenia AT
	#define POSNET_STATUS_MODEM_CONNECTIONLOST		0x0000006E	//!< Status poczenia - przerwane
	#define POSNET_STATUS_MODEM_ERRORONDISCONNECT	0x0000006F	//!< Status poczenia - nie udao si rozczy poczenia (modem nie odpowiada)
	

	#define POSNET_STATUS_INVALID_PARAM1		0x00010101 //!< Bdny 1 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM2		0x00010102 //!< Bdny 2 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM3		0x00010103 //!< Bdny 3 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM4		0x00010104 //!< Bdny 4 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM5		0x00010105 //!< Bdny 5 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM6		0x00010106 //!< Bdny 6 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM7		0x00010107 //!< Bdny 7 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM8		0x00010108 //!< Bdny 8 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM9		0x00010109 //!< Bdny 9 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM10		0x0001010A //!< Bdny 10 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM11		0x0001010B //!< Bdny 11 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM12		0x0001010C //!< Bdny 12 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM13		0x0001010D //!< Bdny 13 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM14		0x0001010E //!< Bdny 14 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM15		0x0001010F //!< Bdny 15 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM16		0x00010110 //!< Bdny 16 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM17		0x00010111 //!< Bdny 17 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM18		0x00010112 //!< Bdny 18 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM19		0x00010113 //!< Bdny 19 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM20		0x00010114 //!< Bdny 20 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM21		0x00010115 //!< Bdny 21 parametr polecenia
	#define POSNET_STATUS_INVALID_PARAM22		0x00010116 //!< Bdny 22 parametr polecenia

	#define	POSNET_STATUS_CASHREGBASE			0x00430000 //!< Bazowy kod bdu wykonania rozkazu kasy [bdy 0x00430000 - 0x0043FFFF]
	#define	POSNET_STATUS_CASHREGCOMMBASE		0x00440000 //!< Bazowy kod bdu transmisji rozkazu do kasy [bdy 0x00440000 - 0x0044FFFF]
	/*!
		@}
	*/


	/*!
		\defgroup	error_handling	Obsuga bdw
		@{
	*/

	/*!
		\brief	Podaj kod statusu zwizany z uchwytem urzdzenia
		
		Zwraca ostatnio ustawiony kod statusu zwizany z uchwytem urzdzenia. 
		Kada wywoywana funkcja oprcz zwrcenia tej wartoci jako wyniku dziaania
		(o ile nie zwraca innego rodzaju rezultatu)	ustawia wewntrzny znacznik bdu. 
		\param hLocalDevice Uchwyt lokalny urzdzenia lub uchwyt globalny urzdzenia.
		\return Kod statusu patrz \ref error_codes Kody bdw.
	*/
	POSNET_API POSNET_STATUS	__stdcall POS_GetError(POSNET_HANDLE hLocalDevice);	
	/*!
		\brief	Zwr tekstowy opis bdu

		Funkcja zwraca tekstowy opis bdu zrozumiay dla uytkownika / programisty.
		Komunikat moe by zwrcony we wskazanym jzyku (o ile przygotowano
		niezbdny plik jzykowy). W przeciwnym wypadku komunikat zwracany jest
		w domylnym jzyku biblioteki. 

		<em>UWAGA:</em> W systemie Linux pliki z tekstowymi opisami kodw bdw (pliki jzykowe
		o nazwach w postaci posnet_xx.lng mog by umieszczone w katalogu, z ktrego
		uruchomiono program (nie zalecane) lub w miejscu wskazywanym przez zmienn
		rodowiskow POSNET_LIB_SHARE_DIR (zalecane).
		W systemie WINDOWS katalog wskazany w POSNET_LIB_SHARE_DIR musi by zakoczony 
		znakiem \ rozdzielajcym katalogi np. POSNET_LIB_SHARE_DIR=c:\myapp\bin\

		\param code	Kod bdu do wyjanienia
		\param lang	2 znakowy kod jzyka wg ISO-3166
		\return Cig znakw opisujcych zdarzenia (C-string) zakoczony znakiem 0. Cig ten zwracany
				jest z wewntrznego bufora. Nie wolno go zwalnia funkcjami allokacji pamici.
	*/
	POSNET_API const char *			__stdcall POS_GetErrorString(POSNET_STATUS code, char *lang);
	/*!
		\brief	Zwr status rozkazu

		\return Funkcja zwraca kod bdu zwizany z rozkazem. W przypadku odebrania odpowiedzi o bdzie 
				wykonania rozkazu zwracane s kody odebrane od kasy, s one take dostpne w polach rezultatu
				komendy w postaci zgodnej z Instrukcj Programisty.
				Kody o wartociach 0x00000000-0x0042FFFF su do przekazywania stanu rozkazu w ramach biblioteki.
				Kody o wartociach 0x00430000-0x0043FFFF wykorzystywane s w przypadku negatywnej odpowiedzi kasy na rozkaz, po jego zakoczeniu w wyniku bdu kasy  kod bdu kasy zwikszony jest o warto 0x00430000.
				Kody o wartociach 0x00440000-0x0044FFFF wykorzystywane s w przypadku negatywnej odpowiedzi kasy na rozkaz, po jego zakoczeniu w wyniku bdu transmisji  kod bdu transmisji zwikszony jest o warto 0x00440000.
		\sa sync_api "Obsuga synchroniczna kasy"
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_GetRequestStatus(POSNET_HANDLE hRequest);
	/*!
		@}
	*/



	// --------------------------------------------------------------------------------------------------------
	/*! \defgroup event_types Typy zdarze
		\ingroup	event_handling
		@{
	*/
	/*!
		\brief	Wyczenie obsugi zdarze asynchronicznych - w tym trybie
		wszystkie zdarzenia s automatycznie usuwane, a aplikacja nie jest
		o nich informowana.
	*/
	#define POSNET_EVENT_DISABLE	0x0000
#ifdef _WIN32
	/*!
		\brief	Sygnalizacja otrzymania zdarzenia za pomoc komunikacji midzyprocesowej
		typu "Event" (zdarzenie) w systemie Windows.
		Po wybraniu tego typu obsugi za pomoc funkcji \ref POS_GetEvent mona
		uzyska uchwyt zdarzenia zarezerwowanego przez urzdzenie. 

		Tylko dla WIN32
	*/
	#define POSNET_EVENT_EVENT		0x0001
	/*!
		\brief	Sygnalizacja otrzymania zdarzenia za pomoc komunikatw systemu Windows.
		Po wybraniu tego trybu naley za pomoc funkcji \ref POS_SetMessageParams
		ustawi kod komunikatu i uchwyt okna do ktrego ma on by wysany. Wysyany
		komunikat ma jako lParam umieszczony uchwyt urzdzenia, ktre go wygenerowao.

		Tylko dla WIN32
	*/
	#define	POSNET_EVENT_MESSAGE	0x0002
#else
	/*!
		\brief Sygnalizacja otzrymania zdarzenia za pomoca semafora pthread

		Tylko dla Linux
	*/	
	#define POSNET_EVENT_SEMAPHORE	0x0005

#endif
	/*!
		\brief	Tryb obsugi poprzez odpytywanie. System gromadzi otrzymywane zdarzenia
		asynchroniczne i oczekuje, e aplikacja bdzie w sposb regularny sprawdza, 
		czy jest zdarzenie oczekujce. 

		\warning Kolejka komunikatw ma ograniczon dugo. Istnieje moliwo ustawienia 
		iloci zapamitywanych komunikatw za pomoc funkcji \ref POS_SetDeviceParam .
	*/
	#define POSNET_EVENT_POLLING	0x0003

	/*!
		\brief	Tryb obsugi poprzez wywoanie funkcji w momencie otrzymania
		pakietu danych asynchronicznych.
	*/
	#define POSNET_EVENT_CALLBACK	0x0004
	/*! 
		@}
	*/

	/*!
		\defgroup	event_handling	Obsuga zdarze asynchronicznych
		@{
	*/


	/*!
		\brief Ustaw metod obsugi zdarze asynchronicznych

		Kasa ma moliwo generacji zdarze asynchronicznych, ktre musz by przesane do aplikacji. 
		Przykadowym zdarzeniem jest obsuga karty rabatowej w trakcie sprzeday. 
		Tego typu zdarzenia mona przesa do aplikacji w nastpujcy sposb:
		- za pomoc IPC typu "Event"
		- za pomoc komunikatw systemu Windows (Windows Messages)
		- za pomoc systemu pollingu, gdzie aplikacja odpytuje bufor zdarze asynchronicznych
		
		Funkcja suy to ustawienia trybu sygnalizacji zdarze.
		\param hLocalDevice	Uchwyt lokalny urzdzenia. Funkcja pomimo pobierania uchwytu lokalnego ma zasig
				globalny dla urzdzenia.
		\param eventMode Typ sygnalizacji zdarze definiowany przez \ref event_types "Typy zdarze"
		\return Status wykonania funkcji (POSNET_STATUS_OK w przypadku sukcesu)
	*/
	POSNET_API POSNET_STATUS	__stdcall POS_SetEventHandlingMode(POSNET_HANDLE hLocalDevice, unsigned long eventMode);
#ifdef _WIN32
	/*!
		\brief	Funkcja ustawia kod komunikatu i uchwyt okna do ktrego ma by on wysany
				przy obsudze zdarze asynchronicznych. Tylko dla Windows.
		\param hLocalDevice	Uchwyt lokalny urzdzenia. Funkcja pomimo pobierania uchwytu lokalnego ma zasig
				globalny dla urzdzenia.
		\param	messageCode	Kod komunikatu (WM_xxxx)
		\param	hWnd	Uchwyt okna

		Tylko dla WIN32
	*/
	POSNET_API POSNET_STATUS	__stdcall POS_SetMessageParams(POSNET_HANDLE hLocalDevice, UINT messageCode, HANDLE hWnd);
	/*!
		\brief	Funkcja zwraca uchwyt do zdarzenia. Obiekt zdarzenia jest zarzdzany przez
				bibliotek. Zdarzenie pracuje w trybie Manual Reset 
				patrz \sa http://msdn.microsoft.com/library/default.asp?url=/library/en-us/dllproc/base/createevent.asp MSDN.
		\param hLocalDevice	Uchwyt lokalny urzdzenia. Funkcja pomimo pobierania uchwytu lokalnego ma zasig
				globalny dla urzdzenia.
		\return	NULL w przypadku bdu, w przeciwnym przypadku uchwyt zdarzenia (Event).

		Tylko dla WIN32
	*/
	POSNET_API HANDLE			__stdcall POS_GetEvent(POSNET_HANDLE hLocalDevice);
#else
	/*!
		\brief Pobranie semafora synchronizujcego wtki pthread (typ sem_t)
		\param hLocalDevice Uchwyt lokalny urzdzenia. Funkcja pomimo pobierania uchwytu lokalnego ma zasig
				globalny dla urzdzenia.
		\return NULL w przypadku bdu, w przeciwnym wypadku wskanik na semafor.

		Tylko dla Linux
	*/
	POSNET_API void * __stdcall POS_GetSemaphore(POSNET_HANDLE hLocalDevice);

#endif
	/*!
		\brief Typ definiujcy funkcj callback dla zdarze asynchronicznych. Przyjmuje jeden parametr
		- uchwyt do odebranych danych (hRequest). Funkcja MUSI usun orzymany obiekt wyniku.
	*/
	typedef void (POSNET_CALLBACK_T)(POSNET_HANDLE handle);

	/*!
		\brief Funkcja ustawia w bibliotece funkcj callback, ktra bdzie wywoywana po otrzymaniu zdarzenia asynchronicznego.
		\param hLocalDevice Uchwyt lokalny urzdzenia. Funkcja pomimo pobierania uchwytu lokalnego ma zasig
				globalny dla urzdzenia.
		\param callback wskanik na funkcj typu callback.
	*/
	POSNET_API POSNET_STATUS	__stdcall POS_SetCallback(POSNET_HANDLE hLocalDevice, POSNET_CALLBACK_T *callback);

	/*!
		@}
	*/
	// --------------------------------------------------------------------------------------------------------


	/* MAIN COMMAND API */

	/*!
		\defgroup	req_modes	Tryby wysyania rozkazw
		\ingroup sync_api
		@{
	*/

	#define	POSNET_REQMODE_SPOOL	0x00 //!< Tryb kolejkowania [domylny], w tym trybie rozkaz umieszczany jest na 
										 //!< kocu kolejki rozkazw do wysania, za wyjtkiem nastpujcych komend,
										 //!< ktre ze swej natury umieszczane s na samym pocztku kolejki:
										 //!< MANUALDISCNTPCSET, DBDISCNTPCSET, WAITSTATUSGET, SEQSTATUSGET, CMPLXSEQSTOP
	#define POSNET_REQMODE_IMMEDIATE 0x01 //!< Tryb bezporedni. Podobny do \ref POSNET_REQMODE_SPOOL kolejkowania, lecz
										  //!< w przypadku, gdy w kolejce s ju jakie rozkazy zwraca bd.
	#define	POSNET_REQMODE_SPOOLSPECIAL	0x02 //!< Tryb kolejkowania specjalnego, w ktrym
											 //!< w kolejce odbiorczej odpowied OK (brak bdu)
											 //!< na rozkaz nie zwracajcy wyniku zostanie automatycznie
											 //!< usunita z kolejki odbiorczej. Ten tryb musi by uywany 
											 //!< jedynie w trybie odbioru z kolejki odbiorczej (nie wolno
											 //!< stosowa \ref POS_WaitForRequestCompleted POS_WaitForRequestCompleted, gdy
											 //!< nie ma gwarancji poprawnoci uchwytu urzdzenia.
	#define POSNET_REQMODE_AUTOCLEAR 0x03 //!< Ten tryb powoduje automatyczne czyszczenie odpowiedzi,
										  //!< bez wzgldu na kod powrotu. W momencie wysania rozkazu w tym trybie naley uzna,
										  //!< e uchwyt rozkazu jest bdny.

	/*!
		@}
	*/
	
	/*!
		\defgroup	req_states	Stany rozkazu
		\ingroup sync_api
		@{
	*/

	#define POSNET_RSTATE_NEW			0x00019000	//!< Nowe polecenie, nie umieszczone w kolejce
	#define POSNET_RSTATE_PENDING		0x00019001	//!< Nowe polecenie, umieszczone w kolejce
	#define POSNET_RSTATE_SENT			0x00019002	//!< Polecenie wysane, nie potwierdzone
	#define POSNET_RSTATE_ACK			0x00019003	//!< Polecenie wysane, zoone, potwierdzone
	#define	POSNET_RSTATE_COMPLETED		0x00019004	//!< Wykonanie rozkazu zakoczone
	#define	POSNET_RSTATE_ERRCOMPLETED	0x00019005	//!< Wykonanie rozkazu zakoczone bdem
	/*!
		@}
	*/


	// --------------------------------------------------------------------------------------------------------


	/*!
		\defgroup	request_base	Obsuga obiektw rozkazowych
		\ingroup sync_api

		@{
	*/

	/*!
		\brief	Funkcja tworzy nowy obiekt rozkazowy dla kasy.

		Funkcja tworzy obiekt rozkazowy dla kasy. Obiekt tego typu jest podstawow
		komrk transmisyjn pomidzy aplikacj a kas. Jego zadaniem jest realizacja
		pojedynczej transakcji kasa-aplikacja.

		Wicej informacji we wprowadzeniu - \ref sec_flow "Przepyw informacji" 

		\param	hLocalDevice	Uchwyt lokalny urzdzenia
		\param	command	Identyfikator rozkazu dla kasy
		\return	Zwracany jest uchwyt do nowego obiektu rozkazowego lub NULL w przypadku bdu
	*/
	POSNET_API	POSNET_HANDLE	 __stdcall POS_CreateRequest(POSNET_HANDLE hLocalDevice, POSNET_CMD	command);
	/*!
		\brief Funkcja suy do pobrania uchwytu urzdzenia zwizanego z rozkazem

		\param hRequest	Uchwyt rozkazu
		\return uchwyt lokalny urzdzenia lub NULL w przypadku bdu lub dla rozkazw odesanych przez kas (karta rabatowa),
				gdy nie mona ustali adresata rozkazu.
	*/
	POSNET_API POSNET_HANDLE	__stdcall POS_RequestDevice(POSNET_HANDLE hRequest);

	/*!
		\brief	Fukcja umieszcza obiekt rozkazowy w kolejce rozkazw do wykonania.

		Istniej dwa warianty wysyania rozkazw 
		  - tryb kolejkowania,
		  - tryb bezporedni.
		
		W trybie kolejkowania nowy rozkaz jest umieszczany w kolejce do wysania do kasy i
		automatycznie wysyany w miar zwalniania si bufora kasy. 
		\warning Dugoc kolejki jest ograniczona. Po jej przekroczeniu rozkazy traktowane s 
				 jakby byy wysyane w trybie bezporednim.
	   
	    Tryb bezporedni kontroluje, czy kasa jest wolna i dopiero gdy jest wolna umoliwia
		umieszczenie rozkazu w buforze. W ten sposb w danej chwili do kasy wysany jest 
		co najwyej 1 rozkaz.

		\param	hRequest	Uchwyt rozkazu
		\param	mode		Wybr trybu wysyania rozkazu \ref req_modes "Tryby wysyania rozkazw"
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PostRequest(POSNET_HANDLE hRequest,unsigned char mode);
	/*!
		\brief	Anulowanie obiektu rozkazowego

		Funkcja anuluje wykonanie rozkazu. W zalenoci od stanu rozkazu moe to oznacza:
		  - jeli rozkaz nie zosta jeszcze wysany zostaje on usunity z kolejki rozkazw,
		  - jeli rozkaz zosta wysany do kasy i jest to rozkaz zoony, ktry zosta potwierdzony
		    to nastpuje prba anulowania poprzez komend CMPLSEQSTOP, po sukcesie anulowania
			zostaje on usunity z kolejki rozkazw,
		  - jeli rozkaz by ju wykonany to nic nie jest wykonywane i zostaje zwrcony
			kod bdu \ref POSNET_STATUS_ALREADY_COMPLETED .

		W kadym przypadku za zniszczenie obiektu odpowiada aplikacja - naley dla anulowanego rozkazu
		wywoa \ref POS_DestroyRequest .

		\param hRequest	Uchwyt rozkazu
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_CancelRequest(POSNET_HANDLE hRequest);
	/*!
		\brief	Zniszczenie obiektu rozkazowego i zwolnienie zajmowanej przeze pamici.

		Funkcja kasuje obiekt rozkazowy oraz wszystkie powizane z nim dane.
		Musi by uyta dla kadego rozkazu allokowanego poprzez \ref POS_CreateRequest POS_CreateRequest 
		ktry nie jest automatycznie usuwany w ytybach SPOOLSPECIAL i AUTOCLEAR.

		\param hRequest	Uchwyt rozkazu
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_DestroyRequest(POSNET_HANDLE hRequest);

	/*!
		\brief	Wiek rozkazu - czas jaki upyn od wywoania \ref POS_PostRequest

		Funkcja ta ma na celu ustalenie wieku rozkazu i moe by przydatna w obsudze
		sytuacji nadzwyczajnych. Czas podawany jest w milisekundach.

		\param hRequest	Uchwyt rozkazu
	*/
	POSNET_API	unsigned long	__stdcall POS_GetRequestAge(POSNET_HANDLE hRequest);
	/*!
		\brief	Pobierz numer polecenia, ktry zosta uyty przy tworzeniu obiektu

		\param hRequest	Uchwyt rozkazu
		\return Numer rozkazu lub \ref POSNET_STATUS_INVALIDCOMMAND w przypadku bdu
	*/
	POSNET_API	unsigned long	__stdcall POS_GetRequestCommandID(POSNET_HANDLE hRequest);
	/*!
		\brief	Pobierz numer seryjny rozkazu

		\param hRequest	Uchwyt urzdzenia
		\return Numer seryjny rozkazu
	*/
	POSNET_API	unsigned long	__stdcall POS_GetRequestCommandSerial(POSNET_HANDLE hRequest);
	/*!
		\brief	Zwr stan rozkazu

		Funkcja zwraca stan w jakim aktualnie znajduje si rozkaz.
		Wicej informacji we wprowadzeniu - \ref sec_flow "Przepyw informacji" 

		\param hRequest	Uchwyt rozkazu
	*/
	POSNET_API	POSNET_STATE	__stdcall POS_GetRequestState(POSNET_HANDLE hRequest);
	/*!
		\brief	Czekaj na zakoczenie rozkazu

		Funkcja powoduje zatrzymanie (upienie) woajcej j aplikacji do momentu
		zmiany stanu rozkazu na \ref POSNET_RSTATE_COMPLETED lub POSNET_RSTATE_ERRCOMPLETED lub upynicia czasu
		wskazanego przez parametr timeout.
 
		\param hRequest	Uchwyt rozkazu
		\param	timeout Czas w ms na jaki ma aplikacja by upiona. 0 oznacza natychmiastowy 
				powrt
		\return	zwraca POSNET_STATUS_OK jeli rozkaz zosta juz ukoczony lub POSNET_STATUS_TIMEOUT 
				jeli rozkaz nie zdy si zakoczy we wskazanym czasie.
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_WaitForRequestCompleted(POSNET_HANDLE hRequest,unsigned long timeout);

	/*!
		@}
	*/

	// --------------------------------------------------------------------------------------------------------

	/*!
		\defgroup req_param	Obsuga parametrw rozkazu
		\ingroup sync_api

		\brief  W zalenoci od typu rozkazu moe on posiada odpowiedni
				ilo parametrw. Parametry te (w instrukcji programisty
				opisywane jako DATAxx) odkadane s na list parametrw
				za pomoc kolejnych wywoa funkcji POS_PushRequestParamXXXXX.
		@{
	*/

	/*!
		\brief	Wstaw parametr typu "Cig znakowy"
		\param	hRequest	Uchwyt rozkazu
		\param	param		Cig znakw w konwencji jzyka C (zakoczony znakiem 0)
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PushRequestParamString(POSNET_HANDLE hRequest,char *param);
	/*!
		\brief	Wstaw parametr typu liczba cakowita o zakresie 1 bajtowym (0 - 255) (znak)
		\param	hRequest	Uchwyt rozkazu
		\param	param		Warto 1 bajtowa
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PushRequestParamByte(POSNET_HANDLE hRequest,unsigned char param);
	/*!
		\brief	Wstaw parametr typu liczba cakowita o zakresie 2 bajtowym (0 - 65535)
		\param	hRequest	Uchwyt rozkazu
		\param	param		Warto 2 bajtowa
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PushRequestParamWord(POSNET_HANDLE hRequest,unsigned short param);
	/*!
		\brief	Wstaw parametr typu liczba cakowita o zakresie 4 bajtowym (0 - 2^32-1)
		\param	hRequest	Uchwyt rozkazu
		\param	param		Warto 4 bajtowa
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PushRequestParamLong(POSNET_HANDLE hRequest,unsigned long param);
	/*!
		\brief	Wstaw parametr typu ilociowego - 2 miejsca po przecinku [typ Q w/g instrukcji programisty]
		
		W przeciwiestwie do sposobu reprezentacji liczb w protokole kasy biblioteka wymienia si z aplikacj
		reprezentacj tekstow liczb [tzw. Decimal String]. Biblioteka wewntrznie tumaczy otrzymany cig
		znakw na waciwy format liczby stosujc jednoczenie technik "ucinania" bez zaokrglania orzymanej
		wartoci. Na aplikacji spoczywa obowizek dostarczenia licz w wymaganej precyzji (iloci miejsc po
		przecinku).
		
		Biblioteka akceptuje ciagi znakw zawierajce kropk "." lub "," jako separator czci dziesitnej.
		Biblioteka nie akceptuje stosowania separatora tysicy.

		\warning W obecnej wersji kasa COMBO nie wykorzystuje tego typu.

		\param	hRequest	Uchwyt rozkazu
		\param	param		Cig znakw bdcy reprezentacj tekstow liczby
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PushRequestParamQuantity(POSNET_HANDLE hRequest,char *param);
	/*!
		\brief Wstaw parametr typu walutowego podawany w "groszach" - najmniejszej jednostce waluty

		\warning W obecnej wersji kasa COMBO nie wykorzystuje tego typu.

		\param	hRequest	Uchwyt rozkazu
		\param	param		Cig znakw bdcy reprezentacj tekstow liczby

		\sa POS_PushRequestParamQuantity
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PushRequestParamCurrency(POSNET_HANDLE hRequest,char *param); 
	/*!
		\brief Wstaw parametr typu numerycznego

		\param	hRequest	Uchwyt rozkazu
		\param	param		Cig znakw bdcy reprezentacj tekstow liczby, bez miejsc dziesitnych. Ilo
							miejsc dziesitnych wynika bezporednio z dokumentacji kasy (Instrukcja Programisty)
							i jest zalena od polecenia.

		\sa POS_PushRequestParamQuantity
		*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PushRequestParamNumeric(POSNET_HANDLE hRequest,char *param); 

	/*!
		@}
	*/
	// --------------------------------------------------------------------------------------------------------

	/*!
		\defgroup	response_handling	Analiza pl odpowiedzi
		\ingroup sync_api

		@{
	*/
	/*!
		\brief	Pobierz ilo otrzymanych pl wartoci

		Funkcja zwraca ilo pl DATA otrzymanych w odpowiedzi na rozkaz. Poprawna tylko
		wtedy, gdy sam rozkaz jest w stanie \ref POSNET_RSTATE_COMPLETED

		\param hRequest	Uchwyt zapytania/odpowiedzi
		\return Ilo otrzymanych pl odpowiedzi lub -1 w przypadku bdu
	*/
	POSNET_API	long			__stdcall POS_GetResponseValueCount(POSNET_HANDLE hRequest);
	/*!
		\brief	Jaki jest typ nastpnego parametru DATA

		\param	hRequest	Uchwyt zapytania/odpowiedzi
		\return	Typ danych aktualnego pola lub POSNET_STATUS_INVALIDVALUE w przypadku bdu (wycznie bdny uchwyt hRequest)
				lub gdy nastpne pole jest niedostpne (poprzednie byo ostatnim).
	*/
	POSNET_API	POSNET_DATA_TYPE	__stdcall POS_GetResponseValueType(POSNET_HANDLE hRequest);
	/*!
		\brief	Pobierz wato typu "cigu znakw" i przesu na nastpne pole

		\param	hRequest	Uchwyt zapytania/odpowiedzi
		\param  retVal Wskanik do bufora znakowego, w ktrym funkcja umieci odebrany cig znakw. Aplikacja musi zapewni odpowiedni
						pojemno bufora, ktr przekazuje w parametrze retValLen. W przypadku zbyt krtkiego
						bufora zostanie zwrcony bd \ref POSNET_STATUS_BUFFERTOOSHORT
		\param	retValLen	Dugo bufora
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PopResponseValueString(POSNET_HANDLE hRequest, char * retVal, unsigned long retValLen);
	/*!
		\brief	Pobierz wato typu liczba 1 bajtowa i przesu na nastpne pole

		\param	hRequest	Uchwyt zapytania/odpowiedzi
		\param  retVal	Wskanik do zmiennej, w ktrej zostanie umieszczona odczytana warto
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PopResponseValueByte(POSNET_HANDLE hRequest,unsigned char *retVal);
	/*!
		\brief	Pobierz wato typu liczba 2 bajtowa i przesu na nastpne pole

		\param	hRequest	Uchwyt zapytania/odpowiedzi
		\param  retVal	Wskanik do zmiennej, w ktrej zostanie umieszczona odczytana warto
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PopResponseValueWord(POSNET_HANDLE hRequest,unsigned short *retVal);
	/*!
		\brief	Pobierz wato typu liczba 4 bajtowa i przesu na nastpne pole

		\param	hRequest	Uchwyt zapytania/odpowiedzi
		\param  retVal	Wskanik do zmiennej, w ktrej zostanie umieszczona odczytana warto
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_PopResponseValueLong(POSNET_HANDLE hRequest,unsigned long *retVal);
	/*!
		\brief	Pobierz wato typu "ilociowego" w jej reprezentacji jako cig znakw i przesu na nastpne pole

		\warning	Separator czci dziesitnej moe by ustawiony za pomoc funkcji \ref POS_SetDeviceParam
					Domylnym separatorem jest separator systemowy (ustawienia regionalne Windows).

		\param	hRequest	Uchwyt zapytania/odpowiedzi
		\param  retVal Wskanik do bufora znakowego, w ktrym funkcja umieci odebrany cig znakw. Aplikacja musi zapewni odpowiedni
						pojemno bufora. W przypadku zbyt krtkiego
						bufora zostanie zwrcony bd \ref POSNET_STATUS_BUFFERTOOSHORT
		\param	retValLen	Dugo bufora

	*/
	POSNET_API	POSNET_STATUS		__stdcall POS_PopResponseValueQuantity(POSNET_HANDLE hRequest,char *retVal, unsigned long retValLen);
	/*!
		\brief	Pobierz wato typu "walutowego" w jej reprezentacji jako cig znakw w najmniejszej jednostce waluty i przesu na nastpne pole

		\param	hRequest	Uchwyt zapytania/odpowiedzi
		\param  retVal Wskanik do bufora znakowego, w ktrym funkcja umieci odebrany cig znakw. Aplikacja musi zapewni odpowiedni
				pojemno bufora.  W przypadku zbyt krtkiego
						bufora zostanie zwrcony bd \ref POSNET_STATUS_BUFFERTOOSHORT
		\param	retValLen	Dugo bufora
	*/
	POSNET_API	POSNET_STATUS		__stdcall POS_PopResponseValueCurrency(POSNET_HANDLE hRequest, char *retVal, unsigned long retValLen);
	/*!
		\brief	Pobierz wato typu "numerycznego" w jej reprezentacji jako cig znakw i przesu na nastpne pole

		\param	hRequest	Uchwyt zapytania/odpowiedzi
		\param  retVal Wskanik do bufora znakowego, w ktrym funkcja umieci odebrany cig znakw. Aplikacja musi zapewni odpowiedni
						pojemno bufora.  W przypadku zbyt krtkiego
						bufora zostanie zwrcony bd \ref POSNET_STATUS_BUFFERTOOSHORT
		\param	retValLen	Dugo bufora
	*/
	POSNET_API	POSNET_STATUS		__stdcall POS_PopResponseValueNumeric(POSNET_HANDLE hRequest, char *retVal, unsigned long retValLen);
	/*!
		\brief	Przesu wskanik pl na pocztek listy

		Funkcja umoliwia rozpoczcie analizy pl od pocztku.

		\param	hRequest	Uchwyt zapytania/odpowiedzi
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_ResponseRewind(POSNET_HANDLE hRequest);
	
	/*!
		@}
	*/

	/*!
		\defgroup req_queue Obsuga kolejek rozkazw i wynikw
		\ingroup sync_api

		Aplikacja moe obsugiwa wysyane rozkazy w dwch trybach.
		  * W trybie "wylij-zapomnij" aplikacja tworzy rozkaz, wypenia parametrami a nastpnie
			umieszcza w kolejce rozkazw do wykonania. Jednoczenie nie przechowuje samodzielnie 
			uchwytw wysanych rozkazw. Wyniki rozkazw pobiera z kolejki wynikw za porednictwem
			\ref POS_GetNextResponse i obsuguje odpowiednio.
		  * W trybie "interaktywnym" aplikacja tworzy rozkaz, wypenia parametrami i wstawia
			do kolejki rozkazw. Jednake zapamituje uchwyt rozkazu i obserwujc stan rozkazu
			za porednictwem \ref POS_GetRequestState obsuguje go w momencie zakoczenia.
		
		Tryb "wylij-zapomnij" jest bardziej odpowiedni dla operacji masowych (np. programowanie
		kasy) gdy umoliwia efektywniejsze (szybsze) wykonywanie rozkazw, ktrych wynik jest
		mniej istotny.

		Tryb "interkatywny" wskazany jest dla rozkazw, ktrych wynik jest w danej chwili niezbdny dla
		dalszej pracy aplikacji. W tym celu wprowadzony jest te rozkaz \ref POS_WaitForRequestCompleted
		ktry umozliwia synchronizowane oczekiwanie na zakoczenie wykonania rozkazu przez kas.

		\warning	Nie ma moliwoci przegldania kolejki rozkazw oczekujcych/wysanych. Jest to spowo
		dowane ich asynchronicznym w stosunku do apliacki wykonywaniem i zawarto tej kolejki moe si
		zmienia w trakcie wykonywania zaputa przegldajcych (rozkazy mog znika z kolejki mimo
		i aplikacja pobraa je jeszcze z kolejki oczekujcych).

		@{
	*/

	/*!
		\brief	Pobierz z kolejki odpowiedzi (rozkazw zakoczonych) nastpny dostpny wynik.

		Z kolejki odpowiedzi zostaje pobrany (i usunity) nastpny wynik. Pobrany wynik naley 
		zniszczy za pomoc \ref POS_DestroyRequest. Pobierane s wycznie wyniki otrzymane na
		rozkazy wysane za porednictwem biecego kontekstu urzdzenia (hLocalDevice). Rozkazy 
		wysane za pomoc innych kontekstw tego samego urzdzenia s pomijane.

		Funkcja jest nieblokujca.

		\param	hLocalDevice	Uchwyt lokalny urzdzenia
		\return	Uchwyt do odpowiedzi lub NULL w przypadku bdu lub braku nastpnej odpowiedzi
	*/
	POSNET_API	POSNET_HANDLE	__stdcall POS_GetNextResponse(POSNET_HANDLE hLocalDevice);
	/*!
		\brief	Pobierz ilo wynikw w kolejce wynikw

		\param hLocalDevice	Uchwyt lokalny urzdzenia
		\return Ilo wynikw dla biecego kontekstu urzdzenia.
	*/
	POSNET_API	unsigned long	__stdcall POS_GetResponseCount(POSNET_HANDLE hLocalDevice);
	/*!
		\brief	Pobierz ilo rozkazw oczekujcych w kolejce rozkazw wysanych przez biecy kontekst
				urzdzenia lub wszystkich rozkazw oczekujcych w kolejce.

		\param hLocalDevice	Uchwyt lokalny urzdzenia
		\param globalnie Jeli parametr ten jest rny od 0 zwracana warto podaje ilo wszystkich rozkazw 
				oczekujcych w kolejce.
	*/
	POSNET_API	unsigned long	__stdcall POS_GetRequestCount(POSNET_HANDLE hLocalDevice,unsigned char globalnie=0);

	/*!
		\brief	Pobierz statystyki kolejek. Statystyki s zwracane w kontekcie caego urzdzenia.

		\param hLocalDevice	Uchwyt lokalny urzdzenia
		\param sent		Do tej zmiennej wpisywana jest ilo wszystkich wysanych do kasy
						rozkazw
		\param completed	Do tej zmiennej wpisywana jest ilo wszystkich ukoczonych rozkazw
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_RequestQueueStats(POSNET_HANDLE hLocalDevice, unsigned long *sent, unsigned long *completed);	


	/*!
		\brief	Wyczy kolejk rozkazw oczekujcych na wysanie

		Czyci kolejk rozkazw oczekujcych na wysanie. Funkcja powinna by wykorzystywana wycznie
		w sytuacji, gdy nastpi krytyczny bd urzdzenia. Rozkazy ju wysane zostan obsuone, jeli
		w dalszej perspektywie pojawi si na nie odpowied. Domylnie rozkazy czyszczone s wycznie dla biecego
		kontekstu urzdzenia.

		\param	hLocalDevice	Uchwyt lokalny urzdzenia
		\param globalnie Jeli parametr ten jest rny od 0 ignorowany jest kontekst urzdzenia.
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_RequestQueueCancelPending(POSNET_HANDLE hLocalDevice,unsigned char globalnie=0);
	/*!
		\brief	Wyczy kolejk rozkazw oczekujcych na wysanie

		Czyci kolejk rozkazw oczekujcych. Funkcja powinna by wykorzystywana wycznie
		w sytuacji, gdy nastpi krytyczny bd urzdzenia. Wszystkie otrzymane pniej
		wyniki dla rozkazw, ktre byy w trakcie wykonywania zostan odrzucone. 
		Domylnie rozkazy czyszczone s wycznie dla biecego
		kontekstu urzdzenia.

		\param	hLocalDevice	Uchwyt lokalny urzdzenia
		\param globalnie Jeli parametr ten jest rny od 0 ignorowany jest kontekst urzdzenia.
	*/
	POSNET_API  POSNET_STATUS	__stdcall POS_RequestQueueCancelAll(POSNET_HANDLE hLocalDevice,unsigned char globalnie=0);
	/*!
		\brief	Anuluj rozkaz aktualnie wykonywany przez kas

		Funkcja jest przydatna w sytuacji, gry aplikacja chce anlulowa wycznie wykonywany
		rozkaz bez czyszczenia kolejki oczekujcych, a pracuje w trybie wyslij-zapomnij.
		Anulowanie nastpuje w kontekcie globalnym urzdzenia, jako e tylko jeden rozkaz moe by 
		w danej chwili wykonywany przez kas. 

		\param hLocalDevice	Uchwyt lokalny urzdzenia
		\return Uchwyt anulowanego rozkazu lub NULL w przypadku braku rozkazu do anulowania
	*/
	POSNET_API	POSNET_HANDLE	__stdcall POS_CancelExecuting(POSNET_HANDLE hLocalDevice);


	/*!
		\brief	Wywouje funkcj REPEAT dla utraconej odpowiedzi kasy

		Funkcja jest przydatna w sytuacji, gdy odpowied kasy na wysan ramk zostaa utracona w 
		wyniku bdu transmisji z kasy do komputera. Jej uycie powoduje ponowne wysanie ramki z ustawionym 
		bitem REPEAT. Uycie moliwe jest jeli rozkaz znajduje si w stanie POSNET_RSTATE_SENT lub POSNET_RSTATE_ACK
		(por. \ref POS_GetRequestState)

		\param hRequest	Uchwyt rozkazu, ktry ma by ponowiony
		\return Status wykonania
	*/
	POSNET_API      POSNET_STATUS  __stdcall POS_RepeatRequest(POSNET_HANDLE hRequest);

	/*!
		@}
	*/

	// --------------------------------------------------------------------------------------------------------
	/*!
	\defgroup	sync_api	Obsuga synchroniczna kasy
	@{
	*/
	
	// PLACEHOLDER

	/*!
		@}
	*/
	// --------------------------------------------------------------------------------------------------------

	// --------------------------------------------------------------------------------------------------------
	/*!
		\addtogroup	event_handling
		@{
	*/
	/*!
		\brief	Sprawdzenie czy w kolejce zdarze asynchronicznych znajduj si obiekty.

		Sprawdza czy w kolejce zdarze asynchronicznych znajduj si jakiekolwiek obiekty.
		Wrd tych obiektw moe by obiekt karty rabatowej. Obiekty asynchroniczne nie
		posiadaj kontekstu urzdzenia.

		\param	hLocalDevice	Uchwyt lokalny urzdzenia
		\return	\ref POSNET_STATUS_OK jeli s elementy lub \ref POSNET_STATUS_EMPTY jeli ich nie ma
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_AsyncDataWaiting(POSNET_HANDLE hLocalDevice);
	/*!
		\brief Pobierz z kolejki asynchronicznej nastpny obiekt.

		Pobrany obiekt naley nastpnie skasowa za pomoc funkcji \ref POS_DestroyRequest .
		
		\param	hLocalDevice	Uchwyt lokalny urzdzenia
		\param	timeout	Parametr okrelajcy czas oczekiwania na now warto w kolejce asynchronicznej.
				Jeli ma warto INFINITE funkcja czeka w nieskoczono, 0 - wraca natychmiast w przeciwnym
				wypadku oczekuje odpowiedni ilo milisekund na otrzymanie danych.
		\return NULL jeli nie ma (lub oczekiwanie zakoczyo si timeoutem), uchwyt obiektu w przeciwnym razie.
	*/
	POSNET_API	POSNET_HANDLE	__stdcall POS_PopAsyncData(POSNET_HANDLE hLocalDevice,unsigned long timeout);
	/*!
		\brief	Ilo elementw w kolejce zdarze asynchronicznych

		\param	hLocalDevice	Uchwyt lokalny urzdzenia
		\return Ilo elementw w kolejce lub -1 w przypadku bdu
	*/
	POSNET_API	unsigned long	__stdcall POS_AsyncQueueLength(POSNET_HANDLE hLocalDevice);
	/*!
		\brief	Wyczy kolejk zdarze asynchronicznych

		Czyci kolejk zdarze asynchronicznych bez ich obsugi.

		\param hLocalDevice Uchwyt urzdzenia
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_AsyncQueuePurge(POSNET_HANDLE hLocalDevice);

	/*!
		@}
	*/
	// --------------------------------------------------------------------------------------------------------

	// --------------------------------------------------------------------------------------------------------
	/*!
		\defgroup	sale_buffer Obsuga bufora pozycji paragonowych

		\brief	Odebrane pozycje paragonowe s przechowywane w osobnej kolejce. Umoliwia to
				rozdzielenie obsugi polece zwykych od obsugi odbioru danych towarowych,
				a co za tym idzie z punktu widzenia aplikacji - rwnolege ich wykonywanie.

		Rozkazy odczytu kolejnych pozycji paragonowych s umieszczane w gwnej kolejce rozkazw,
		ale ich wyniki s gromadzone w osobnej kolejce odbiorczej. Dziki temu obsuga pozycji
		jest niezalena od obsugi rozkazw gwnych.
		@{
	*/
	
	/*!
		\brief Pobierz z kolejki pozycji paragonowych nastpny obiekt. Obiekty paragonowe
		maj swj kontekst urzdzenia, ale dla wygody umieszczane s w osobnej kolejce odbiorczej.

		Pobrany obiekt naley nastpnie skasowa za pomoc funkcji \ref POS_DestroyRequest .

		\param	hLocalDevice	Uchwyt lokalny urzdzenia
		\param	timeout	Parametr okrelajcy czas oczekiwania na now warto w kolejce paragonowej.
		Jeli ma warto INFINITE funkcja czeka w nieskoczono, 0 - wraca natychmiast w przeciwnym
		wypadku oczekuje odpowiedni ilo milisekund na otrzymanie danych.
		\return NULL jeli nie ma (lub oczekiwanie zakoczyo si timeoutem), uchwyt obiektu w przeciwnym razie.
	*/
	POSNET_API	POSNET_HANDLE __stdcall POS_PopSalesQueue(POSNET_HANDLE hLocalDevice,unsigned long timeout );
	/*!
		\brief	Ilo elementw w kolejce pozycji paragonowych

		\param	hLocalDevice	Uchwyt lokalny urzdzenia
		\param globalnie Jeli parametr ten jest rny od 0 zwracana jest ilo obiektw w kontekscie globalnym, a nie lokalnym urzdzenia
		(ilo wszystkich pozycji)
		\return Ilo elementw w kolejce lub -1 w przypadku bdu
	*/
	POSNET_API	unsigned long	__stdcall POS_SalesQueueLength(POSNET_HANDLE hLocalDevice,unsigned char globalnie=0);
	/*!
		\brief	Wyczy kolejk pozycji paragonowych

		Czyci kolejk zdarze paragonowych bez ich obsugi.

		\param hLocalDevice Uchwyt lokalny urzdzenia
		\param globalnie Jeli ten parametr jest rny od 0 czyszczone s WSZYSTKIE obiekty w kolejce, nie tylko nalece
				do biecego kontekstu urzdzenia.
	*/
	POSNET_API	POSNET_STATUS	__stdcall POS_SalesQueuePurge(POSNET_HANDLE hLocalDevice,unsigned char globalnie=0);

	/*!
		@}
	*/
	// --------------------------------------------------------------------------------------------------------


}


#endif

