//
//
//
//			POSNET BASE EXAMPLES
//			EXAMPLE QUEUE MODE
//
//

#include <stdlib.h>
#include <string>
#include <iostream>
#include <istream>
#include <limits>
#ifdef WIN32
#include <windows.h>
#else
#define INFINITE 0xFFFFFFFF
#endif
#include "../../include/posnet.h"
#include "../../include/posnet_cmdid.h"
#include "../../include/posnet_hlapi.h"

using namespace std;



int main(int argc, char *argv[])
{

#ifdef WIN32
	WSADATA WSAData;
	if (WSAStartup (MAKEWORD(2,0), &WSAData) != 0) 
	{
		MessageBox (NULL, TEXT("WSAStartup failed!"), TEXT("Error"), MB_OK);
		return FALSE;
	}

 #endif
 
#include "../setup.inc"

	POSNET_HANDLE hRequest;

	// Przygotowanie polecenia
	// Numer polecenia DSPPARAMGET = 101
	hRequest = POS_CreateRequest(hLocalDevice,POSNET_CMDID_DSPPARAMGET);

	// Przygotowanie parametrw polecenia
	// Pobierz dane dla wywietlacza operatora
	// Wymagany 1 paramter typu 'B' o wartoci 0
	POS_PushRequestParamByte(hRequest,0);

	// Wylij rozkaz do kasy w trybie interaktywnym
	POS_PostRequest(hRequest,POSNET_REQMODE_IMMEDIATE);

	// Oczekuj na wykonanie
	POS_WaitForRequestCompleted(hRequest,INFINITE);

	// Sprawd czy zakoczyo si sukcesem
	if (POS_GetRequestStatus(hRequest) == POSNET_STATUS_OK)
	{
		// Pobranie wynikw, polecenie zwraca 3 wartoci typu byte
		unsigned char kontrast,podswietlenie,tryb;
		POS_PopResponseValueByte(hRequest,&kontrast);
		POS_PopResponseValueByte(hRequest,&podswietlenie);
		POS_PopResponseValueByte(hRequest,&tryb);
		cout << "Kontrast: " << (int)kontrast << " Podswietlenie: " << (int)podswietlenie << " Tryb: " << (int)tryb << endl;
	}

	// Usu stworzone zapytanie
	POS_DestroyRequest(hRequest);


	POS_CloseDevice(hLocalDevice);
	POS_DestroyDeviceHandle(hDevice);
	return 0;
}
