//
//
//
//			POSNET BASE EXAMPLES
//			EXAMPLE ASYNC EVENT
//
//

#include <stdlib.h>
#include <string>
#include <iostream>
#include <istream>
#include <limits>
#ifdef WIN32
#include <windows.h>
#else
#include <pthread.h>
#include <semaphore.h>
#endif
#include "../../include/posnet.h"
#include "../../include/posnet_hlapi.h"

using namespace std;

// callback function
// funkcja wywolywana jest w kontekscie watku KASY
// nie mozna wiec uzywac POS_WaitForRequestCompleted!
// a funkcja musi konczyc sie szybko, w przykadzie
// odsyla natychmiast odpowiedz

POSNET_HANDLE hLocal;
int mode=-1;

void myCallback(POSNET_HANDLE handle)
{
	char buffer[64];
	
	if (POSG_CardInfo(handle,buffer)==POSNET_STATUS_OK)
	{
		POSNET_HANDLE rq;
		POSNET_STATUS pstat;
				
		if (mode)
			pstat=POSS_DBDiscntPCSet(hLocal,&rq,0,1,POSNET_REQMODE_AUTOCLEAR);
			else
			pstat=POSS_ManualDiscntPCSet(hLocal,&rq,0,"FRIEND1",0x11,"100",1,1,POSNET_REQMODE_AUTOCLEAR);
		if (pstat!=POSNET_STATUS_OK)
		{
			cout << "Setting Discount failed - function error : 0x" << hex << pstat << dec << endl;
		}
		else
		{
			cout << "Discount Sent." << endl;
		}
	}
	else
	{
		cout << "POSG_CardInfo Failed....." << endl;
		POSG_Default(handle);
	}
}

int main(int argc, char *argv[])
{

#ifdef WIN32
	WSADATA WSAData;
	if (WSAStartup (MAKEWORD(2,0), &WSAData) != 0) 
	{
		MessageBox (NULL, TEXT("WSAStartup failed!"), TEXT("Error"), MB_OK);
		return FALSE;
	}

#endif  
  
#include "../setup.inc"

	hLocal=hLocalDevice;
	POS_SetEventHandlingMode(hLocalDevice,POSNET_EVENT_CALLBACK);
	POS_SetCallback (hLocalDevice,myCallback);

	
	while (mode<0 || mode>1)
	{
		cout << "Prosze wybra tryb: 0-Manual, 1-DB" ;
		cin >> mode;
	}

	while (1) 
	{
		// do here something else
		Sleep(10);		
	}

	POS_CloseDevice(hLocalDevice);
	POS_DestroyDeviceHandle(hDevice);
	return 0;
}
