//
//
//
//			POSNET BASE EXAMPLES
//			EXAMPLE ASYNC POLLING
//
//

#include <stdlib.h>
#include <string>
#include <iostream>
#include <istream>
#include <limits>
#ifdef WIN32
#include <windows.h>
#endif
#include "../../include/posnet.h"
#include "../../include/posnet_hlapi.h"

using namespace std;



int main(int argc, char *argv[])
{

#ifdef WIN32
	WSADATA WSAData;
	if (WSAStartup (MAKEWORD(2,0), &WSAData) != 0) 
	{
		MessageBox (NULL, TEXT("WSAStartup failed!"), TEXT("Error"), MB_OK);
		return FALSE;
	}
#endif
	#include "../setup.inc"
	
	POS_SetEventHandlingMode(hLocalDevice,POSNET_EVENT_POLLING);
	
	while (1) 
	{
		POSNET_HANDLE ps=POS_PopAsyncData(hLocalDevice,1000);
		if (ps)
		{
			char buffer[64];
			if (POSG_CardInfo(ps,buffer)==POSNET_STATUS_OK)
			{
				POSNET_HANDLE rq;
				POSNET_STATUS pstat;
				if (pstat=POSS_ManualDiscntPCSet(hLocalDevice,&rq,0,"FRIEND1",0x11,"100",1,1,POSNET_REQMODE_SPOOL)!=POSNET_STATUS_OK)
				{
					cout << "Setting Manual discount failed - function error : 0x" << hex << pstat << dec << endl;
				}
				else
				{
					cout << "Setting Manual discount" << endl;
					int x=30;
					while (POS_WaitForRequestCompleted(rq,1000)!=POSNET_STATUS_OK)
					{
						cout << "Still waiting for answer ...." << endl;
						if (!x--) break;
					}
					if (POS_GetRequestState(rq)==POSNET_RSTATE_COMPLETED)
					{
						cout << "Answer for setup received : ";
						pstat=POS_GetRequestStatus(rq);
						cout << "0x" << hex << pstat << dec << endl;
					}
					POSG_Default(rq);
				}

			}
			else
				cout << "POSG_CardInfo Failed....." << endl;
		}
		else
		{
			cout << "1s No card ....." << endl;
		}
	}
	
	POS_CloseDevice(hLocalDevice);
	POS_DestroyDeviceHandle(hDevice);
	return 0;
}
