/* Tab 2 */

/*
	ThermalResponse.h - plik nagwkowy dla ThermalResponse.cpp
*/

#ifndef _THERMAL_RESPONSE
#define _THERMAL_RESPONSE

#include "StdAfx.h"
#include "..\\ThermalServiceLibrary.h"
#include "ComPort.h"
#include "ThermalCommand.h"
#include "FunctionDeclarations.h"

extern CComPort CThComPort;
extern CThermalCommand CThCmd;

class CThermalResponse
{
public:
	CThermalResponse();
	~CThermalResponse();

/*
	Clear
		Wyczy rozkaz (== inicjalizacja)

	Argumenty:
		---

	Zwraca:
		---
*/
	void Clear();

/*
	Receive, Receive2 (Receive to nakadka na Receive2, dodane flush-owanie logu)
		Odbierz ramk odpowiedzi, jeli zawiera pola danych to je wczytaj.

	Argumenty wejciowe:
		aProtocolType				- rodzaj (odmiana) protokou	(PROTOCOL
		aRespWithData				- TRUE jeli ramka zawiera dane (tzn. nie jest to ramka potwierdzenia)
		aResponseTime				- maksymalny czas oczekiwania na odpowied

	Zwraca:
		SOK
		ERR_PORT_NOT_OPEN		- gdy prbowano co odebra bez otwierania portu
		ERR_I_MAX_RETRIES		- (woski) zbyt dua liczba prb odebrania ramki
		ERR_NO_RESPONSE			- brak odpowiedzi (nie odebrano adnego bajtu)
													w wyznaczonym czasie
		ERR_RESPONSE_TOUT		- przekroczony czas od odebrania pierwszego bajtu do
													odebrania znacznika koca ramki
		ERR_FMT_HEADER			- nagwek (znacznik pocztku) nieprawidowy (lub brak)
		ERR_RETURN_CODE			-	urzdzenie zwrcio kod bdu rny od 0
		ERR_FMT_RETURN_CODE	- pole kodu bdu - zy format (lub brak)
		ERR_CHECKSUM				-	suma kontrolna - za warto (niezgodna z wyliczon)
		ERR_FMT_CHECKSUM		- suma kontrolna - nieprawidowy format pola (lub brak)
		ERR_INPUT_BUF_OVRRUN	- zapenienie bufora wejciowego
		ERR_UNKNOWN_CMD			- urzdzenie zasygnalizowao, e nie rozpoznao rozkazu
		ERR_UNKNOWN_FRAME		- urzdzenie odesao ramk niezgodn z oczekiwaniami
		ERR_WRITE_FILE			- bd zapisu do pliku (log) - jeli wczone jest logowanie
*/
	int Receive( BYTE aProtocolType, BOOL aRespWithData, DWORD aResponseTime = NORMAL_RESPONSE_TIME );
	int Receive2( BYTE aProtocolType, BOOL aRespWithData, DWORD aResponseTime );

/*
	Translate
		Zamie odebran ramk (pola) na posta wewntrzn (wczytanie i okrelenie
		rodzajw pl)

	Argumenty wejciowe:
		aDataPtr						- adres pierwszego bajtu pierwszego pola ramki
		aDataLen						- liczba bajtw (do znacznika koca ramki)

	Zwraca:
		SOK
		ERR_FIELD_TYPE			- nieznany rodzaj pola (bd terminatora)
*/
	int Translate( BYTE *aDataPtr, DWORD aDataLen );


/*
	CreateRespStruct

	Argumenty wejciowe:
		aProtocolType				- rodzaj protokou
		aResponseStruct			- struktura okrelajca liczb i rodzaje pl oraz
													adres wyjciowej struktury zawierajcej pola

	Zwraca:
		SOK
		ERR_NUMBER_OF_FIELDS - ramka zawiera liczb pl rn od oczekiwanej
		ERR_FIELD_TYPE			-	pole nie odpowiada dostarczonemu opisowi
													(niezgodny terminator)
		ERR_FIELD_CONTENTS	- za zawarto pola (nie odpowiada rodzajowi pola)
*/
	int CreateRespStruct( BYTE	aProtocolType, tRESPONSE * aResponseStruct );

/*
	GetDataFieldDescr
		Pobierz informacj o polu danych

	Argumenty wyjciowe:
		aLenOut							- tu zostanie wpisana liczba bajtw danych
		aPtrOut							- tu zostanie wpisany adres pocztku pola danych

	Zwraca:
		---
*/
	void GetDataFieldDescr( DWORD *aLenOut, BYTE **aPtrOut );


/*
	AddField

	Argumenty wejciowe:
		aStrPtr							- /PTR/ zawarto pola (tekst)
		aFieldType					-	rodzaj pola (FLD_...)
		aStrLen							- dugo pola (liczba bajtw bez koczcego zera)

	Zwraca:
		---

*/
	void AddField( char *aStrPtr, BYTE aFieldType, DWORD aStrLen );


/*
	GetExtendedErrorCode

	Argumenty:
		---

	Zwraca:
		rozszerzony kod bdu (zawierajcy zwrcone przez urzdzenie:
		kod rozkazu i kod bdu)
*/
	DWORD GetExtendedErrorCode();


/*
	GetFieldCount
		Pobierz liczb pl odpowiedzi

	Argumenty:
		---

	Zwraca:
		liczb pl
*/
	DWORD GetFieldCount();


/*
	GetFieldType
		Pobierz typ wybranego pola z ramki odpowiedzi

	Argumenty wejciowe:
		aFieldNdx						- indeks (od zera) pola
	
	Zwraca:
		typ pola (FLD_...)
*/
	BYTE GetFieldType( DWORD aFieldNdx );


/*
	GetFieldLength
		Pobierz dugo wybranego pola z ramki odpowiedzi (pole jest tekstem)

	Argumenty wejciowe:
		aFieldNdx						- indeks (od zera) pola
	
	Zwraca:
		dugo pola
*/
	DWORD GetFieldLength( DWORD aFieldNdx );


/*
	GetFieldLength
		Pobierz dugo wybranego pola z ramki odpowiedzi (pole jest tekstem)

	Argumenty wejciowe:
		aFieldNdx						- indeks (od zera) pola
	
	Zwraca:
		dugo pola
*/
	void SetFieldText( DWORD aFieldNdx, char * aFieldText );


/*
	GetFieldText
		Pobierz wybrane pole z ramki odpowiedzi

	Argumenty wejciowe:
		aFieldNdx						- indeks (od zera) pola
	
	Zwraca:
		wskanik do (tekstu) wybranego pola. Nie wolno dokonywa adnych zmian we wskazanym polu -
		jeli trzeba co zmienia to naley skopiowa wczeniej do jakiego bufora.
*/
	char * GetFieldText( DWORD aFieldNdx );


/*
	SetCmdString
		Ustaw kod rozkazu (dwa znaki)

	Argumenty wejciowe:
		aFirstChar					- pierwszy znak
		aSecondChar					- drugi znak
	
	Zwraca:
		---
*/
	void SetCmdString( char aFirstChar, char aSecondChar );


/*
	GetCmdString
		Zwr kod rozkazu

	Argumenty:
		---
	
	Zwraca:
		wskanik do kodu rozkazu (dwuznakowego tekstu)
*/
	char * GetCmdString();


/*
	SetReturnCode
		Ustaw kod potwierdzenia/bdu wykonania rozkazu

	Argumenty wejciowe:
		aCode								- warto kodu
	
	Zwraca:
		---
*/
	void SetReturnCode( DWORD aCode );


/*
	GetReturnCode
		Pobierz kod potwierdzenia/bdu wykonania rozkazu

	Argumenty:
		---
	
	Zwraca:
		warto kodu
*/
	DWORD GetReturnCode();


/*
	ClearResponseStructPtr
		Skasuj (wyczy) wskanik do struktury opisujcej odpowied

	Argumenty:
		---
	
	Zwraca:
		---
*/
	void ClearResponseStructPtr();


/*
	SetResponseStructPtr
		Ustaw wskanik do struktury opisujcej odpowied

	Argumenty wejciowe:
		aResponseStructPtr	- /PTR/ struktura

	Zwraca:
		---
*/
	void SetResponseStructPtr( tRESPONSE * aResponseStructPtr );


/*
	GetResponseStructPtr
		Pobierz wskanik do struktury opisujcej odpowied

	Argumenty:
		---

	Zwraca:
		wskanik do struktury
*/
	tRESPONSE * GetResponseStructPtr();


/*
	Zmienne
*/
													/* Flagi: */
	BOOL F_Resp,						/* obecno odpowiedzi */
		F_Italian,						/* protok woski */
		F_ItalianRemote,			/* protok woski, Remote PC */
		F_RxChksum;						/* suma kontrolna w ramce nadawanej */

protected:

	char RetCmdString[CMD_CMD_STR_LEN+1];		/* kod rozkazu - ramka zwrotna */ 
	DWORD RetCode;													/* ramka zwrotna: kod zwrotny (ten, ktry umieszczony jest */
																					/* przed kodem rozkazu */

	DWORD	FieldCount,												/* liczba pl w ramce */
			DataLen;														/* Dugo pola danych */
	BYTE * DataPtr;													/* pocztek pola danych */

	BYTE ProtocolType;											/* protok (charakterystyka) */

	tRESPONSE *ResponseStructPtr;						/* /PTR/ struktura odpowiedzi (pola oraz ich opis -  */
																					/* liczba i rodzaje pl) */

	tVectorOfStrings	VectOfTextFields;			/* argumenty rozkazu zamienione na stringi */
	tVectorOfBytes		VectOfFieldTypes;			/* rodzaj argumentu -> wyznacza separator */
	tVectorOfDwords		VectOfTextLengths;		/* dugo argumentu zamienionego na tekst */
};

#endif // _THERMAL_RESPONSE