/* Tab 2 */

/*
	ThermalResponse.cpp - implementacja klasy CThermalResponse
*/

#include "ThermalResponse.h"

extern DWORD ExtendedErrorCode;
extern tTIMEOUT_DLG_FUNC TimeoutDialogFunc;

/******************************************************************************/

CThermalResponse::CThermalResponse()
{
	CThermalResponse::Clear();

	ClearResponseStructPtr();
}

/*----------------------------------------------------------------------------*/

CThermalResponse::~CThermalResponse()
{
}

/*----------------------------------------------------------------------------*/

void CThermalResponse::Clear()
{
/*
	Inicjalizujemy troch rzeczy 
*/
	ExtendedErrorCode = 0;

	FieldCount = 0;

	VectOfTextFields.clear();
	VectOfFieldTypes.clear();
	VectOfTextLengths.clear();
}

/******************************************************************************/

void CThermalResponse::ClearResponseStructPtr()
{
	ResponseStructPtr = NULL;
}

/*----------------------------------------------------------------------------*/

void CThermalResponse::SetResponseStructPtr( tRESPONSE * aResponseStructPtr )
{
	_ASSERTE( aResponseStructPtr );

	ResponseStructPtr = aResponseStructPtr;
}

/*----------------------------------------------------------------------------*/

tRESPONSE * CThermalResponse::GetResponseStructPtr()
{
	return ResponseStructPtr;
}

/******************************************************************************/

int CThermalResponse::Receive( BYTE aProtocolType, BOOL aRespWithData, DWORD aResponseTime )
{
	static int RetI_Recv, RetI_Flush;

	RetI_Recv = Receive2( aProtocolType, aRespWithData, aResponseTime );
	RetI_Flush = CThComPort.LogFlush();

	if( RetI_Recv != SOK )
	{
		return RetI_Recv;
	}

	return RetI_Flush;
}

/*----------------------------------------------------------------------------*/

int CThermalResponse::Receive2( BYTE aProtocolType, BOOL aRespWithData, DWORD aResponseTime )
{
	static int RetI,
		UserDecision;

	static DWORD BytesRead,		/* Liczba bajtw odczytanych */
		BytesToRead,						/* Jakiej dugoci pakiet ma by odebrany */
		InBufNdx,								/* Indeks bufora wejciowego */
		FirstTick,							/* Tick Time - do odmierzania czasu */
		FrameEndMarkNdx,				/* Indeks znacznika koca ramki */
		TmpFrameEndMarkNdx,			/* tymczasowy FrameEndMarkNdx */
		RetChecksum,						/* Ramka zwrotna: suma kontrolna */
		I_Retries,							/* Liczba prb - protok woski */
		TimeSpan,								/* */
		RetCode,								/* Kod zwrotny (ten przed kodem rozkazu ) */
		RetCodeStrLen;					/* Dugo kodu zwrotnego */

	
	static BYTE Checksum;			/* Suma kontrolna ramki odebranej */

	static BOOL SearchForP,		/* Czy czekamy na ESC P, czy te moe odbieramy reszt */
		RespStatusPresent;			/* Czy znaleziono co co wyglda na status wykonania rozkazu */

	ProtocolType = aProtocolType;

	F_Resp =					( (aProtocolType & PROTO_RESP) != 0 );
	F_Italian =				( (aProtocolType & PROTO_ITALIAN) != 0 );
	F_ItalianRemote = ( ((aProtocolType & PROTO_ITALIAN) != 0) && ((aProtocolType & PROTO_REMOTE) != 0) );
	F_RxChksum =			( (aProtocolType & PROTO_RX_CHKSUM) != 0 );

#ifdef _DEBUG
	memset( CThComPort.PortInBuf, 0 ,PORT_INPUT_BUFFER_LEN );
#endif // _DEBUG

	/* na wszelki wypadek... */
	if( !CThComPort.WasPortOpened() )
	{
		return ERR_PORT_NOT_OPEN;
	}

DLE_LOOP:
TOUT_LOOP:
	I_Retries = I_MAX_RETRIES ;		/* Max liczba prb dla protokou woskiego */

	/* czekamy na odpowied - na pocztek jeden bajt, a po jego wartoci okrelimy co dalej */
	if( F_Resp )
	{

/*
		Fuj ! Etykieta !  Kto uywa 'goto'... ;-)
*/
LOOP:

/*
		Dla protokou woskiego wprowadziem maksymaln liczb prb (gdy tam w przypadku
		bdu nastpuje wysanie negatywnego potwierdzenia i ponowne oczekiwanie na odebranie
		ramki)

		Uwaga - sprawdzanie wykonywane po wysaniu ale przed odbiorem.
		
		Nie dotyczy trybu Remote PC
*/
		if( F_Italian && (!F_ItalianRemote) )
		{
			if( !I_Retries )
			{
				return ERR_I_MAX_RETRIES;
			}
			else
			{
				I_Retries--;
			}
		}

		SearchForP = TRUE;			/* Bdziemy czeka na ESC P */

/*
		Timeout bdzie wykrywany wanie tutaj - przy czekaniu na pierwszy bajt
*/
		RetI = CThComPort.WaitForAnyByte( aResponseTime, CThComPort.PortInBuf );
		if( RetI != SOK )
		{
/*
			Spytamy uytkownika o to co sdzi o tajmacie ;-)
			Yes - czekanie dalej na odpowied
			No - wysanie ponowne
			Cancel - przerwanie
*/
			UserDecision = TimeoutDialogFunc();

			if( UserDecision == IDYES )
			{
				goto TOUT_LOOP;							/* IDYES -> no to jeszcze poczekamy */
			}
			else if( UserDecision == IDNO )
			{
				return ERR_RESEND;					/* IDNO -> wysyamy ponownie */
			}
			else
			{
				return ERR_NO_RESPONSE;			/* cokolwiek innego -> wychodzimy z kodem bdu */
			}
		}

/*
		Jeli kto w TimeoutDialogFunc() odpali DLE i wybra dalsze czekanie (IDYES)
		i przypadkiem odpowied na DLE przysza dopiero teraz - trzeba j pomin.
		Jeli bajt nie pasuje do odpowiedzi na DLE - to przepucimy go do dalszego
		sprawdzania.
*/
		if( ! F_Italian )
		{
			if( (CThComPort.PortInBuf[0] & DLE_RESP_MASK) == DLE_RESP_SIGNATURE )	/* czy bajt odpowiedzi na DLE ? */
			{
				goto DLE_LOOP;	/* jeli odpowied na DLE - to wracamy do pocztku */
			}
		}
		else if( F_Italian && (!F_ItalianRemote) )
		{
			if( (CThComPort.PortInBuf[0] & I_DLE_RESP_MASK) == I_DLE_RESP_SIGNATURE )
			{
				goto DLE_LOOP;
			}
		}


		if( ! F_ItalianRemote )	/* pobieramy warto timera systemowego (ITALIAN_REMOTE - nie) */
		{
			FirstTick = GetTickCount();
		}

/*
		Jeli pierwszym znakiem jest ESC, drugim P oznacza to, e otrzymamy w odpowiedzi dusz ramk -
		zakoczon ESC \
		Wyszukiwanie znacznika koca jest jedyn skuteczn metod okrelenia dugoci ramki.
*/

		InBufNdx = 1;
		
		if( CThComPort.PortInBuf[0] == ESC )
		{
			while( TRUE )
			{
				BytesToRead = min( READ_N_BYTES_AT_ONCE, PORT_INPUT_BUFFER_LEN - InBufNdx ); 	

				/* Odczyt paczkami po ile tam (READ_N_BYTES_AT_ONCE) bajtw */
				
				RetI = CThComPort.Read( BytesToRead, & BytesRead, & CThComPort.PortInBuf[InBufNdx] );
/*
				Bd moe by np. spowodowany TimeOut-em, wic najpierw trzeba bdzie sprawdzi co 
				zostao odebrane
*/
				if( !F_ItalianRemote )		/* ITALIAN_REMOTE - nie sprawdzamy */
				{
					TimeSpan = GetTickCount() - FirstTick;

					if( TimeSpan > MAX_RESPONSE_FRAME_TIME )
					{
						if( F_Italian )	
						{
							Send_NACK();
							goto LOOP;	
						}
						else
						{
							return ERR_RESPONSE_TOUT;
						}
					}
				}

				if( !BytesRead )
				{
					continue;
				}
				else
				{
					InBufNdx += BytesRead;								/* wskazujemy na pierwszy bajt za tymi ju odebranymi */

					if( SearchForP )											/* czy szukamy P wystpujcego po ESC ? */
					{
						if( CThComPort.PortInBuf[1] != 'P' )
						{
							if( F_Italian )
							{
								Send_NACK();
								goto LOOP;	
							}
							else
							{
								return ERR_FMT_HEADER;
							}
						}
						else
						{
							SearchForP = FALSE;
						}
					}
/*
					Skoro wanie znaleziono nagwek ramki to znacznik koca musi by gdzie dalej
					 czyli jeli odczytano zbyt mao bajtw to nie ma sensu szuka...
					Jeli natomiast nie zostanie znaleziony znacznik koca to bd doczytywane kolejne bajty
					 i dalej bdzie szukany ten znacznik - a do skutku (albo do Timeout-u)
*/
					if( InBufNdx > 4 )		/* bdzie chyba co wicej ni tylko znaczniki pocztku i koca ? */
					{
						if( !FindFrameEnd(& CThComPort.PortInBuf[2], InBufNdx - 2, & FrameEndMarkNdx) )
						{
							if( InBufNdx == PORT_INPUT_BUFFER_LEN )
							{
								if( F_Italian )
								{
									Send_NACK();
									goto LOOP;	
								}
								else
								{
									return ERR_INPUT_BUF_OVRRUN;
								}
							}
							else
							{
								continue;
							}
						}
						else
						{
/*
							Ciekawe rzeczy si dziej w polskim protokole. Jak si wczyo automatyczne odsyanie
							odpowiedzi z kodem bdu - to jeli rozkaz odsya jak tam odpowied, dodana na koniec zostanie
							ramka z kodem bdu (zazwyczaj rwnym zero ?)
							No to musz troch inaczej wyszukiwa koniec ramki - eby znale koniec tej waciwej, szukajc
							od koca
*/
							if( (!F_Italian) && (F_Resp) && (aRespWithData) )
							{
								BytesRead = 1;
/*
								Doczytujemy ewentualne resztki z ramki potwierdzenia, ktra zostaa wysana zaraz za ramk
								odpowiedzi.
*/
								while( BytesRead > 0 )
								{
									BytesToRead = min( READ_N_BYTES_AT_ONCE, PORT_INPUT_BUFFER_LEN - InBufNdx ); 	
									RetI = CThComPort.Read( BytesToRead, & BytesRead, & CThComPort.PortInBuf[InBufNdx] );
									InBufNdx += BytesRead;

									if( FindFrameEnd(& CThComPort.PortInBuf[2], InBufNdx - 2, & FrameEndMarkNdx) )
									{
										break;
									}
								}

								if( FrameEndMarkNdx > 8 )			/* Tyle ma najkrtsza ramka zwrotna */
								{
/*
									Do FindFrameEnd przekaemy liczb bajtw zmniejszon o 2 - czyli o znacznik koca.
									Wtedy bdzie usiowa znale taki znacznik gdzie wczeniej.
*/									
									if( FindFrameEnd(& CThComPort.PortInBuf[2], InBufNdx - 4, & TmpFrameEndMarkNdx) )
									{
										FrameEndMarkNdx = TmpFrameEndMarkNdx;
									}
								}
							}

							FrameEndMarkNdx += 3;							/* tak bdzie liczc od pocztku bufora */
							break;
						}
					}
				}
			}
		}
		else
		{
			if( F_Italian )
			{
				Send_NACK();
				goto LOOP;	
			}
			else
			{
				return ERR_FMT_HEADER;
			}
		}

/*
		Woski protok przewiduje, e ramki odpowiedzi zawsze maj sum kontroln. Prawidowo
		sumy potwierdzana jest przez odesanie znaku ACK. Odesanie NACK spowoduje powtrzenie
		odpowiedzi.

		W starym protokole jest inaczej - suma kontrolna nie zawsze jest obecna. I nawet jeden rozkaz
		moe w zalenoci od parametrw zwaraca sum kontroln a raz nie. 
*/
		if( F_RxChksum )
		{
			/* Wpisujemy 0 w pierwszy bajt znacznika koca - aby sscanf mia podany cig */
			CThComPort.PortInBuf[FrameEndMarkNdx] = 0;

			if( sscanf((char *) & CThComPort.PortInBuf[FrameEndMarkNdx-2], "%x", & RetChecksum) != 1 )
			{
				if( F_Italian )
				{
					Send_NACK();
					goto LOOP;	
				}
				else
				{
					return ERR_FMT_CHECKSUM;
				}
			}

			if( GenerateChecksum(& CThComPort.PortInBuf[2], FrameEndMarkNdx - 4) != (BYTE) RetChecksum )
			{
				if( F_Italian )
				{
					Send_NACK();
					goto LOOP;	
				}
				else
				{
					return ERR_CHECKSUM;
				}
			}

			if( !F_Italian)		/* poniewa w polskim protokole suma kontrolna nie jest oddzielona od ostatniego */
			{									/* pola - sami j oddzielamy, zapisujc pierwszy znak sumy znakiem ESC */
				CThComPort.PortInBuf[FrameEndMarkNdx-2] = ESC;
/*
				Jeli ostatnie pole ma porzdny terminator - to FrameEndMarkNdx zmniejszamy o 2, eby
				ESC nie zostao zaliczone jako terminator pustego pola.
				Jeli natomiast nie ma terminatora - to zmniejszamy o 1.
*/
				switch( CThComPort.PortInBuf[FrameEndMarkNdx-3] )
				{
					default:
						FrameEndMarkNdx--;
						break;

					case SEP_BYT:
					case SEP_NUM:
					case SEP_STR:
					case SEP_LIN:
						FrameEndMarkNdx -= 2;
						break;
						
				}
			}
			
		}

/* 
		Sprawdzimy czy w ramce zwrotnej zasygnalizowany jest bd.
		Jeli nie - i jeli oczekiwana jest odpowied z polami informacyjnymi - to
		przejdziemy do analizy pl.

		(Znowu format ramki zwrotnej jest inny dla obu wersji protokow...)
*/
		if( F_Italian )
		{
			RespStatusPresent = ( sscanf((const char *) & CThComPort.PortInBuf[2],
				"#Z%c%c%d", & RetCmdString[0], & RetCmdString[1], & RetCode ) == 3 );
		}
		else
		{
			RespStatusPresent = ( sscanf((const char *) & CThComPort.PortInBuf[2],
				"%d#Z%c%c", & RetCode, & RetCmdString[0], & RetCmdString[1] ) == 3 );
		}

/*
		Czy ramka odpowiedzi pasuje do wzorca ramki potwierdzenia wykonania rozkazu ?
*/
		if( RespStatusPresent )
		{
			if( !RetCode )
			{
				if( F_Italian )
				{
					return SOK;										/* Rozkaz wykonany bez bdw - wychodzimy */
				}
				else
				{
					if( aRespWithData )						/* W wersji polskiej - kod bdu == 0 rwnie dla */
					{															/* nierozpoznanych rozkazw, wic skoro oczekiwalimy */
						return ERR_UNKNOWN_CMD;			/* innej odpowiedzi - to najwyraniej nie rozpoznano rozkazu */
					}
					else
					{
						return SOK;
					}
				}
			}
			else
			{
																			/* Bd  wykonania - zapamitujemy i wychodzimy */
				ExtendedErrorCode = MAKELONG( (WORD) RetCode , MAKEWORD(RetCmdString[1], RetCmdString[0]) );	
				return ERR_RETURN_CODE;
			}
		}
		else
		{
/*
			Wyglda na to, e ramka nie zawiera potwierdzenia - to moe s w niej
			pola danych - ale czy oczekujemy takiej ramki ?
*/
			if( !aRespWithData )
			{
				if( F_Italian )
				{																					/* Nie oczekiwalimy ramki z danymi  */
																									/* wic musi to by jaka bdna ramka */
					Send_NACK();														/* A we woskim protokole - odsyamy */
					goto LOOP;															/* Negatywne Potwierdzenie (NACK) */	
				}
				else
				{
					return ERR_UNKNOWN_FRAME;								/* Stary protok - wychodzimy z kodem bdu */
				}
			}
		}

/*
		Uff... Skoro tu doszlimy to chyba tylko dlatego, e w ramce zwrotnej odesano jakie
		informacje (tzn. nie bya to ramka potwierdzajca wykonanie rozkazu).
*/
		_ASSERTE( aRespWithData );

		if( aRespWithData )
		{
			DataPtr = CThComPort.PortInBuf;
			DataLen = FrameEndMarkNdx;

			if( F_Italian )
			{
/*
				SetReturnCode nie dotyczy protokou woskiego !!!
*/
				SetCmdString( DataPtr[2], DataPtr[3] );
				DataPtr += 4;			/* Woski: ESC P i dwa znaki kodu rozkazu a potem dopiero dane */
				DataLen -= 6;			/* tu -6 bo 4 z powyszego i jeszcze 2 sumy kontrolnej */
			}
			else
			{

/*
				Kod zwrotny w wikszoci ramek to tylko wypeniacz - jednobajtowy (0x30).
				Ale nie zawsze ! Dlatego te reszta ramki si moe przesuwa.
*/
				if( isdigit(DataPtr[4]) )		/* Troche naiwne sprawdzenie - ale i tak */
				{														/* w przypadku bledu na wyszym poziomie zostanie */
					RetCodeStrLen = 3;				/* wykryta jakas nieprawidlowosc */
				}
				else if( isdigit(DataPtr[3]) )
				{
					RetCodeStrLen = 2;
				}
				else
				{
					RetCodeStrLen = 1;
				}

				if( sscanf((char *) DataPtr + 2, "%d", & RetCode) != 1 )
				{
					return ERR_FMT_RETURN_CODE;
				}

				SetReturnCode( RetCode );

				SetCmdString( DataPtr[2 + RetCodeStrLen], DataPtr[3 + RetCodeStrLen] );
				DataPtr += (4 + RetCodeStrLen);
/*
				Czy jest suma kontrolna czy nie ma - to teraz nie ma ju rnicy jeli chodzi
				o dugo pola danych - jeli bya suma, to FrameEndMarkNdx wczeniej by ju
				zmodyfikowany - tak, jakby przesunity zosta znacznik koca ramki
*/
				DataLen -= (4 + RetCodeStrLen);	

			}

			RetI = Translate( DataPtr, DataLen );
			if( RetI != SOK )
			{
				return RetI;
			}
		}
	}

	return SOK;
}

/******************************************************************************/

void CThermalResponse::SetCmdString( char aFirstChar, char aSecondChar )
{
	RetCmdString[0] = aFirstChar;
	RetCmdString[1] = aSecondChar;
	RetCmdString[2] = 0;
}

/*----------------------------------------------------------------------------*/

char * CThermalResponse::GetCmdString()
{
	return RetCmdString;
}

/******************************************************************************/

void CThermalResponse::SetReturnCode( DWORD aCode )
{
	RetCode = aCode;
}

/*----------------------------------------------------------------------------*/

DWORD CThermalResponse::GetReturnCode()
{
	return RetCode;
}

/******************************************************************************/

int CThermalResponse::Translate( BYTE *aDataPtr, DWORD aDataLen )
{
	static char	Separators[6];	/* Separatory - do analizy odpowiedzi (4 + koczce zero */
															/* lub 5 + koczce zero) */

	static BYTE	FieldSeparator,	/* Znaleziony separator - do okrelenia rodzaju pola */
		FieldType;								/* Rodzaj pola - na podstawie separatora */

	static DWORD FieldOffsNdx,
		StrLen;

	if( F_Italian )
	{
		Separators[0] = SEP_BYT_IT;
		Separators[1] = SEP_NUM_IT;
		Separators[2] = SEP_STR_IT;
		Separators[3] = SEP_LIN_IT;
		Separators[4] = 0;
	}
	else
	{
		Separators[0] = SEP_BYT;
		Separators[1] = SEP_NUM;
		Separators[2] = SEP_STR;
		Separators[3] = SEP_LIN;
		Separators[4] = SEP_ESC;	/* to jest ESC - dorabiane "rcznie" */
	}

	Separators[5] = 0;		/* strcspn wymaga cigu separatorw - zakoczonego zerem */

	Clear();

	FieldOffsNdx = 0;

/*
	Dopki mamy jeszcze dane do obrobienia...
*/
	while( FieldOffsNdx < aDataLen )
	{
/*
		Znajdujemy pole zakoczone jakim ze znakw separatora
*/
		StrLen = strcspn( (char *) & aDataPtr[FieldOffsNdx], Separators );

/*
		Bierzemy sepratator i na jego podstawie okrelamy rodzaj pola.
		W miejsce separatora wpisujemy zero, aby pniej sscanf mia uatwione zadanie.

		W wersji polskiej separatory nie odpowiadaj rodzajom pl - dlatego niespecjalnie si nimi
		przejmujemy (bd sprawdzane w ograniczonym zakresie).
*/
		FieldSeparator = aDataPtr[FieldOffsNdx + StrLen];
		aDataPtr[FieldOffsNdx + StrLen] = 0;

		if( F_Italian )
		{
			switch( FieldSeparator )
			{
				default:									/* Jaki dziwny separator - zgosimy bd */
					return ERR_FIELD_TYPE;	/* NO BREAK HERE !!! */

				case SEP_BYT_IT:
					FieldType = FLD_BYT;
					break;

				case SEP_NUM_IT:
					FieldType = FLD_NUM;
					break;

				case SEP_STR_IT:
					FieldType = FLD_STR;
					break;

				case SEP_LIN_IT:
					FieldType = FLD_LIN;
					break;
			}
		}
		else
		{
			switch( FieldSeparator )
			{
				default:									/* Jaki dziwny separator - zgosimy bd */
					return ERR_FIELD_TYPE;	/* NO BREAK HERE !!! */

				case SEP_ESC:
					FieldType = FLD_UNK;		/* ostatnie pole - nie wiadomo jakiego typu ... */
					break;

				case SEP_BYT:
					FieldType = FLD_BYT;
					break;

				case SEP_NUM:
					FieldType = FLD_NUM;
					break;

				case SEP_STR:
					FieldType = FLD_STR;
					break;

				case SEP_LIN:
					FieldType = FLD_LIN;
					break;
			}
		}

/*
		Zapamitujemy znalezione pola (teksty) w tablicach dynamicznych (vector...) - 
		z rodzajem pola i jego dugoci.
*/
		AddField( (char *) & aDataPtr[FieldOffsNdx], FieldType, StrLen );

/*
		Na potrzeby zgodnoci ze star bibliotek (PosnetDf.dll) odtwarzam separator,
		tak, aby mona zwrci "surowe" pole danych.
*/
		aDataPtr[FieldOffsNdx + StrLen] = FieldSeparator;

		FieldOffsNdx += ( StrLen + 1 );
	}
		
	return SOK;
}

/******************************************************************************/

int CThermalResponse::CreateRespStruct( BYTE	aProtocolType, tRESPONSE *aResponseStruct )
{
	static BYTE FieldType,		/* Rodzaj pola */
		TrueFieldType,
		TmpFieldType,
		*RespFieldsPtr;

	BYTE *DescrPtr;

	static DWORD FieldNr,
		TmpNum,
		DescrLen,
		i;

	FieldNr = 0;

	DescrLen = aResponseStruct->DescriptionLen;
	DescrPtr = aResponseStruct->Description;
	RespFieldsPtr = aResponseStruct->FieldsStruct;

/*
	Czy liczba pl w ramce odebranej odpowiada liczbie pl dostarczonego opisu ?
*/
	if( DescrLen != GetFieldCount() )
	{
		return ERR_NUMBER_OF_FIELDS;
	}

/*
	Przegldamy list pl i na podstawie ich typw generujemy struktur komunikatu (- odpowiedzi
	lub rozkazu).
*/
	for( i = 0; i < DescrLen; i++ )
	{
/*
		Sprawdzimy czy rodzaje pl wzitych z ramki zgodne s z dostarczonym opisem.

		Uwaga (0) - [do obu wersji] na podstawie terminatora nie ma moliwoci rozrnienia czy jest to
								FLD_NUM czy FLD_NUM_EXT (bo to jest wewntrzne rozrnienie).
		Uwaga (1) -	[werja woska] - adnie i piknie, porzdek... ;-)
		Uwaga (2) -	[wersja polska] tutaj panuje zbyt duy baagan; waciwie tylko pola bajtowe
								i to jeszcze nie wszystkie (bo ostatnie nie) posiadaj porzdne separatory (terminatory ?).
								Sprawdzanie bdzie dotyczy przede wszystkim pl bajtowych, pozostae - czy separator
								jest taki jak dla pola numerycznego (slash /).
								W tablicy opisujcej pola mona wymusi inny terminator. 
*/
		FieldType = DescrPtr[i] & FLD_TYPE_MASK;	/* rodzaj pola - z tablicy opisujcej */

		if( aProtocolType & PROTO_ITALIAN )				/* woski */
		{
			if( FieldType !=  GetFieldType(i) )
			{
				if( (GetFieldType(i) != FLD_NUM) && (FieldType != FLD_NUM_EXT) )
				{
					return ERR_FIELD_TYPE;
				}
			}
		}
		else																		/* polski ... */
		{
			TrueFieldType = GetTrueFieldType( DescrPtr[i] );
			TmpFieldType = GetFieldType(i);

/*
			Sprawdza zgodno mona tylko wtedy, gdy jaki terminator jest - a niektre z ostatnich pl
			nie maj (FLD_UNK)...
*/
			if( (TmpFieldType != FLD_UNK) && (TrueFieldType !=  TmpFieldType) )
			{
				if( (TmpFieldType != FLD_NUM) && (TrueFieldType != FLD_NUM_EXT) )
				{
					return ERR_FIELD_TYPE;
				}
			}
		}

/*
		FieldType - rodzaj pola wzity z opisu rozkazu a nie z ramki - ze wzgldu na baagan w wersji
		polskiej, a w wersji woskiej FLD_NUM i FLD_NUM_EXT (to rozrnienie wprowadziem sam)
*/
		switch( FieldType )		/* NO DEFAULT !!! - NOT REQUIRED */
		{
			case FLD_BYT:				/* sprawdzimy czy rzeczywicie jest to bajt */
				if( (sscanf(GetFieldText(i), "%d", & TmpNum) != 1) || (TmpNum > 256) )
				{
					return ERR_FIELD_CONTENTS;
				}

				*RespFieldsPtr = (BYTE) TmpNum;
				RespFieldsPtr += sizeof( BYTE );
				break;

			case FLD_NUM:				/* DWORD w odrnieniu od FLD_NUM_EXT, ktry jest stringiem */	
				if( sscanf(GetFieldText(i), "%d", & TmpNum) != 1 )
				{
					return ERR_FIELD_CONTENTS;
				}

				*( (DWORD *) RespFieldsPtr ) = TmpNum;
				RespFieldsPtr += sizeof( DWORD );
				break;

/*
			Pozostae rodzaje pl - stringi
*/	
			case FLD_NUM_EXT:		/* NO BREAK HERE !!! */
			case FLD_STR:				/* NO BREAK HERE !!! */
			case FLD_LIN:
				*( (char **) RespFieldsPtr ) = GetFieldText(i);
				RespFieldsPtr += sizeof( char * );
				break;
		}
	}
		
	return SOK;
}

/******************************************************************************/

DWORD CThermalResponse::GetExtendedErrorCode()
{
	return ExtendedErrorCode;
}

/******************************************************************************/

void CThermalResponse::GetDataFieldDescr( DWORD *aLenOut, BYTE **aPtrOut )
{
	*aLenOut = DataLen;
	*aPtrOut = DataPtr;
}

/******************************************************************************/

void CThermalResponse::AddField( char *aStrPtr, BYTE aFieldType, DWORD aStrLen )
{
	VectOfTextFields.push_back( aStrPtr );
	VectOfFieldTypes.push_back( aFieldType );
	VectOfTextLengths.push_back( aStrLen );
	FieldCount++;
}

/*----------------------------------------------------------------------------*/

DWORD CThermalResponse::GetFieldCount()
{
	return FieldCount;
} 

/*----------------------------------------------------------------------------*/

BYTE CThermalResponse::GetFieldType( DWORD aFieldNdx )
{
	_ASSERTE( aFieldNdx < VectOfFieldTypes.size() );

	return VectOfFieldTypes[aFieldNdx];
}

/*----------------------------------------------------------------------------*/

DWORD CThermalResponse::GetFieldLength( DWORD aFieldNdx )
{
	_ASSERTE( aFieldNdx < VectOfTextLengths.size() );

	return VectOfTextLengths[aFieldNdx];
}

/*----------------------------------------------------------------------------*/

char * CThermalResponse::GetFieldText( DWORD aFieldNdx )
{
	_ASSERTE( aFieldNdx < VectOfTextFields.size() );

	return (char *) VectOfTextFields[aFieldNdx].c_str();
}

/*----------------------------------------------------------------------------*/

void CThermalResponse::SetFieldText( DWORD aFieldNdx, char * aFieldText )
{
	_ASSERTE( aFieldNdx < VectOfTextFields.size() );
	_ASSERTE( aFieldText );

	VectOfTextFields[aFieldNdx] = aFieldText;
	VectOfTextLengths[aFieldNdx] = strlen( aFieldText );
}
