/* Tab 2 */

/*
	ThermalCommand.h - plik nagwkowy dla ThermalCommand.cpp
*/

#ifndef _THERMAL_COMMAND
#define _THERMAL_COMMAND

#include "StdAfx.h"
#include "..\\CommonTexts.h"
#include "..\\ThermalServiceLibrary.h"
#include "FunctionDeclarations.h"

#define LBSERM_PS_MAX 3

extern DWORD ExtendedErrorCode;

class CThermalCommand
{
public:
	CThermalCommand();
	~CThermalCommand();

/*
	Clear
		Wyczy rozkaz (== inicjalizacja)

	Argumenty:
		---

	Zwraca:
		---
*/
	void Clear();


/*
	GetErrorMessage
		Pobierz komunikat o bdzie zasygnalizowanym przez urzdzenie
		
	Argumenty wejciowe:
		aExtendedErrorCode	- rozszerzony kod bdu (zawierajcy kod rozkazu i kod bdu)

	Argumenty wyjciowe:
		aStrOutPtr					- /PTR to PTR/ pod ten adres zostanie wpisany wskanik do tekstu

	Zwraca:
		TRUE jeli wygenerowano opis bdu (warunkiem jest poprawna skadnia kodu bdu),
		FALSE jeli nie
*/
	BOOL GetErrorMessage( DWORD aExtendedErrorCode, char **aStrOutPtr );


/*
	Translate
		Zamie rozkaz z zewntrznej postaci (cig rozkazowy, struktura argumentw wraz z
		tablic opisujc rodzaje pl struktury i ich dozwolonymi wartociami, na posta
		wewntrzn (wektory: tekstw, rodzajw pl, dugoci tekstw)

	Argumenty wejciowe:
		aCommandPtr					-	/PTR/ cig rozkazowy
		aFieldDescrTabLen		- wielko tablicy opisujcej pola struktury ( sizeof(...) )
		aFieldDescrTabPtr		-	/PTR/ tablica opisujca pola struktury
		aArgStructPtr				- /PTR/ struktura z argumentami rozkazu

	Zwraca:
		SOK									- gdy operacja zakoczya si pomylnie
		ERR_ACCESS_VIOLATION
		ERR_PARAM_VALUE
		ERR_PARAM_LEN
		
	Uwagi:
		1. aFieldDescrTabLen - podajemy wielko tablicy (jej elementy to struktury),
			natomiast liczba pl jest wyliczana wewntrz Translate
		2. kody bdw zawieraj w sobie indeks (liczony od zera) argumentu, ktry spowodowa
			bd (suma logiczna maski oznaczajcej kod bdu i indeksu)
*/
	int Translate( BYTE	aProtocolType, char *aCommandPtr, DWORD aFieldDescrTabLen,
										 tPARAMETER_DESCRIPTION *aFieldDescrTabPtr,	BYTE *aArgStructPtr );


/*
	CreateFrame
		Utwrz kompletn ramk - pobierajc dane z wewntrznej postaci rozkazu

	Argumenty wejciowe:
		aMaxNrOfBytes				- dugo bufora wyjciowego (= maks. liczba bajtw)
		aOutBufPtr					-	/PTR/ bufor wyjciowy

	Argumenty wyjciowe:
		aBytesWrittenPtr		- /PTR/ jeli zostanie podany (!=NULL) to wpisana tam bdzie
													liczba bajtw wpisanych do bufora
	Zwraca:
		SOK
		ERR_FRAME_TOO_LONG	- gdy bufor bdzie za krtki (ramka si nie zmieci)
*/
	int CreateFrame( DWORD aMaxNrOfBytes, BYTE *aOutBufPtr, DWORD *aBytesWrittenPtr );


/*
	SetCmdString
		Ustaw cig rozkazowy (- posta wewntrzna rozkazu)
	
	Argumenty wejciowe:
		aCmdStringPtr				- /PTR/ cig rozkazowy (dwuznakowy)

	Zwraca:
		---
*/
	void SetCmdString( char *aCmdStringPtr );


/*
	GetParam
		Pobierz parametr (ju po konwersji na tekst)

	Argumenty wejciowe:
		aParamNdx						- indeks (od zera) parametru

	Zwraca:
		dany parametr (obiekt klasy 'string')
*/
	string GetParam( DWORD aParamNdx );


/*
	GetParamCount
		Pobierz liczb parametrw

	Argumenty:
		---

	Zwraca:
		liczb parametrw
*/
	DWORD GetParamCount();


/*
	GetRequiredFrameBufferLength
		Pobierz wymagan dugo bufora dla ramki

	Argumenty:
		---

	Zwraca:
		dugo bufora
*/
	DWORD GetRequiredFrameBufferLength();


/*
	AddByteParam
		Dodaj do wewntrznej reprezentacji rozkazu parametr bajtowy

	Argumenty wejciowe:
		aParam							- parametr
		aFieldSep						- rodzaj separatora/terminatora (jeli nie jest zgodny z rodzajem pola)
		aMin								- warto minimalna
		aMax								- warto maksymalna

	Zwraca:
		SOK
		ERR_PARAM_VALUE			- gdy warto nie mieci si wewntrz podanego zakresu

	Uwagi:
		aMin i aMax oba rwne zero -> brak kontroli
*/
	int AddByteParam( BYTE aParam, BYTE aFieldSep = 0, BYTE aMin = 0, BYTE aMax = 0 );

/*
	AddNumericParam
		Dodaj do wewntrznej reprezentacji rozkazu parametr numeryczny (DWORD)

	Argumenty wejciowe:
		aParam							- parametr
		aFieldSep						- rodzaj separatora/terminatora (jeli nie jest zgodny z rodzajem pola)
		aMin								- warto minimalna
		aMax								- warto maksymalna

	Zwraca:
		SOK
		ERR_PARAM_VALUE			- gdy warto nie mieci si wewntrz podanego zakresu

	Uwagi:
		aMin i aMax oba rwne zero -> brak kontroli
*/
	int AddNumericParam( DWORD aParam, BYTE aFieldSep = 0, DWORD aMin = 0, DWORD aMax = 0 );

/*
	AddNumericParamExt
		Dodaj do wewntrznej reprezentacji rozkazu parametr numeryczny w postaci zewntrznej

	Argumenty wejciowe:
		aParamPtr						- /PTR/ struktura, przez ktr przekazywany jest parametr
		aFieldSep						- rodzaj separatora/terminatora (jeli nie jest zgodny z rodzajem pola)
		aMaxLen							- maks. dugo tekstowej reprezentacji (cznie z kropk)
		aMaxIntg						- maks. dugo czci cakowitej
		aMaxFact						- maks. dugo czci uamkowej

	Zwraca:
		SOK
		ERR_PARAM_LEN				- gdy nieprawidowa dugo (caoci lub czci)
		ERR_FIELD_TYPE			- gdy cig nie odpowiada wartoci numerycznej

	Uwagi:
		aMaxLen rwne 0 wycza dalsze sprawdzanie dugoci
		aMaxIntg i aMaxFact oba rwne zero - nie bd sprawdzane dugoci czci, natomiast
			moe by sprawdzana dugo caoci (zaley od aMaxLen)
*/
	int AddNumericParamExt( tEXTERNAL_NUMERIC *aParamPtr, BYTE aFieldSep = 0, BYTE aMaxLen = 0, BYTE aMaxIntg = 0, BYTE aMaxFact = 0 );

/*
	CheckNumericParamExt
		Sprawd poprawno (skadniow) postaci tekstowej wartoci numerycznej.
		- Funkcja pomocnicza wykorzystywana przez AddNumericParamExt

	Argumenty wejciowe:
		aParamPtr						- /PTR/ tekst
		aLen								- dugo tekstu
		aMaxIntg						- maks. dugo czci cakowitej
		aMaxFact						- maks. dugo czci uamkowej

	Zwraca:
		SOK
		ERR_PARAM_LEN				- gdy nieprawidowa dugo
		ERR_FIELD_TYPE			- gdy cig nie odpowiada wartoci numerycznej

	Uwagi:
		aMaxIntg i aMaxFact oba rwne zero -> bez sprawdzania dugoci
*/
	int CheckNumericParamExt( char *aParamPtr, BYTE aLen, BYTE aMaxIntg, BYTE aMaxFact );

/*
	AddStringParam
		Dodaj do wewntrznej reprezentacji rozkazu parametr tekstowy
			
	Argumenty wejciowe:
		aParamPtr						- /PTR/ tekst
		aFieldSep						- rodzaj separatora/terminatora (jeli nie jest zgodny z rodzajem pola)
		aMaxLen							- maks. dugo cigu

	Zwraca:
		SOK
		ERR_PARAM_LEN				- gdy nieprawidowa dugo cigu

	Przy podaniu zerowego wskanika zapamitany zostanie cig pusty,
	ale w	pole dugoci wpisany bdzie specjalny	znacznik - STR_EMPTY.
	W takim przypadku pole to nie bdzie obecne w ramce (dotyczy rwnie separatora).
*/
	int AddStringParam( char *aParamPtr, BYTE aFieldSep = 0, BYTE aMaxLen = 0 );

/*
	AddLineParam
		Dodaj do wewntrznej reprezentacji rozkazu parametr tekstowy - dug lini
		(rnica pomidzy AddStringParam a AddLineParam jest jedna - zapamitany zostanie
		inny rodzaj pola, co da w wyniku inny separator)
			
	Argumenty wejciowe:
		aParamPtr						- /PTR/ tekst
		aFieldSep						- rodzaj separatora/terminatora (jeli nie jest zgodny z rodzajem pola)
		aMaxLen							- maks. dugo cigu

	Zwraca:
		SOK
		ERR_PARAM_LEN				- gdy nieprawidowa dugo cigu

	Uwagi: jak przy AddStringParam
*/
	int AddLineParam( char *aParamPtr, BYTE aFieldSep = 0, BYTE aMaxLen = 0 );


/*
	ConcatenateParam
		Docz do wybranego parametru (po konwersji na tekst) podany cig
	
	Argumenty wejciowe:
		aParamNdx						- indeks (od zera) parametru
		aStringPtr					- /PTR/ cig ktry naley doda
	
	Zwraca:
		---
*/
	void ConcatenateParam( DWORD aParamNdx, char *aStringPtr );


/*
	AddField
		Dodaj pole (parametr) do wewntrznej reprezentacji rozkazu

	Argumenty wejciowe:
		aStrPtr							- /PTR/ parametr (w postaci tekstowej)
		aFieldType					- rodzaj pola:
														FLD_BYT - bajtowe
														FLD_NUM - numeryczne
														FLD_STR - tekstowe
														FLD_LIN - tekstowe wieloliniowe
		aStrLen							- dugo tekstu (parametru) lub
													STR_EMPTY jeli ma to by puste pole

	Zwraca:
		---
*/
	void AddField( char *aStrPtr, BYTE aFieldType, DWORD aStrLen );


/*
	InsertParam
		Wstaw nowy parametr (tekst) do wewntrznej reprezentacji rozkazu

	Argumenty wejciowe:
		aParamNdx						- indeks (od zera) parametru przed ktrym zostanie wstawiony nowy tekst
		aFieldType					- rodzaj pola:
														FLD_BYT - bajtowe
														FLD_NUM - numeryczne
														FLD_STR - tekstowe
														FLD_LIN - tekstowe wieloliniowe
		aStringPtr					- /PTR/ tekst, ktry naley wstawi

	Zwraca:
		---
*/
	void InsertParam( DWORD aParamNdx, BYTE aFieldType, char *aStringPtr );


/*
	Send, Send2   (Send to nakadka na Send2, dodane jest flush-owanie logu)
		Generuje a nastpnie wysya ramk rozkazow.
	
	Argumenty:
		---
	
	Zwraca:
		SOK
		ERR_PORT_NOT_OPEN	- prba wysania do portu, ktry nie zosta otwarty
		ERR_FRAME_TOO_LONG - gdy bufor za krtki (ramka si nie zmieci)
		ERR_WRITE_FILE_COM - bd zapisu do portu
		ERR_WRITE_FILE		- bd zapisu do pliku (log) - jeli wczone jest logowanie
*/
	int Send();
	int Send2();


/*
	GetExtendedErrorCode
		Pobierz rozszerzony kod bdu -> w niektrych rozkazach zwracane s dodatkowe
		inforamcje o bdach.

	Argumenty:
		---
	
	Zwraca:
		kod bdu.
*/
	DWORD GetExtendedErrorCode();


/*
	GetProtocolType
		Zwr rodzaj protokou (zapamitany przy Translate(...))

	Argumenty:
		---
	
	Zwraca:
		rodzaj protokou (PROTOCOL_ITALIAN..., PROTOCOL_OLD...)
*/
	BYTE GetProtocolType();



/*
	Zmienne
*/
													/* Flagi: */
	BOOL F_Resp,						/* obecno odpowiedzi */
		F_Italian,						/* protok woski */
		F_ItalianRemote,			/* protok woski, Remote PC */
		F_RxChksum,						/* suma kontrolna w ramce nadawanej */
		F_TxChksum;						/* suma kontrolna w ramce odbieranej */

protected:
	char	CmdString[CMD_CMD_STR_LEN+1];

	DWORD	ParamCount,											/* Parameter Count */
		ByteParamCount;											/* Byte Parameter Count */

	BYTE ProtocolType;

/*
	Ponisze trzy obiekty dotycz ramki wysyanej
*/
	tVectorOfStrings	VectOfTextFields;		/* argumenty rozkazu zamienione na stringi */
	tVectorOfBytes		VectOfFieldTypes;		/* rodzaj argumentu -> wyznacza separator */
	tVectorOfDwords		VectOfTextLengths;	/* dugo argumentu zamienionego na tekst */



/*
	RemoveDot
		Usu kropk z tekstowej postaci wartoci numerycznej (to dla protokou woskiego)
	
	Argumenty wejciowe:
		aNumericInPtr				- /PTR/ cig wejciowy

	Argumenty wyjciowe:
		aNumericInPtr				- /PTR/ cig wyjciowy (jeli nie byo kropki w wejciowym - to 
													zostanie tam skopiowany cig wejciowy
	Zwraca:
		TRUE jeli kropka zostaa usunita - wtedy cig wyjciowy jest o jeden znak krtszy 
		od wejciowego
*/
	BOOL RemoveDot( char * aNumericInPtr, char * aNumericOutPtr );


};

#endif // _THERMAL_COMMAND