/* Tab 2 */

/*
	FunctionDeclarations.h
	deklaracje funkcji globalnych, ktre s czsto uywane w ThermalServiceLibrary.cpp,
	ThermalCommand.cpp, ThermalResponse.cpp i ComPort.h
	(pozostae funkcje to te, ktre s eksportowane z DLL-a i nie musz mie deklaracji)
*/

#ifndef _FUNCTION_DECLARATIONS
#define _FUNCTION_DECLARATIONS

/*
	GetStatus_CashRegister
		Pobierz status (stan) kasy

	Argumenty wyjciowe:
		aStatusOutPtr					- /PTR/ struktura z flagami opisujcymi stan kasy

	Zwraca:
		SOK
		ERR_READ_FILE_COM			- bd przy odczycie z portu
		ERR_NO_RESPONSE				- brak odpowiedzi
		ERR_FMT_ENQ						- bdna odpowied (zy format)
*/
int GetStatus_CashRegister( tCASH_REGISTER_STATUS *aStatusOutPtr );


/*
	GetStatus_Printer
		Pobierz status (stan) drukarki

	Argumenty wyjciowe:
		aStatusOutPtr					- /PTR/ struktura z flagami opisujcymi stan drukarki

	Zwraca:
		SOK
		ERR_READ_FILE_COM			- bd przy odczycie z portu
		ERR_NO_RESPONSE				- brak odpowiedzi
		ERR_FMT_DLE						- bdna odpowied (zy format)
*/
int GetStatus_Printer( tPRINTER_STATUS *aStatusOutPtr );


/*
	ErrorMessage
		Wywietl komunikat (podany z zewntrz) o bdzie.
		Analizuje przekazany kodu bdu (zwrcony przez funkcje).
		Rozpoznaje ERR_RETURN_CODE i wtedy pobiera rozszerzony kod bdu oraz
		go interpretuje, dopisujc do podanego tekstu kod rozkazu i numer bdu.

	Argumenty wejciowe:
		aStrPtr								- tekst (bdzie wypisany na pierwszym miejscu)
		aReturnCode						- kod bdu

	Zwraca:
		---
*/
void ErrorMessage( char *aStrPtr, int aReturnCode );


/*
	TimeoutDialog
		Wywietl okienko dialogowe z zapytaniem o reakcj na Timeout (czy czeka
		dalej)

	Argumenty:
		---

	Zwraca:	
		IDYES									- uytkownik chce czeka dalej								
		IDNO									- uytkownik nie chce czeka
*/
int TimeoutDialog();


/*
	GetTrueFieldType
		Pobierz prawdziwy rodzaj pola (ten ze struktury opisujcej a nie wyznaczony
		na podstawie terminatora pola)

	Argumenty wejciowe:
		aFieldType						- rodzaj pola

	Zwraca:	
		rodzaj pola (FLD_...)
*/
BYTE GetTrueFieldType( BYTE aFieldType );


/*
	SeparatorFromFieldType
		Pobierz separator/terminator dla danego typu pola i protokou

	Argumenty wejciowe:
		aFieldType						- rodzaj pola
		aProtoItalian					- TRUE dla protokou woskiego, FALSE dla polskiego

	Zwraca:	
		znak separatora/terminatora
*/
char SeparatorFromFieldType( BYTE aFieldType, BOOL aProtoItalian );


/*
	FindFrameEnd
		Znajd koniec ramki

	Argumenty wejciowe:
		aBufferPtr						- adres bufora
		aNrOfBytesInBuffer		- liczba bajtw w buforze

	Argumenty wyjciowe:
		aEndMarkOffsPtr				- /PTR/ pod ten adres zostanie wpisany offset znalezionego
														znacznika koca ramki (o ile zosta znaleziony)
	Zwraca:
		TRUE jeli znaleziono znacznik koca ramki
		FALSE gdy nie znaleziono
*/
BOOL FindFrameEnd( BYTE *aBufferPtr, DWORD aNrOfBytesInBuffer, DWORD *aEndMarkOffsPtr );


/* Execute zakomentowane ze wagldu na CThermalCommand i CThermalResponse */
#if 0

/*
	Execute
		Wykonaj rozkaz (wygeneruj i wylij ramk oraz ewentualnie czekaj na
		odpowied a jeli	zawiera ona pola danych - to je wczytaj/przekonwertuj)

	Argumenty wejciowe:
		aCThCmd								- /PTR/ rozkaz (obiekt)
		aCThResp							- /PTR/ odpowied (obiekt)
		aResponseTime					- jak dugo czeka na odpowied
		
	Zwraca:
		SOK										- gdy operacja zakoczya si pomylnie
		ERR_RETURN_CODE				- odpowied z kodem bdu -> GetExtendedErrorCode()
														aby pobra kod bdu i kod rozkazu
		ERR_NO_RESPONSE				- cakowity brak odpowiedzi
		ERR_RESPONSE_TIMEOUT	- przekroczony czas oczekiwania na zakoczenie odpowiedzi
		ERR_INPUT_BUF_OVRRUN	- przepeniony bufor wejciowy
		ERR_FMT_HEADER				- nieprawidowe pole znacznika pocztku ramki
		ERR_FMT_RETURN_CODE		- nieprawidowe pole kodu bdu
*/
	int Execute( CThermalCommand *aCThCmd, CThermalResponse *aCThResp,
									DWORD aResponseTime = NORMAL_RESPONSE_TIME );

#endif // 0

/*
	GenerateChecksum
		Wyznacza sum kontroln
	
	Argumenty wejciowe:
		aDataPtr						- /PTR/ pocztek obszaru, z ktrego zostanie wyliczona suma kontrolna
		aNrOfBytes					- liczba bajtw, ktre wejd do sumy kontrolnej
	
	Zwraca:
		sum kontroln
*/
BYTE GenerateChecksum( BYTE *aDataPtr, DWORD aNrOfBytes );


/*
	ConvertNumericToAmount
		Zamienia warto numeryczn na kwot (obsuga rozkazw woskich) - przerabia
		tekstowo podan warto na posta z kropk - o ile dotyczy to Euro.

	Argumenty wejciowe:
		aNumStrIn						- /PTR/ warto, ktr naley przekonwertowa
		aEuroMode						- TRUE, jeli tryb Euro
	
	Zwraca:
		wskanik do przekonwertowanego cigu (nie wolno zmienia cigu, jeli zajdzie potrzeba,
		trzeba wczeniej skopiowa)
*/
char * ConvertNumericToAmount( char *aNumStrIn, BOOL aEuroMode );


/*
	ConvertNumericToQuantity
		Zamienia warto numeryczn na ilo (obsuga rozkazw woskich) - przerabia
		tekstowo podan warto na posta z kropk.

	Argumenty wejciowe:
		aNumStrIn						- /PTR/ warto, ktr naley przekonwertowa
	
	Zwraca:
		wskanik do przekonwertowanego cigu (nie wolno zmienia cigu, jeli zajdzie potrzeba,
		trzeba wczeniej skopiowa)
*/
char * ConvertNumericToQuantity( char *aNumStrIn );


/*
	GetDeviceErrorMessage
		Pobierz tekst komunikatu o bdzie zasygnalizowanym przez urzdzenie
		(kod rozkazu i numer bdu)

	Argumenty wejciowe:
		aExtendedErrorCode	- rozszerzony kod bdu (kod rozkazu i numer bdu spakowane do DWORDa)
	
	Argumenty wejciowe:
		aStrOutPtr					- /PTR to PTR/ tu zostanie wpisany adres wygenerowanego tekstu komunikatu
													(nie naley modyfikowa zawartoci tekstu !)

	Zwraca:
		TRUE jel rozszerzony kod bdu mia prawidow posta i wygenerowany zosta komunikat,
		FALSE w przeciwnym razie
*/
BOOL GetDeviceErrorMessage( DWORD aExtendedErrorCode, char **aStrOutPtr );

/*
	GetDeviceExtErrorCode
		Pobierz (rozszerzony) kod bdu (ma sens tylko gdy urzdzenie zasygnalizuje bd)

	Argumenty:
		---

	Zwraca:
		(rozszerzony) kod bdu
*/
DWORD GetDeviceError();

/*
	Send_ACK, Send_NACK, Send_CAN, Send_BEL
		Wylij odpowiednio:
			ACK (potwierdzenie pozytywne)
			NACK (potwierdzenie negatywne)
			CAN (taki "soft reset" parsera)
			BEL (sygna dwikowy)

	Argumenty:
		---

	Zwraca:
		---
*/
void Send_ACK();
void Send_NACK();
void Send_CAN();
void Send_BEL();



/*
	CheckDate
		Sprawdza czy podana data jest poprawna - ale jedynie pod wzgldem zakresw wartoci.
		Nie jest sprawdzane czy dany dzie istnieje.

	Argumenty wejciowe:
		aYear								- rok
		aMonth							- miesic
		aDay								- dzie

	Argumenty wyjciowe:
		aOffendingArg				- /PTR/ tu zostanie wpisany indeks parametru, ktry wykracza poza
													dozwolony zakres
	Zwraca:
		TRUE jeli data jest poprawna
		FALSE jeli nie (wtedy te wpisana zostanie warto w aOffendingArg)
		
*/
BOOL CheckDate( BYTE aYear, BYTE aMonth, BYTE aDay, BYTE * aOffendingArg );

#endif // _FUNCTION_DECLARATIONS