/* Tab 2 */

/*
	ComPort.h - plik nagwkowy dla ComPort.cpp
*/

#ifndef _COM_PORT
#define _COM_PORT

#include "StdAfx.h"
#include "..\\ThermalServiceLibrary.h"
#include "FunctionDeclarations.h"

#define MAX_LOG_LINE 16

extern DWORD ExtendedErrorCode;

class CComPort
{
public:
	CComPort();
	~CComPort();


/*
	Open
		Otwiera i konfiguruje wybrany port, allokuje obszary pamici na bufory (wejciowy i wyjciowy)
	
	Argumenty wejciowe:
		aPortNamePtr				-	nazwa portu (taka, pod jak wystpuje w systemie)
		aBaudRate						- prdko transmisji (podana wprost, CBR_...)

	Zwraca:
		SOK									- port zosta otwarty
		ERR_COMM_SETTINGS
		ERR_CREATE_FILE
		ERR_ALLOC
*/
	int Open( char *aPortNamePtr, DWORD aBaudRate );


/*
	WasPortOpened
		Czy port zosta otwarty ?
	
	Argumenty:						---
	
	Zwraca:
		TRUE jeli otwarty, FALSE jeli nie
*/
	BOOL WasPortOpened();


/*
	SetBaudRate
		Ustaw prdko transmisji
	
	Argumenty wejciowe:
		aRate								- prdko transmisji (podana wprost)

	Zwraca:
		SOK
		SERROR
*/
	int SetBaudRate( DWORD aRate );


/*
	Write
		Zapisz (wylij) cig bajtw
	
	Argumenty wejciowe:
		aNrOfBytes					-	liczba bajtw do wysania
		aDataPtr						- /PTR/ pocztek obszaru do wysania

	Zwraca:
		SOK
		ERR_WRITE_FILE
		ERR_WRITE_FILE_COM

*/
	int Write( DWORD aNrOfBytes, BYTE * );

	
/*
	Read
		Odczytaj (odbierz) cig bajtw. Timeouty s ustalone z gry (po otwarciu portu)
	
	Argumenty wejciowe:
		aNrOfBytes					- liczba bajtw do odebrania
		aNrOfBytesReadPtr		- /PTR/ bufor do ktrego zostan wpisane odebrane bajty

	Argumenty wyjciowe:
		aDataPtr						- /PTR/ tu zostanie wpisana liczba bajtw odczytanych
	
	Zwraca:
		SOK
		ERR_READ_FILE_COM
		ERR_WRITE_FILE
*/
	int Read( DWORD aNrOfBytes, DWORD *aNrOfBytesReadPtr, BYTE *aDataPtr );


/*
	SendSingleByte
		Wylij pojedynczy bajt (np. ACK czy NACK)
	
	Argumenty wejciowe:
		aByte								- bajt do wysania

	Zwraca:
		SOK
		ERR_WRITE_FILE_COM
		ERR_WRITE_FILE
*/
	int SendSingleByte( BYTE aByte );


/*
	ClearRxQueue
		Czyszczenie kolejki wejciowej (usuwa wszystkie bajty czekajce w buforze wejciowym)
	
	Argumenty:						---

	Zwraca:								---
*/
	void ClearRxQueue();


/*
	WaitForAnyByte
		Oczekiwanie na odbir bajtu (dowolnego) - z ewentualnym jego zapamitaniem
	
	Argumenty wejciowe:
		aTimeout						-	maks. czas oczekiwania (milisekundy)

	Argumenty wyjciowe:
		aFetchedBytePtr			- /PTR/ jeli != NULL to pod ten adres zostanie wpisany odebrany bajt
	
	Zwraca:
		SOK
		ERR_NO_RESPONSE
		ERR_COMM_SETTINGS
		ERR_READ_FILE_COM
		ERR_WRITE_FILE
*/
	int WaitForAnyByte( DWORD aTimeout, BYTE *aFetchedBytePtr );


/*
	Close
		Zamyka port (i usuwa zaallokowane bufory)
	
	Argumenty:						---

	Zwraca:
		SOK
		SERROR							- gdy prbowano zamkn port bez wczeniejszego otworzenia;
												  lub nie powiodo si zamknicie portu
		ERR_WRITE_FILE			- logowanie
*/
	int Close();


/*
	LoggingStart
		Rozpoczcie logowania transmisji do pliku
	
	Argumenty wejciowe:
		aFileNamePtr				- /PTR/ nazwa (scieka dostpu) pliku
	
	Zwraca:
		SOK
		ERR_CREATE_FILE
*/
	int LoggingStart( char *aFileNamePtr );


/*
	LoggingStop
		Zakoczenie logowania 
	
	Argumenty wejciowe:	---

	Zwraca:
		SOK
		SERROR
		ERR_WRITE_FILE_COM
*/
	int LoggingStop();


/*
	LogUpdate
		Uaktualnienie logu (dodanie sekwencji bajtw zapisywanych / odczytywanych )

	Argumenty wejciowe:
		aLogOperation				- operacja: zapis (LOG_WRITE) / odczyt (LOG_READ)
		aNrOfBytes					- liczba bajtw do dodania do logu
		aDataPtr						- /PTR/ pocztek bufora, z ktrego pobrane zostan bajty

		Zwraca:
		SOK
		...
*/
	int LogUpdate( enum LOG_OPERATION aLogOperation, DWORD aNrOfBytes, BYTE *aDataPtr );


/*
	LogCreateHexAndWrite
		Wygenerowanie linii tekstowej i zapis do pliku
	
	Argumenty:						---
	
	Zwraca:
		SOK
		ERR_WRITE_FILE
*/
	int LogCreateHexAndWrite();

/*
	WriteToLog
		Funkcja pomocnicza - zapis do mailslota i ewentualnie do pliku logu.
	
	Argumenty wejciowe:
		aBufferAddr					-	adres bufora
		aBytesToWrite				- liczba bajtw do zapisu
		aLogAlso						- TRUE jeli dane maj by wysane rwnie do pliku

	Argumenty wyjciowe:
		aBytesWrittenPtr		- /PTR/ tu bdzie wpisana liczba bajtw zapisanych

	Zwraca:
		SOK
		ERR_...
*/
	int WriteToLog( BYTE * aBufferAddr, DWORD aBytesToWrite, DWORD * aBytesWrittenPtr, BOOL aLogAlso );

/*
	LogFlush
		Funkcja oprnia wyjciowy bufor logu - wysyajc zawarto do mailslota/pliku
		(w trakcie normalnej pracy takie oprnienie nastpuje przy zmianie operacji - R/W)

	Argumenty:						---
	
	Zwraca:
		SOK
		ERR_...
*/
	int LogFlush();


/*
	A tu s zmienne...
*/
	BYTE *PortOutBuf,				/* Bufor wyjciowy (transmisja) */
		*PortInBuf;						/* Bufor wejciowy */


protected:

/*
	CleanUp
		Czyszczenie zmiennych i usuwanie buforw zwizanych z portem komunikacyjnym
	
	Argumenty:						---

	Zwraca:								---
*/
	void CleanUp();


/*
	A tu s zmienne...
*/
	HANDLE hCom,						/* - handle portu komunikacyjnego */
		hLogFile,							/* - handle pliku (log) */
		hMailSlut;						/* - handle Mailslota (log) */

	DCB Dcb;								/* DCB */
	COMMTIMEOUTS Timeouts;	/* COMMTIMEOUTS */

	enum LOGGING_STATES LoggingState;				/* Stan logowania (aktywne czy nie) */
	enum LOG_OPERATION	LogLastOperation;		/* Ostatnia operacja (zapis lub odczyt) */

	DWORD LogLineLen;				/* Liczba bajtw w buforze linii bajtowej (log) */

	BYTE LogByteLineBuf[MAX_LOG_LINE];			/* Bufor linii bajtowej (log) */
	char LogStrLineBuf[MAX_LOG_LINE*4 + 5];	/* Bufor linii tekstowej (log)  */
};

#endif // _COM_PORT