/* Tab 2 */

/*
	ErrorCodes.h - kody bdw
*/

#ifndef _ERROR_CODES
#define _ERROR_CODES

/****************************** KODY BDW ***********************************/

/*
	Uwaga na:
	ERR_ACCESS_VIOLATION, ERR_PARAM_VALUE, ERR_PARAM_LEN, ERR_FIELD_TYPE
	Na modszym sowie bd miay numer argumentu (liczony od zera), ktry
	spowodowa ten bd
	Zdefiniowana jest maska bitowa ERR_SPECIAL_MASK, suca do wykrywania tych
	bdw
*/

#define ERR_SPECIAL_MASK							 0xFFFF0000

/* wszystko w porzdku */
#define SOK														 0

/* wystpi bd (kiedy nie jest konieczne blisze sprecyzowanie rodzaju) */
#define SERROR												-1

/* dostp do nieprawidowego obszaru pamici */
#define ERR_ACCESS_VIOLATION					0xC0000000

/* bd allokacji pamici */
#define ERR_ALLOC											-2

/* bd CreateFile(...) - w przypadku plikw dyskowych */
#define ERR_CREATE_FILE								-3

/* bd CreateFile(...) - w przypadku portu komunikacyjnego  */
#define ERR_CREATE_FILE_COM						-4

/* bd funkcji ReadFile - dla pliku i dla portu, odpowiednio */
#define ERR_READ_FILE									-5
#define ERR_READ_FILE_COM							-6

/* bd funkcji WriteFile (plik/port)*/
#define ERR_WRITE_FILE								-7
#define ERR_WRITE_FILE_COM						-8

/* bd ustawiania parametrw portu */
#define ERR_COMM_SETTINGS							-9	

/* port nie zosta otwarty, a kto prbuje wysa lub odebra dane */
#define ERR_PORT_NOT_OPEN							-10



/* zupeny brak odpowiedzi (w wyznaczonym czasie) */
#define ERR_NO_RESPONSE								-20

/*
	Za dugie oczekiwanie na odpowied (na odbir caej ramki)
	Moliwe przyczyny:
	- jakie przerwy w transmisji
	- nie otrzymano znacznika koca ramki w wyznaczonym czasie
*/
#define ERR_RESPONSE_TOUT							-21

/* w przypadku timeout-u uytkownik wybra ponowne wysanie ramki */
#define ERR_RESEND										-22

/* przekroczona liczba prb - protok woski */
#define ERR_I_MAX_RETRIES							-23

/* nieprawidowa warto sumy konrolnej */
#define ERR_CHECKSUM									-24

/* zasygnalizowano bd wykonania rozkazu -> GetExtendedErrorCode() aby pobra ten kod */
#define ERR_RETURN_CODE								-25

/* nieznana/nieprawidowa ramka  */
#define ERR_UNKNOWN_FRAME							-26

/* nieznana (nierozpoznana) komenda */
#define ERR_UNKNOWN_CMD								-27

/* zapeniono bufor wejciowy - a nie byo znacznika koca ramki */
#define ERR_INPUT_BUF_OVRRUN					-28

/* nie jest moliwe wygenerowanie ramki (zbyt duga - bufor zbyt krtki) */
#define ERR_FRAME_TOO_LONG						-29



/* nieprawidowy rodzaj pola */
#define ERR_FIELD_TYPE								0xD0000000

/* nieprawidowa zawarto pola - niezgodna z rodzajem  (ODPOWIED) */
#define ERR_FIELD_CONTENTS						-41

/* nieprawidowa liczba pl w ramce zwrotnej */
#define ERR_NUMBER_OF_FIELDS					-42

/* nieprawidowe pole nagwka */
#define ERR_FMT_HEADER								-43



/* nieprawidowe pole zwrotnego kodu
	- bdu: IT, POL
	- bajtowego (?) znajdujcego si przed kodem rozkazu: POL
*/
#define ERR_FMT_RETURN_CODE						-50

/* nieprawidowe pole (format) sumy kontrolnej */
#define ERR_FMT_CHECKSUM							-51

/* nieprawidowe odpowiedzi na ENQ/DLE */
#define ERR_FMT_ENQ										-52
#define ERR_FMT_DLE										-53



/* nieprawidowa warto parametru */
#define ERR_PARAM_VALUE								0xE0000000

/* nieprawidowa dugo parametru (teksty) */
#define ERR_PARAM_LEN									0xF0000000

/*
	bd parametrw opcjonalnych (kiedy wymagane jest, aby wystpoway albo
	wszystkie, albo aden
*/
#define ERR_OPT_PARAMS								-60

/* nieprawidowa warto rabatu/narzutu*/
#define ERR_DISCOUNT_VALUE						-61



/* nieprawidowa linia w pliku z bazami danych - le sformatowana */
#define ERR_FMT_DB_LINE								-200

/* nieprawidowe pola w pliku z bazami danych */
#define ERR_FMT_DB_FIELD							-201
#define ERR_FMT_DB_FIELD_NUM					-202



#define ERR_NOTHING_TO_CANCEL					-300
#define ERR_CANT_CANCEL								-301
#define ERR_CANCEL										-302

/********************* KODY BDW ZWRACANE PRZEZ URZDZENIA ******************/


#define DEVERR_I_NOT_ALLOWED				254
#define DEVERR_I_VAT_NOT_DIFFERENT	93

#endif // _ERROR_CODES