//
//
//
//			POSNET BASE EXAMPLES
//			EXAMPLE QUEUE MODE
//
//

#include <stdlib.h>
#include <string>
#include <iostream>
#include <istream>
#include <limits>
#ifdef WIN32
#include <windows.h>
#else
#define INFINITE 0xFFFFFFFF
#define Sleep(a) {struct timespec tc,tc1;\
                 tc.tv_sec=a/1000; \
		 tc.tv_nsec=(a%1000)*1000*1000; \
		 nanosleep(&tc,&tc1);   \
		 }
						    
#endif
#include "../../include/posnet.h"

using namespace std;



int main(int argc, char *argv[])
{

#ifdef WIN32
	WSADATA WSAData;
	if (WSAStartup (MAKEWORD(2,0), &WSAData) != 0) 
	{
		MessageBox (NULL, TEXT("WSAStartup failed!"), TEXT("Error"), MB_OK);
		return FALSE;
	}

 #endif
 
#include "../setup.inc"

	/*
		UWAGA: W tym przykadzie obsug bdw zmiejszono do minimum
		dla czytelnoci pozostaej czci kodu - prosz skorzysta z 
		programu demo_all dla zapoznania si z peniejsz obsug bdw.
	*/

	POSNET_HANDLE hRequest;
	int cancel=1;


	// ustawienie parametru - czas pomidzy poszczeglnymi automatycznymi zapytaniami o status drukarki
	unsigned long pi=5;
	POS_SetDeviceParam(hDevice,POSNET_DEV_PARAM_STATUSPOLLINGINTERVAL,&pi);
	
	// pobranie statusu drukarki
	long globalStatus,printerStatus;
	POS_GetPrnDeviceStatus(hLocalDevice,1,&globalStatus,&printerStatus);
	printf("Printer status D:%ld, P%ld\n",globalStatus,printerStatus);
	
	// drobne opnienie - tylko dla celw demonstracynych
	Sleep(2000);

	// jeli drukarka nie gotowa, nie wykonujemy polecenia
	if (globalStatus!=0) 
	{
		cancel=0;
	}
	else
	// ponisza ptla jest trikiem umoliwiajcym proste obsugiwanie bdw
	// za porednictwem instrukcji break - ptla wykonuje si zawsze raz
	do
	{
		// utworzenie obiektu rozkazowego dla rozkazu trinit (pocztek transakcji)
		hRequest = POS_CreateRequest(hLocalDevice,"trinit");
		// jeli nie powiodo si przerywamy dziaanie
		if (!hRequest)
		{
				printf("POS_CreateRequest status: %d",POS_GetError(hLocalDevice));
				break;		
		}
		// dodanie paramtru "bm" o wartoci "1" do obiektu rozkazowego
		POS_PushRequestParam(hRequest,"bm","1");
		// wysanie polecenia w podstawowym trybie SPOOL
		POS_PostRequest(hRequest,POSNET_REQMODE_SPOOL);
		// oczekiwanie na zakoczenie polecenia (5 sekund)
		POS_WaitForRequestCompleted(hRequest,5000);
		// sprawdzenie statusu rozkazu, przerwa w przypadku bdu
		if (POS_GetRequestStatus(hRequest) != POSNET_STATUS_OK) break;
		// likwidacja wykonanego ju rozkazu
		POS_DestroyRequest(hRequest);
		// utworzenie obiektu rozkazowego reprezentujcego lini paragonu
		// z automatycznym dodaniem niezbdnych dla tej linii parametrw
		hRequest = POS_CreateRequestEx(hLocalDevice,"trline","na,Buka Standardowa\nvt,0\npr,35");
			
		if (!hRequest)
		{
				printf("POS_CreateRequestEx status: %d",POS_GetError(hLocalDevice));
				break;		
		}
		// analogicznie jak powyej - wyslanie i oczekiwanie na zakoczenie
		POS_PostRequest(hRequest,POSNET_REQMODE_SPOOL);
		POS_WaitForRequestCompleted(hRequest,5000);
		if (POS_GetRequestStatus(hRequest) != POSNET_STATUS_OK) break;

		POS_DestroyRequest(hRequest);
		// utworzenie obiektu rozkazowego reprezentujcego patno gotwk
		hRequest = POS_CreateRequestEx(hLocalDevice,"trpayment","ty,0\nre,0\nwa,35");
		if (!hRequest)
		{
				printf("POS_CreateRequestEx status: %d",POS_GetError(hLocalDevice));
				break;		
		}
		// analogicznie jak powyej - wyslanie i oczekiwanie na zakoczenie
		POS_PostRequest(hRequest,POSNET_REQMODE_SPOOL);
		POS_WaitForRequestCompleted(hRequest,5000);
		if (POS_GetRequestStatus(hRequest) != POSNET_STATUS_OK) break;

		POS_DestroyRequest(hRequest);
		// utworzenie obiektu rozkazowego reprezentujcego zakoczenie transakcji wraz
		// z dodaniem niezbdnych parametrw
		hRequest = POS_CreateRequestEx(hLocalDevice,"trend","to,35\nfp,35");
		// analogicznie jak powyej - wyslanie i oczekiwanie na zakoczenie
		POS_PostRequest(hRequest,POSNET_REQMODE_SPOOL);
		POS_WaitForRequestCompleted(hRequest,5000);
		if (POS_GetRequestStatus(hRequest) != POSNET_STATUS_OK) break;

		POS_DestroyRequest(hRequest);
		hRequest=NULL;
		// uniemoliwienie wykonania si sekcji obsugi bedw
		cancel=0;
	}
	while (0);
	if (cancel)
	{
		// likwidacja bdnie wykonanej sekwencji
		if (hRequest) POS_DestroyRequest(hRequest);
		// utworzenie obiektu rozkazowego reprezentujcego anulowanie biecej transakcji
		hRequest = POS_CreateRequest(hLocalDevice,"prncancel");
		// oraz wyslanie go do drukarki
		POS_PostRequest(hRequest,POSNET_REQMODE_SPOOL);
		POS_WaitForRequestCompleted(hRequest,5000);
		POS_DestroyRequest(hRequest);
	}
	// zamknicie uchwytw urzdze
	POS_CloseDevice(hLocalDevice);
	POS_DestroyDeviceHandle(hDevice);
	return 0;
}
