// PortTestDlg.cpp : implementation file
//

#include "stdafx.h"
//#include "PortTest_700.h"
#include "..\Source\resource.h"		// main symbols
#include "PortTestDlg.h"
#include "..\..\BIN\Library\Library.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BOOL CAboutDlg::OnInitDialog() 
{
	CString strVersion;
	CDialog::OnInitDialog();
	
	
	strVersion.Format("PortTest Version: %s", PORTTEST_VER);
	GetDlgItem(IDC_STATIC_VER)->SetWindowText(strVersion);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPortTestDlg dialog

CPortTestDlg::CPortTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPortTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPortTestDlg)
	m_nPortType = 0;
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

CPortTestDlg::~CPortTestDlg()
{
	AL_ClosePort();
}

void CPortTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPortTestDlg)
	DDX_Control(pDX, IDC_LIST_DIRECTORY_PC, m_listDirectoryPC);
	DDX_Control(pDX, IDC_LIST_PC_FILES, m_listPCFiles);
	DDX_Control(pDX, IDC_LIST_FILES, m_listFiles);
	DDX_Control(pDX, IDC_LIST_DIRECTORY, m_listDirectory);
	DDX_Control(pDX, IDC_COMBO1, m_ctlCom);
	DDX_Radio(pDX, IDC_RADIO1, m_nPortType);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPortTestDlg, CDialog)
	//{{AFX_MSG_MAP(CPortTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_ALOPEN, OnBtnReqAlopen)
	ON_BN_CLICKED(IDC_BTN_ALCLOSE, OnBtnReqAlclose)
	ON_BN_CLICKED(IDC_BTN_VERSION, OnBtnReqVersion)
	ON_BN_CLICKED(IDC_BUT_REQ_DIR, OnButReqDir)
	ON_BN_CLICKED(IDC_BUT_DIR_FOLDER, OnButReqDirFolder)
	ON_LBN_SELCHANGE(IDC_LIST_DIRECTORY, OnSelchangeListDirectory)
	ON_BN_CLICKED(IDC_BUT_REQ_UPLOADFILE, OnButReqUploadfile)
	ON_LBN_SELCHANGE(IDC_LIST_FILES, OnSelchangeListFiles)
	ON_BN_CLICKED(IDC_BUT_REQ_DOWNLOADFILE, OnButReqDownloadfile)
	ON_LBN_SELCHANGE(IDC_LIST_PC_FILES, OnSelchangeListPcFiles)
	ON_LBN_SELCHANGE(IDC_LIST_DIRECTORY_PC, OnSelchangeListDirectoryPc)
	ON_BN_CLICKED(IDC_BUT_REQ_DELETEFILE, OnButReqDeletefile)
	ON_BN_CLICKED(IDC_BUT_FORMAT_C, OnButReqFormatC)
	ON_BN_CLICKED(IDC_BUT_FORMAT_D, OnButReqFormatD)
	ON_BN_CLICKED(IDC_BUT_REQ_DEFRAGDISK, OnButReqDefragdisk)
	ON_BN_CLICKED(IDC_BUT_REQ_FILEEXIST, OnButReqFileexist)
	ON_BN_CLICKED(IDC_BUT_REQ_DIREXIST, OnButReqDirexist)
	ON_BN_CLICKED(IDC_BUT_REQ_FIRMWARE, OnButReqFirmware)
	ON_BN_CLICKED(IDC_BUT_REQ_SETDATE, OnButReqSetdate)
	ON_BN_CLICKED(IDC_BUT_REQ_SERIALNUM, OnButReqSerialnum)
	ON_BN_CLICKED(IDC_BUT_REQ_PDC_INFO, OnButReqPdcInfo)
	ON_BN_CLICKED(IDC_RADIO1, OnPortType)
	ON_BN_CLICKED(IDC_RADIO2, OnPortType)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPortTestDlg message handlers

BOOL CPortTestDlg::OnInitDialog()
{
	CString strVersion;

	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	

	GetWindowText(strVersion);
	strVersion += " ";
	strVersion += PORTTEST_VER; 
	SetWindowText(strVersion);
	
	m_ctlCom.SetCurSel(0);

	OnSelchangeListDirectory();
	EnumPCSideFolder();
	OnSelchangeListFiles();
	OnSelchangeListPcFiles();

	GetDlgItem(IDC_EDIT_REQ_FILEEXIST)->SetWindowText("c:\\data\\test.dat");
	GetDlgItem(IDC_EDIT_REQ_DIREXIST)->SetWindowText("c:\\data");

	OnPortType();

//	SetMessageDialog(FALSE);
	//SetTransmissionDialog(FALSE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPortTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPortTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CPortTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPortTestDlg::OnBtnReqAlopen() 
{
	CString strTemp;
	int  nSelPort;

	UpdateData(TRUE);

	switch(m_nPortType)
	{
	case PORT_SERIAL:
		nSelPort = m_ctlCom.GetCurSel() + 1;
		if(AL_OpenPort(0, nSelPort, 13, 8, 0, 1) != REQ_SUCCESS)
			return;
		
		GetDlgItem(IDC_USB_DEVICENAME)->SetWindowText("");
		break;

	case PORT_USB:
		if(AL_OpenPort(1, 0, 0, 0, 0, 0) != REQ_SUCCESS)
		{
			GetDlgItem(IDC_USB_DEVICENAME)->SetWindowText("");
			return;
		}
		strTemp = USB_GetDeviceName();
		GetDlgItem(IDC_USB_DEVICENAME)->SetWindowText(strTemp);
		strTemp.Format("%d.%d", USB_GetDeviceVer()/10, USB_GetDeviceVer()%10);
		GetDlgItem(IDC_USB_DEVICE_VER)->SetWindowText(strTemp);
		break;

	case PORT_IR:
		return;
		break;
	default:
		return;
	}


	GetDlgItem(IDC_BTN_ALOPEN)->EnableWindow(FALSE);
	GetDlgItem(IDC_BTN_ALCLOSE)->EnableWindow(TRUE);

	GetDlgItem(IDC_BUT_REQ_DIR)->EnableWindow(TRUE);
	GetDlgItem(IDC_LIST_DIRECTORY_PC)->EnableWindow(TRUE);
	GetDlgItem(IDC_LIST_PC_FILES)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUT_FORMAT_C)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUT_FORMAT_D)->EnableWindow(TRUE);
//	GetDlgItem(IDC_BUT_REQ_DEFRAGDISK)->EnableWindow(TRUE);
//	GetDlgItem(IDC_BTN_VERSION)->EnableWindow(TRUE);

	GetDlgItem(IDC_BUT_REQ_FIRMWARE)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUT_REQ_SETDATE)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUT_REQ_SERIALNUM)->EnableWindow(TRUE);
	GetDlgItem(IDC_EDIT_REQ_FILEEXIST)->EnableWindow(TRUE);
	GetDlgItem(IDC_EDIT_REQ_DIREXIST)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUT_REQ_FILEEXIST)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUT_REQ_DIREXIST)->EnableWindow(TRUE);
	GetDlgItem(IDC_LIST_DIRECTORY)->EnableWindow(TRUE);
	GetDlgItem(IDC_LIST_FILES)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUT_REQ_PDC_INFO)->EnableWindow(TRUE);
	//GetDlgItem()->EnableWindow(TRUE);

	
	GetDlgItem(IDC_RADIO1)->EnableWindow(FALSE);
	GetDlgItem(IDC_RADIO2)->EnableWindow(FALSE);
	GetDlgItem(IDC_COMBO1)->EnableWindow(FALSE);

	
}

void CPortTestDlg::OnBtnReqAlclose() 
{
	AL_ClosePort();

	GetDlgItem(IDC_BTN_ALOPEN)->EnableWindow(TRUE);
	GetDlgItem(IDC_BTN_ALCLOSE)->EnableWindow(FALSE);

	GetDlgItem(IDC_BUT_REQ_DIR)->EnableWindow(FALSE);
	GetDlgItem(IDC_LIST_DIRECTORY_PC)->EnableWindow(FALSE);
	GetDlgItem(IDC_LIST_PC_FILES)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUT_FORMAT_C)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUT_FORMAT_D)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUT_REQ_DEFRAGDISK)->EnableWindow(FALSE);
//	GetDlgItem(IDC_BTN_VERSION)->EnableWindow(FALSE);

	GetDlgItem(IDC_BUT_REQ_FIRMWARE)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUT_REQ_SETDATE)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUT_REQ_SERIALNUM)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_REQ_FILEEXIST)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_REQ_DIREXIST)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUT_REQ_FILEEXIST)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUT_REQ_DIREXIST)->EnableWindow(FALSE);

	GetDlgItem(IDC_LIST_DIRECTORY)->EnableWindow(FALSE);
	GetDlgItem(IDC_LIST_FILES)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUT_REQ_PDC_INFO)->EnableWindow(FALSE);

	GetDlgItem(IDC_RADIO1)->EnableWindow(TRUE);
	GetDlgItem(IDC_RADIO2)->EnableWindow(TRUE);
	GetDlgItem(IDC_COMBO1)->EnableWindow(TRUE);
}

void CPortTestDlg::OnBtnReqVersion() 
{
	char acVersion[100];
	GetDllVersion(acVersion);

	CString strTemp;
	strTemp.Format(_T("COMM_SDK.dll Version: %s"),acVersion);
	AfxMessageBox(strTemp);
}

void CPortTestDlg::OnButReqDir() 
{
	int nBufferSize, nItemAmount, i, j;
	_DIRINFO *pBuffer, *pDirInfo;
	CString strItemName;
	char *pDisk;

	m_listDirectory.ResetContent();

	for(i=0; i<2; i++)
	{
		if(i==0)
			pDisk = "C:\\";
		else
			pDisk = "d:\\";

		switch(Req_DirDataLen(pDisk, (long*)&nBufferSize))
		{
		case REQ_SUCCESS:
			break;
		case ERR_DIR_DISKC_UNFORMAT:
			AfxMessageBox("Disk C is unformat. (Req_DirDataLen)");
			continue;
		case ERR_DIR_DISKD_UNFORMAT:
			AfxMessageBox("Disk D is unformat. (Req_DirDataLen)");
			return;
		default:
			AfxMessageBox("Request Fail (Req_DirDataLen)");
			return;
		}

		if(nBufferSize <= 0)
		{
			AfxMessageBox("No files in this path (OnButReqDir)");
			m_listDirectory.ResetContent();
			return;
		}

		pBuffer = (_DIRINFO*) new char[nBufferSize];
		
		switch(Req_Dir((char*)pBuffer, &nItemAmount))
		{
		case REQ_SUCCESS:
			break;
		
		case ERR_DIR_DISK_UNFORMAT:
			AfxMessageBox("A disk is unformat. (Req_Dir)");
			m_listDirectory.ResetContent();
			delete pBuffer;
			return;
		
		default:
			AfxMessageBox("Request Fail (Req_Dir)");
			m_listDirectory.ResetContent();
			delete pBuffer;
			return;
		}

		if(nItemAmount <= 0)
		{
			//AfxMessageBox("No items in this path (OnButReqDir)");
			//m_listDirectory.ResetContent();
			delete pBuffer;
			return;
		}
			
	
		pDirInfo = pBuffer;

		for(j=0; j<nItemAmount; j++, pDirInfo++)
		{
			switch(pDirInfo->usAttrib)
			{
			case '\x00':
			case '\x10':
				if(i==0)
					pDisk = "C:\\";
				else
					pDisk = "D:\\";

				strItemName.Format(_T("%s%.8s"), pDisk, pDirInfo->assFName);
				m_listDirectory.InsertString(0, strItemName);
				break;
			
			case '\x20':
				strItemName.Format(_T("%.8s.%.3s"), pDirInfo->assFName, pDirInfo->assExtend);
				m_listDirectory.InsertString(0, strItemName);
				break;
			}
		}

		delete pBuffer;
		pBuffer = NULL;
	}
}

void CPortTestDlg::OnButReqDirFolder() 
{
	int nBufferSize, nItemAmount, i, nCurSelItem;
	_DIRINFO *pBuffer, *pDirInfo;
	CString strItemName, strFolder;

	m_listFiles.ResetContent();

	// Get Current Select Item in Folder List
	if((nCurSelItem = m_listDirectory.GetCurSel()) < 0)
		return;

	m_listDirectory.GetText(m_listDirectory.GetCurSel(), strFolder);

	if(Req_DirDataLen(strFolder.LockBuffer(), (long*)&nBufferSize) != REQ_SUCCESS)
	{
		AfxMessageBox("Request Fail (Req_DirDataLen)");
		m_listFiles.ResetContent();
		return;
	}

	if(nBufferSize <= 0)
	{
		AfxMessageBox("No files in this path (OnButReqDirFolder)");
		m_listFiles.ResetContent();
		return;
	}

	pBuffer = (_DIRINFO*) new char[nBufferSize];
		
	if(Req_Dir((char*)pBuffer, &nItemAmount) != REQ_SUCCESS)
	{
		AfxMessageBox("Request Fail (Req_Dir)");
		m_listFiles.ResetContent();
		delete pBuffer;
		return;
	}

	if(nItemAmount <= 0)
	{
		AfxMessageBox("No items in this path (OnButReqDirFolder)");
		m_listFiles.ResetContent();
		delete pBuffer;
		return;
	}
			
			
	pDirInfo = pBuffer;

	for(i=0; i<nItemAmount; i++, pDirInfo++)
	{
		switch(pDirInfo->usAttrib)
		{
		case '\x00':
		case '\x10':
			strItemName.Format(_T("%.8s"), pDirInfo->assFName);
			m_listFiles.InsertString(0, strItemName);
			break;
			
		case '\x20':
			strItemName.Format(_T("%.8s.%.3s"), pDirInfo->assFName, pDirInfo->assExtend);
			m_listFiles.InsertString(0, strItemName);
			break;
		}
	}

	delete pBuffer;
	pBuffer = NULL;
}

void CPortTestDlg::OnSelchangeListDirectory() 
{
	UpdateData();

	GetDlgItem(IDC_BUT_DIR_FOLDER)->EnableWindow(!(m_listDirectory.GetCurSel() < 0));
}

#include "io.h"
void CPortTestDlg::EnumPCSideFiles(char* pPath)
{
	_finddata_t fblk;
	long handle, result;
	char child[_MAX_PATH];
	BOOL ret = FALSE;
	CString strTemp;

	m_listPCFiles.ResetContent();
	Sleep(500);
	
	// To get all files
	wsprintf ( child, "%s*.*", pPath);
	result = handle = _findfirst ( child, &fblk ); /** [19] **/

	while ( result != -1 )
	{
		strTemp.Format("%s", fblk.name);
		if ( ( ( fblk.attrib & _A_SUBDIR ) != 0 ) && (strcmp ( fblk.name, "." ) || strcmp ( fblk.name, ".." )) )
		{	// If is it the catalogue that regards it as the new node to add to arborescent form
			result = _findnext ( handle, &fblk );
			continue;
			
		}
		else 
		{
			if(strTemp.GetLength() < 13)
			{
				m_listPCFiles.AddString(fblk.name);

			}
		}
		result = _findnext ( handle, &fblk );
	}	
	_findclose ( handle );
	return;
}

void CPortTestDlg::EnumPCSideFolder()
{
	_finddata_t fblk;
	long handle, result;
	char child[_MAX_PATH];
	BOOL ret = FALSE;
	CString strTemp;

	m_listDirectoryPC.ResetContent();
	
	// To get all files
	wsprintf ( child, "%s*.*", "C:\\");
	result = handle = _findfirst ( child, &fblk ); /** [19] **/

	while ( result != -1 )
	{
		strTemp.Format("%s", fblk.name);
		if ( ( ( fblk.attrib & _A_SUBDIR ) != 0 ))
		{
			if(!(strcmp ( fblk.name, "." ) || strcmp ( fblk.name, ".." )) )
			{	// If is it the catalogue that regards it as the new node to add to arborescent form
				result = _findnext ( handle, &fblk );
				continue;
			}

			m_listDirectoryPC.AddString(fblk.name);
		}
		result = _findnext ( handle, &fblk );
	}	
	_findclose ( handle );
	return;
}

void CPortTestDlg::OnButReqUploadfile() 
{
	int  nMaxItems, i, nResult;
	int anIndex[100];

	CString strPath, strData, strPathPC;

	nMaxItems = m_listFiles.GetSelCount();
	if(nMaxItems < 1)
		return;

	if(nMaxItems > 100)
	{
		AfxMessageBox("Too Many Files");
		return;
	}

	m_listFiles.GetSelItems(nMaxItems, anIndex);
	
	for(i=0; i<nMaxItems; i++)
	{
		m_listFiles.GetText(anIndex[i], strData);
		if(GetPCSidePath().IsEmpty())
		{
			AfxMessageBox("Please select a PC side folder");
			return;
		}
		strPathPC.Format("%s%s", GetPCSidePath(), strData);

		m_listDirectory.GetText(m_listDirectory.GetCurSel(), strPath);
		strPath += "\\" + strData;

		nResult = Req_UploadMultiFile(strPath.LockBuffer(), strPathPC.LockBuffer(), nMaxItems, i);
		//nResult = Req_UploadFile(strPath.LockBuffer(), strPathPC.LockBuffer());
		switch(nResult)
		{
		case REQ_SUCCESS:
			break;
		case ERR_REQ_UPLOADFILE_INVALID_PATH:
			AfxMessageBox("Upload file fail. (Invalid Path)");
			i = nMaxItems; // It's for end.
			break;
		default:
			AfxMessageBox("Upload file fail.");
			i = nMaxItems; // It's for end.
			break;
		}
	}

	OnSelchangeListDirectoryPc();
	
}

void CPortTestDlg::OnSelchangeListFiles() 
{
	int nMaxItems;
	UpdateData();

	nMaxItems = m_listFiles.GetSelCount();
	if(nMaxItems < 1)
	{
		GetDlgItem(IDC_BUT_REQ_UPLOADFILE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUT_REQ_DELETEFILE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUT_DIR_FILE)->EnableWindow(FALSE);
		return;
	}
	else
	{
		GetDlgItem(IDC_BUT_REQ_UPLOADFILE)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUT_REQ_DELETEFILE)->EnableWindow(TRUE);
//		GetDlgItem(IDC_BUT_DIR_FILE)->EnableWindow(TRUE);
	}

}

void CPortTestDlg::OnButReqDownloadfile() 
{
	int  nMaxItems, i, nResult;
	int anIndex[100];

	CString strPath, strData, strPathPC, strError;

	nMaxItems = m_listPCFiles.GetSelCount();
	if(nMaxItems < 1)
		return;

	if(nMaxItems > 100)
	{
		AfxMessageBox("Too Many Files");
		return;
	}

	m_listPCFiles.GetSelItems(nMaxItems, anIndex);

	if(m_listDirectory.GetCurSel() < 0)
	{
		AfxMessageBox("Please choose the destination path.");
		return;
	}

	for(i=0; i<nMaxItems; i++)
	{
		m_listPCFiles.GetText(anIndex[i], strData);
		strPathPC.Format("%s%s", GetPCSidePath(), strData);

		m_listDirectory.GetText(m_listDirectory.GetCurSel(), strPath);
		
		//nResult = Req_DownloadFile(strPathPC.LockBuffer(), strPath.LockBuffer(), REPLACE_FILE);
		nResult = Req_DownloadMultiFile(strPathPC.LockBuffer(), strPath.LockBuffer(), nMaxItems, i);		
		switch(nResult)
		{
		case REQ_SUCCESS:
			break;
		case ERR_CONNECTING_FAIL:
			AfxMessageBox("Download file fail. (Connection Fail)");
			i = nMaxItems; // It's for end.
			break;
		case ERR_REQ_UPLOADFILE_INVALID_PATH:
			AfxMessageBox("Download file fail. (Invalid Path)");
			i = nMaxItems; // It's for end.
			break;
		default:
			strError.Format("Download file fail. Error Code:%d", nResult);
			AfxMessageBox(strError);
			i = nMaxItems; // It's for end.
			break;
		}
	}
	
	OnButReqDirFolder();
}

void CPortTestDlg::OnSelchangeListPcFiles() 
{
	int nMaxItems;
	UpdateData();

	nMaxItems = m_listPCFiles.GetSelCount();
	if(nMaxItems < 1)
	{
		GetDlgItem(IDC_BUT_REQ_DOWNLOADFILE)->EnableWindow(FALSE);
		return;
	}
	else
		GetDlgItem(IDC_BUT_REQ_DOWNLOADFILE)->EnableWindow(TRUE);
	
}

void CPortTestDlg::OnSelchangeListDirectoryPc() 
{
	CString strFolder, strTemp;

	UpdateData();

	if(m_listDirectoryPC.GetCurSel() < 0)
		return;

	m_listDirectoryPC.GetText(m_listDirectoryPC.GetCurSel(), strFolder);

	strTemp.Format("C:\\%s\\", strFolder);
	EnumPCSideFiles(strTemp.LockBuffer());
}

CString CPortTestDlg::GetPCSidePath()
{
	CString strTemp, strFolder;

	strTemp.Empty();

	if(m_listDirectoryPC.GetCurSel() < 0)
		return strTemp;

	m_listDirectoryPC.GetText(m_listDirectoryPC.GetCurSel(), strFolder);

	strTemp.Format("C:\\%s\\", strFolder);

	return strTemp;
}

void CPortTestDlg::OnButReqDeletefile() 
{
	int  nMaxItems, i, nResult;
	CString strPath, strData, strPathPC, strMessage;
	int anIndex[100];

	nMaxItems = m_listFiles.GetSelCount();
	if(nMaxItems < 1)
		return;

	if(nMaxItems > 100)
	{
		AfxMessageBox("Too Many Files");
		return;
	}

	m_listFiles.GetSelItems(nMaxItems, anIndex);
	
	for(i=0; i<nMaxItems; i++)
	{
		m_listFiles.GetText(anIndex[i], strData);
		m_listDirectory.GetText(m_listDirectory.GetCurSel(), strPath);
		strPath += "\\" + strData;

		nResult = Req_DeleteFile(strPath.LockBuffer());
		switch(nResult)
		{
		case REQ_SUCCESS:
			break;
		default:
			strMessage.Format("Delete file \"%s\" fail.", strPath);
			AfxMessageBox(strMessage);
			i = nMaxItems; // It's for end
			break;
		}
	}

	OnButReqDirFolder();
	OnSelchangeListFiles();
}

void CPortTestDlg::OnButReqFormatC() 
{
	if(Req_FormatDisk("C:\\") == REQ_SUCCESS)
		AfxMessageBox("Formatting the disk C drive succeeds.");
	else
		AfxMessageBox("Formatting the disk C drive failed.");

	OnButReqDir();
	
}

void CPortTestDlg::OnButReqFormatD() 
{
	if(Req_FormatDisk("D:\\") == REQ_SUCCESS)
		AfxMessageBox("Formatting the disk D drive succeeds.");
	else
		AfxMessageBox("Formatting the disk D drive failed.");
	
	OnButReqDir();
}

void CPortTestDlg::OnButReqDefragdisk() 
{
	if(Req_DefragDisk("D:\\") == REQ_SUCCESS)
		AfxMessageBox("Defrag the disk D drive succeeds.");
	else
		AfxMessageBox("Defrag the disk D drive failed.");
	
}

void CPortTestDlg::OnButReqFileexist() 
{
	CString strTemp, strPath;

	GetDlgItem(IDC_EDIT_REQ_FILEEXIST)->GetWindowText(strPath);
	if(Req_FileExist(strPath.LockBuffer()) == REQ_SUCCESS)
		strTemp.Format("The file \"%s\" has already existed.", strPath);
	else
		strTemp.Format("The file \"%s\" does not exist.", strPath);

	AfxMessageBox(strTemp);	
}

void CPortTestDlg::OnButReqDirexist() 
{
	CString strTemp, strPath;

	GetDlgItem(IDC_EDIT_REQ_DIREXIST)->GetWindowText(strPath);
	if(Req_DirectoryExist(strPath.LockBuffer()) == REQ_SUCCESS)
		strTemp.Format("The directory \"%s\" has already existed.", strPath);
	else
		strTemp.Format("The directory \"%s\" does not exist.", strPath);

	AfxMessageBox(strTemp);
	
}

void CPortTestDlg::OnButReqFirmware() 
{
	int nResult;
	CString strTemp;

	//if(Req_FirmWare("T10A230.bin","SST_RW.abp"))
	if((nResult = Req_FirmWare(NULL, NULL)) == REQ_SUCCESS)
		AfxMessageBox("The firmware is upgraded successfully.");
	else
	{
		strTemp.Format("The firmware upgrading and failing. \n(Error Code: %d)", nResult);
		AfxMessageBox(strTemp);
	}
}

void CPortTestDlg::OnButReqSetdate() 
{
	int nResult;

#ifdef _MODE1
	
	TCHAR buf[14];
	CTime ct = CTime::GetCurrentTime();
		
	wsprintf(buf, _T("%.4d%.2d%.2d%.2d%.2d%.2d"), ct.GetYear(), ct.GetMonth(), ct.GetDay(),
													ct.GetHour(), ct.GetMinute(), ct.GetSecond());
	nResult = Req_SetDate(buf);
#else	
	nResult = Req_SetDate(NULL);
#endif

	if(nResult != REQ_SUCCESS)
		AfxMessageBox("It sets for PDC date and time to fail");
	else
		AfxMessageBox("Set date and time successfully");
}

void CPortTestDlg::OnButReqSerialnum() 
{
	char acSerialNumBuffer[20];

	memset(acSerialNumBuffer, 0, 20);

	if(Req_SerialNum(acSerialNumBuffer) == REQ_SUCCESS)
		GetDlgItem(IDC_STATIC_SERIALNUM)->SetWindowText(acSerialNumBuffer);
	else
	{
		GetDlgItem(IDC_STATIC_SERIALNUM)->SetWindowText("");
		AfxMessageBox("Can't get any serial number");
	}
}

void CPortTestDlg::OnButReqPdcInfo() 
{
	// Show the DLL inside dialog about PDC Information directly 
	Req_PDC_Info(NULL, NULL, NULL, NULL, NULL);

	// or
	// Fetch the PDC information form DLL
	// int nPDC_Ver, nTotalSpace_C, nFreeSpace_C, nTotalSpace_D, nFreeSpace_D;
	//Req_PDC_Info(&nPDC_Ver, &nTotalSpace_C, &nFreeSpace_C, &nTotalSpace_D, &nFreeSpace_D);
}

void CPortTestDlg::OnPortType() 
{
	UpdateData(TRUE);

	if(m_nPortType == PORT_SERIAL)
	{
		GetDlgItem(IDC_USB_DEVICE_VER)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_STATIC_CRD_VER)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_USB_DEVICENAME)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_COMBO1)->ShowWindow(SW_SHOW);
	}
	else
	{
		GetDlgItem(IDC_USB_DEVICE_VER)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_STATIC_CRD_VER)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_USB_DEVICENAME)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_COMBO1)->ShowWindow(SW_HIDE);
	}	
}



