/******************************************************************************
Copyright (c) 2003-2007      ARGOX Information Co., Ltd.

Module Name:
	Library.h
Version:
	3.0.0.3
Abstract:
	Public interface to the communication parsing library.
******************************************************************************/
#ifdef SDK_SW_EXPORT
#define SDK_SW extern "C" __declspec(dllexport)
#else
#define SDK_SW extern "C" __declspec(dllimport)
#endif

///////////////////////////////////////////////////////////////////////////////
// Common Functions
///////////////////////////////////////////////////////////////////////////////
SDK_SW void _stdcall GetDllVersion(char *pVersion);
SDK_SW void _stdcall SetMessageDialog(BOOL bEnable);
SDK_SW void _stdcall SetTransmissionDialog(BOOL bEnable);

///////////////////////////////////////////////////////////////////////////////
// Single-Port Processing
///////////////////////////////////////////////////////////////////////////////

	// Base I/O Communication
SDK_SW int _stdcall OpenPort(int nPortType, int nSelPort, int nBaud, int nByteSize, int nParity, int nStopBits, int nFlowCtrl, int nShowDlg);
SDK_SW void _stdcall ClosePort(void);
SDK_SW int _stdcall WriteData(char *pDataBuf, int nBytesToWrite);
SDK_SW int _stdcall ReadData(char* pDataBuf, int nBytesToRead);

	// Inquire Device
SDK_SW char* _stdcall USB_GetDeviceName();
SDK_SW int _stdcall USB_GetDeviceVer();

	// Argolink Protocol Open/Close
SDK_SW int _stdcall AL_OpenPort(int nPortType, int nSelPort, int nBaud, int nByteSize, int nParity, int nStopBits);
SDK_SW void _stdcall AL_ClosePort(void);

	// Argolink Protocol Command for inquiring folder/file
SDK_SW int _stdcall Req_Dir(char *DirItem, int *nFileItem);
SDK_SW int _stdcall Req_DirDataLen(char *strFile, long *lLen);
SDK_SW int _stdcall Req_DirectoryExist(char *strDir);
SDK_SW int _stdcall Req_FileExist(char *strFile);

	// Argolink Protocol Command for processing file
SDK_SW int _stdcall Req_DownloadFile(char *strFile, char *strDest, int nCreateFlag);
SDK_SW int _stdcall Req_DownloadMultiFile(char *strFile, char *strDest, int nMaxFiles, int nFileIndex);
SDK_SW int _stdcall Req_UploadFile(char *strOrigin, char *strDestination);
SDK_SW int _stdcall Req_UploadMultiFile(char *strOrigin, char *strDestination, int nMaxFiles, int nFileIndex);
SDK_SW int _stdcall Req_DeleteFile(char *strFile);

	// Argolink Protocol Command for processing disk
SDK_SW int _stdcall Req_FormatDisk(char *strDisk);
SDK_SW int _stdcall Req_DefragDisk(char *strDisk);

	// Argolink Protocol Command for other functions
SDK_SW int _stdcall Req_FirmWare(char *strFile,char *strAbpFile);
SDK_SW int _stdcall Req_SetDate(char *strDate);
SDK_SW int _stdcall Req_SerialNum(char *pSerialNum);
SDK_SW void _stdcall SetRWPath(char *path);
SDK_SW int _stdcall Req_ConnectionTest(void);
SDK_SW int _stdcall Req_PDC_Info(int* pnPDC_Ver, int* pnTotalSpace_C,  int* pnFreeSpace_C, int* pnTotalSpace_D, int* pnFreeSpace_D);


///////////////////////////////////////////////////////////////////////////////
// Multi-Port Processing
///////////////////////////////////////////////////////////////////////////////
	
	// Create/Destroy Communication
SDK_SW int _stdcall MultiPort_Create(char *pPortName);
SDK_SW void _stdcall MultiPort_Destroy(int nDevHead);

	// Input/Output Communication
SDK_SW int _stdcall MultiPort_Open(int nDevHead);
SDK_SW int _stdcall MultiPort_Close(int nDevHead);
SDK_SW int _stdcall MultiPort_Write(int nDevHead, char *pDataBuf, int nBytesToWrite);
SDK_SW int _stdcall MultiPort_Read(int nDevHead, char* pDataBuf, int nBytesToRead);

	// Inquire Device
SDK_SW char* _stdcall MultiPort_USB_GetDeviceName(int nDevHead);
SDK_SW int _stdcall MultiPort_EnumAllUSBDeviceName(char *pBuffer);

	// Argolink Protocol Command for inquiring folder/file
SDK_SW int _stdcall MultiPort_Req_Dir(char *DirItem, int *nFileItem);
SDK_SW int _stdcall MultiPort_Req_DirDataLen(char *strFile, long *lLen);
SDK_SW int _stdcall MultiPort_Req_DirectoryExist(char *strDir);
SDK_SW int _stdcall MultiPort_Req_FileExist(char *strFile);

	// Argolink Protocol Command for processing file
SDK_SW int _stdcall MultiPort_Req_DownloadFile(int nDevHead, char *strFile, char *strDest, int nCreateFlag);
SDK_SW int _stdcall MultiPort_Req_DownloadMultiFile(int nDevHead, char *strFile, char *strDest, int nMaxFiles, int nFileIndex);
SDK_SW int _stdcall MultiPort_Req_UploadFile(int nDevHead, char *strOrigin, char *strDestination, int nMaxFiles, int nFileIndex);
SDK_SW int _stdcall MultiPort_Req_DeleteFile(char *strFile);

	// Argolink Protocol Command for processing disk
SDK_SW int _stdcall MultiPort_Req_FormatDisk(char *strDisk);
SDK_SW int _stdcall MultiPort_Req_DefragDisk(char *strDisk);

	// Argolink Protocol Command for other functions
SDK_SW int _stdcall MultiPort_Req_FirmWare(char *strFile,char *strAbpFile);
SDK_SW int _stdcall MultiPort_Req_SetDate(char *strDate);
SDK_SW int _stdcall MultiPort_Req_SerialNum(int nDevHead, char *pSerialNum);
SDK_SW int _stdcall MultiPort_Req_ConnectionTest(int nDevHead);
SDK_SW int _stdcall MultiPort_Req_PDC_Info(int nDevHead, int* pnPDC_Ver, int* pnTotalSpace_C,  int* pnFreeSpace_C, int* pnTotalSpace_D, int* pnFreeSpace_D);

///////////////////////////////////////////////////////////////////////////////
// 
///////////////////////////////////////////////////////////////////////////////

#define REQ_SUCCESS 1

#define ERR_CONNECTING_FAIL 2000

#define ERR_REQ_UPLOADFILE_INVALID_PATH				1100
#define ERR_REQ_UPLOADMULTIFILE_PDCFILE_INEXISTENCE 1101
#define ERR_REQ_UPLOADMULTIFILE_PCFILE_INEXISTENCE	1102
#define ERR_FILEUPLOAD_FAIL							1110

#define ERR_AL_OPENPORT_INVALID_USB_DEVICE	1000
#define ERR_AL_OPENPORT_INVALID_PORT		1001
#define ERR_AL_OPENPORT_CREATE_FAIL			1002


#define ERR_REQ_DOWNLOADMULTIFILE_PDCFILE_INEXISTENCE 1200
#define ERR_REQ_DOWNLOADMULTIFILE_PCFILE_INEXISTENCE  1201

#define ERR_DIR_FAIL						1300
#define ERR_DIR_DISKC_UNFORMAT				1301
#define ERR_DIR_DISKD_UNFORMAT				1302
#define ERR_DIR_DISK_UNFORMAT				1303
#define ERR_SETDATETIME_FAIL				1310
#define ERR_GETSERIALNUM_FAIL				1320
#define ERR_IMPORT_BUF_ERROR				1321
#define ERR_FWUPGRADE_FAIL					1330
#define ERR_ASKPCDINFO_FAIL					1340
#define ERR_GETROMWRITER_ID_FAIL			1350
#define ERR_FILEDEL_FAIL					1360
#define	ERR_DISKFORMAT_FAIL					1370
#define	ERR_NO_SUPPORT_DISK					1371


#define ERR_DFU_BINFILE_ERROR				1380
#define ERR_DFU_BINFILE_EXTENSION_ERROR		1381
#define ERR_DFU_ROMFILE_EXTENSION_ERROR		1382
#define ERR_DFU_ROMID_ERROR					1383
#define ERR_DFU_ROMID_NOTSUPPORT			1384
#define ERR_DFU_ROMTYPE_NOTSUPPORT			1385
#define ERR_DFU_DOWNLOAD_FAIL_ROMFILE		1386
#define ERR_DFU_DOWNLOAD_FAIL_BINFILE		1387
#define ERR_DFU_BREAK_OPENFILE				1388
#define ERR_DFU_INEXISTENCE_BINFILE			1389
#define ERR_DFU_INEXISTENCE_ROMFILE			1390
#define ERR_DFU_BREAK_UPGRADE				1391

#define ERR_PROGESS_DLG_SHOWFAIL			1400

#define ERR_AL_MAKEPREFIXPACKET				1450
#define ERR_AL_READPREFIXPACKET_RESPONSE	1451
#define ERR_AL_CHKPREFIXPACKET_RESPONSE		1452
#define ERR_AL_SENDFILE_BREAK				1453
#define ERR_AL_MAKEDATAPACKET				1454
#define ERR_AL_READDATAPACKET_RESPONSE		1455
#define ERR_AL_RETRY_FAIL_1					1456
#define ERR_AL_RETRY_FAIL_2					1457

#define ERR_NEED_HEAD						1500

///////////////////////////////////////////////////////////////////////////////
// 
///////////////////////////////////////////////////////////////////////////////

typedef struct DIRINFO
{
	char		assFName[8];	// Filename
	char		assExtend[3];	// Extension
	char		usAttrib;		// Attribute
	char		usTime[2];		// Access Time
	char		usDate[2];		// Access Date
	unsigned short	umStart;	// Cluster Start Position
	unsigned long 	ulSize;		// file size
	char		endChar[2];	    // partition char.(\x0d\x0a)
}_DIRINFO;



#define PORT_SERIAL 0
#define PORT_USB	1
#define PORT_IR		2
